/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.Blob;
import org.garret.perst.PersistentResource;
import org.garret.perst.RandomAccessInputStream;
import org.garret.perst.RandomAccessOutputStream;
import org.garret.perst.Storage;

public class BlobImpl
extends PersistentResource
implements Blob {
    int size;
    BlobImpl next;
    byte[] body;
    transient int used;
    static final int headerSize = 20;

    void discard(int flags) {
        if (--this.used == 0 && (flags & 1) == 0) {
            this.invalidate();
            this.next = null;
        }
    }

    public boolean recursiveLoading() {
        return false;
    }

    public RandomAccessInputStream getInputStream() {
        return this.getInputStream(0);
    }

    public RandomAccessInputStream getInputStream(int flags) {
        return new BlobInputStream(this, flags);
    }

    public RandomAccessOutputStream getOutputStream() {
        return this.getOutputStream(8);
    }

    public RandomAccessOutputStream getOutputStream(boolean multisession) {
        return this.getOutputStream(multisession ? 8 : 12);
    }

    public RandomAccessOutputStream getOutputStream(long position, boolean multisession) {
        RandomAccessOutputStream stream = this.getOutputStream(multisession);
        stream.setPosition(position);
        return stream;
    }

    public RandomAccessOutputStream getOutputStream(int flags) {
        return new BlobOutputStream(this, flags);
    }

    public void deallocate() {
        this.load();
        if (this.size > 0) {
            BlobImpl curr = this.next;
            while (curr != null) {
                curr.load();
                BlobImpl tail = curr.next;
                curr.deallocate();
                curr = tail;
            }
        }
        super.deallocate();
    }

    BlobImpl(Storage storage, int size) {
        super(storage);
        this.body = new byte[size];
    }

    BlobImpl() {
    }

    static class BlobOutputStream
    extends RandomAccessOutputStream {
        protected BlobImpl first;
        protected BlobImpl curr;
        protected int pos;
        protected int blobOffs;
        protected int flags;
        protected boolean modified;

        public void write(int b) {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf, 0, 1);
        }

        public void write(byte[] b, int off, int len) {
            while (len > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl prev = this.curr;
                    if (prev.next == null) {
                        BlobImpl next;
                        int length = this.curr.body.length;
                        if ((this.flags & 2) != 0 && length << 1 > length) {
                            length = (length + 20 << 1) - 20;
                        }
                        this.curr = prev.next = (next = new BlobImpl(this.curr.getStorage(), length));
                        this.modified = true;
                    } else {
                        this.curr = prev.next;
                        this.curr.load();
                    }
                    ++this.curr.used;
                    if (prev != this.first) {
                        if (this.modified) {
                            prev.store();
                        }
                        prev.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n = len > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : len;
                System.arraycopy(b, off, this.curr.body, this.blobOffs, n);
                this.modified = true;
                this.blobOffs += n;
                off += n;
                len -= n;
                this.pos += n;
            }
            if (this.pos > this.first.size) {
                this.first.size = this.pos;
            }
        }

        public void close() {
            if ((this.flags & 4) != 0 && this.blobOffs < this.curr.body.length && this.curr.next == null) {
                byte[] tmp = new byte[this.blobOffs];
                System.arraycopy(this.curr.body, 0, tmp, 0, this.blobOffs);
                this.curr.body = tmp;
            }
            this.curr.store();
            this.curr.discard(this.flags);
            if (this.curr != this.first) {
                this.first.store();
                this.first.discard(this.flags);
            }
            this.curr = null;
            this.first = null;
        }

        public long setPosition(long newPos) {
            if (newPos < (long)this.pos) {
                if (newPos >= (long)(this.pos - this.blobOffs)) {
                    this.blobOffs = (int)((long)this.blobOffs - ((long)this.pos - newPos));
                    this.pos = (int)newPos;
                    return this.pos;
                }
                if (this.first != this.curr) {
                    if (this.modified) {
                        this.curr.store();
                        this.modified = false;
                    }
                    this.curr.discard(this.flags);
                    this.curr = this.first;
                }
                this.pos = 0;
                this.blobOffs = 0;
            }
            this.skip(newPos - (long)this.pos);
            return this.pos;
        }

        public long getPosition() {
            return this.pos;
        }

        public long size() {
            return this.first.size;
        }

        public long skip(long offs) {
            int rest = this.first.size - this.pos;
            if (offs > (long)rest) {
                offs = rest;
            }
            int len = (int)offs;
            while (len > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl prev = this.curr;
                    this.curr = prev.next;
                    this.curr.load();
                    ++this.curr.used;
                    if (prev != this.first) {
                        if (this.modified) {
                            prev.store();
                            this.modified = false;
                        }
                        prev.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n = len > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : len;
                this.pos += n;
                len -= n;
                this.blobOffs += n;
            }
            return offs;
        }

        BlobOutputStream(BlobImpl first, int flags) {
            this.flags = flags;
            this.first = first;
            first.load();
            ++first.used;
            this.curr = first;
            if ((flags & 8) != 0) {
                this.skip(first.size);
            }
        }
    }

    static class BlobInputStream
    extends RandomAccessInputStream {
        protected BlobImpl curr;
        protected BlobImpl first;
        protected int pos;
        protected int blobOffs;
        protected int flags;

        public int read() {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) == 1 ? b[0] & 0xFF : -1;
        }

        public int read(byte[] b, int off, int len) {
            if (this.pos >= this.first.size) {
                return -1;
            }
            int rest = this.first.size - this.pos;
            if (len > rest) {
                len = rest;
            }
            int rc = len;
            while (len > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl prev = this.curr;
                    this.curr = prev.next;
                    this.curr.load();
                    ++this.curr.used;
                    if (prev != this.first) {
                        prev.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n = len > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : len;
                System.arraycopy(this.curr.body, this.blobOffs, b, off, n);
                this.blobOffs += n;
                off += n;
                len -= n;
                this.pos += n;
            }
            return rc;
        }

        public long setPosition(long newPos) {
            if (newPos < (long)this.pos) {
                if (newPos >= (long)(this.pos - this.blobOffs)) {
                    this.blobOffs = (int)((long)this.blobOffs - ((long)this.pos - newPos));
                    this.pos = (int)newPos;
                    return this.pos;
                }
                if (this.first != this.curr) {
                    this.curr.discard(this.flags);
                    this.curr = this.first;
                }
                this.pos = 0;
                this.blobOffs = 0;
            }
            this.skip(newPos - (long)this.pos);
            return this.pos;
        }

        public long getPosition() {
            return this.pos;
        }

        public long size() {
            return this.first.size;
        }

        public long skip(long offs) {
            int rest = this.first.size - this.pos;
            if (offs > (long)rest) {
                offs = rest;
            }
            int len = (int)offs;
            while (len > 0) {
                if (this.blobOffs == this.curr.body.length) {
                    BlobImpl prev = this.curr;
                    this.curr = prev.next;
                    this.curr.load();
                    ++this.curr.used;
                    if (prev != this.first) {
                        prev.discard(this.flags);
                    }
                    this.blobOffs = 0;
                }
                int n = len > this.curr.body.length - this.blobOffs ? this.curr.body.length - this.blobOffs : len;
                this.pos += n;
                len -= n;
                this.blobOffs += n;
            }
            return offs;
        }

        public int available() {
            return this.first.size - this.pos;
        }

        public void close() {
            this.curr.discard(this.flags);
            if (this.first != this.curr) {
                this.first.discard(this.flags);
            }
            this.first = null;
            this.curr = null;
        }

        protected BlobInputStream(BlobImpl first, int flags) {
            this.flags = flags;
            this.first = first;
            first.load();
            this.curr = first;
            ++first.used;
        }
    }
}

