/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.tristatecheckbox;

import frost.util.gui.tristatecheckbox.TristateButtonModel;
import frost.util.gui.tristatecheckbox.TristateState;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

public final class TristateCheckBox
extends JCheckBox {
    private final ChangeListener enableListener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            TristateCheckBox.this.setFocusable(TristateCheckBox.this.getModel().isEnabled());
        }
    };

    public TristateCheckBox() {
        this(null, null, TristateState.INDETERMINATE);
    }

    public TristateCheckBox(String text) {
        this(text, null, TristateState.INDETERMINATE);
    }

    public TristateCheckBox(String text, Icon icon, TristateState initial) {
        super(text, icon);
        this.setModel(new TristateButtonModel(initial));
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TristateCheckBox.this.iterateState();
            }
        });
        ActionMapUIResource actions = new ActionMapUIResource();
        actions.put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TristateCheckBox.this.iterateState();
            }
        });
        actions.put("released", null);
        SwingUtilities.replaceUIActionMap(this, actions);
    }

    public void setIndeterminate() {
        this.getTristateModel().setIndeterminate();
    }

    public boolean isIndeterminate() {
        return this.getTristateModel().isIndeterminate();
    }

    public TristateState getState() {
        return this.getTristateModel().getState();
    }

    public Boolean getBooleanState() {
        if (this.getState() == TristateState.INDETERMINATE) {
            return null;
        }
        if (this.getState() == TristateState.SELECTED) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setModel(ButtonModel newModel) {
        super.setModel(newModel);
        if (this.model instanceof TristateButtonModel) {
            this.model.addChangeListener(this.enableListener);
        }
    }

    public void addMouseListener(MouseListener l) {
    }

    private void iterateState() {
        if (!this.getModel().isEnabled()) {
            return;
        }
        this.grabFocus();
        this.getTristateModel().iterateState();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getText(), System.currentTimeMillis(), modifiers));
    }

    public TristateButtonModel getTristateModel() {
        return (TristateButtonModel)super.getModel();
    }
}

