/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.Core;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageGuiSupport {
    private static LanguageGuiSupport instance = null;
    private final Language language = Language.getInstance();
    private static List<Locale> buildInLocales = null;
    private final List<JRadioButtonMenuItem> buildinLanguageMenuItemsList;
    private final HashMap<String, JRadioButtonMenuItem> buildinLanguageMenuItemsMap;
    private final JRadioButtonMenuItem languageDefaultMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageBulgarianMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageDutchMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageDanishMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageEnglishMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageFrenchMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageGermanMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageItalianMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageJapaneseMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageSpanishMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageRussianMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languagePolishMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageSwedishMenuItem = new JRadioButtonMenuItem();
    private final JRadioButtonMenuItem languageEsperantoMenuItem = new JRadioButtonMenuItem();
    private final ButtonGroup languageMenuButtonGroup = new ButtonGroup();
    private JMenu languageMenu;

    private LanguageGuiSupport() {
        this.languageBulgarianMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_bg.png", 16, 16));
        this.languageGermanMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_de.png", 16, 16));
        this.languageEnglishMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_en.png", 16, 16));
        this.languageSpanishMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_es.png", 16, 16));
        this.languageFrenchMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_fr.png", 16, 16));
        this.languageItalianMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_it.png", 16, 16));
        this.languageJapaneseMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_ja.png", 16, 16));
        this.languageDanishMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_da.png", 16, 16));
        this.languageDutchMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_nl.png", 16, 16));
        this.languageRussianMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_ru.png", 16, 16));
        this.languagePolishMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_pl.png", 16, 16));
        this.languageSwedishMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_sv.png", 16, 16));
        this.languageEsperantoMenuItem.setIcon(MiscToolkit.getScaledImage("/data/flag_eo.png", 16, 16));
        this.languageDefaultMenuItem.addActionListener(new LanguageAction(null, false));
        this.languageGermanMenuItem.addActionListener(new LanguageAction("de", false));
        this.languageDanishMenuItem.addActionListener(new LanguageAction("da", false));
        this.languageEnglishMenuItem.addActionListener(new LanguageAction("en", false));
        this.languageDutchMenuItem.addActionListener(new LanguageAction("nl", false));
        this.languageFrenchMenuItem.addActionListener(new LanguageAction("fr", false));
        this.languageJapaneseMenuItem.addActionListener(new LanguageAction("ja", false));
        this.languageRussianMenuItem.addActionListener(new LanguageAction("ru", false));
        this.languageItalianMenuItem.addActionListener(new LanguageAction("it", false));
        this.languageSpanishMenuItem.addActionListener(new LanguageAction("es", false));
        this.languageBulgarianMenuItem.addActionListener(new LanguageAction("bg", false));
        this.languagePolishMenuItem.addActionListener(new LanguageAction("pl", false));
        this.languageSwedishMenuItem.addActionListener(new LanguageAction("sv", false));
        this.languageEsperantoMenuItem.addActionListener(new LanguageAction("eo", false));
        this.buildinLanguageMenuItemsList = new ArrayList<JRadioButtonMenuItem>();
        this.buildinLanguageMenuItemsList.add(this.languageDefaultMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageBulgarianMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageDanishMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageDutchMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageEnglishMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageFrenchMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageGermanMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageItalianMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageJapaneseMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languagePolishMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageRussianMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageSpanishMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageSwedishMenuItem);
        this.buildinLanguageMenuItemsList.add(this.languageEsperantoMenuItem);
        this.buildinLanguageMenuItemsMap = new HashMap();
        this.buildinLanguageMenuItemsMap.put("default", this.languageDefaultMenuItem);
        this.buildinLanguageMenuItemsMap.put("da", this.languageDanishMenuItem);
        this.buildinLanguageMenuItemsMap.put("de", this.languageGermanMenuItem);
        this.buildinLanguageMenuItemsMap.put("en", this.languageEnglishMenuItem);
        this.buildinLanguageMenuItemsMap.put("nl", this.languageDutchMenuItem);
        this.buildinLanguageMenuItemsMap.put("fr", this.languageFrenchMenuItem);
        this.buildinLanguageMenuItemsMap.put("ja", this.languageJapaneseMenuItem);
        this.buildinLanguageMenuItemsMap.put("it", this.languageItalianMenuItem);
        this.buildinLanguageMenuItemsMap.put("es", this.languageSpanishMenuItem);
        this.buildinLanguageMenuItemsMap.put("bg", this.languageBulgarianMenuItem);
        this.buildinLanguageMenuItemsMap.put("ru", this.languageRussianMenuItem);
        this.buildinLanguageMenuItemsMap.put("pl", this.languagePolishMenuItem);
        this.buildinLanguageMenuItemsMap.put("sv", this.languageSwedishMenuItem);
        this.buildinLanguageMenuItemsMap.put("eo", this.languageEsperantoMenuItem);
    }

    public static LanguageGuiSupport getInstance() {
        if (instance == null) {
            instance = new LanguageGuiSupport();
        }
        return instance;
    }

    public void buildInitialLanguageMenu(JMenu langMenu) {
        this.languageMenu = langMenu;
        this.buildLanguageMenu();
    }

    public void updateLanguageMenu() {
        this.languageMenu.removeAll();
        ArrayList<AbstractButton> l = new ArrayList<AbstractButton>();
        Enumeration<AbstractButton> e = this.languageMenuButtonGroup.getElements();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        for (AbstractButton b : l) {
            this.languageMenuButtonGroup.remove(b);
        }
        this.buildLanguageMenu();
    }

    private void buildLanguageMenu() {
        JRadioButtonMenuItem languageItem;
        boolean anItemIsSelected = false;
        String configuredLang = Core.frostSettings.getValue("locale");
        String langIsExternal = Core.frostSettings.getValue("localeExternal");
        boolean isExternal = langIsExternal != null && langIsExternal.length() != 0 && langIsExternal.equals("true");
        for (JRadioButtonMenuItem n : this.buildinLanguageMenuItemsList) {
            this.languageMenuButtonGroup.add(n);
        }
        this.languageMenu.add(this.languageDefaultMenuItem);
        this.languageMenu.addSeparator();
        this.languageMenu.add(this.languageBulgarianMenuItem);
        this.languageMenu.add(this.languageDanishMenuItem);
        this.languageMenu.add(this.languageDutchMenuItem);
        this.languageMenu.add(this.languageEnglishMenuItem);
        this.languageMenu.add(this.languageEsperantoMenuItem);
        this.languageMenu.add(this.languageFrenchMenuItem);
        this.languageMenu.add(this.languageGermanMenuItem);
        this.languageMenu.add(this.languageItalianMenuItem);
        this.languageMenu.add(this.languageJapaneseMenuItem);
        this.languageMenu.add(this.languagePolishMenuItem);
        this.languageMenu.add(this.languageRussianMenuItem);
        this.languageMenu.add(this.languageSpanishMenuItem);
        this.languageMenu.add(this.languageSwedishMenuItem);
        List<Locale> externalLocales = Language.getExternalLocales();
        if (externalLocales.size() > 0) {
            this.languageMenu.addSeparator();
            for (Locale locale : externalLocales) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem();
                String localeDesc = locale.getDisplayName() + "  (external) (" + locale.getLanguage() + ")";
                item.setText(localeDesc);
                item.addActionListener(new LanguageAction(locale.getLanguage(), true));
                this.languageMenuButtonGroup.add(item);
                this.languageMenu.add(item);
                if (!isExternal || !locale.getLanguage().equals(configuredLang)) continue;
                this.languageMenuButtonGroup.setSelected(item.getModel(), true);
                anItemIsSelected = true;
            }
        }
        if (!anItemIsSelected && !isExternal && (languageItem = this.buildinLanguageMenuItemsMap.get(configuredLang)) != null) {
            this.languageMenuButtonGroup.setSelected(((JMenuItem)languageItem).getModel(), true);
            anItemIsSelected = true;
        }
        if (!anItemIsSelected) {
            this.languageMenuButtonGroup.setSelected(this.languageDefaultMenuItem.getModel(), true);
        }
        this.translateLanguageMenu();
    }

    private void setLanguageResource(String newLocaleName, boolean isExternal) {
        if (newLocaleName == null) {
            Core.frostSettings.setValue("locale", "default");
            Core.frostSettings.setValue("localeExternal", "false");
            isExternal = false;
        } else {
            Core.frostSettings.setValue("locale", newLocaleName);
            Core.frostSettings.setValue("localeExternal", Boolean.toString(isExternal));
        }
        this.language.changeLanguage(newLocaleName, isExternal);
    }

    public void translateLanguageMenu() {
        this.languageDefaultMenuItem.setText(this.language.getString("MainFrame.menu.language.default"));
        this.languageDanishMenuItem.setText(this.language.getString("MainFrame.menu.language.danish"));
        this.languageDutchMenuItem.setText(this.language.getString("MainFrame.menu.language.dutch"));
        this.languageEnglishMenuItem.setText(this.language.getString("MainFrame.menu.language.english"));
        this.languageFrenchMenuItem.setText(this.language.getString("MainFrame.menu.language.french"));
        this.languageGermanMenuItem.setText(this.language.getString("MainFrame.menu.language.german"));
        this.languageItalianMenuItem.setText(this.language.getString("MainFrame.menu.language.italian"));
        this.languageJapaneseMenuItem.setText(this.language.getString("MainFrame.menu.language.japanese"));
        this.languageSpanishMenuItem.setText(this.language.getString("MainFrame.menu.language.spanish"));
        this.languageBulgarianMenuItem.setText(this.language.getString("MainFrame.menu.language.bulgarian"));
        this.languageRussianMenuItem.setText(this.language.getString("MainFrame.menu.language.russian"));
        this.languagePolishMenuItem.setText(this.language.getString("MainFrame.menu.language.polish"));
        this.languageSwedishMenuItem.setText(this.language.getString("MainFrame.menu.language.swedish"));
        this.languageEsperantoMenuItem.setText(this.language.getString("MainFrame.menu.language.esperanto"));
    }

    public static List<Locale> getBuildInLocales() {
        if (buildInLocales == null) {
            ArrayList<Locale> lst = new ArrayList<Locale>();
            lst.add(new Locale("bg"));
            lst.add(new Locale("da"));
            lst.add(new Locale("de"));
            lst.add(new Locale("en"));
            lst.add(new Locale("es"));
            lst.add(new Locale("fr"));
            lst.add(new Locale("it"));
            lst.add(new Locale("ja"));
            lst.add(new Locale("nl"));
            lst.add(new Locale("ru"));
            lst.add(new Locale("pl"));
            lst.add(new Locale("sv"));
            lst.add(new Locale("eo"));
            buildInLocales = lst;
        }
        return buildInLocales;
    }

    class LanguageAction
    implements ActionListener {
        String langCode;
        boolean isExternal;

        public LanguageAction(String langCode, boolean isExternal) {
            this.langCode = langCode;
            this.isExternal = isExternal;
        }

        public void actionPerformed(ActionEvent e) {
            LanguageGuiSupport.this.setLanguageResource(this.langCode, this.isExternal);
        }
    }
}

