/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.util.FileAccess;
import frost.util.XMLizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTools {
    private static final Logger logger = Logger.getLogger(XMLTools.class.getName());
    private static DocumentBuilderFactory validatingFactory = DocumentBuilderFactory.newInstance();
    private static DocumentBuilderFactory nonValidatingFactory = DocumentBuilderFactory.newInstance();

    public XMLTools() {
        validatingFactory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        validatingFactory.setAttribute("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        validatingFactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        validatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", Boolean.FALSE);
        validatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        validatingFactory.setValidating(true);
        nonValidatingFactory.setAttribute("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        nonValidatingFactory.setAttribute("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        nonValidatingFactory.setAttribute("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        nonValidatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", Boolean.FALSE);
        nonValidatingFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        nonValidatingFactory.setValidating(false);
    }

    public static Document getXMLDocument(XMLizable element) {
        Document doc = XMLTools.createDomDocument();
        doc.appendChild(element.getXMLElement(doc));
        return doc;
    }

    public static byte[] getRawXMLDocument(XMLizable element) {
        Document doc = XMLTools.getXMLDocument(element);
        File tmp = XMLTools.getXmlTempFile();
        byte[] result = null;
        try {
            XMLTools.writeXmlFile(doc, tmp.getPath());
            result = FileAccess.readByteArray(tmp);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception thrown in getRawXMLDocument(XMLizable element)", t);
        }
        tmp.delete();
        return result;
    }

    public static Document parseXmlContent(byte[] content, boolean validating) {
        Document result = null;
        File tmp = XMLTools.getXmlTempFile();
        try {
            FileAccess.writeFile(content, tmp);
            result = XMLTools.parseXmlFile(tmp, validating);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception thrown in parseXmlContent", t);
        }
        tmp.delete();
        return result;
    }

    public static Document parseXmlFile(String filename, boolean validating) throws IllegalArgumentException {
        return XMLTools.parseXmlFile(new File(filename), validating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXmlFile(File file, boolean validating) throws IllegalArgumentException {
        try {
            DocumentBuilder builder;
            if (validating) {
                DocumentBuilderFactory documentBuilderFactory = validatingFactory;
                synchronized (documentBuilderFactory) {
                    builder = validatingFactory.newDocumentBuilder();
                }
            }
            DocumentBuilderFactory documentBuilderFactory = nonValidatingFactory;
            synchronized (documentBuilderFactory) {
                builder = nonValidatingFactory.newDocumentBuilder();
            }
            return builder.parse(file);
        }
        catch (SAXException e) {
            logger.log(Level.SEVERE, "Parsing of xml file failed (send badfile.xml to a dev for analysis) - File name: '" + file.getName() + "'", e);
            file.renameTo(new File("badfile.xml"));
            throw new IllegalArgumentException();
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception thrown in parseXmlFile(File file, boolean validating) - File name: '" + file.getName() + "'", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception thrown in parseXmlFile(File file, boolean validating) - File name: '" + file.getName() + "'", e);
        }
        return null;
    }

    public static boolean writeXmlFile(Document doc, String filename) {
        return XMLTools.writeXmlFile(doc, new File(filename));
    }

    public static boolean writeXmlFile(Document doc, File file) {
        try {
            OutputFormat format = new OutputFormat(doc, "UTF-8", false);
            format.setLineSeparator("\r\n");
            format.setLineWidth(0);
            format.setPreserveSpace(true);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            XMLSerializer serializer = new XMLSerializer(writer, format);
            serializer.asDOMSerializer();
            serializer.serialize(doc);
            writer.close();
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception thrown in writeXmlFile(Document doc, String filename)", ex);
            return false;
        }
    }

    public static Document createDomDocument() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.SEVERE, "Exception thrown in createDomDocument()", e);
            return null;
        }
    }

    public static boolean getBoolValueFromAttribute(Element el, String attr, boolean defaultVal) {
        String res = el.getAttribute(attr);
        if (res == null) {
            return defaultVal;
        }
        return res.toLowerCase().equals("true");
    }

    public static List<Element> getChildElementsByTagName(Element parent, String name) {
        LinkedList<Element> newList = new LinkedList<Element>();
        NodeList childs = parent.getChildNodes();
        for (int x = 0; x < childs.getLength(); ++x) {
            Element ele;
            Node child = childs.item(x);
            if (child.getNodeType() != 1 || !(ele = (Element)child).getTagName().equals(name)) continue;
            newList.add(ele);
        }
        return newList;
    }

    public static String getChildElementsTextValue(Element parent, String childname) {
        List<Element> nodes = XMLTools.getChildElementsByTagName(parent, childname);
        if (nodes.size() == 0) {
            return null;
        }
        Text txtname = (Text)((Node)nodes.get(0)).getFirstChild();
        if (txtname == null) {
            return null;
        }
        return txtname.getData();
    }

    public static String getChildElementsCDATAValue(Element parent, String childname) {
        List<Element> nodes = XMLTools.getChildElementsByTagName(parent, childname);
        if (nodes.size() == 0) {
            return null;
        }
        CDATASection txtname = (CDATASection)((Node)nodes.get(0)).getFirstChild();
        if (txtname == null) {
            return null;
        }
        if (txtname.getNextSibling() == null) {
            return txtname.getData();
        }
        StringBuilder sb = new StringBuilder(txtname.getData());
        while (txtname.getNextSibling() != null) {
            txtname = (CDATASection)txtname.getNextSibling();
            sb.append(txtname.getData());
        }
        return sb.toString();
    }

    private static File getXmlTempFile() {
        File tmp = FileAccess.createTempFile("xmltools_", ".tmp");
        tmp.deleteOnExit();
        return tmp;
    }
}

