/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.boards.Board;
import frost.messages.Attachment;
import frost.util.XMLTools;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BoardAttachment
extends Attachment {
    private Board boardObj;

    public int getType() {
        return 1;
    }

    public Element getXMLElement(Document container) {
        Element el = container.createElement("Attachment");
        el.setAttribute("type", "board");
        Element name = container.createElement("Name");
        CDATASection cdata = container.createCDATASection(this.boardObj.getName());
        name.appendChild(cdata);
        el.appendChild(name);
        if (this.boardObj.getPublicKey() != null) {
            Element pubkey = container.createElement("pubKey");
            cdata = container.createCDATASection(this.boardObj.getPublicKey());
            pubkey.appendChild(cdata);
            el.appendChild(pubkey);
        }
        if (this.boardObj.getPrivateKey() != null) {
            Element privkey = container.createElement("privKey");
            cdata = container.createCDATASection(this.boardObj.getPrivateKey());
            privkey.appendChild(cdata);
            el.appendChild(privkey);
        }
        if (this.boardObj.getDescription() != null) {
            Element description = container.createElement("description");
            cdata = container.createCDATASection(this.boardObj.getDescription());
            description.appendChild(cdata);
            el.appendChild(description);
        }
        return el;
    }

    public void loadXMLElement(Element e) throws SAXException {
        String name = XMLTools.getChildElementsCDATAValue(e, "Name");
        String privkey = XMLTools.getChildElementsCDATAValue(e, "privKey");
        String pubkey = XMLTools.getChildElementsCDATAValue(e, "pubKey");
        String description = XMLTools.getChildElementsCDATAValue(e, "description");
        this.boardObj = new Board(name, pubkey, privkey, description);
    }

    protected BoardAttachment(Element e) throws SAXException {
        this.loadXMLElement(e);
    }

    public BoardAttachment(Board obj) {
        this.boardObj = obj;
    }

    public Board getBoardObj() {
        return this.boardObj;
    }

    public String toString() {
        if (this.getBoardObj() != null) {
            return this.getBoardObj().getName();
        }
        return "*ERR*";
    }

    public int compareTo(Object o) {
        String me = this.toString();
        String other = ((BoardAttachment)o).toString();
        return me.compareToIgnoreCase(other);
    }
}

