/*
 * Decompiled with CFR 0.152.
 */
package frost.identities;

import frost.Core;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.storage.StorageException;
import frost.storage.perst.identities.IdentitiesStorage;
import frost.util.Mixed;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrostIdentities {
    private static final Logger logger = Logger.getLogger(FrostIdentities.class.getName());
    private Hashtable<String, Identity> identities = null;
    private Hashtable<String, LocalIdentity> localIdentities = null;
    private final Object lockObject = new Object();
    Language language = Language.getInstance();

    public void initialize(boolean freenetIsOnline) throws StorageException {
        this.localIdentities = IdentitiesStorage.inst().loadLocalIdentities();
        if (this.localIdentities.size() == 0) {
            LocalIdentity mySelf;
            if (!freenetIsOnline) {
                MiscToolkit.showMessage(this.language.getString("Core.loadIdentities.ConnectionNotEstablishedBody"), 0, this.language.getString("Core.loadIdentities.ConnectionNotEstablishedTitle"));
                System.exit(2);
            }
            if ((mySelf = this.createIdentity(true)) == null) {
                logger.severe("Frost can't run without an identity.");
                System.exit(1);
            }
            this.addLocalIdentity(mySelf);
        }
        this.identities = IdentitiesStorage.inst().loadIdentities();
        for (LocalIdentity li : this.localIdentities.values()) {
            this.identities.remove(li.getUniqueName());
        }
    }

    public LocalIdentity createIdentity() {
        LocalIdentity li = this.createIdentity(false);
        if (li != null && !this.addLocalIdentity(li)) {
            return null;
        }
        return li;
    }

    private LocalIdentity createIdentity(boolean firstIdentity) {
        LocalIdentity newIdentity = null;
        try {
            String nick = null;
            while ((nick = JOptionPane.showInputDialog(this.language.getString("Core.loadIdentities.ChooseName"))) != null) {
                nick = nick.trim();
                boolean isNickOk = true;
                if (nick.length() < 2 || nick.length() > 32) {
                    isNickOk = false;
                } else if (nick.indexOf("@") > -1) {
                    isNickOk = false;
                } else if (!Character.isLetter(nick.charAt(0))) {
                    isNickOk = false;
                } else {
                    char oldChar = '\u0000';
                    int charCount = 0;
                    for (int x = 0; x < nick.length(); ++x) {
                        if (nick.charAt(x) == oldChar) {
                            ++charCount;
                        } else {
                            oldChar = nick.charAt(x);
                            charCount = 1;
                        }
                        if (charCount <= 3) continue;
                        isNickOk = false;
                        break;
                    }
                }
                if (!isNickOk) {
                    MiscToolkit.showMessage(this.language.getString("Core.loadIdentities.InvalidNameBody"), 0, this.language.getString("Core.loadIdentities.InvalidNameTitle"));
                }
                if (!isNickOk) continue;
            }
            if (nick == null) {
                return null;
            }
            while ((newIdentity = new LocalIdentity(nick)).getUniqueName().indexOf("//") != -1) {
            }
        }
        catch (Exception e) {
            logger.severe("couldn't create new identitiy" + e.toString());
        }
        if (newIdentity != null && firstIdentity) {
            Core.frostSettings.setValue("userName", newIdentity.getUniqueName());
        }
        return newIdentity;
    }

    public Identity getIdentity(String uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        Identity identity = null;
        identity = this.getLocalIdentity(uniqueName);
        if (identity == null) {
            identity = this.identities.get(uniqueName);
        }
        return identity;
    }

    public boolean addIdentity(Identity id) {
        return this.addIdentity(id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIdentity(Identity id, boolean useLock) {
        if (id == null) {
            return false;
        }
        String key = id.getUniqueName();
        if (this.identities.containsKey(key)) {
            return false;
        }
        if (useLock && !IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            if (!IdentitiesStorage.inst().insertIdentity(id)) {
                boolean bl = false;
                return bl;
            }
            this.identities.put(key, id);
        }
        finally {
            if (useLock) {
                IdentitiesStorage.inst().endThreadTransaction();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLocalIdentity(LocalIdentity li) {
        if (li == null) {
            return false;
        }
        if (this.localIdentities.containsKey(li.getUniqueName())) {
            return false;
        }
        if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            if (!IdentitiesStorage.inst().insertLocalIdentity(li)) {
                boolean bl = false;
                return bl;
            }
            this.localIdentities.put(li.getUniqueName(), li);
        }
        finally {
            IdentitiesStorage.inst().endThreadTransaction();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteLocalIdentity(LocalIdentity li) {
        boolean removed;
        if (li == null) {
            return false;
        }
        if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            if (!this.localIdentities.containsKey(li.getUniqueName())) {
                boolean bl = false;
                return bl;
            }
            this.localIdentities.remove(li.getUniqueName());
            removed = IdentitiesStorage.inst().removeLocalIdentity(li);
        }
        finally {
            IdentitiesStorage.inst().endThreadTransaction();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIdentity(Identity li) {
        boolean removed;
        if (li == null) {
            return false;
        }
        if (!this.identities.containsKey(li.getUniqueName())) {
            return false;
        }
        if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            this.identities.remove(li.getUniqueName());
            removed = IdentitiesStorage.inst().removeIdentity(li);
        }
        finally {
            IdentitiesStorage.inst().endThreadTransaction();
        }
        return removed;
    }

    public boolean isMySelf(String uniqueName) {
        return this.getLocalIdentity(uniqueName) != null;
    }

    public LocalIdentity getLocalIdentity(String uniqueName) {
        LocalIdentity li = null;
        li = this.localIdentities.get(uniqueName);
        return li;
    }

    public List<Identity> getAllGOODIdentities() {
        ArrayList<Identity> list = new ArrayList<Identity>();
        for (Identity id : this.identities.values()) {
            if (!id.isGOOD()) continue;
            list.add(id);
        }
        return list;
    }

    public List<LocalIdentity> getLocalIdentities() {
        return new ArrayList<LocalIdentity>(this.localIdentities.values());
    }

    public List<Identity> getIdentities() {
        return new ArrayList<Identity>(this.identities.values());
    }

    private void takeoverTrustState(Identity source, Identity target) {
        if (source.isGOOD()) {
            target.setGOODWithoutUpdate();
            target.modify();
        } else if (source.isOBSERVE()) {
            target.setOBSERVEWithoutUpdate();
            target.modify();
        } else if (source.isBAD()) {
            target.setBADWithoutUpdate();
            target.modify();
        } else if (source.isCHECK()) {
            target.setCHECKWithoutUpdate();
            target.modify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importIdentities(List<Identity> importedIdentities) {
        if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
            return 0;
        }
        int importedCount = 0;
        try {
            for (Identity newId : importedIdentities) {
                if (!this.isNewIdentityValid(newId)) continue;
                Identity oldId = this.getIdentity(newId.getUniqueName());
                if (oldId == null) {
                    if (!this.addIdentity(newId, false)) continue;
                    ++importedCount;
                    continue;
                }
                if (!oldId.isCHECK() || newId.isCHECK()) continue;
                this.takeoverTrustState(newId, oldId);
                ++importedCount;
            }
        }
        finally {
            IdentitiesStorage.inst().endThreadTransaction();
        }
        return importedCount;
    }

    public boolean isIdentityValid(Identity id) {
        if (id == null) {
            return false;
        }
        String uName = id.getUniqueName();
        String puKey = id.getPublicKey();
        try {
            String given_digest = uName.substring(uName.indexOf("@") + 1, uName.length()).trim();
            String calculatedDigest = Core.getCrypto().digest(puKey.trim()).trim();
            calculatedDigest = Mixed.makeFilename(calculatedDigest).trim();
            if (!given_digest.equals(calculatedDigest)) {
                logger.severe("Warning: public key of sharer didn't match its digest:\ngiven digest :'" + given_digest + "'\n" + "pubkey       :'" + puKey.trim() + "'\n" + "calc. digest :'" + calculatedDigest + "'");
                return false;
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Exception during key validation", e);
            return false;
        }
        return true;
    }

    public boolean isNewIdentityValid(Identity id) {
        if (!this.isIdentityValid(id)) {
            return false;
        }
        for (Identity identity : this.getIdentities()) {
            if (!id.getPublicKey().equals(identity.getPublicKey()) || id.getUniqueName().equals(identity.getUniqueName())) continue;
            logger.severe("Rejecting new Identity because its public key is already used by another known Identity. newId='" + id.getUniqueName() + "', oldId='" + identity.getUniqueName() + "'");
            return false;
        }
        for (Identity identity : this.getLocalIdentities()) {
            if (!id.getPublicKey().equals(identity.getPublicKey()) || id.getUniqueName().equals(identity.getUniqueName())) continue;
            logger.severe("Rejecting new Identity because its public key is already used by an OWN Identity. newId='" + id.getUniqueName() + "', oldId='" + identity.getUniqueName() + "'");
            return false;
        }
        return true;
    }

    public Object getLockObject() {
        return this.lockObject;
    }
}

