/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.MainFrame;
import frost.SettingsClass;
import frost.fcp.FcpHandler;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class NewsPanel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private final JLabel uploadHtlOrPrioLabel = new JLabel();
    private final JTextField uploadHtlOrPrioTextField = new JTextField(8);
    private final JLabel downloadHtlOrPrioLabel = new JLabel();
    private final JTextField downloadHtlOrPrioTextField = new JTextField(8);
    private final JLabel displayDaysLabel = new JLabel();
    private final JTextField displayDaysTextField = new JTextField(8);
    private final JLabel downloadDaysLabel = new JLabel();
    private final JTextField downloadDaysTextField = new JTextField(8);
    private final JLabel messageBaseLabel = new JLabel();
    private final JTextField messageBaseTextField = new JTextField(16);
    private final JCheckBox alwaysDownloadBackloadCheckBox = new JCheckBox();
    private final JCheckBox automaticBoardUpdateCheckBox = new JCheckBox();
    private JPanel updatePanel = null;
    private final JLabel minimumIntervalLabel = new JLabel();
    private final JTextField minimumIntervalTextField = new JTextField(8);
    private final JLabel concurrentUpdatesLabel = new JLabel();
    private final JTextField concurrentUpdatesTextField = new JTextField(8);
    private final JCheckBox storeSentMessagesCheckBox = new JCheckBox();
    private final JCheckBox silentlyRetryCheckBox = new JCheckBox();
    private final JCheckBox acceptSignatureFormatV1CheckBox = new JCheckBox();
    private final JCheckBox altEditCheckBox = new JCheckBox();
    private final JTextField altEditTextField = new JTextField();
    private final Listener listener = new Listener();
    private final JCheckBox useOneConnectionForMessagesCheckBox = new JCheckBox();

    protected NewsPanel(SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    private JPanel getUpdatePanel() {
        if (this.updatePanel == null) {
            this.updatePanel = new JPanel(new GridBagLayout());
            this.updatePanel.setBorder(new EmptyBorder(0, 30, 0, 5));
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.insets = new Insets(0, 5, 5, 5);
            constraints.weighty = 0.0;
            constraints.weightx = 0.0;
            constraints.anchor = 18;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.gridx = 0;
            constraints.weightx = 0.5;
            this.updatePanel.add((Component)this.minimumIntervalLabel, constraints);
            constraints.fill = 0;
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            this.updatePanel.add((Component)this.minimumIntervalTextField, constraints);
            constraints.insets = new Insets(0, 5, 0, 5);
            constraints.fill = 2;
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.weightx = 0.5;
            this.updatePanel.add((Component)this.concurrentUpdatesLabel, constraints);
            constraints.fill = 0;
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            this.updatePanel.add((Component)this.concurrentUpdatesTextField, constraints);
        }
        return this.updatePanel;
    }

    private void initialize() {
        this.setName("NewsPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.uploadHtlOrPrioTextField, this.language);
        new TextComponentClipboardMenu(this.downloadHtlOrPrioTextField, this.language);
        new TextComponentClipboardMenu(this.displayDaysTextField, this.language);
        new TextComponentClipboardMenu(this.downloadDaysTextField, this.language);
        new TextComponentClipboardMenu(this.messageBaseTextField, this.language);
        new TextComponentClipboardMenu(this.minimumIntervalTextField, this.language);
        new TextComponentClipboardMenu(this.concurrentUpdatesTextField, this.language);
        new TextComponentClipboardMenu(this.altEditTextField, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 5, 5, 5);
        constraints.gridy = 0;
        constraints.gridx = 0;
        this.add((Component)this.displayDaysLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.displayDaysTextField, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)this.downloadDaysLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.downloadDaysTextField, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        this.add((Component)this.alwaysDownloadBackloadCheckBox, constraints);
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)this.messageBaseLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.messageBaseTextField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.uploadHtlOrPrioLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.uploadHtlOrPrioTextField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.downloadHtlOrPrioLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.downloadHtlOrPrioTextField, constraints);
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        ++constraints.gridy;
        this.add((Component)this.automaticBoardUpdateCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.getUpdatePanel(), constraints);
        if (FcpHandler.isFreenet07()) {
            ++constraints.gridy;
            this.add((Component)this.useOneConnectionForMessagesCheckBox, constraints);
        }
        ++constraints.gridy;
        this.add((Component)this.storeSentMessagesCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.silentlyRetryCheckBox, constraints);
        ++constraints.gridy;
        this.add((Component)this.acceptSignatureFormatV1CheckBox, constraints);
        constraints.gridwidth = 1;
        constraints.insets = new Insets(0, 5, 0, 5);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.altEditCheckBox, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.add((Component)this.altEditTextField, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(""), constraints);
        this.automaticBoardUpdateCheckBox.addActionListener(this.listener);
        this.altEditCheckBox.addChangeListener(this.listener);
    }

    private void loadSettings() {
        if (FcpHandler.isFreenet07()) {
            this.uploadHtlOrPrioTextField.setText(this.settings.getValue("fcp2.defaultPriorityMessageUpload"));
            this.downloadHtlOrPrioTextField.setText(this.settings.getValue("fcp2.defaultPriorityMessageDownload"));
            this.useOneConnectionForMessagesCheckBox.setSelected(this.settings.getBoolValue("fcp2.useOneConnectionForMessages"));
        } else {
            this.uploadHtlOrPrioTextField.setText(this.settings.getValue("tofUploadHtl"));
            this.downloadHtlOrPrioTextField.setText(this.settings.getValue("tofDownloadHtl"));
        }
        this.displayDaysTextField.setText(this.settings.getValue("maxMessageDisplay"));
        this.downloadDaysTextField.setText(this.settings.getValue("maxMessageDownload"));
        this.messageBaseTextField.setText(this.settings.getValue("messageBase"));
        this.alwaysDownloadBackloadCheckBox.setSelected(this.settings.getBoolValue("alwaysDownloadMessagesBackload"));
        this.minimumIntervalTextField.setText(this.settings.getValue("automaticUpdate.boardsMinimumUpdateInterval"));
        this.concurrentUpdatesTextField.setText(this.settings.getValue("automaticUpdate.concurrentBoardUpdates"));
        this.automaticBoardUpdateCheckBox.setSelected(MainFrame.getInstance().isAutomaticBoardUpdateEnabled());
        this.refreshUpdateState();
        this.storeSentMessagesCheckBox.setSelected(this.settings.getBoolValue("storage.storeSentMessages"));
        this.silentlyRetryCheckBox.setSelected(this.settings.getBoolValue("silentlyRetryMessages"));
        this.acceptSignatureFormatV1CheckBox.setSelected(this.settings.getBoolValue("acceptSignatureFormatV1"));
        this.altEditCheckBox.setSelected(this.settings.getBoolValue("useAltEdit"));
        this.altEditTextField.setEnabled(this.altEditCheckBox.isSelected());
        this.altEditTextField.setText(this.settings.getValue("altEdit"));
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        if (FcpHandler.isFreenet07()) {
            this.uploadHtlOrPrioLabel.setText(this.language.getString("Options.news.1.messageUploadPriority") + " (2)");
            this.downloadHtlOrPrioLabel.setText(this.language.getString("Options.news.1.messageDownloadPriority") + " (2)");
            this.useOneConnectionForMessagesCheckBox.setText(this.language.getString("Options.news.1.useOneConnectionForMessages"));
        } else {
            this.uploadHtlOrPrioLabel.setText(this.language.getString("Options.news.1.messageUploadHtl") + " (21)");
            this.downloadHtlOrPrioLabel.setText(this.language.getString("Options.news.1.messageDownloadHtl") + " (23)");
        }
        this.displayDaysLabel.setText(this.language.getString("Options.news.1.numberOfDaysToDisplay") + " (15)");
        this.downloadDaysLabel.setText(this.language.getString("Options.news.1.numberOfDaysToDownloadBackwards") + " (5)");
        this.messageBaseLabel.setText(this.language.getString("Options.news.1.messageBase") + " (news)");
        this.alwaysDownloadBackloadCheckBox.setText(this.language.getString("Options.news.1.alwaysDownloadBackload"));
        this.alwaysDownloadBackloadCheckBox.setToolTipText(this.language.getString("Options.news.1.alwaysDownloadBackload.tooltip"));
        String minutes = this.language.getString("Options.common.minutes");
        this.minimumIntervalLabel.setText(this.language.getString("Options.news.3.minimumUpdateInterval") + " (" + minutes + ") (45)");
        this.concurrentUpdatesLabel.setText(this.language.getString("Options.news.3.numberOfConcurrentlyUpdatingBoards") + " (6)");
        this.automaticBoardUpdateCheckBox.setText(this.language.getString("Options.news.3.automaticBoardUpdate"));
        this.storeSentMessagesCheckBox.setText(this.language.getString("Options.news.1.storeSentMessages"));
        this.silentlyRetryCheckBox.setText(this.language.getString("Options.news.3.silentlyRetryFailedMessages"));
        this.acceptSignatureFormatV1CheckBox.setText(this.language.getString("Options.news.3.acceptSignatureFormatV1"));
        String off = this.language.getString("Options.common.off");
        this.altEditCheckBox.setText(this.language.getString("Options.miscellaneous.useEditorForWritingMessages") + " (" + off + ")");
    }

    private void saveSettings() {
        if (FcpHandler.isFreenet07()) {
            this.settings.setValue("fcp2.defaultPriorityMessageUpload", this.uploadHtlOrPrioTextField.getText());
            this.settings.setValue("fcp2.defaultPriorityMessageDownload", this.downloadHtlOrPrioTextField.getText());
            this.settings.setValue("fcp2.useOneConnectionForMessages", this.useOneConnectionForMessagesCheckBox.isSelected());
        } else {
            this.settings.setValue("tofUploadHtl", this.uploadHtlOrPrioTextField.getText());
            this.settings.setValue("tofDownloadHtl", this.downloadHtlOrPrioTextField.getText());
        }
        this.settings.setValue("maxMessageDisplay", this.displayDaysTextField.getText());
        this.settings.setValue("maxMessageDownload", this.downloadDaysTextField.getText());
        this.settings.setValue("messageBase", this.messageBaseTextField.getText().trim().toLowerCase());
        this.settings.setValue("alwaysDownloadMessagesBackload", this.alwaysDownloadBackloadCheckBox.isSelected());
        this.settings.setValue("automaticUpdate.concurrentBoardUpdates", this.concurrentUpdatesTextField.getText());
        this.settings.setValue("automaticUpdate.boardsMinimumUpdateInterval", this.minimumIntervalTextField.getText());
        MainFrame.getInstance().setAutomaticBoardUpdateEnabled(this.automaticBoardUpdateCheckBox.isSelected());
        this.settings.setValue("storage.storeSentMessages", this.storeSentMessagesCheckBox.isSelected());
        this.settings.setValue("silentlyRetryMessages", this.silentlyRetryCheckBox.isSelected());
        this.settings.setValue("acceptSignatureFormatV1", this.acceptSignatureFormatV1CheckBox.isSelected());
        this.settings.setValue("useAltEdit", this.altEditCheckBox.isSelected());
        this.settings.setValue("altEdit", this.altEditTextField.getText());
    }

    private void refreshUpdateState() {
        MiscToolkit.setContainerEnabled(this.getUpdatePanel(), this.automaticBoardUpdateCheckBox.isSelected());
    }

    private void altEditChanged() {
        this.altEditTextField.setEnabled(this.altEditCheckBox.isSelected());
    }

    private class Listener
    implements ActionListener,
    ChangeListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == NewsPanel.this.automaticBoardUpdateCheckBox) {
                NewsPanel.this.refreshUpdateState();
            }
        }

        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == NewsPanel.this.altEditCheckBox) {
                NewsPanel.this.altEditChanged();
            }
        }
    }
}

