/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class News2Panel
extends JPanel {
    private SettingsClass settings = null;
    private Language language = null;
    private final JCheckBox blockBoardCheckBox = new JCheckBox();
    private final JTextArea blockBoardTextField = new JTextArea(2, 0);
    private final JCheckBox blockBodyCheckBox = new JCheckBox();
    private final JTextArea blockBodyTextField = new JTextArea(2, 0);
    private final JCheckBox blockSubjectCheckBox = new JCheckBox();
    private final JTextArea blockSubjectTextField = new JTextArea(2, 0);
    private final JCheckBox hideBadMessagesCheckBox = new JCheckBox();
    private final JCheckBox hideCheckMessagesCheckBox = new JCheckBox();
    private final JCheckBox hideObserveMessagesCheckBox = new JCheckBox();
    private final JCheckBox hideUnsignedMessagesCheckBox = new JCheckBox();
    private final JCheckBox blockBoardsFromBadCheckBox = new JCheckBox();
    private final JCheckBox blockBoardsFromCheckCheckBox = new JCheckBox();
    private final JCheckBox blockBoardsFromObserveCheckBox = new JCheckBox();
    private final JCheckBox blockBoardsFromUnsignedCheckBox = new JCheckBox();
    private final JLabel hideMessagesLabel = new JLabel();
    private final JLabel blockBoardsLabel = new JLabel();
    private final Listener listener = new Listener();

    protected News2Panel(SettingsClass settings) {
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
    }

    private void blockBoardPressed() {
        this.blockBoardTextField.setEnabled(this.blockBoardCheckBox.isSelected());
    }

    private void blockBodyPressed() {
        this.blockBodyTextField.setEnabled(this.blockBodyCheckBox.isSelected());
    }

    private void blockSubjectPressed() {
        this.blockSubjectTextField.setEnabled(this.blockSubjectCheckBox.isSelected());
    }

    private JPanel getHideMessagesPanel() {
        JPanel hidePanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 4;
        hidePanel.add((Component)this.hideMessagesLabel, constraints);
        ++constraints.gridy;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.insets = new Insets(5, 20, 5, 5);
        hidePanel.add((Component)this.hideObserveMessagesCheckBox, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 5, 0, 5);
        hidePanel.add((Component)this.hideCheckMessagesCheckBox, constraints);
        constraints.gridx = 2;
        hidePanel.add((Component)this.hideBadMessagesCheckBox, constraints);
        constraints.gridx = 3;
        hidePanel.add((Component)this.hideUnsignedMessagesCheckBox, constraints);
        return hidePanel;
    }

    private JPanel getBlockBoardsPanel() {
        JPanel blockBoardsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 4;
        blockBoardsPanel.add((Component)this.blockBoardsLabel, constraints);
        ++constraints.gridy;
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.gridx = 0;
        constraints.insets = new Insets(5, 20, 5, 5);
        blockBoardsPanel.add((Component)this.blockBoardsFromObserveCheckBox, constraints);
        constraints.gridx = 1;
        constraints.insets = new Insets(5, 5, 0, 5);
        blockBoardsPanel.add((Component)this.blockBoardsFromCheckCheckBox, constraints);
        constraints.gridx = 2;
        blockBoardsPanel.add((Component)this.blockBoardsFromBadCheckBox, constraints);
        constraints.gridx = 3;
        blockBoardsPanel.add((Component)this.blockBoardsFromUnsignedCheckBox, constraints);
        return blockBoardsPanel;
    }

    private void initialize() {
        this.setName("News2Panel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.blockBodyTextField, this.language);
        new TextComponentClipboardMenu(this.blockBoardTextField, this.language);
        new TextComponentClipboardMenu(this.blockSubjectTextField, this.language);
        this.blockBoardTextField.setLineWrap(true);
        this.blockBodyTextField.setLineWrap(true);
        this.blockSubjectTextField.setLineWrap(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        Insets insets5555 = new Insets(5, 5, 5, 5);
        Insets insets0_30_5_5 = new Insets(0, 30, 5, 5);
        constraints.insets = insets5555;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.blockSubjectCheckBox, constraints);
        constraints.insets = insets0_30_5_5;
        ++constraints.gridy;
        constraints.weighty = 0.9;
        JScrollPane sp = new JScrollPane(this.blockSubjectTextField);
        this.add((Component)sp, constraints);
        constraints.weighty = 0.0;
        constraints.insets = insets5555;
        ++constraints.gridy;
        this.add((Component)this.blockBodyCheckBox, constraints);
        constraints.insets = insets0_30_5_5;
        ++constraints.gridy;
        constraints.weighty = 0.9;
        sp = new JScrollPane(this.blockBodyTextField);
        this.add((Component)sp, constraints);
        constraints.weighty = 0.0;
        constraints.insets = insets5555;
        ++constraints.gridy;
        this.add((Component)this.blockBoardCheckBox, constraints);
        constraints.insets = insets0_30_5_5;
        ++constraints.gridy;
        constraints.weighty = 0.9;
        sp = new JScrollPane(this.blockBoardTextField);
        this.add((Component)sp, constraints);
        constraints.weighty = 0.0;
        constraints.insets = insets5555;
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)this.getHideMessagesPanel(), constraints);
        constraints.insets = new Insets(0, 5, 0, 5);
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)this.getBlockBoardsPanel(), constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        this.add((Component)new JLabel(""), constraints);
        this.blockSubjectCheckBox.addActionListener(this.listener);
        this.blockBodyCheckBox.addActionListener(this.listener);
        this.blockBoardCheckBox.addActionListener(this.listener);
    }

    private void loadSettings() {
        this.hideUnsignedMessagesCheckBox.setSelected(this.settings.getBoolValue("signedOnly"));
        this.hideBadMessagesCheckBox.setSelected(this.settings.getBoolValue("hideBadMessages"));
        this.hideCheckMessagesCheckBox.setSelected(this.settings.getBoolValue("hideCheckMessages"));
        this.hideObserveMessagesCheckBox.setSelected(this.settings.getBoolValue("hideObserveMessages"));
        this.blockBoardsFromUnsignedCheckBox.setSelected(this.settings.getBoolValue("blockBoardsFromUnsigned"));
        this.blockBoardsFromBadCheckBox.setSelected(this.settings.getBoolValue("blockBoardsFromBad"));
        this.blockBoardsFromCheckCheckBox.setSelected(this.settings.getBoolValue("blockBoardsFromCheck"));
        this.blockBoardsFromObserveCheckBox.setSelected(this.settings.getBoolValue("blockBoardsFromObserve"));
        this.blockSubjectCheckBox.setSelected(this.settings.getBoolValue("blockMessageChecked"));
        this.blockSubjectTextField.setEnabled(this.blockSubjectCheckBox.isSelected());
        this.blockSubjectTextField.setText(this.settings.getValue("blockMessage"));
        this.blockBodyCheckBox.setSelected(this.settings.getBoolValue("blockMessageBodyChecked"));
        this.blockBodyTextField.setEnabled(this.blockBodyCheckBox.isSelected());
        this.blockBodyTextField.setText(this.settings.getValue("blockMessageBody"));
        this.blockBoardCheckBox.setSelected(this.settings.getBoolValue("blockMessageBoardChecked"));
        this.blockBoardTextField.setEnabled(this.blockBoardCheckBox.isSelected());
        this.blockBoardTextField.setText(this.settings.getValue("blockMessageBoard"));
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        this.hideMessagesLabel.setText(this.language.getString("Options.news.2.hideMessagesWithTrustStates"));
        this.hideUnsignedMessagesCheckBox.setText(this.language.getString("Options.news.2.trustState.none"));
        this.hideBadMessagesCheckBox.setText(this.language.getString("Options.news.2.trustState.bad"));
        this.hideCheckMessagesCheckBox.setText(this.language.getString("Options.news.2.trustState.check"));
        this.hideObserveMessagesCheckBox.setText(this.language.getString("Options.news.2.trustState.observe"));
        this.blockBoardsLabel.setText(this.language.getString("Options.news.2.dontAddBoardsFromTrustStates"));
        this.blockBoardsFromUnsignedCheckBox.setText(this.language.getString("Options.news.2.trustState.none"));
        this.blockBoardsFromBadCheckBox.setText(this.language.getString("Options.news.2.trustState.bad"));
        this.blockBoardsFromCheckCheckBox.setText(this.language.getString("Options.news.2.trustState.check"));
        this.blockBoardsFromObserveCheckBox.setText(this.language.getString("Options.news.2.trustState.observe"));
        this.blockSubjectCheckBox.setText(this.language.getString("Options.news.2.blockMessagesWithSubject"));
        this.blockBodyCheckBox.setText(this.language.getString("Options.news.2.blockMessagesWithBody"));
        this.blockBoardCheckBox.setText(this.language.getString("Options.news.2.blockMessagesWithTheseBoards"));
    }

    private void saveSettings() {
        this.settings.setValue("blockMessage", this.blockSubjectTextField.getText().trim().toLowerCase());
        this.settings.setValue("blockMessageChecked", this.blockSubjectCheckBox.isSelected());
        this.settings.setValue("blockMessageBody", this.blockBodyTextField.getText().trim().toLowerCase());
        this.settings.setValue("blockMessageBodyChecked", this.blockBodyCheckBox.isSelected());
        this.settings.setValue("blockMessageBoard", this.blockBoardTextField.getText().trim().toLowerCase());
        this.settings.setValue("blockMessageBoardChecked", this.blockBoardCheckBox.isSelected());
        this.settings.setValue("signedOnly", this.hideUnsignedMessagesCheckBox.isSelected());
        this.settings.setValue("hideBadMessages", this.hideBadMessagesCheckBox.isSelected());
        this.settings.setValue("hideCheckMessages", this.hideCheckMessagesCheckBox.isSelected());
        this.settings.setValue("hideObserveMessages", this.hideObserveMessagesCheckBox.isSelected());
        this.settings.setValue("blockBoardsFromUnsigned", this.blockBoardsFromUnsignedCheckBox.isSelected());
        this.settings.setValue("blockBoardsFromBad", this.blockBoardsFromBadCheckBox.isSelected());
        this.settings.setValue("blockBoardsFromCheck", this.blockBoardsFromCheckCheckBox.isSelected());
        this.settings.setValue("blockBoardsFromObserve", this.blockBoardsFromObserveCheckBox.isSelected());
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == News2Panel.this.blockSubjectCheckBox) {
                News2Panel.this.blockSubjectPressed();
            }
            if (e.getSource() == News2Panel.this.blockBodyCheckBox) {
                News2Panel.this.blockBodyPressed();
            }
            if (e.getSource() == News2Panel.this.blockBoardCheckBox) {
                News2Panel.this.blockBoardPressed();
            }
        }
    }
}

