/*
 * Decompiled with CFR 0.152.
 */
package frost.gui.preferences;

import frost.SettingsClass;
import frost.fcp.FcpHandler;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DownloadPanel
extends JPanel {
    private JDialog owner = null;
    private SettingsClass settings = null;
    private Language language = null;
    private final JLabel splitfileThreadsLabel = new JLabel();
    private final JTextField splitfileThreadsTextField = new JTextField(6);
    private final JCheckBox decodeAfterEachSegmentCheckBox = new JCheckBox();
    private final JCheckBox tryAllSegmentsCheckBox = new JCheckBox();
    private final JLabel priorityLabel = new JLabel();
    private final JTextField priorityTextField = new JTextField(6);
    private final JButton browseDirectoryButton = new JButton();
    private final JLabel directoryLabel = new JLabel();
    private final JTextField directoryTextField = new JTextField(20);
    private final Listener listener = new Listener();
    private final JLabel maxRetriesLabel = new JLabel();
    private final JTextField maxRetriesTextField = new JTextField(6);
    private final JTextField threadsTextField = new JTextField(6);
    private final JLabel threadsTextLabel = new JLabel();
    private final JCheckBox logDownloadsCheckBox = new JCheckBox();
    private final JLabel waitTimeLabel = new JLabel();
    private final JTextField waitTimeTextField = new JTextField(6);

    protected DownloadPanel(JDialog owner, SettingsClass settings) {
        this.owner = owner;
        this.language = Language.getInstance();
        this.settings = settings;
        this.initialize();
        this.loadSettings();
        if (FcpHandler.isFreenet07()) {
            this.splitfileThreadsLabel.setEnabled(false);
            this.splitfileThreadsTextField.setEnabled(false);
            this.tryAllSegmentsCheckBox.setEnabled(false);
            this.decodeAfterEachSegmentCheckBox.setEnabled(false);
        }
    }

    private void browseDirectoryPressed() {
        JFileChooser fc = new JFileChooser(this.settings.getValue("lastUsedDirectory"));
        fc.setDialogTitle(this.language.getString("Options.downloads.filechooser.title"));
        fc.setFileHidingEnabled(true);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        int returnVal = fc.showOpenDialog(this.owner);
        if (returnVal == 0) {
            String fileSeparator = System.getProperty("file.separator");
            File file = fc.getSelectedFile();
            this.settings.setValue("lastUsedDirectory", file.getParent());
            this.directoryTextField.setText(file.getPath() + fileSeparator);
        }
    }

    private void initialize() {
        this.setName("DownloadPanel");
        this.setLayout(new GridBagLayout());
        this.refreshLanguage();
        new TextComponentClipboardMenu(this.directoryTextField, this.language);
        new TextComponentClipboardMenu(this.maxRetriesTextField, this.language);
        new TextComponentClipboardMenu(this.splitfileThreadsTextField, this.language);
        new TextComponentClipboardMenu(this.threadsTextField, this.language);
        new TextComponentClipboardMenu(this.waitTimeTextField, this.language);
        GridBagConstraints constraints = new GridBagConstraints();
        Insets insets0555 = new Insets(0, 5, 5, 5);
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.insets = insets0555;
        constraints.anchor = 17;
        constraints.gridx = 0;
        this.add((Component)this.directoryLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.add((Component)this.directoryTextField, constraints);
        constraints.fill = 0;
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        this.add((Component)this.browseDirectoryButton, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.maxRetriesLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.maxRetriesTextField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.waitTimeLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.waitTimeTextField, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.threadsTextLabel, constraints);
        constraints.gridx = 1;
        this.add((Component)this.threadsTextField, constraints);
        if (FcpHandler.isFreenet07()) {
            ++constraints.gridy;
            constraints.gridx = 0;
            this.add((Component)this.priorityLabel, constraints);
            constraints.gridx = 1;
            this.add((Component)this.priorityTextField, constraints);
        } else {
            ++constraints.gridy;
            constraints.gridx = 0;
            this.add((Component)this.splitfileThreadsLabel, constraints);
            constraints.gridx = 1;
            this.add((Component)this.splitfileThreadsTextField, constraints);
            constraints.gridwidth = 3;
            constraints.insets = new Insets(5, 5, 5, 5);
            ++constraints.gridy;
            constraints.gridx = 0;
            this.add((Component)this.tryAllSegmentsCheckBox, constraints);
            constraints.insets = insets0555;
            ++constraints.gridy;
            this.add((Component)this.decodeAfterEachSegmentCheckBox, constraints);
        }
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        constraints.insets = insets0555;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        this.add((Component)this.logDownloadsCheckBox, constraints);
        this.browseDirectoryButton.addActionListener(this.listener);
    }

    private void loadSettings() {
        this.directoryTextField.setText(this.settings.getValue("downloadDirectory"));
        this.threadsTextField.setText(this.settings.getValue("downloadThreads"));
        this.maxRetriesTextField.setText("" + this.settings.getIntValue("downloadMaxRetries"));
        this.waitTimeTextField.setText("" + this.settings.getIntValue("downloadWaittime"));
        this.logDownloadsCheckBox.setSelected(this.settings.getBoolValue("logDownloads"));
        if (FcpHandler.isFreenet07()) {
            this.priorityTextField.setText(this.settings.getValue("fcp2.defaultPriorityFileDownload"));
        } else {
            this.splitfileThreadsTextField.setText(this.settings.getValue("splitfileDownloadThreads"));
            this.tryAllSegmentsCheckBox.setSelected(this.settings.getBoolValue("downloadTryAllSegments"));
            this.decodeAfterEachSegmentCheckBox.setSelected(this.settings.getBoolValue("downloadDecodeAfterEachSegment"));
        }
    }

    public void ok() {
        this.saveSettings();
    }

    private void refreshLanguage() {
        String on = this.language.getString("Options.common.on");
        String minutes = this.language.getString("Options.common.minutes");
        this.waitTimeLabel.setText(this.language.getString("Options.downloads.waittimeAfterEachTry") + " (" + minutes + ")");
        this.maxRetriesLabel.setText(this.language.getString("Options.downloads.maximumNumberOfRetries"));
        this.logDownloadsCheckBox.setText(this.language.getString("Options.downloads.logDownloads"));
        this.directoryLabel.setText(this.language.getString("Options.downloads.downloadDirectory"));
        this.browseDirectoryButton.setText(this.language.getString("Common.browse") + "...");
        this.threadsTextLabel.setText(this.language.getString("Options.downloads.numberOfSimultaneousDownloads") + " (3)");
        if (FcpHandler.isFreenet07()) {
            this.priorityLabel.setText(this.language.getString("Options.downloads.downloadPriority") + " (3)");
        } else {
            this.splitfileThreadsLabel.setText(this.language.getString("Options.downloads.numberOfSplitfileThreads") + " (30)");
            this.tryAllSegmentsCheckBox.setText(this.language.getString("Options.downloads.tryToDownloadAllSegments") + " (" + on + ")");
            this.decodeAfterEachSegmentCheckBox.setText(this.language.getString("Options.downloads.decodeEachSegmentImmediately"));
        }
    }

    private void saveSettings() {
        String filesep;
        String downlDirTxt = this.directoryTextField.getText();
        if (downlDirTxt.lastIndexOf(filesep = System.getProperty("file.separator")) != downlDirTxt.length() - 1 || downlDirTxt.lastIndexOf(filesep) < 0) {
            this.settings.setValue("downloadDirectory", downlDirTxt + filesep);
        } else {
            this.settings.setValue("downloadDirectory", downlDirTxt);
        }
        this.settings.setValue("downloadThreads", this.threadsTextField.getText());
        this.settings.setValue("downloadMaxRetries", this.maxRetriesTextField.getText());
        this.settings.setValue("downloadWaittime", this.waitTimeTextField.getText());
        this.settings.setValue("logDownloads", this.logDownloadsCheckBox.isSelected());
        if (FcpHandler.isFreenet07()) {
            this.settings.setValue("fcp2.defaultPriorityFileDownload", this.priorityTextField.getText());
        } else {
            this.settings.setValue("splitfileDownloadThreads", this.splitfileThreadsTextField.getText());
            this.settings.setValue("downloadTryAllSegments", this.tryAllSegmentsCheckBox.isSelected());
            this.settings.setValue("downloadDecodeAfterEachSegment", this.decodeAfterEachSegmentCheckBox.isSelected());
        }
    }

    public class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DownloadPanel.this.browseDirectoryButton) {
                DownloadPanel.this.browseDirectoryPressed();
            }
        }
    }
}

