/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.search;

import frost.Core;
import frost.fileTransfer.search.SearchModel;
import frost.fileTransfer.search.SearchParameters;
import frost.fileTransfer.search.SearchTable;
import frost.fileTransfer.search.SearchTableFormat;
import frost.fileTransfer.search.SearchThread;
import frost.util.gui.CloseableTabbedPane;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.search.TableFindAction;
import frost.util.gui.translation.JTranslatableComboBox;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class SearchPanel
extends JPanel
implements LanguageListener {
    private final Language language = Language.getInstance();
    private SearchSimpleToolBar searchSimpleToolBar;
    private SearchAdvancedToolBar searchAdvancedToolBar;
    private final ImageIcon searchIcon = MiscToolkit.loadImageIcon("/data/toolbar/system-search.png");
    private final ImageIcon clearIcon = MiscToolkit.loadImageIcon("/data/toolbar/user-trash.png");
    TableFindAction tableFindAction = new TableFindAction();
    private boolean isInitialized = false;
    private CloseableTabbedPane searchTabs;
    private final String[] searchComboBoxKeys = new String[]{"SearchPane.fileTypes.allFiles", "SearchPane.fileTypes.audio", "SearchPane.fileTypes.video", "SearchPane.fileTypes.images", "SearchPane.fileTypes.documents", "SearchPane.fileTypes.executables", "SearchPane.fileTypes.archives"};

    public SearchPanel() {
        this.language.addLanguageListener(this);
    }

    public void initialize() {
        if (!this.isInitialized) {
            this.searchSimpleToolBar = new SearchSimpleToolBar();
            this.searchAdvancedToolBar = new SearchAdvancedToolBar();
            this.languageChanged(null);
            this.setLayout(new BorderLayout());
            this.searchTabs = new SearchCloseableTabbedPane();
            this.add((Component)this.searchTabs, "Center");
            this.toggleMode(true);
            this.isInitialized = true;
        }
    }

    private void toggleMode(boolean toSimpleMode) {
        if (toSimpleMode) {
            this.remove(this.searchAdvancedToolBar);
            this.add((Component)this.searchSimpleToolBar, "North");
        } else {
            this.remove(this.searchSimpleToolBar);
            this.add((Component)this.searchAdvancedToolBar, "North");
        }
        this.updateUI();
    }

    public void languageChanged(LanguageEvent event) {
        this.searchSimpleToolBar.refreshLanguage();
        this.searchAdvancedToolBar.refreshLanguage();
    }

    public void startNewSearch(SearchParameters searchParams) {
        String tabText = searchParams.getTabText();
        SearchModel model = new SearchModel(new SearchTableFormat());
        SearchTable modelTable = new SearchTable(model, this.searchTabs, tabText);
        this.tableFindAction.install(modelTable.getTable());
        ProxyPanel pp = new ProxyPanel(modelTable.getScrollPane(), model, modelTable.getTable());
        this.searchTabs.addTab(tabText + " (...)", pp);
        SearchThread searchThread = new SearchThread(searchParams, modelTable, pp);
        searchThread.start();
    }

    private JSkinnablePopupMenu buildSearchOptionsMenu() {
        JSkinnablePopupMenu searchOptionsMenu = new JSkinnablePopupMenu();
        final JCheckBoxMenuItem hideBadUserFilesCheckBox = new JCheckBoxMenuItem(this.language.getString("SearchPane.toolbar.searchOptions.hideFilesFromPeopleMarkedBad"));
        final JCheckBoxMenuItem hideCheckUserFilesCheckBox = new JCheckBoxMenuItem(this.language.getString("SearchPane.toolbar.searchOptions.hideFilesFromPeopleMarkedCheck"));
        final JCheckBoxMenuItem hideObserveUserFilesCheckBox = new JCheckBoxMenuItem(this.language.getString("SearchPane.toolbar.searchOptions.hideFilesFromPeopleMarkedObserve"));
        final JCheckBoxMenuItem hideFilesWithoutChkCheckBox = new JCheckBoxMenuItem(this.language.getString("SearchPane.toolbar.searchOptions.hideFilesWithoutChk"));
        hideBadUserFilesCheckBox.setSelected(Core.frostSettings.getBoolValue("hideBadFiles"));
        hideCheckUserFilesCheckBox.setSelected(Core.frostSettings.getBoolValue("hideCheckFiles"));
        hideObserveUserFilesCheckBox.setSelected(Core.frostSettings.getBoolValue("hideObserveFiles"));
        hideFilesWithoutChkCheckBox.setSelected(Core.frostSettings.getBoolValue("hideFilesWithoutChk"));
        hideBadUserFilesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Core.frostSettings.setValue("hideBadFiles", hideBadUserFilesCheckBox.isSelected());
            }
        });
        hideCheckUserFilesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Core.frostSettings.setValue("hideCheckFiles", hideCheckUserFilesCheckBox.isSelected());
            }
        });
        hideObserveUserFilesCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Core.frostSettings.setValue("hideObserveFiles", hideObserveUserFilesCheckBox.isSelected());
            }
        });
        hideFilesWithoutChkCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Core.frostSettings.setValue("hideFilesWithoutChk", hideFilesWithoutChkCheckBox.isSelected());
            }
        });
        searchOptionsMenu.add(hideBadUserFilesCheckBox);
        searchOptionsMenu.add(hideCheckUserFilesCheckBox);
        searchOptionsMenu.add(hideObserveUserFilesCheckBox);
        searchOptionsMenu.addSeparator();
        searchOptionsMenu.add(hideFilesWithoutChkCheckBox);
        return searchOptionsMenu;
    }

    static /* synthetic */ ImageIcon access$000(SearchPanel x0) {
        return x0.searchIcon;
    }

    static /* synthetic */ ImageIcon access$500(SearchPanel x0) {
        return x0.clearIcon;
    }

    public class ProxyPanel
    extends JPanel {
        SearchModel model;
        SearchThread thread = null;
        JTable table;

        public ProxyPanel(Component c, SearchModel m, JTable table) {
            this.model = m;
            this.table = table;
            this.setLayout(new BorderLayout());
            this.add(c, "Center");
        }

        public void setSearchThread(SearchThread t) {
            this.thread = t;
        }

        public void tabWasClosed() {
            if (this.thread != null) {
                this.thread.requestCancel();
            }
            SearchPanel.this.tableFindAction.deinstall(this.table);
        }

        public SearchModel getModel() {
            return this.model;
        }
    }

    private class SearchCloseableTabbedPane
    extends CloseableTabbedPane {
        protected void tabWasClosed(Component c) {
            if (c instanceof ProxyPanel) {
                ProxyPanel pp = (ProxyPanel)c;
                pp.tabWasClosed();
                pp.getModel().clear();
            }
        }
    }

    private class SearchAdvancedToolBar
    extends JToolBar
    implements ActionListener {
        private JTranslatableComboBox searchComboBox = null;
        private final JButton searchButton = new JButton(SearchPanel.access$000(SearchPanel.this));
        private final JButton clearButton = new JButton(SearchPanel.access$500(SearchPanel.this));
        private final JButton toggleModeButtonToSimple = new JButton("<<");
        private final JLabel searchNameLabel = new JLabel();
        private final JLabel searchCommentLabel = new JLabel();
        private final JLabel searchKeywordsLabel = new JLabel();
        private final JLabel searchOwnerLabel = new JLabel();
        private final JTextField searchNameTextField = new JTextField(18);
        private final JTextField searchCommentTextField = new JTextField(18);
        private final JTextField searchKeywordsTextField = new JTextField(18);
        private final JTextField searchOwnerTextField = new JTextField(18);
        private final JButton searchOptionsButton = new JButton();

        public SearchAdvancedToolBar() {
            this.initialize();
        }

        private void initialize() {
            this.setRollover(true);
            this.setFloatable(false);
            new TextComponentClipboardMenu(this.searchNameTextField, SearchPanel.this.language);
            new TextComponentClipboardMenu(this.searchCommentTextField, SearchPanel.this.language);
            new TextComponentClipboardMenu(this.searchKeywordsTextField, SearchPanel.this.language);
            new TextComponentClipboardMenu(this.searchOwnerTextField, SearchPanel.this.language);
            this.searchComboBox = new JTranslatableComboBox(SearchPanel.this.language, SearchPanel.this.searchComboBoxKeys);
            this.toggleModeButtonToSimple.setOpaque(false);
            this.searchOptionsButton.setOpaque(false);
            this.searchOptionsButton.setFocusPainted(false);
            MiscToolkit.configureButton(this.searchButton);
            MiscToolkit.configureButton(this.clearButton);
            this.searchComboBox.setMaximumSize(this.searchComboBox.getPreferredSize());
            this.searchNameTextField.setMaximumSize(this.searchNameTextField.getPreferredSize());
            this.searchCommentTextField.setMaximumSize(this.searchCommentTextField.getPreferredSize());
            this.searchKeywordsTextField.setMaximumSize(this.searchKeywordsTextField.getPreferredSize());
            this.searchOwnerTextField.setMaximumSize(this.searchOwnerTextField.getPreferredSize());
            this.toggleModeButtonToSimple.setMargin(new Insets(0, 0, 0, 0));
            this.toggleModeButtonToSimple.setBorderPainted(false);
            this.toggleModeButtonToSimple.setFocusPainted(false);
            this.toggleModeButtonToSimple.setRolloverEnabled(true);
            Dimension blankSpace = new Dimension(8, 0);
            Dimension smallSpace = new Dimension(3, 0);
            this.add(this.toggleModeButtonToSimple);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchNameLabel);
            this.add(Box.createRigidArea(smallSpace));
            this.add(this.searchNameTextField);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchCommentLabel);
            this.add(Box.createRigidArea(smallSpace));
            this.add(this.searchCommentTextField);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchKeywordsLabel);
            this.add(Box.createRigidArea(smallSpace));
            this.add(this.searchKeywordsTextField);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchOwnerLabel);
            this.add(Box.createRigidArea(smallSpace));
            this.add(this.searchOwnerTextField);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchComboBox);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchOptionsButton);
            this.add(Box.createRigidArea(smallSpace));
            this.add(this.clearButton);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchButton);
            this.add(Box.createHorizontalGlue());
            this.searchNameTextField.addActionListener(this);
            this.searchCommentTextField.addActionListener(this);
            this.searchKeywordsTextField.addActionListener(this);
            this.searchOwnerTextField.addActionListener(this);
            this.searchButton.addActionListener(this);
            this.clearButton.addActionListener(this);
            this.toggleModeButtonToSimple.addActionListener(this);
            this.searchOptionsButton.addActionListener(this);
        }

        public SearchParameters getSearchParameters() {
            SearchParameters sp = new SearchParameters(false);
            sp.setExtensions(this.searchComboBox.getSelectedKey());
            sp.setNameString(this.searchNameTextField.getText());
            sp.setCommentString(this.searchCommentTextField.getText());
            sp.setKeywordString(this.searchKeywordsTextField.getText());
            sp.setOwnerString(this.searchOwnerTextField.getText());
            sp.setHideBadUserFiles(Core.frostSettings.getBoolValue("hideBadFiles"));
            sp.setHideCheckUserFiles(Core.frostSettings.getBoolValue("hideCheckFiles"));
            sp.setHideObserveUserFiles(Core.frostSettings.getBoolValue("hideObserveFiles"));
            sp.setHideFilesWithoutChkKey(Core.frostSettings.getBoolValue("hideFilesWithoutChk"));
            return sp;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.searchButton || e.getSource() == this.searchNameTextField || e.getSource() == this.searchCommentTextField || e.getSource() == this.searchKeywordsTextField || e.getSource() == this.searchOwnerTextField) {
                SearchPanel.this.startNewSearch(this.getSearchParameters());
            } else if (e.getSource() == this.toggleModeButtonToSimple) {
                SearchPanel.this.toggleMode(true);
            } else if (e.getSource() == this.clearButton) {
                this.clearTextfields();
            } else if (e.getSource() == this.searchOptionsButton) {
                SearchPanel.this.buildSearchOptionsMenu().show(this.searchOptionsButton, 5, 5);
            }
        }

        private void clearTextfields() {
            this.searchNameTextField.setText("");
            this.searchCommentTextField.setText("");
            this.searchKeywordsTextField.setText("");
            this.searchOwnerTextField.setText("");
        }

        public void refreshLanguage() {
            this.searchButton.setToolTipText(SearchPanel.this.language.getString("SearchPane.toolbar.tooltip.search"));
            this.clearButton.setToolTipText(SearchPanel.this.language.getString("SearchPane.toolbar.tooltip.clear"));
            this.toggleModeButtonToSimple.setToolTipText(SearchPanel.this.language.getString("SearchPane.toolbar.tooltip.toggleMode"));
            this.searchNameLabel.setText(SearchPanel.this.language.getString("SearchPane.toolbar.name") + ":");
            this.searchCommentLabel.setText(SearchPanel.this.language.getString("SearchPane.toolbar.comment") + ":");
            this.searchKeywordsLabel.setText(SearchPanel.this.language.getString("SearchPane.toolbar.keywords") + ":");
            this.searchOwnerLabel.setText(SearchPanel.this.language.getString("SearchPane.toolbar.owner") + ":");
            this.searchOptionsButton.setText(SearchPanel.this.language.getString("SearchPane.toolbar.searchOptionsButton") + "...");
        }
    }

    private class SearchSimpleToolBar
    extends JToolBar
    implements ActionListener {
        private JTranslatableComboBox searchComboBox = null;
        private final JButton searchButton = new JButton(SearchPanel.access$000(SearchPanel.this));
        private final JTextField searchTextField = new JTextField(30);
        private final JButton toggleModeButtonToAdvanced = new JButton(">>");
        private final JButton searchOptionsButton = new JButton();

        public SearchSimpleToolBar() {
            this.initialize();
        }

        private void initialize() {
            this.setRollover(true);
            this.setFloatable(false);
            new TextComponentClipboardMenu(this.searchTextField, SearchPanel.this.language);
            this.searchComboBox = new JTranslatableComboBox(SearchPanel.this.language, SearchPanel.this.searchComboBoxKeys);
            this.toggleModeButtonToAdvanced.setOpaque(false);
            this.searchOptionsButton.setOpaque(false);
            this.searchOptionsButton.setFocusPainted(false);
            MiscToolkit.configureButton(this.searchButton);
            this.searchComboBox.setMaximumSize(this.searchComboBox.getPreferredSize());
            this.searchTextField.setMaximumSize(this.searchTextField.getPreferredSize());
            this.toggleModeButtonToAdvanced.setMargin(new Insets(0, 0, 0, 0));
            this.toggleModeButtonToAdvanced.setBorderPainted(false);
            this.toggleModeButtonToAdvanced.setFocusPainted(false);
            this.toggleModeButtonToAdvanced.setRolloverEnabled(true);
            Dimension blankSpace = new Dimension(8, 0);
            this.add(this.toggleModeButtonToAdvanced);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchTextField);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchComboBox);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchOptionsButton);
            this.add(Box.createRigidArea(blankSpace));
            this.add(this.searchButton);
            this.add(Box.createHorizontalGlue());
            this.searchTextField.addActionListener(this);
            this.searchButton.addActionListener(this);
            this.toggleModeButtonToAdvanced.addActionListener(this);
            this.searchOptionsButton.addActionListener(this);
        }

        public SearchParameters getSearchParameters() {
            SearchParameters sp = new SearchParameters(true);
            sp.setExtensions(this.searchComboBox.getSelectedKey());
            sp.setSimpleSearchString(this.searchTextField.getText());
            sp.setHideBadUserFiles(Core.frostSettings.getBoolValue("hideBadFiles"));
            sp.setHideCheckUserFiles(Core.frostSettings.getBoolValue("hideCheckFiles"));
            sp.setHideObserveUserFiles(Core.frostSettings.getBoolValue("hideObserveFiles"));
            sp.setHideFilesWithoutChkKey(Core.frostSettings.getBoolValue("hideFilesWithoutChk"));
            return sp;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.searchButton || e.getSource() == this.searchTextField) {
                SearchPanel.this.startNewSearch(this.getSearchParameters());
            } else if (e.getSource() == this.toggleModeButtonToAdvanced) {
                SearchPanel.this.toggleMode(false);
            } else if (e.getSource() == this.searchOptionsButton) {
                SearchPanel.this.buildSearchOptionsMenu().show(this.searchOptionsButton, 5, 5);
            }
        }

        public void refreshLanguage() {
            this.searchButton.setToolTipText(SearchPanel.this.language.getString("SearchPane.toolbar.tooltip.search"));
            this.toggleModeButtonToAdvanced.setToolTipText(SearchPanel.this.language.getString("SearchPane.toolbar.tooltip.toggleMode"));
            this.searchOptionsButton.setText(SearchPanel.this.language.getString("SearchPane.toolbar.searchOptionsButton") + "...");
        }
    }
}

