/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer.download;

import frost.Core;
import frost.fcp.FcpHandler;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.PersistenceManager;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.util.DateFun;
import frost.util.FormatterUtils;
import frost.util.Mixed;
import frost.util.gui.BooleanCell;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.model.ModelItem;
import frost.util.model.ModelTable;
import frost.util.model.SortedModelTable;
import frost.util.model.SortedTableFormat;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class DownloadTableFormat
extends SortedTableFormat
implements LanguageListener,
PropertyChangeListener {
    private static final String CFGKEY_SORTSTATE_SORTEDCOLUMN = "DownloadTable.sortState.sortedColumn";
    private static final String CFGKEY_SORTSTATE_SORTEDASCENDING = "DownloadTable.sortState.sortedAscending";
    private static final String CFGKEY_COLUMN_TABLEINDEX = "DownloadTable.tableindex.modelcolumn.";
    private static final String CFGKEY_COLUMN_WIDTH = "DownloadTable.columnwidth.modelcolumn.";
    private static ImageIcon isSharedIcon = MiscToolkit.loadImageIcon("/data/shared.png");
    private static ImageIcon isRequestedIcon = MiscToolkit.loadImageIcon("/data/signal.png");
    private static ImageIcon isDDAIcon = MiscToolkit.loadImageIcon("/data/hook.png");
    private static final long CONST_32k = 32768L;
    private SortedModelTable modelTable = null;
    private boolean showColoredLines;
    private final Language language = Language.getInstance();
    private static final int COLUMN_COUNT = PersistenceManager.isPersistenceEnabled() ? 13 : 11;
    private String stateWaiting;
    private String stateTrying;
    private String stateFailed;
    private String stateDone;
    private String stateDecoding;
    private String stateDownloading;
    private String unknown;
    private String isSharedTooltip;
    private String isRequestedTooltip;
    private String isDDATooltip;

    public DownloadTableFormat() {
        super(COLUMN_COUNT);
        this.language.addLanguageListener(this);
        this.refreshLanguage();
        this.setComparator(new EnabledComparator(), 0);
        this.setComparator(new IsSharedComparator(), 1);
        this.setComparator(new IsRequestedComparator(), 2);
        this.setComparator(new FileNameComparator(), 3);
        this.setComparator(new SizeComparator(), 4);
        this.setComparator(new StateComparator(), 5);
        this.setComparator(new LastReceivedComparator(), 6);
        this.setComparator(new LastUploadedComparator(), 7);
        this.setComparator(new BlocksComparator(), 8);
        this.setComparator(new TriesComparator(), 9);
        this.setComparator(new KeyComparator(), 10);
        if (PersistenceManager.isPersistenceEnabled()) {
            this.setComparator(new IsDDAComparator(), 11);
            this.setComparator(new PriorityComparator(), 12);
        }
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
        Core.frostSettings.addPropertyChangeListener(this);
    }

    private void refreshLanguage() {
        this.setColumnName(0, this.language.getString("DownloadPane.fileTable.enabled"));
        this.setColumnName(1, this.language.getString("DownloadPane.fileTable.shared"));
        this.setColumnName(2, this.language.getString("DownloadPane.fileTable.requested"));
        this.setColumnName(3, this.language.getString("DownloadPane.fileTable.filename"));
        this.setColumnName(4, this.language.getString("DownloadPane.fileTable.size"));
        this.setColumnName(5, this.language.getString("DownloadPane.fileTable.state"));
        this.setColumnName(6, this.language.getString("DownloadPane.fileTable.lastReceived"));
        this.setColumnName(7, this.language.getString("DownloadPane.fileTable.lastUploaded"));
        this.setColumnName(8, this.language.getString("DownloadPane.fileTable.blocks"));
        this.setColumnName(9, this.language.getString("DownloadPane.fileTable.tries"));
        this.setColumnName(10, this.language.getString("DownloadPane.fileTable.key"));
        if (PersistenceManager.isPersistenceEnabled()) {
            this.setColumnName(11, this.language.getString("DownloadPane.fileTable.isDDA"));
            this.setColumnName(12, this.language.getString("DownloadPane.fileTable.priority"));
        }
        this.stateWaiting = this.language.getString("DownloadPane.fileTable.states.waiting");
        this.stateTrying = this.language.getString("DownloadPane.fileTable.states.trying");
        this.stateFailed = this.language.getString("DownloadPane.fileTable.states.failed");
        this.stateDone = this.language.getString("DownloadPane.fileTable.states.done");
        this.stateDecoding = this.language.getString("DownloadPane.fileTable.states.decodingSegment") + "...";
        this.stateDownloading = this.language.getString("DownloadPane.fileTable.states.downloading");
        this.unknown = this.language.getString("DownloadPane.fileTable.states.unknown");
        this.isSharedTooltip = this.language.getString("DownloadPane.fileTable.shared.tooltip");
        this.isRequestedTooltip = this.language.getString("DownloadPane.fileTable.requested.tooltip");
        this.isDDATooltip = this.language.getString("DownloadPane.fileTable.isDDA.tooltip");
        this.refreshColumnNames();
    }

    public void languageChanged(LanguageEvent event) {
        this.refreshLanguage();
    }

    public Object getCellValue(ModelItem item, int columnIndex) {
        if (item == null) {
            return "*null*";
        }
        FrostDownloadItem downloadItem = (FrostDownloadItem)item;
        switch (columnIndex) {
            case 0: {
                return downloadItem.isEnabled();
            }
            case 1: {
                return downloadItem.isSharedFile();
            }
            case 2: {
                return this.getIsRequested(downloadItem.getFileListFileObject());
            }
            case 3: {
                return downloadItem.getFilename();
            }
            case 4: {
                if (downloadItem.getFileSize() >= 0L) {
                    return FormatterUtils.formatSize(downloadItem.getFileSize());
                }
                if (FcpHandler.isFreenet07() && downloadItem.getRequiredBlocks() > 0 && downloadItem.isFinalized() != null && downloadItem.isFinalized().booleanValue()) {
                    long apprSize = (long)downloadItem.getRequiredBlocks() * 32768L;
                    return "~" + FormatterUtils.formatSize(apprSize);
                }
                return this.unknown;
            }
            case 5: {
                return this.getStateAsString(downloadItem.getState());
            }
            case 6: {
                if (downloadItem.getLastReceived() > 0L) {
                    return DateFun.getExtendedDateFromMillis(downloadItem.getLastReceived());
                }
                return "";
            }
            case 7: {
                if (downloadItem.getLastUploaded() > 0L) {
                    return DateFun.getExtendedDateFromMillis(downloadItem.getLastUploaded());
                }
                return "";
            }
            case 8: {
                return this.getBlocksAsString(downloadItem);
            }
            case 9: {
                return new Integer(downloadItem.getRetries());
            }
            case 10: {
                if (downloadItem.getKey() == null) {
                    return " ?";
                }
                return downloadItem.getKey();
            }
            case 11: {
                return !downloadItem.isDirect();
            }
            case 12: {
                int value = downloadItem.getPriority();
                if (value < 0) {
                    return "-";
                }
                return new Integer(value);
            }
        }
        return "**ERROR**";
    }

    private Boolean getIsRequested(FrostFileListFileObject flfo) {
        if (flfo == null) {
            return Boolean.FALSE;
        }
        long now = System.currentTimeMillis();
        long before24hours = now - 86400000L;
        if (flfo.getRequestLastReceived() > before24hours || flfo.getRequestLastSent() > before24hours) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getBlocksAsString(FrostDownloadItem downloadItem) {
        int totalBlocks = downloadItem.getTotalBlocks();
        int doneBlocks = downloadItem.getDoneBlocks();
        int requiredBlocks = downloadItem.getRequiredBlocks();
        Boolean isFinalized = downloadItem.isFinalized();
        if (totalBlocks <= 0) {
            return "";
        }
        int percentDone = 0;
        if (requiredBlocks > 0) {
            percentDone = doneBlocks * 100 / requiredBlocks;
        }
        if (percentDone > 100) {
            percentDone = 100;
        }
        StringBuilder sb = new StringBuilder();
        if (isFinalized != null && !isFinalized.booleanValue()) {
            sb.append("~");
        }
        sb.append(percentDone).append("% ");
        sb.append(doneBlocks).append("/").append(requiredBlocks).append(" [").append(totalBlocks).append("]");
        return sb.toString();
    }

    private String getStateAsString(int state) {
        switch (state) {
            case 1: {
                return this.stateWaiting;
            }
            case 2: {
                return this.stateTrying;
            }
            case 4: {
                return this.stateFailed;
            }
            case 3: {
                return this.stateDone;
            }
            case 6: {
                return this.stateDecoding;
            }
            case 5: {
                return this.stateDownloading;
            }
        }
        return "**ERROR**";
    }

    public void customizeTable(ModelTable lModelTable) {
        super.customizeTable(lModelTable);
        this.modelTable = (SortedModelTable)lModelTable;
        if (Core.frostSettings.getBoolValue("saveSortStates") && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDCOLUMN) != null && Core.frostSettings.getObjectValue(CFGKEY_SORTSTATE_SORTEDASCENDING) != null) {
            int sortedColumn = Core.frostSettings.getIntValue(CFGKEY_SORTSTATE_SORTEDCOLUMN);
            boolean isSortedAsc = Core.frostSettings.getBoolValue(CFGKEY_SORTSTATE_SORTEDASCENDING);
            if (sortedColumn > -1) {
                this.modelTable.setSortedColumn(sortedColumn, isSortedAsc);
            }
        } else {
            this.modelTable.setSortedColumn(3, true);
        }
        lModelTable.getTable().setAutoResizeMode(1);
        TableColumnModel columnModel = lModelTable.getTable().getColumnModel();
        columnModel.getColumn(0).setCellEditor(BooleanCell.EDITOR);
        this.setColumnEditable(0, true);
        columnModel.getColumn(0).setMinWidth(20);
        columnModel.getColumn(0).setMaxWidth(20);
        columnModel.getColumn(0).setPreferredWidth(20);
        columnModel.getColumn(0).setCellRenderer(new IsEnabledRenderer());
        columnModel.getColumn(1).setMinWidth(20);
        columnModel.getColumn(1).setMaxWidth(20);
        columnModel.getColumn(1).setPreferredWidth(20);
        columnModel.getColumn(1).setCellRenderer(new IsSharedRenderer());
        columnModel.getColumn(2).setMinWidth(20);
        columnModel.getColumn(2).setMaxWidth(20);
        columnModel.getColumn(2).setPreferredWidth(20);
        columnModel.getColumn(2).setCellRenderer(new IsRequestedRenderer());
        if (PersistenceManager.isPersistenceEnabled()) {
            columnModel.getColumn(11).setMinWidth(20);
            columnModel.getColumn(11).setMaxWidth(20);
            columnModel.getColumn(11).setPreferredWidth(20);
            columnModel.getColumn(12).setMinWidth(20);
            columnModel.getColumn(12).setMaxWidth(20);
            columnModel.getColumn(12).setPreferredWidth(20);
        }
        BaseRenderer baseRenderer = new BaseRenderer();
        RightAlignRenderer rightAlignRenderer = new RightAlignRenderer();
        ShowContentTooltipRenderer showContentTooltipRenderer = new ShowContentTooltipRenderer();
        columnModel.getColumn(3).setCellRenderer(new ShowNameTooltipRenderer());
        columnModel.getColumn(4).setCellRenderer(rightAlignRenderer);
        columnModel.getColumn(5).setCellRenderer(new ShowStateContentTooltipRenderer());
        columnModel.getColumn(6).setCellRenderer(baseRenderer);
        columnModel.getColumn(7).setCellRenderer(baseRenderer);
        columnModel.getColumn(8).setCellRenderer(new BlocksProgressRenderer());
        columnModel.getColumn(9).setCellRenderer(rightAlignRenderer);
        columnModel.getColumn(10).setCellRenderer(showContentTooltipRenderer);
        if (PersistenceManager.isPersistenceEnabled()) {
            columnModel.getColumn(11).setCellRenderer(new IsDDARenderer());
            columnModel.getColumn(12).setCellRenderer(rightAlignRenderer);
        }
        if (!this.loadTableLayout(columnModel)) {
            int[] newWidths;
            int[] widths = PersistenceManager.isPersistenceEnabled() ? (newWidths = new int[]{20, 20, 20, 150, 30, 30, 20, 20, 70, 10, 60, 20, 20}) : (newWidths = new int[]{20, 20, 20, 150, 30, 30, 20, 20, 70, 10, 60});
            for (int i = 0; i < widths.length; ++i) {
                columnModel.getColumn(i).setPreferredWidth(widths[i]);
            }
        }
    }

    public void saveTableLayout() {
        TableColumnModel tcm = this.modelTable.getTable().getColumnModel();
        for (int columnIndexInTable = 0; columnIndexInTable < tcm.getColumnCount(); ++columnIndexInTable) {
            TableColumn tc = tcm.getColumn(columnIndexInTable);
            int columnIndexInModel = tc.getModelIndex();
            Core.frostSettings.setValue(CFGKEY_COLUMN_TABLEINDEX + columnIndexInModel, columnIndexInTable);
            int columnWidth = tc.getWidth();
            Core.frostSettings.setValue(CFGKEY_COLUMN_WIDTH + columnIndexInModel, columnWidth);
        }
        if (Core.frostSettings.getBoolValue("saveSortStates") && this.modelTable.getSortedColumn() > -1) {
            int sortedColumn = this.modelTable.getSortedColumn();
            boolean isSortedAsc = this.modelTable.isSortedAscending();
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDCOLUMN, sortedColumn);
            Core.frostSettings.setValue(CFGKEY_SORTSTATE_SORTEDASCENDING, isSortedAsc);
        }
    }

    private boolean loadTableLayout(TableColumnModel tcm) {
        int[] tableToModelIndex = new int[tcm.getColumnCount()];
        int[] columnWidths = new int[tcm.getColumnCount()];
        for (int x = 0; x < tableToModelIndex.length; ++x) {
            String indexKey = CFGKEY_COLUMN_TABLEINDEX + x;
            if (Core.frostSettings.getObjectValue(indexKey) == null) {
                return false;
            }
            int tableIndex = Core.frostSettings.getIntValue(indexKey);
            if (tableIndex < 0 || tableIndex >= tableToModelIndex.length) {
                return false;
            }
            tableToModelIndex[tableIndex] = x;
            String widthKey = CFGKEY_COLUMN_WIDTH + x;
            if (Core.frostSettings.getObjectValue(widthKey) == null) {
                return false;
            }
            int columnWidth = Core.frostSettings.getIntValue(widthKey);
            if (columnWidth <= 0) {
                return false;
            }
            columnWidths[x] = columnWidth;
        }
        TableColumn[] tcms = new TableColumn[tcm.getColumnCount()];
        for (int x = tcms.length - 1; x >= 0; --x) {
            tcms[x] = tcm.getColumn(x);
            tcm.removeColumn(tcms[x]);
            if (x == 0 || x == 1 || x == 2) continue;
            tcms[x].setPreferredWidth(columnWidths[x]);
        }
        for (int element : tableToModelIndex) {
            tcm.addColumn(tcms[element]);
        }
        return true;
    }

    public void setCellValue(Object value, ModelItem item, int columnIndex) {
        FrostDownloadItem downloadItem = (FrostDownloadItem)item;
        switch (columnIndex) {
            case 0: {
                Boolean valueBoolean = (Boolean)value;
                downloadItem.setEnabled(valueBoolean);
                FileTransferManager.inst().getDownloadManager().notifyDownloadItemEnabledStateChanged(downloadItem);
                break;
            }
            default: {
                super.setCellValue(value, item, columnIndex);
            }
        }
    }

    public int[] getColumnNumbers(int fieldID) {
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showColoredRows")) {
            this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
            this.modelTable.fireTableDataChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastUploadedComparator
    implements Comparator<FrostDownloadItem> {
        private LastUploadedComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            return Mixed.compareLong(item1.getLastUploaded(), item2.getLastUploaded());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LastReceivedComparator
    implements Comparator<FrostDownloadItem> {
        private LastReceivedComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            return Mixed.compareLong(item1.getLastReceived(), item2.getLastReceived());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsDDAComparator
    implements Comparator<FrostDownloadItem> {
        private IsDDAComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            Boolean b1 = item1.isDirect();
            Boolean b2 = item2.isDirect();
            return b1.compareTo(b2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsRequestedComparator
    implements Comparator<FrostDownloadItem> {
        private IsRequestedComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            Boolean b1 = DownloadTableFormat.this.getIsRequested(item1.getFileListFileObject());
            Boolean b2 = DownloadTableFormat.this.getIsRequested(item2.getFileListFileObject());
            return b1.compareTo(b2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IsSharedComparator
    implements Comparator<FrostDownloadItem> {
        private IsSharedComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            Boolean b1 = item1.isSharedFile();
            Boolean b2 = item2.isSharedFile();
            return b1.compareTo(b2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnabledComparator
    implements Comparator<FrostDownloadItem> {
        private EnabledComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            Boolean b1 = (boolean)item1.isEnabled();
            Boolean b2 = (boolean)item2.isEnabled();
            return b1.compareTo(b2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileNameComparator
    implements Comparator<FrostDownloadItem> {
        private FileNameComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            return item1.getFilename().compareToIgnoreCase(item2.getFilename());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SizeComparator
    implements Comparator<FrostDownloadItem> {
        private final Long unknownSize = new Long(-1L);

        private SizeComparator() {
        }

        @Override
        public int compare(FrostDownloadItem dli1, FrostDownloadItem dli2) {
            long apprSize;
            Long size1 = dli1.getFileSize();
            Long size2 = dli2.getFileSize();
            if (dli1.getFileSize() >= 0L) {
                size1 = dli1.getFileSize();
            } else if (FcpHandler.isFreenet07() && dli1.getTotalBlocks() > 0 && dli1.isFinalized() != null && dli1.isFinalized().booleanValue()) {
                apprSize = (long)dli1.getTotalBlocks() * 32768L;
                size1 = new Long(apprSize);
            } else {
                size1 = this.unknownSize;
            }
            if (dli2.getFileSize() >= 0L) {
                size2 = dli2.getFileSize();
            } else if (FcpHandler.isFreenet07() && dli2.getTotalBlocks() > 0 && dli2.isFinalized() != null && dli2.isFinalized().booleanValue()) {
                apprSize = (long)dli2.getTotalBlocks() * 32768L;
                size2 = new Long(apprSize);
            } else {
                size2 = this.unknownSize;
            }
            return size1.compareTo(size2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StateComparator
    implements Comparator<FrostDownloadItem> {
        private StateComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            String state1 = DownloadTableFormat.this.getStateAsString(item1.getState());
            String state2 = DownloadTableFormat.this.getStateAsString(item2.getState());
            return state1.compareToIgnoreCase(state2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BlocksComparator
    implements Comparator<FrostDownloadItem> {
        private BlocksComparator() {
        }

        @Override
        public int compare(FrostDownloadItem item1, FrostDownloadItem item2) {
            return Mixed.compareInt(item1.getDoneBlocks(), item2.getDoneBlocks());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PriorityComparator
    implements Comparator<FrostDownloadItem> {
        private PriorityComparator() {
        }

        @Override
        public int compare(FrostDownloadItem o1, FrostDownloadItem o2) {
            int prio1 = o1.getPriority();
            int prio2 = o2.getPriority();
            return Mixed.compareInt(prio1, prio2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TriesComparator
    implements Comparator<FrostDownloadItem> {
        private TriesComparator() {
        }

        @Override
        public int compare(FrostDownloadItem o1, FrostDownloadItem o2) {
            int retries1 = o1.getRetries();
            int retries2 = o2.getRetries();
            return Mixed.compareInt(retries1, retries2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyComparator
    implements Comparator<FrostDownloadItem> {
        private KeyComparator() {
        }

        @Override
        public int compare(FrostDownloadItem o1, FrostDownloadItem o2) {
            String key1 = o1.getKey();
            String key2 = o2.getKey();
            if (key1 == null) {
                key1 = "";
            }
            if (key2 == null) {
                key2 = "";
            }
            return key1.compareToIgnoreCase(key2);
        }
    }

    private class IsDDARenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Boolean b = (Boolean)value;
            this.setText("");
            if (b.booleanValue()) {
                this.setIcon(isDDAIcon);
            } else {
                this.setIcon(null);
            }
            this.setToolTipText(DownloadTableFormat.this.isDDATooltip);
            return this;
        }
    }

    private class IsRequestedRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Boolean b = (Boolean)value;
            this.setText("");
            if (b.booleanValue()) {
                this.setIcon(isRequestedIcon);
            } else {
                this.setIcon(null);
            }
            this.setToolTipText(DownloadTableFormat.this.isRequestedTooltip);
            return this;
        }
    }

    private class IsSharedRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Boolean b = (Boolean)value;
            this.setText("");
            if (b.booleanValue()) {
                this.setIcon(isSharedIcon);
            } else {
                this.setIcon(null);
            }
            this.setToolTipText(DownloadTableFormat.this.isSharedTooltip);
            return this;
        }
    }

    private class IsEnabledRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public IsEnabledRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            ModelItem item = DownloadTableFormat.this.modelTable.getItemAt(row);
            if (item != null) {
                FrostDownloadItem downloadItem = (FrostDownloadItem)item;
                if (downloadItem.isExternal()) {
                    this.setEnabled(false);
                    this.setSelected(true);
                } else {
                    this.setEnabled(true);
                    this.setSelected(value != null && (Boolean)value != false);
                }
            }
            return this;
        }
    }

    private class ShowStateContentTooltipRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            FrostDownloadItem downloadItem;
            String errorCodeDescription;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            ModelItem item = DownloadTableFormat.this.modelTable.getItemAt(row);
            if (item != null && (errorCodeDescription = (downloadItem = (FrostDownloadItem)item).getErrorCodeDescription()) != null && errorCodeDescription.length() > 0) {
                tooltip = "Last error: " + errorCodeDescription;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class ShowNameTooltipRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            ModelItem item = DownloadTableFormat.this.modelTable.getItemAt(row);
            if (item != null) {
                FrostDownloadItem downloadItem = (FrostDownloadItem)item;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>").append(downloadItem.getFilename());
                if (downloadItem.getDownloadAddedMillis() > 0L) {
                    sb.append("<br>Added: ");
                    sb.append(DateFun.FORMAT_DATE_VISIBLE.print(downloadItem.getDownloadAddedMillis()));
                    sb.append("  ");
                    sb.append(DateFun.FORMAT_TIME_VISIBLE.print(downloadItem.getDownloadAddedMillis()));
                }
                if (downloadItem.getDownloadStartedMillis() > 0L) {
                    sb.append("<br>Started: ");
                    sb.append(DateFun.FORMAT_DATE_VISIBLE.print(downloadItem.getDownloadStartedMillis()));
                    sb.append("  ");
                    sb.append(DateFun.FORMAT_TIME_VISIBLE.print(downloadItem.getDownloadStartedMillis()));
                }
                if (downloadItem.getDownloadFinishedMillis() > 0L) {
                    sb.append("<br>Finished: ");
                    sb.append(DateFun.FORMAT_DATE_VISIBLE.print(downloadItem.getDownloadFinishedMillis()));
                    sb.append("  ");
                    sb.append(DateFun.FORMAT_TIME_VISIBLE.print(downloadItem.getDownloadFinishedMillis()));
                }
                sb.append("</html>");
                tooltip = sb.toString();
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class ShowContentTooltipRenderer
    extends BaseRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = null;
            if (value != null && (tooltip = value.toString()).length() == 0) {
                tooltip = null;
            }
            this.setToolTipText(tooltip);
            return this;
        }
    }

    private class RightAlignRenderer
    extends BaseRenderer {
        final EmptyBorder border;

        public RightAlignRenderer() {
            this.border = new EmptyBorder(0, 0, 0, 3);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(4);
            this.setBorder(this.border);
            return this;
        }
    }

    private class BlocksProgressRenderer
    extends JProgressBar
    implements TableCellRenderer {
        public BlocksProgressRenderer() {
            this.setMinimum(0);
            this.setMaximum(100);
            this.setStringPainted(true);
            this.setBorderPainted(false);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, DownloadTableFormat.this.showColoredLines);
            this.setBackground(newBackground);
            this.setValue(0);
            ModelItem item = DownloadTableFormat.this.modelTable.getItemAt(row);
            if (item != null) {
                FrostDownloadItem downloadItem = (FrostDownloadItem)item;
                int totalBlocks = downloadItem.getTotalBlocks();
                int doneBlocks = downloadItem.getDoneBlocks();
                int requiredBlocks = downloadItem.getRequiredBlocks();
                if (totalBlocks > 0) {
                    int percentDone = 0;
                    if (requiredBlocks > 0) {
                        percentDone = doneBlocks * 100 / requiredBlocks;
                    }
                    if (percentDone > 100) {
                        percentDone = 100;
                    }
                    this.setValue(percentDone);
                }
            }
            this.setString(value.toString());
            return this;
        }
    }

    private class BaseRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, DownloadTableFormat.this.showColoredLines);
                ModelItem item = DownloadTableFormat.this.modelTable.getItemAt(row);
                if (item != null) {
                    FrostDownloadItem downloadItem = (FrostDownloadItem)item;
                    int itemState = downloadItem.getState();
                    if (itemState == 3) {
                        newBackground = TableBackgroundColors.getBackgroundColorDone(table, row, DownloadTableFormat.this.showColoredLines);
                    } else if (itemState == 4) {
                        newBackground = TableBackgroundColors.getBackgroundColorFailed(table, row, DownloadTableFormat.this.showColoredLines);
                    }
                }
                this.setBackground(newBackground);
                this.setForeground(Color.black);
            }
            return this;
        }
    }
}

