/*
 * Decompiled with CFR 0.152.
 */
package frost.fileTransfer;

import frost.Core;
import frost.fcp.FcpHandler;
import frost.fcp.FreenetKeys;
import frost.fileTransfer.FileListFileContent;
import frost.fileTransfer.FileListManagerFileInfo;
import frost.fileTransfer.FileTransferManager;
import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.SharedFileXmlFile;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.sharing.FrostSharedFileItem;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.storage.perst.filelist.FileListStorage;
import frost.storage.perst.identities.IdentitiesStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListManager {
    private static final Logger logger = Logger.getLogger(FileListManager.class.getName());
    public static final int MAX_FILES_PER_FILE = 250;
    private static final Comparator<FrostSharedFileItem> refLastSentComparator = new Comparator<FrostSharedFileItem>(){

        @Override
        public int compare(FrostSharedFileItem value1, FrostSharedFileItem value2) {
            if (value1.getRefLastSent() > value2.getRefLastSent()) {
                return 1;
            }
            if (value1.getRefLastSent() < value2.getRefLastSent()) {
                return -1;
            }
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileListManagerFileInfo getFilesToSend() {
        int maxAge = Core.frostSettings.getIntValue("minDaysBeforeFileReshare");
        long maxDiff = (long)maxAge * 24L * 60L * 60L * 1000L;
        long now = System.currentTimeMillis();
        long minDate = now - maxDiff;
        List<LocalIdentity> localIdentities = Core.getIdentities().getLocalIdentities();
        if (!IdentitiesStorage.inst().beginExclusiveThreadTransaction()) {
            return null;
        }
        try {
            for (int identityCount = localIdentities.size(); identityCount > 0; --identityCount) {
                FileListManagerFileInfo fif;
                LocalIdentity idToUpdate = null;
                long minUpdateMillis = Long.MAX_VALUE;
                for (LocalIdentity id : localIdentities) {
                    long lastShared = id.getLastFilesSharedMillis();
                    if (lastShared >= minUpdateMillis) continue;
                    minUpdateMillis = lastShared;
                    idToUpdate = id;
                }
                idToUpdate.setLastFilesSharedMillis(now);
                LinkedList<SharedFileXmlFile> filesToShare = FileListManager.getUploadItemsToShare(idToUpdate.getUniqueName(), 250, minDate);
                if (filesToShare == null || filesToShare.size() <= 0) continue;
                FileListManagerFileInfo fileListManagerFileInfo = fif = new FileListManagerFileInfo(filesToShare, idToUpdate);
                return fileListManagerFileInfo;
            }
            FileListManagerFileInfo fileListManagerFileInfo = null;
            return fileListManagerFileInfo;
        }
        finally {
            IdentitiesStorage.inst().endThreadTransaction();
        }
    }

    private static LinkedList<SharedFileXmlFile> getUploadItemsToShare(String owner, int maxItems, long minDate) {
        LinkedList<SharedFileXmlFile> result = new LinkedList<SharedFileXmlFile>();
        ArrayList<FrostSharedFileItem> sorted = new ArrayList<FrostSharedFileItem>();
        List<FrostSharedFileItem> sharedFileItems = FileTransferManager.inst().getSharedFilesManager().getSharedFileItemList();
        for (FrostSharedFileItem sfo : sharedFileItems) {
            if (!sfo.isValid() || !sfo.getOwner().equals(owner)) continue;
            sorted.add(sfo);
        }
        if (sorted.isEmpty()) {
            return result;
        }
        Collections.sort(sorted, refLastSentComparator);
        FrostSharedFileItem sfo = (FrostSharedFileItem)sorted.get(0);
        if (sfo.getRefLastSent() > minDate) {
            return result;
        }
        for (FrostSharedFileItem sfo2 : sorted) {
            result.add(sfo2.getSharedFileXmlFileInstance());
            if (result.size() < maxItems) continue;
            return result;
        }
        return result;
    }

    public static boolean updateFileListWasSuccessfullySent(List<SharedFileXmlFile> files) {
        long now = System.currentTimeMillis();
        List<FrostSharedFileItem> sharedFileItems = FileTransferManager.inst().getSharedFilesManager().getSharedFileItemList();
        for (SharedFileXmlFile sfx : files) {
            for (FrostSharedFileItem sfo : sharedFileItems) {
                if (!sfo.getSha().equals(sfx.getSha())) continue;
                sfo.setRefLastSent(now);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processReceivedFileList(FileListFileContent content) {
        Identity localOwner;
        if (content == null || content.getReceivedOwner() == null || content.getFileList() == null || content.getFileList().size() == 0) {
            return false;
        }
        Object object = Core.getIdentities().getLockObject();
        synchronized (object) {
            localOwner = Core.getIdentities().getIdentity(content.getReceivedOwner().getUniqueName());
            if (localOwner == null) {
                localOwner = content.getReceivedOwner();
                localOwner.setLastSeenTimestampWithoutUpdate(content.getTimestamp());
                if (!Core.getIdentities().addIdentity(content.getReceivedOwner())) {
                    logger.severe("Core.getIdentities().addIdentity() returned false!");
                }
            } else if (localOwner.getLastSeenTimestamp() < content.getTimestamp()) {
                localOwner.setLastSeenTimestamp(content.getTimestamp());
            }
        }
        if (localOwner.isBAD() && Core.frostSettings.getBoolValue("hideBadFiles")) {
            logger.info("Skipped index file from BAD user " + localOwner.getUniqueName());
            return true;
        }
        List<FrostDownloadItem> downloadItems = FileTransferManager.inst().getDownloadManager().getDownloadItemList();
        ArrayList<FrostDownloadItem> downloadsToRestart = new ArrayList<FrostDownloadItem>();
        boolean errorOccured = false;
        if (!FileListStorage.inst().beginExclusiveThreadTransaction()) {
            logger.severe("Failed to begin an EXCLUSIVE thread transaction, aborting.");
            return false;
        }
        boolean isFreenet07 = FcpHandler.isFreenet07();
        try {
            for (SharedFileXmlFile sfx : content.getFileList()) {
                FrostFileListFileObject sfo = new FrostFileListFileObject(sfx, localOwner, content.getTimestamp());
                if (isFreenet07 && FreenetKeys.isOld07ChkKey(sfo.getKey())) continue;
                for (FrostDownloadItem dlItem : downloadItems) {
                    FrostFileListFileObject dlSfo;
                    if (!dlItem.isSharedFile() || dlItem.getState() != 4 || !(dlSfo = dlItem.getFileListFileObject()).getSha().equals(sfx.getSha()) || dlSfo.getLastUploaded() >= sfo.getLastUploaded()) continue;
                    downloadsToRestart.add(dlItem);
                }
                boolean wasOk = FileListStorage.inst().insertOrUpdateFileListFileObject(sfo);
                if (wasOk) continue;
                errorOccured = true;
                break;
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception during insertOrUpdateFrostSharedFileObject", t);
            errorOccured = true;
        }
        if (errorOccured) {
            FileListStorage.inst().rollbackTransaction();
            return false;
        }
        FileListStorage.inst().endThreadTransaction();
        block7: for (SharedFileXmlFile sfx : content.getFileList()) {
            for (FrostDownloadItem dlItem : downloadItems) {
                FrostFileListFileObject dlSfo;
                if (!dlItem.isSharedFile() || !(dlSfo = dlItem.getFileListFileObject()).getSha().equals(sfx.getSha())) continue;
                FrostFileListFileObject updatedSfo = null;
                if (!FileListStorage.inst().beginCooperativeThreadTransaction()) {
                    logger.severe("Failed to begin an COOPERATIVE thread transaction.");
                } else {
                    updatedSfo = FileListStorage.inst().getFileBySha(sfx.getSha());
                    FileListStorage.inst().endThreadTransaction();
                }
                if (updatedSfo != null) {
                    dlItem.setFileListFileObject(updatedSfo);
                    continue block7;
                }
                System.out.println("no file for sha!");
                continue block7;
            }
        }
        for (FrostDownloadItem dlItem : downloadsToRestart) {
            dlItem.setState(1);
            dlItem.setRetries(0);
            dlItem.setLastDownloadStopTime(0L);
            dlItem.setEnabled(true);
        }
        return true;
    }
}

