/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.Core;
import frost.fcp.BoardKeyPair;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpResultPut;
import frost.fcp.NodeAddress;
import frost.fcp.fcp05.FcpConnection;
import frost.fcp.fcp05.FcpFactory;
import frost.fcp.fcp05.FcpInsert;
import frost.fcp.fcp05.FcpRequest;
import frost.fcp.fcp05.FecSplitfile;
import frost.fcp.fcp05.FecTools;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.fileTransfer.upload.FrostUploadItem;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpHandler05
extends FcpHandler {
    @Override
    public void initialize(List<String> nodes) {
        FcpFactory.init(nodes);
    }

    @Override
    public List<NodeAddress> getNodes() {
        return FcpFactory.getNodes();
    }

    @Override
    public FcpResultGet getFile(int type, String key, Long size, File target, boolean doRedirect, boolean fastDownload, int maxSize, int maxRetries, boolean createTempFile, FrostDownloadItem dlItem) {
        int htl = this.getDownloadHtlForType(type);
        return FcpRequest.getFile(key, size, target, htl, doRedirect, fastDownload, createTempFile, dlItem);
    }

    private int getDownloadHtlForType(int type) {
        if (type == 1) {
            return Core.frostSettings.getIntValue("tofDownloadHtl");
        }
        if (type == 2) {
            return 25;
        }
        return 21;
    }

    private int getUploadHtlForType(int type) {
        if (type == 1) {
            return Core.frostSettings.getIntValue("tofUploadHtl");
        }
        if (type == 2) {
            return Core.frostSettings.getIntValue("htlUpload");
        }
        return 21;
    }

    @Override
    public FcpResultPut putFile(int type, String uri, File file, byte[] metadata, boolean doRedirect, boolean removeLocalKey, boolean doMime, FrostUploadItem ulItem) {
        int htl = this.getUploadHtlForType(type);
        FcpResultPut result = FcpInsert.putFile(uri, file, metadata, htl, doRedirect, removeLocalKey, ulItem);
        if (result == null) {
            return FcpResultPut.ERROR_RESULT;
        }
        return result;
    }

    @Override
    public String generateCHK(File file) throws Throwable {
        String chkkey;
        if (file.length() <= 786432L) {
            chkkey = FecTools.generateCHK(file);
        } else {
            FecSplitfile splitfile = new FecSplitfile(file);
            boolean alreadyEncoded = splitfile.uploadInit();
            if (!alreadyEncoded) {
                splitfile.encode();
            }
            splitfile.createRedirectFile(false);
            chkkey = FecTools.generateCHK(splitfile.getRedirectFile(), splitfile.getRedirectFile().length());
        }
        return chkkey;
    }

    @Override
    public List<String> getNodeInfo() throws IOException, ConnectException {
        FcpConnection connection = FcpFactory.getFcpConnectionInstance();
        if (connection == null) {
            return null;
        }
        return connection.getNodeInfo();
    }

    @Override
    public BoardKeyPair generateBoardKeyPair() throws IOException, ConnectException {
        FcpConnection connection = FcpFactory.getFcpConnectionInstance();
        if (connection == null) {
            return null;
        }
        String[] keyPair = connection.getKeyPair();
        String privKey = keyPair[0];
        String pubKey = keyPair[1];
        return new BoardKeyPair(pubKey, privKey);
    }
}

