/*
 * Decompiled with CFR 0.152.
 */
package frost.components.translate;

import frost.components.translate.TranslationDialog;
import frost.util.gui.translation.FrostResourceBundle;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageGuiSupport;
import frost.util.gui.translation.TranslateableFrostResourceBundle;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TranslationStartDialog
extends JFrame {
    Language language = Language.getInstance();
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JComboBox CBoxTargetLanguage = null;
    private JLabel jLabel1 = null;
    private JComboBox CBoxSourceLanguage = null;
    private JPanel jPanel = null;
    private JButton Bok = null;
    private JButton Bcancel = null;
    private JLabel jLabel2 = null;

    public TranslationStartDialog(JFrame parent) {
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initialize() {
        this.setSize(495, 276);
        this.setTitle("Translate Frost");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 18;
            gridBagConstraints11.insets = new Insets(3, 5, 0, 5);
            gridBagConstraints11.gridy = 3;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("(The fallback language for all missing keys is english.)");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 6;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 4;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.insets = new Insets(5, 25, 10, 5);
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(15, 5, 0, 5);
            gridBagConstraints2.gridy = 2;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Choose the language used as source for the translation:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.weightx = 0.0;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.insets = new Insets(5, 25, 0, 5);
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Choose the target language to translate into:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.getCBoxTargetLanguage(), gridBagConstraints1);
            this.jContentPane.add((Component)this.jLabel1, gridBagConstraints2);
            this.jContentPane.add((Component)this.getCBoxSourceLanguage(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints4);
            this.jContentPane.add((Component)this.jLabel2, gridBagConstraints11);
        }
        return this.jContentPane;
    }

    private JComboBox getCBoxTargetLanguage() {
        if (this.CBoxTargetLanguage == null) {
            this.CBoxTargetLanguage = new JComboBox();
            Locale[] availableLocales = Locale.getAvailableLocales();
            List<Locale> buildIns = LanguageGuiSupport.getBuildInLocales();
            List<Locale> externals = Language.getExternalLocales();
            TreeMap<ComboBoxEntry, ComboBoxEntry> tm = new TreeMap<ComboBoxEntry, ComboBoxEntry>();
            for (Locale element : availableLocales) {
                String newOrChangeStr;
                if (element.getCountry().length() > 0) continue;
                String langCode = element.getLanguage();
                boolean isExternal = false;
                boolean isNew = false;
                if (externals.contains(element)) {
                    newOrChangeStr = "external";
                    isExternal = true;
                } else if (buildIns.contains(element)) {
                    newOrChangeStr = "build-in";
                } else {
                    newOrChangeStr = "create";
                    isNew = true;
                }
                String localeDesc = element.getDisplayName() + "  (" + newOrChangeStr + ") (" + langCode + ")";
                ComboBoxEntry cbe = new ComboBoxEntry(element, isExternal, isNew, localeDesc);
                tm.put(cbe, cbe);
            }
            for (ComboBoxEntry element : tm.keySet()) {
                this.CBoxTargetLanguage.addItem(element);
            }
        }
        return this.CBoxTargetLanguage;
    }

    private JComboBox getCBoxSourceLanguage() {
        if (this.CBoxSourceLanguage == null) {
            this.CBoxSourceLanguage = new JComboBox();
            ComboBoxEntry defaultEntry = null;
            List<Locale> lst_buildin = LanguageGuiSupport.getBuildInLocales();
            TreeMap<ComboBoxEntry, ComboBoxEntry> tm_buildin = new TreeMap<ComboBoxEntry, ComboBoxEntry>();
            Iterator<Locale> i$ = lst_buildin.iterator();
            while (i$.hasNext()) {
                Locale locale2;
                Locale locale = locale2 = i$.next();
                String localeDesc = locale.getDisplayName() + "  (" + locale.getLanguage() + ")";
                ComboBoxEntry cbe = new ComboBoxEntry(locale, false, false, localeDesc);
                tm_buildin.put(cbe, cbe);
                if (!locale.getLanguage().equals("en")) continue;
                defaultEntry = cbe;
            }
            for (ComboBoxEntry comboBoxEntry : tm_buildin.keySet()) {
                this.CBoxSourceLanguage.addItem(comboBoxEntry);
            }
            List<Locale> lst_external = Language.getExternalLocales();
            TreeMap<ComboBoxEntry, ComboBoxEntry> tm_external = new TreeMap<ComboBoxEntry, ComboBoxEntry>();
            Iterator<Locale> i$2 = lst_external.iterator();
            while (i$2.hasNext()) {
                Locale locale2;
                Locale locale = locale2 = i$2.next();
                String localeDesc = locale.getDisplayName() + "  (external) (" + locale.getLanguage() + ")";
                ComboBoxEntry cbe = new ComboBoxEntry(locale, true, false, localeDesc);
                tm_external.put(cbe, cbe);
            }
            for (ComboBoxEntry element : tm_external.keySet()) {
                this.CBoxSourceLanguage.addItem(element);
            }
            if (defaultEntry != null) {
                this.CBoxSourceLanguage.setSelectedItem(defaultEntry);
            }
        }
        return this.CBoxSourceLanguage;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(flowLayout);
            this.jPanel.add((Component)this.getBok(), null);
            this.jPanel.add((Component)this.getBcancel(), null);
        }
        return this.jPanel;
    }

    private JButton getBok() {
        if (this.Bok == null) {
            this.Bok = new JButton();
            this.Bok.setText("Ok");
            this.Bok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ComboBoxEntry cbe = (ComboBoxEntry)TranslationStartDialog.this.getCBoxSourceLanguage().getSelectedItem();
                    String sourceLanguageName = cbe.getLocale().getLanguage();
                    boolean isSourceExternal = cbe.isExternal();
                    cbe = (ComboBoxEntry)TranslationStartDialog.this.getCBoxTargetLanguage().getSelectedItem();
                    String targetLanguageName = cbe.getLocale().getLanguage();
                    boolean isTargetExternal = cbe.isExternal();
                    boolean isTargetNew = cbe.isNew();
                    TranslationStartDialog.this.startTranslation(sourceLanguageName, isSourceExternal, targetLanguageName, isTargetExternal, isTargetNew);
                }
            });
        }
        return this.Bok;
    }

    private void startTranslation(String sourceLanguageName, boolean isSourceExternal, String targetLanguageName, boolean isTargetExternal, boolean isTargetNew) {
        this.setVisible(false);
        FrostResourceBundle rootBundle = new FrostResourceBundle();
        FrostResourceBundle sourceBundle = isSourceExternal ? new FrostResourceBundle(sourceLanguageName, rootBundle, true) : new FrostResourceBundle(sourceLanguageName, rootBundle, false);
        TranslateableFrostResourceBundle targetBundle = isTargetExternal ? new TranslateableFrostResourceBundle(targetLanguageName, null, true) : (isTargetNew ? new TranslateableFrostResourceBundle() : new TranslateableFrostResourceBundle(targetLanguageName, null, false));
        TranslationDialog td = new TranslationDialog();
        td.startDialog(rootBundle, sourceBundle, sourceLanguageName, targetBundle, targetLanguageName);
        this.dispose();
    }

    private JButton getBcancel() {
        if (this.Bcancel == null) {
            this.Bcancel = new JButton();
            this.Bcancel.setText("Cancel");
            this.Bcancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TranslationStartDialog.this.setVisible(false);
                    TranslationStartDialog.this.dispose();
                }
            });
        }
        return this.Bcancel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComboBoxEntry
    implements Comparable<Object> {
        boolean isExternal;
        boolean isNew;
        Locale locale;
        String displayString;

        public ComboBoxEntry(Locale locale, boolean isExternal, boolean isNew, String displayString) {
            this.locale = locale;
            this.isExternal = isExternal;
            this.displayString = displayString;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public boolean isExternal() {
            return this.isExternal;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public String toString() {
            return this.displayString;
        }

        @Override
        public int compareTo(Object other) {
            return this.toString().compareTo(other.toString());
        }
    }
}

