/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.Folder;
import frost.boards.SentMessagesFolder;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.boards.UnsentMessagesFolder;
import frost.util.XMLTools;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TofTreeXmlIO {
    private static final Logger logger = Logger.getLogger(TofTreeXmlIO.class.getName());

    public boolean loadBoardTree(TofTree tree, TofTreeModel model, String filename, UnsentMessagesFolder unsentMsgs, SentMessagesFolder sentMsgs) {
        Document doc = null;
        try {
            doc = XMLTools.parseXmlFile(filename, false);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (doc == null) {
            logger.severe("Error - loadBoardTree: could'nt parse XML Document.");
            return false;
        }
        Element rootNode = doc.getDocumentElement();
        if (!rootNode.getTagName().equals("FrostBoardTree")) {
            logger.severe("Error - boards.xml invalid: does not contain the root tag 'FrostBoardTree'");
            return false;
        }
        List<Element> nodelist = XMLTools.getChildElementsByTagName(rootNode, "FrostBoardTreeEntry");
        if (nodelist.size() != 1) {
            logger.severe("Error - boards.xml invalid: first element must be the one and only root folder (" + nodelist.size() + ")");
            return false;
        }
        Element boardRootNode = nodelist.get(0);
        String tagName = boardRootNode.getTagName();
        if (tagName == null || !tagName.equals("FrostBoardTreeEntry")) {
            logger.severe("Error - boards.xml invalid: first element must the root folder");
            return false;
        }
        String name = this.getName(boardRootNode);
        boolean isFolder = this.isFolder(boardRootNode);
        if (!isFolder) {
            logger.severe("Error - boards.xml invalid: first element must be a folder (the root folder)");
            return false;
        }
        Folder treeRootNode = new Folder(name);
        model.setRoot(treeRootNode);
        treeRootNode.add(unsentMsgs);
        treeRootNode.add(sentMsgs);
        this.loadProcessFolder(boardRootNode, treeRootNode, tree, model);
        this.refreshModel(model, treeRootNode);
        model.initialAssignPerstFrostBoardObjects();
        tree.updateUI();
        logger.info("Board tree loaded successfully.");
        return true;
    }

    private void loadProcessFolder(Element boardFolder, Folder treeFolder, JTree tree, DefaultTreeModel model) {
        List<Element> list = XMLTools.getChildElementsByTagName(boardFolder, "FrostBoardTreeEntry");
        for (Element child : list) {
            String nodename = this.getName(child);
            if (nodename == null) continue;
            boolean isFolder = this.isFolder(child);
            if (!isFolder) {
                long millis;
                Text txtname;
                String publicKey = this.getPublicKey(child);
                String privateKey = this.getPrivateKey(child);
                String description = this.getDescription(child);
                Board fbobj = new Board(nodename, publicKey, privateKey, description);
                this.getBoardConfiguration(child, fbobj);
                List<Element> ltmp = XMLTools.getChildElementsByTagName(child, "lastUpdateStartedMillis");
                if (ltmp.size() > 0 && (txtname = (Text)((Node)ltmp.get(0)).getFirstChild()) != null) {
                    millis = -1L;
                    try {
                        millis = Long.parseLong(txtname.getData().trim());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (millis > 0L) {
                        fbobj.setLastUpdateStartMillis(millis);
                    }
                }
                if ((ltmp = XMLTools.getChildElementsByTagName(child, "lastBackloadUpdateFinishedMillis")).size() > 0 && (txtname = (Text)((Node)ltmp.get(0)).getFirstChild()) != null) {
                    millis = -1L;
                    try {
                        millis = Long.parseLong(txtname.getData().trim());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (millis > 0L) {
                        fbobj.setLastBackloadUpdateFinishedMillis(millis);
                    }
                }
                treeFolder.add(fbobj);
                continue;
            }
            boolean isExpanded = this.isExpanded(child);
            Folder fbobj = new Folder(nodename);
            treeFolder.add(fbobj);
            this.loadProcessFolder(child, fbobj, tree, model);
            this.refreshModel(model, fbobj);
            if (!isExpanded) continue;
            tree.expandPath(new TreePath(model.getPathToRoot(fbobj)));
        }
    }

    private void getBoardConfiguration(Element element, Board board) {
        List<Element> list = XMLTools.getChildElementsByTagName(element, "config");
        if (list.size() == 0) {
            board.setConfigured(false);
            return;
        }
        board.setConfigured(true);
        element = list.get(0);
        String val = element.getAttribute("autoUpdate");
        board.setAutoUpdateEnabled(Boolean.valueOf(val));
        val = element.getAttribute("maxMessageDisplay");
        if (val.length() == 0) {
            board.setMaxMessageDays(null);
        } else {
            board.setMaxMessageDays(new Integer(val));
        }
        val = element.getAttribute("maxMessageDownload");
        if (val.length() == 0) {
            board.setMaxMessageDownload(null);
        } else {
            board.setMaxMessageDownload(new Integer(val));
        }
        val = element.getAttribute("showSignedOnly");
        if (val.length() == 0) {
            board.setShowSignedOnly(null);
        } else {
            board.setShowSignedOnly(Boolean.valueOf(val));
        }
        val = element.getAttribute("storeSentMessages");
        if (val.length() == 0) {
            board.setStoreSentMessages(null);
        } else {
            board.setStoreSentMessages(Boolean.valueOf(val));
        }
        val = element.getAttribute("hideBadMessages");
        if (val.length() == 0) {
            board.setHideBad(null);
        } else {
            board.setHideBad(Boolean.valueOf(val));
        }
        val = element.getAttribute("hideCheckMessages");
        if (val.length() == 0) {
            board.setHideCheck(null);
        } else {
            board.setHideCheck(Boolean.valueOf(val));
        }
        val = element.getAttribute("hideObserveMessages");
        if (val.length() == 0) {
            board.setHideObserve(null);
        } else {
            board.setHideObserve(Boolean.valueOf(val));
        }
    }

    private void refreshModel(DefaultTreeModel model, Folder node) {
        int[] childIndicies = new int[node.getChildCount()];
        for (int x = 0; x < node.getChildCount(); ++x) {
            childIndicies[x] = x;
        }
        model.nodesWereInserted(node, childIndicies);
    }

    private boolean isFolder(Element treeEntry) {
        String isFolder = treeEntry.getAttribute("isfolder");
        return isFolder != null && isFolder.toLowerCase().equals("true");
    }

    private boolean isExpanded(Element treeEntry) {
        String isExpanded = treeEntry.getAttribute("isexpanded");
        return isExpanded != null && isExpanded.toLowerCase().equals("true");
    }

    private String getName(Element treeEntry) {
        List<Element> list = XMLTools.getChildElementsByTagName(treeEntry, "name");
        if (list.size() != 1) {
            logger.severe("Error - boards.xml invalid: there must be 1 <name> tag for each entry");
            return null;
        }
        Text txtname = (Text)((Node)list.get(0)).getFirstChild();
        if (txtname == null) {
            return null;
        }
        return txtname.getData().trim();
    }

    private String getPublicKey(Element treeEntry) {
        List<Element> list = XMLTools.getChildElementsByTagName(treeEntry, "publicKey");
        if (list.size() > 1) {
            logger.severe("Error - boards.xml invalid: there should be a maximum of 1 <publicKey> tag for each entry");
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        Text txtname = (Text)((Node)list.get(0)).getFirstChild();
        if (txtname == null) {
            return null;
        }
        return txtname.getData().trim();
    }

    private String getDescription(Element treeEntry) {
        List<Element> list = XMLTools.getChildElementsByTagName(treeEntry, "description");
        if (list.size() > 1) {
            logger.severe("Error - boards.xml invalid: there should be a maximum of 1 <description> tag for each entry");
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        Text txtname = (Text)((Node)list.get(0)).getFirstChild();
        if (txtname == null) {
            return null;
        }
        return txtname.getData().trim();
    }

    private String getPrivateKey(Element treeEntry) {
        List<Element> list = XMLTools.getChildElementsByTagName(treeEntry, "privateKey");
        if (list.size() > 1) {
            logger.severe("Error - boards.xml invalid: there should be a maximum of 1 <privateKey> tag for each entry");
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        Text txtname = (Text)((Node)list.get(0)).getFirstChild();
        if (txtname == null) {
            return null;
        }
        return txtname.getData().trim();
    }

    public boolean saveBoardTree(TofTree tree, TofTreeModel model, File file) {
        Document doc = XMLTools.createDomDocument();
        if (doc == null) {
            logger.severe("Error - saveBoardTree: factory could'nt create XML Document.");
            return false;
        }
        Folder root = (Folder)model.getRoot();
        Element rootElement = doc.createElement("FrostBoardTree");
        doc.appendChild(rootElement);
        Element rootBoardElement = doc.createElement("FrostBoardTreeEntry");
        rootBoardElement.setAttribute("isfolder", "true");
        rootBoardElement.setAttribute("isexpanded", "true");
        Element nameElement = doc.createElement("name");
        Text text = doc.createTextNode(root.getName());
        nameElement.appendChild(text);
        rootBoardElement.appendChild(nameElement);
        rootElement.appendChild(rootBoardElement);
        this.saveProcessFolder(rootBoardElement, root, doc, model, tree);
        boolean writeOK = false;
        try {
            writeOK = XMLTools.writeXmlFile(doc, file);
            logger.info("Board tree saved successfully.");
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception - saveBoardTree", t);
        }
        return writeOK;
    }

    private void saveProcessFolder(Element parentElement, Folder treeNode, Document doc, DefaultTreeModel model, JTree tree) {
        for (int x = 0; x < treeNode.getChildCount(); ++x) {
            AbstractNode boardObject = (AbstractNode)treeNode.getChildAt(x);
            if (boardObject.isBoard()) {
                this.appendBoard(parentElement, (Board)boardObject, doc);
                continue;
            }
            if (!boardObject.isFolder()) continue;
            Element newFolder = this.appendFolder(parentElement, (Folder)boardObject, doc, model, tree);
            this.saveProcessFolder(newFolder, (Folder)boardObject, doc, model, tree);
        }
    }

    private void appendBoard(Element parent, Board board, Document doc) {
        Text text;
        Element rootBoardElement = doc.createElement("FrostBoardTreeEntry");
        Element element = doc.createElement("name");
        CDATASection cdata = doc.createCDATASection(board.getName());
        element.appendChild(cdata);
        rootBoardElement.appendChild(element);
        if (board.getPublicKey() != null) {
            element = doc.createElement("publicKey");
            cdata = doc.createCDATASection(board.getPublicKey());
            element.appendChild(cdata);
            rootBoardElement.appendChild(element);
        }
        if (board.getPrivateKey() != null) {
            element = doc.createElement("privateKey");
            cdata = doc.createCDATASection(board.getPrivateKey());
            element.appendChild(cdata);
            rootBoardElement.appendChild(element);
        }
        if (board.getDescription() != null) {
            element = doc.createElement("description");
            cdata = doc.createCDATASection(board.getDescription());
            element.appendChild(cdata);
            rootBoardElement.appendChild(element);
        }
        if (board.isConfigured()) {
            element = doc.createElement("config");
            element.setAttribute("autoUpdate", "" + board.getAutoUpdateEnabled());
            if (board.getMaxMessageDisplayObj() != null) {
                element.setAttribute("maxMessageDisplay", "" + board.getMaxMessageDisplay());
            }
            if (board.getMaxMessageDownloadObj() != null) {
                element.setAttribute("maxMessageDownload", "" + board.getMaxMessageDownload());
            }
            if (board.getShowSignedOnlyObj() != null) {
                element.setAttribute("showSignedOnly", "" + board.getShowSignedOnly());
            }
            if (board.getStoreSentMessagesObj() != null) {
                element.setAttribute("storeSentMessages", "" + board.getStoreSentMessages());
            }
            if (board.getHideBadObj() != null) {
                element.setAttribute("hideBadMessages", "" + board.getHideBad());
            }
            if (board.getHideCheckObj() != null) {
                element.setAttribute("hideCheckMessages", "" + board.getHideCheck());
            }
            if (board.getHideObserveObj() != null) {
                element.setAttribute("hideObserveMessages", "" + board.getHideObserve());
            }
            rootBoardElement.appendChild(element);
        }
        if (board.getLastUpdateStartMillis() > 0L) {
            element = doc.createElement("lastUpdateStartedMillis");
            text = doc.createTextNode("" + board.getLastUpdateStartMillis());
            element.appendChild(text);
            rootBoardElement.appendChild(element);
        }
        if (board.getLastBackloadUpdateFinishedMillis() > 0L) {
            element = doc.createElement("lastBackloadUpdateFinishedMillis");
            text = doc.createTextNode("" + board.getLastBackloadUpdateFinishedMillis());
            element.appendChild(text);
            rootBoardElement.appendChild(element);
        }
        parent.appendChild(rootBoardElement);
    }

    private Element appendFolder(Element parent, Folder board, Document doc, DefaultTreeModel model, JTree tree) {
        Element rootBoardElement = doc.createElement("FrostBoardTreeEntry");
        rootBoardElement.setAttribute("isfolder", "true");
        boolean expanded = tree.isExpanded(new TreePath(model.getPathToRoot(board)));
        String expandedstr = expanded ? "true" : "false";
        rootBoardElement.setAttribute("isexpanded", expandedstr);
        Element element = doc.createElement("name");
        Text text = doc.createTextNode(board.getName());
        element.appendChild(text);
        rootBoardElement.appendChild(element);
        parent.appendChild(rootBoardElement);
        return rootBoardElement;
    }
}

