/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Core;
import frost.boards.Board;
import frost.boards.BoardUpdateInformation;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.fileTransfer.common.TableBackgroundColors;
import frost.gui.SortedTable;
import frost.gui.model.BoardInfoTableModel;
import frost.gui.model.SortedTableModel;
import frost.gui.model.TableMember;
import frost.storage.perst.messages.MessageStorage;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import frost.util.CopyToClipboard;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class BoardInfoFrame
extends JFrame
implements BoardUpdateThreadListener {
    private final boolean showColoredLines;
    private TofTree tofTree = null;
    private static boolean isShowing = false;
    private Language language = null;
    private final Listener listener = new Listener();
    private static final Logger logger = Logger.getLogger(BoardInfoFrame.class.getName());
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final JPanel boardTablePanel = new JPanel(new BorderLayout());
    private final JLabel summaryLabel = new JLabel();
    private final JButton updateButton = new JButton();
    private final JButton updateSelectedBoardButton = new JButton();
    private final JButton updateAllBoardsButton = new JButton();
    private final JButton Bclose = new JButton();
    private JSkinnablePopupMenu popupMenu = null;
    private final JMenuItem MIupdate = new JMenuItem();
    private final JMenuItem MIupdateSelectedBoard = new JMenuItem();
    private final JMenuItem MIupdateAllBoards = new JMenuItem();
    private final JMenuItem MIcopyInfoToClipboard = new JMenuItem();
    private BoardInfoTableModel boardTableModel = null;
    private SortedTable boardTable = null;
    private static UpdateBoardInfoTableThread updateBoardInfoTableThread = null;

    private void refreshLanguage() {
        this.setTitle(this.language.getString("BoardInfoFrame.title"));
        this.updateButton.setText(this.language.getString("BoardInfoFrame.button.update"));
        this.updateSelectedBoardButton.setText(this.language.getString("BoardInfoFrame.button.updateSelectedBoard"));
        this.updateAllBoardsButton.setText(this.language.getString("BoardInfoFrame.button.updateAllBoards"));
        this.Bclose.setText(this.language.getString("BoardInfoFrame.button.close"));
        this.MIupdate.setText(this.language.getString("BoardInfoFrame.button.update"));
        this.MIupdateSelectedBoard.setText(this.language.getString("BoardInfoFrame.button.updateSelectedBoard"));
        this.MIupdateAllBoards.setText(this.language.getString("BoardInfoFrame.button.updateAllBoards"));
        this.MIcopyInfoToClipboard.setText(this.language.getString("BoardInfoFrame.popupMenu.copyInfoToClipboard"));
    }

    public BoardInfoFrame(JFrame parentFrame, TofTree tofTree) {
        this.language = Language.getInstance();
        this.refreshLanguage();
        this.tofTree = tofTree;
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", e);
        }
        this.setSize((int)((double)parentFrame.getWidth() * 0.75), (int)((double)parentFrame.getHeight() * 0.75));
        this.setLocationRelativeTo(parentFrame);
        this.showColoredLines = Core.frostSettings.getBoolValue("showColoredRows");
    }

    private void Init() throws Exception {
        this.boardTableModel = new BoardInfoTableModel();
        this.boardTable = new SortedTable(this.boardTableModel);
        ImageIcon frameIcon = MiscToolkit.loadImageIcon("/data/jtc.jpg");
        this.setIconImage(frameIcon.getImage());
        this.setSize(new Dimension(300, 200));
        this.setResizable(true);
        this.boardTable.setRowSelectionAllowed(true);
        this.boardTable.setSelectionMode(2);
        this.boardTable.setRowHeight(18);
        BoardInfoTableCellRenderer cellRenderer = new BoardInfoTableCellRenderer();
        this.boardTable.setDefaultRenderer(Object.class, cellRenderer);
        this.boardTable.setDefaultRenderer(Number.class, cellRenderer);
        this.updateSelectedBoardButton.setEnabled(false);
        this.boardTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BoardInfoFrame.this.boardTableListModel_valueChanged(e);
            }
        });
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoardInfoFrame.this.updateButton_actionPerformed(e);
            }
        };
        this.updateButton.addActionListener(al);
        this.MIupdate.addActionListener(al);
        al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoardInfoFrame.this.updateSelectedBoardButton_actionPerformed(e);
            }
        };
        this.updateSelectedBoardButton.addActionListener(al);
        this.MIupdateSelectedBoard.addActionListener(al);
        al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoardInfoFrame.this.updateAllBoardsButton_actionPerformed(e);
            }
        };
        this.updateAllBoardsButton.addActionListener(al);
        this.MIupdateAllBoards.addActionListener(al);
        this.MIcopyInfoToClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoardInfoFrame.this.copyInfoToClipboard_actionPerformed(e);
            }
        });
        al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BoardInfoFrame.this.closeDialog();
            }
        };
        this.Bclose.addActionListener(al);
        this.getContentPane().add((Component)this.mainPanel, null);
        this.mainPanel.add((Component)this.boardTablePanel, "Center");
        this.boardTablePanel.add((Component)this.updateSelectedBoardButton, "North");
        this.boardTablePanel.add((Component)new JScrollPane(this.boardTable), "Center");
        JPanel summaryPanel = new JPanel();
        summaryPanel.setLayout(new BoxLayout(summaryPanel, 0));
        summaryPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        summaryPanel.add(this.summaryLabel);
        summaryPanel.add(Box.createRigidArea(new Dimension(15, 3)));
        summaryPanel.add(Box.createHorizontalGlue());
        summaryPanel.add(this.updateButton);
        this.boardTablePanel.add((Component)summaryPanel, "South");
        this.boardTablePanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(7, 7, 7, 7)));
        this.boardTablePanel.setBorder(new CompoundBorder(new EmptyBorder(7, 7, 7, 7), this.boardTablePanel.getBorder()));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 7, 7, 7));
        buttonsPanel.add(this.updateSelectedBoardButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(15, 3)));
        buttonsPanel.add(this.updateAllBoardsButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(15, 3)));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.Bclose);
        this.mainPanel.add((Component)buttonsPanel, "South");
        this.boardTable.addMouseListener(this.listener);
        this.updateButton_actionPerformed(null);
    }

    private JSkinnablePopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JSkinnablePopupMenu();
            this.popupMenu.add(this.MIcopyInfoToClipboard);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.MIupdateSelectedBoard);
            this.popupMenu.add(this.MIupdateAllBoards);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.MIupdate);
        }
        return this.popupMenu;
    }

    private void boardTableListModel_valueChanged(ListSelectionEvent e) {
        if (this.boardTable.getSelectedRowCount() > 0) {
            this.updateSelectedBoardButton.setEnabled(true);
            this.MIupdateSelectedBoard.setEnabled(true);
        } else {
            this.updateSelectedBoardButton.setEnabled(false);
            this.MIupdateSelectedBoard.setEnabled(false);
        }
    }

    private void updateButton_actionPerformed(ActionEvent e) {
        if (updateBoardInfoTableThread != null) {
            return;
        }
        ((SortedTableModel)this.boardTable.getModel()).clearDataModel();
        updateBoardInfoTableThread = new UpdateBoardInfoTableThread();
        updateBoardInfoTableThread.start();
        this.updateSelectedBoardButton.setEnabled(false);
        this.MIupdateSelectedBoard.setEnabled(false);
    }

    private void updateAllBoardsButton_actionPerformed(ActionEvent e) {
        LinkedList<Board> boards = ((TofTreeModel)this.tofTree.getModel()).getAllBoards();
        for (Board board : boards) {
            if (board.isManualUpdateAllowed()) {
                this.tofTree.updateBoard(board);
            }
            this.boardTableModel.fireTableDataChanged();
        }
    }

    private void updateSelectedBoardButton_actionPerformed(ActionEvent e) {
        int[] selectedRows = this.boardTable.getSelectedRows();
        if (selectedRows.length > 0) {
            for (int rowIx : selectedRows) {
                if (rowIx >= this.boardTableModel.getRowCount()) continue;
                BoardInfoTableMember row = (BoardInfoTableMember)this.boardTableModel.getRow(rowIx);
                if (row.getBoard().isManualUpdateAllowed()) {
                    this.tofTree.updateBoard(row.getBoard());
                }
                this.boardTableModel.fireTableCellUpdated(rowIx, 0);
            }
            this.boardTable.clearSelection();
        }
    }

    private void copyInfoToClipboard_actionPerformed(ActionEvent e) {
        int[] selectedRows = this.boardTable.getSelectedRows();
        if (selectedRows.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int rowIx : selectedRows) {
                if (rowIx >= this.boardTableModel.getRowCount()) continue;
                BoardInfoTableMember row = (BoardInfoTableMember)this.boardTableModel.getRow(rowIx);
                String boardName = row.getBoard().getName();
                String state = row.getBoard().getStateString();
                String allMsgs = row.getAllMessageCount().toString();
                sb.append(boardName).append("  (").append(state).append(")  ").append(allMsgs).append("\n");
            }
            CopyToClipboard.copyText(sb.toString());
        }
    }

    public BoardInfoTableMember fillInBoardCounts(Board board, BoardInfoTableMember row) {
        int countNewMessages = 0;
        int countAllMessages = 0;
        countNewMessages = MessageStorage.inst().getMessageCount(board, 0);
        countAllMessages = MessageStorage.inst().getMessageCount(board, -1);
        row.setAllMessageCount(countAllMessages);
        row.setNewMessageCount(countNewMessages);
        return row;
    }

    public void startDialog() {
        this.tofTree.getRunningBoardUpdateThreads().addBoardUpdateThreadListener(this);
        this.language.addLanguageListener(this.listener);
        this.language.addLanguageListener(this.boardTableModel);
        BoardInfoFrame.setDialogShowing(true);
        this.setVisible(true);
    }

    protected void closeDialog() {
        this.tofTree.getRunningBoardUpdateThreads().removeBoardUpdateThreadListener(this);
        this.language.removeLanguageListener(this.listener);
        this.language.removeLanguageListener(this.boardTableModel);
        BoardInfoFrame.setDialogShowing(false);
        this.dispose();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closeDialog();
        }
        super.processWindowEvent(e);
    }

    public void boardUpdateThreadFinished(BoardUpdateThread thread) {
        this.boardTableModel.tableEntriesChanged();
    }

    public void boardUpdateThreadStarted(BoardUpdateThread thread) {
        this.boardTableModel.tableEntriesChanged();
    }

    public void boardUpdateInformationChanged(BoardUpdateThread thread, BoardUpdateInformation bui) {
    }

    public static boolean isDialogShowing() {
        return isShowing;
    }

    public static void setDialogShowing(boolean val) {
        isShowing = val;
    }

    private class BoardInfoTableCellRenderer
    extends DefaultTableCellRenderer {
        Font boldFont;
        Font origFont;

        public BoardInfoTableCellRenderer() {
            this.origFont = BoardInfoFrame.this.boardTable.getFont();
            this.boldFont = this.origFont.deriveFont(1);
            this.setVerticalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            BoardInfoTableMember tblrow = (BoardInfoTableMember)BoardInfoFrame.this.boardTableModel.getRow(row);
            if (tblrow.getBoard().isUpdating()) {
                this.setFont(this.boldFont);
            } else {
                this.setFont(this.origFont);
            }
            TableColumn tableColumn = table.getColumnModel().getColumn(column);
            int modelColumn = tableColumn.getModelIndex();
            if (modelColumn == 0) {
                this.setIcon(tblrow.getBoard().getStateIcon());
            } else {
                this.setIcon(null);
            }
            if (!isSelected) {
                Color newBackground = TableBackgroundColors.getBackgroundColor(table, row, BoardInfoFrame.this.showColoredLines);
                this.setBackground(newBackground);
            }
            return this;
        }
    }

    class BoardInfoTableMember
    implements TableMember {
        Board board;
        Integer allmsg;
        Integer newmsg;

        public BoardInfoTableMember(Board board) {
            this.board = board;
            this.allmsg = null;
            this.newmsg = null;
        }

        public Object getValueAt(int column) {
            switch (column) {
                case 0: {
                    return this.board.getName();
                }
                case 1: {
                    return this.board.getStateString();
                }
                case 2: {
                    return this.allmsg;
                }
                case 3: {
                    return this.newmsg;
                }
            }
            return "*ERR*";
        }

        public int compareTo(TableMember anOther, int tableColumIndex) {
            Comparable c1 = (Comparable)this.getValueAt(tableColumIndex);
            Comparable c2 = (Comparable)anOther.getValueAt(tableColumIndex);
            return c1.compareTo(c2);
        }

        public Board getBoard() {
            return this.board;
        }

        public Integer getAllMessageCount() {
            return this.allmsg;
        }

        public void setAllMessageCount(int i) {
            this.allmsg = new Integer(i);
        }

        public void setNewMessageCount(int i) {
            this.newmsg = new Integer(i);
        }
    }

    private class UpdateBoardInfoTableThread
    extends Thread {
        private UpdateBoardInfoTableThread() {
        }

        public void run() {
            int messageCount = 0;
            int boardCount = 0;
            LinkedList<Board> boards = ((TofTreeModel)BoardInfoFrame.this.tofTree.getModel()).getAllBoards();
            for (Board board : boards) {
                BoardInfoTableMember newRow = new BoardInfoTableMember(board);
                BoardInfoFrame.this.fillInBoardCounts(board, newRow);
                final BoardInfoTableMember finalRow = newRow;
                final int finalBoardCount = ++boardCount;
                final int finalMessageCount = messageCount += newRow.getAllMessageCount().intValue();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BoardInfoFrame.this.boardTableModel.addRow(finalRow);
                        BoardInfoFrame.this.summaryLabel.setText(BoardInfoFrame.this.language.getString("BoardInfoFrame.label.boards") + ": " + finalBoardCount + "    " + BoardInfoFrame.this.language.getString("BoardInfoFrame.label.messages") + ": " + finalMessageCount);
                    }
                });
            }
            updateBoardInfoTableThread = null;
        }
    }

    private class Listener
    implements MouseListener,
    LanguageListener {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                BoardInfoFrame.this.updateSelectedBoardButton_actionPerformed(null);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BoardInfoFrame.this.getPopupMenu().show(BoardInfoFrame.this.boardTable, e.getX(), e.getY());
            }
        }

        public void languageChanged(LanguageEvent event) {
            BoardInfoFrame.this.refreshLanguage();
        }
    }
}

