/*
 * Decompiled with CFR 0.152.
 */
package frost;

import frost.SettingsUpdater;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SettingsClass
implements ExitSavable {
    private final File settingsFile;
    private final Hashtable<String, Object> settingsHash;
    private Hashtable<String, Object> defaults = null;
    private final String fs = System.getProperty("file.separator");
    private PropertyChangeSupport changeSupport = null;
    private Vector<SettingsUpdater> updaters = null;
    private static final Logger logger = Logger.getLogger(SettingsClass.class.getName());
    public static final String DOS_STOP_BOARD_UPDATES_WHEN_DOSED = "dos.stopBoardUpdatesWhenDosed";
    public static final String DOS_INVALID_SUBSEQUENT_MSGS_THRESHOLD = "dos.invalidSubsequentMessagesThreshold";
    public static final String MIGRATE_VERSION = "migrate.version";
    public static final String DB_CLEANUP_INTERVAL = "database.cleanup.interval";
    public static final String DB_CLEANUP_LASTRUN = "database.cleanup.lastRun";
    public static final String DB_CLEANUP_REMOVEOFFLINEFILEWITHKEY = "database.cleanup.removeOfflineFilesWithKey";
    public static final String DB_CLEANUP_OFFLINEFILESMAXDAYSOLD = "database.cleanup.offlineFilesMaxDaysOld";
    public static final String PERST_COMPACT_STORAGES = "perst.compactStorages";
    public static final String DIR_CONFIG = "config.dir";
    public static final String DIR_DOWNLOAD = "downloadDirectory";
    public static final String DIR_LAST_USED = "lastUsedDirectory";
    public static final String DIR_TEMP = "temp.dir";
    public static final String DIR_LOCALDATA = "localdata.dir";
    public static final String DIR_STORE = "store.dir";
    public static final String FREENET_VERSION = "freenetVersion";
    public static final String LANGUAGE_LOCALE = "locale";
    public static final String CONFIRM_MARK_ALL_MSGS_READ = "confirm.markAllMessagesRead";
    public static final String ACCEPT_SIGNATURE_FORMAT_V1 = "acceptSignatureFormatV1";
    public static final String LOOK_AND_FEEL = "ChoosenLookAndFeel";
    public static final String STORAGE_STORE_INVALID_MESSAGES = "storage.storeInvalidMessages";
    public static final String STORAGE_STORE_SENT_MESSAGES = "storage.storeSentMessages";
    public static final String PERST_PAGEPOOLSIZE_FILES = "perst.pagepoolsizeKiB.files";
    public static final String PERST_PAGEPOOLSIZE_INDEXSLOTS = "perst.pagepoolsizeKiB.indexslots";
    public static final String PERST_PAGEPOOLSIZE_SHAREDFILESCHKKEYS = "perst.pagepoolsizeKiB.sharedfilechkkeys";
    public static final String PERST_PAGEPOOLSIZE_FILELIST = "perst.pagepoolsizeKiB.filelist";
    public static final String PERST_PAGEPOOLSIZE_IDENTITIES = "perst.pagepoolsizeKiB.identities";
    public static final String PERST_PAGEPOOLSIZE_MESSAGEARCHIVE = "perst.pagepoolsizeKiB.messagearchive";
    public static final String PERST_PAGEPOOLSIZE_MESSAGES = "perst.pagepoolsizeKiB.messages";
    public static final String PERST_PAGEPOOLSIZE_MESSAGECONTENTS = "perst.pagepoolsizeKiB.messagecontents";
    public static final String AVAILABLE_NODES = "availableNodes";
    public static final String FCP2_USE_DDA = "fcp2.useDDA";
    public static final String FCP2_USE_PERSISTENCE = "fcp2.usePersistence";
    public static final String FCP2_USE_ONE_CONNECTION_FOR_MESSAGES = "fcp2.useOneConnectionForMessages";
    public static final String FCP2_DEFAULT_PRIO_MESSAGE_UPLOAD = "fcp2.defaultPriorityMessageUpload";
    public static final String FCP2_DEFAULT_PRIO_MESSAGE_DOWNLOAD = "fcp2.defaultPriorityMessageDownload";
    public static final String FCP2_DEFAULT_PRIO_FILE_UPLOAD = "fcp2.defaultPriorityFileUpload";
    public static final String FCP2_DEFAULT_PRIO_FILE_DOWNLOAD = "fcp2.defaultPriorityFileDownload";
    public static final String FCP2_SET_TARGETFILENAME_FOR_MANUAL_PUT = "fcp2.setTargetfilenameForManualPut";
    public static final String FCP2_QUICKLY_FAIL_ON_ADNF = "fcp2.quicklyFailOnAdnf";
    public static final String AUTO_SAVE_INTERVAL = "autoSaveInterval";
    public static final String AUTO_SAVE_LOCAL_IDENTITIES = "autoSaveLocalIdentities";
    public static final String DISABLE_FILESHARING = "disableFilesharing";
    public static final String REMEMBER_SHAREDFILE_DOWNLOADED = "rememberSharedFileDownloaded";
    public static final String DOWNLOADING_ACTIVATED = "downloadingActivated";
    public static final String LOG_FILE_SIZE_LIMIT = "logFileSizeLimit";
    public static final String LOG_LEVEL = "logLevel";
    public static final String LOG_TO_CONSOLE = "logToConsole";
    public static final String LOG_TO_FILE = "logToFile";
    public static final String LOG_FCP2_MESSAGES = "log.logFcp2MessagesToConsole";
    public static final String LOG_FILEBASE_MESSAGES = "log.logFilebaseMessagesToConsole";
    public static final String FILE_LIST_FONT_NAME = "fileListFontName";
    public static final String FILE_LIST_FONT_SIZE = "fileListFontSize";
    public static final String FILE_LIST_FONT_STYLE = "fileListFontStyle";
    public static final String MESSAGE_BODY_FONT_NAME = "messageBodyFontName";
    public static final String MESSAGE_BODY_FONT_SIZE = "messageBodyFontSize";
    public static final String MESSAGE_BODY_FONT_STYLE = "messageBodyFontStyle";
    public static final String MESSAGE_LIST_FONT_NAME = "messageListFontName";
    public static final String MESSAGE_LIST_FONT_SIZE = "messageListFontSize";
    public static final String MESSAGE_LIST_FONT_STYLE = "messageListFontStyle";
    public static final String SHOW_DELETED_MESSAGES = "showDeletedMessages";
    public static final String SILENTLY_RETRY_MESSAGES = "silentlyRetryMessages";
    public static final String HANDLE_OWN_MESSAGES_AS_NEW_DISABLED = "handleOwnMessagesAsNewDisabled";
    public static final String SHOW_OWN_MESSAGES_AS_ME_DISABLED = "showOwnMessagesAsMeDisabled";
    public static final String SORT_THREADROOTMSGS_ASCENDING = "sortThreadRootMessagesAscending";
    public static final String ALWAYS_DOWNLOAD_MESSAGES_BACKLOAD = "alwaysDownloadMessagesBackload";
    public static final String UPLOAD_MAX_RETRIES = "uploadMaxRetries";
    public static final String UPLOAD_WAITTIME = "uploadRetriesWaitTime";
    public static final String UPLOAD_MAX_THREADS = "uploadThreads";
    public static final String UPLOAD_FILE_HTL = "htlUpload";
    public static final String UPLOAD_MAX_SPLITFILE_THREADS = "splitfileUploadThreads";
    public static final String UPLOAD_REMOVE_CHUNKS = "removeOldUploadFileChunks";
    public static final String DOWNLOAD_MAX_THREADS = "downloadThreads";
    public static final String DOWNLOAD_MAX_RETRIES = "downloadMaxRetries";
    public static final String DOWNLOAD_WAITTIME = "downloadWaittime";
    public static final String DOWNLOAD_TRY_ALL_SEGMENTS = "downloadTryAllSegments";
    public static final String DOWNLOAD_DECODE_AFTER_EACH_SEGMENT = "downloadDecodeAfterEachSegment";
    public static final String DOWNLOAD_REMOVE_FINISHED = "removeFinishedDownloads";
    public static final String UPLOAD_REMOVE_FINISHED = "removeFinishedUploads";
    public static final String DOWNLOAD_MAX_SPLITFILE_THREADS = "splitfileDownloadThreads";
    public static final String GQ_SHOW_EXTERNAL_ITEMS_DOWNLOAD = "showExternalGlobalQueueDownloads";
    public static final String GQ_SHOW_EXTERNAL_ITEMS_UPLOAD = "showExternalGlobalQueueUploads";
    public static final String SAVE_SORT_STATES = "saveSortStates";
    public static final String MSGTABLE_MULTILINE_SELECT = "messageTableMultilineSelect";
    public static final String MSGTABLE_SCROLL_HORIZONTAL = "messageTableScrollHorizontal";
    public static final String MSGTABLE_SHOW_COLLAPSED_THREADS = "messageTableShowCollapsedThreads";
    public static final String SHOW_BOARDDESC_TOOLTIPS = "showBoardDescriptionTooltips";
    public static final String SHOW_BOARD_UPDATED_COUNT = "showBoardUpdatedCount";
    public static final String PREVENT_BOARDTREE_REORDERING = "preventBoardTreeReordering";
    public static final String SHOW_BOARDTREE_FLAGGEDSTARRED_INDICATOR = "showBoardtreeFlaggedStarredIndicators";
    public static final String SHOW_BOARD_UPDATE_VISUALIZATION = "boardUpdateVisualization";
    public static final String DISABLE_SPLASHSCREEN = "disableSplashScreen";
    public static final String SHOW_SYSTRAY_ICON = "showSystrayIcon";
    public static final String MINIMIZE_TO_SYSTRAY = "minimizeToSystray";
    public static final String MAX_MESSAGE_DISPLAY = "maxMessageDisplay";
    public static final String MAX_MESSAGE_DOWNLOAD = "maxMessageDownload";
    public static final String MESSAGE_UPLOAD_DISABLED = "messageUploadDisabled";
    public static final String SEARCH_MAX_RESULTS = "maxSearchResults";
    public static final String SEARCH_HIDE_BAD = "hideBadFiles";
    public static final String SEARCH_HIDE_CHECK = "hideCheckFiles";
    public static final String SEARCH_HIDE_OBSERVE = "hideObserveFiles";
    public static final String SEARCH_HIDE_FILES_WITHOUT_CHK = "hideFilesWithoutChk";
    public static final String BOARDLIST_LAST_SELECTED_BOARD = "tofTreeSelectedRow";
    public static final String MESSAGE_DOWNLOAD_HTL = "tofDownloadHtl";
    public static final String MESSAGE_UPLOAD_HTL = "tofUploadHtl";
    public static final String MESSAGE_BLOCK_SUBJECT = "blockMessage";
    public static final String MESSAGE_BLOCK_SUBJECT_ENABLED = "blockMessageChecked";
    public static final String MESSAGE_BLOCK_BODY = "blockMessageBody";
    public static final String MESSAGE_BLOCK_BODY_ENABLED = "blockMessageBodyChecked";
    public static final String MESSAGE_BLOCK_BOARDNAME = "blockMessageBoard";
    public static final String MESSAGE_BLOCK_BOARDNAME_ENABLED = "blockMessageBoardChecked";
    public static final String JUNK_HIDE_JUNK_MESSAGES = "junk.hideJunkMessages";
    public static final String JUNK_MARK_JUNK_IDENTITY_BAD = "junk.markJunkIdentityBad";
    public static final String MESSAGE_HIDE_OBSERVE = "hideObserveMessages";
    public static final String MESSAGE_HIDE_CHECK = "hideCheckMessages";
    public static final String MESSAGE_HIDE_BAD = "hideBadMessages";
    public static final String MESSAGE_HIDE_UNSIGNED = "signedOnly";
    public static final String KNOWNBOARDS_BLOCK_FROM_OBSERVE = "blockBoardsFromObserve";
    public static final String KNOWNBOARDS_BLOCK_FROM_CHECK = "blockBoardsFromCheck";
    public static final String KNOWNBOARDS_BLOCK_FROM_BAD = "blockBoardsFromBad";
    public static final String KNOWNBOARDS_BLOCK_FROM_UNSIGNED = "blockBoardsFromUnsigned";
    public static final String BOARD_AUTOUPDATE_ENABLED = "automaticUpdate";
    public static final String BOARD_AUTOUPDATE_CONCURRENT_UPDATES = "automaticUpdate.concurrentBoardUpdates";
    public static final String BOARD_AUTOUPDATE_MIN_INTERVAL = "automaticUpdate.boardsMinimumUpdateInterval";
    public static final String BOARD_UPDATE_VISUALIZATION_ENABLED = "boardUpdateVisualization";
    public static final String BOARD_UPDATE_VISUALIZATION_BGCOLOR_SELECTED = "boardUpdatingSelectedBackgroundColor";
    public static final String BOARD_UPDATE_VISUALIZATION_BGCOLOR_NOT_SELECTED = "boardUpdatingNonSelectedBackgroundColor";
    public static final String SHOW_THREADS = "MessagePanel.showThreads";
    public static final String INDICATE_LOW_RECEIVED_MESSAGES = "MessagePanel.indicateLowReceivedMessages";
    public static final String INDICATE_LOW_RECEIVED_MESSAGES_COUNT_RED = "MessagePanel.indicateLowReceivedMessages.redCount";
    public static final String INDICATE_LOW_RECEIVED_MESSAGES_COUNT_LIGHTRED = "MessagePanel.indicateLowReceivedMessages.lightRedCount";
    public static final String SHOW_UNREAD_ONLY = "MessagePanel.showUnreadOnly";
    public static final String MSGTABLE_MSGTEXT_DIVIDER_LOCATION = "MessagePanel.msgTableAndMsgTextSplitpaneDividerLocation";
    public static final String SHOW_COLORED_ROWS = "showColoredRows";
    public static final String SHOW_SMILEYS = "showSmileys";
    public static final String SHOW_KEYS_AS_HYPERLINKS = "showKeysAsHyperlinks";
    public static final String MESSAGE_BODY_ANTIALIAS = "messageBodyAA";
    public static final String ALTERNATE_EDITOR_ENABLED = "useAltEdit";
    public static final String ALTERNATE_EDITOR_COMMAND = "altEdit";
    public static final String FILE_BASE = "fileBase";
    public static final String MESSAGE_BASE = "messageBase";
    public static final String MESSAGE_EXPIRE_DAYS = "messageExpireDays";
    public static final String MESSAGE_EXPIRATION_MODE = "messageExpirationMode";
    public static final String ARCHIVE_KEEP_FLAGGED_AND_STARRED = "archiveKeepFlaggedOrStarredMessages";
    public static final String ARCHIVE_KEEP_UNREAD = "archiveKeepUnreadMessages";
    public static final String MIN_DAYS_BEFORE_FILE_RESHARE = "minDaysBeforeFileReshare";
    public static final String MAX_FILELIST_DOWNLOAD_DAYS = "fileListDownloadDays";
    public static final String FILEEXTENSION_AUDIO = "audioExtension";
    public static final String FILEEXTENSION_VIDEO = "videoExtension";
    public static final String FILEEXTENSION_DOCUMENT = "documentExtension";
    public static final String FILEEXTENSION_EXECUTABLE = "executableExtension";
    public static final String FILEEXTENSION_ARCHIVE = "archiveExtension";
    public static final String FILEEXTENSION_IMAGE = "imageExtension";
    public static final String LAST_USED_FROMNAME = "userName";
    public static final String MAINFRAME_LAST_WIDTH = "lastFrameWidth";
    public static final String MAINFRAME_LAST_HEIGHT = "lastFrameHeight";
    public static final String MAINFRAME_LAST_X = "lastFramePosX";
    public static final String MAINFRAME_LAST_Y = "lastFramePosY";
    public static final String MAINFRAME_LAST_MAXIMIZED = "lastFrameMaximized";
    public static final String LOG_DOWNLOADS_ENABLED = "logDownloads";
    public static final String LOG_UPLOADS_ENABLED = "logUploads";

    public SettingsClass() {
        this.settingsHash = new Hashtable();
        this.settingsHash.put(DIR_CONFIG, "config" + this.fs);
        String configFilename = "config" + this.fs + "frost.ini";
        this.settingsFile = new File(configFilename);
        this.loadDefaults();
        if (!this.readSettingsFile()) {
            this.writeSettingsFile();
        }
        this.settingsHash.put(FILE_BASE, "testfiles1");
    }

    public SettingsClass(File baseDirectory) {
        this.settingsHash = new Hashtable();
        this.settingsHash.put(DIR_CONFIG, baseDirectory.getPath() + this.fs + "config" + this.fs);
        String configFilename = baseDirectory.getPath() + this.fs + "config" + this.fs + "frost.ini";
        this.settingsFile = new File(configFilename);
    }

    public String setSystemFileSeparator(String path) {
        if (this.fs.equals("\\")) {
            path = path.replace('/', File.separatorChar);
        } else if (this.fs.equals("/")) {
            path = path.replace('\\', File.separatorChar);
        }
        if (!path.endsWith(this.fs)) {
            path = path + this.fs;
        }
        return path;
    }

    public String getDefaultValue(String key) {
        String val = (String)this.defaults.get(key);
        if (val == null) {
            val = "";
        }
        return val;
    }

    public boolean readSettingsFile() {
        LineNumberReader settingsReader = null;
        if (!this.settingsFile.isFile() || this.settingsFile.length() == 0L) {
            String configDirStr = this.getValue(DIR_CONFIG);
            File bakFile = new File(configDirStr + "frost.ini.bak");
            if (bakFile.isFile() && bakFile.length() > 0L) {
                bakFile.renameTo(this.settingsFile);
            } else {
                return false;
            }
        }
        try {
            settingsReader = new LineNumberReader(new FileReader(this.settingsFile));
        }
        catch (Exception e) {
            logger.warning(this.settingsFile.getName() + " does not exist, will create it");
            return false;
        }
        try {
            String line;
            while ((line = settingsReader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                StringTokenizer strtok = new StringTokenizer(line, "=");
                String key = "";
                String value = "";
                Object objValue = value;
                if (strtok.countTokens() < 2) continue;
                key = strtok.nextToken().trim();
                value = strtok.nextToken().trim();
                while (strtok.hasMoreElements()) {
                    value = value + "=" + strtok.nextToken();
                }
                if (value.startsWith("type.color(") && value.endsWith(")")) {
                    String rgbPart = value.substring(11, value.length() - 1);
                    StringTokenizer strtok2 = new StringTokenizer(rgbPart, ",");
                    if (strtok2.countTokens() == 3) {
                        try {
                            int red = Integer.parseInt(strtok2.nextToken().trim());
                            int green = Integer.parseInt(strtok2.nextToken().trim());
                            int blue = Integer.parseInt(strtok2.nextToken().trim());
                            Color c = new Color(red, green, blue);
                            objValue = c;
                        }
                        catch (Exception ex) {
                            objValue = null;
                        }
                    } else {
                        objValue = null;
                    }
                } else if (key.equals(DIR_TEMP) || key.equals(DIR_LOCALDATA) || key.equals(DIR_STORE) || key.equals(DIR_DOWNLOAD) || key.equals(DIR_LAST_USED)) {
                    value = this.setSystemFileSeparator(value);
                    objValue = value;
                } else {
                    objValue = value;
                }
                if (objValue == null) continue;
                this.settingsHash.put(key, objValue);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in readSettingsFile()", e);
        }
        try {
            settingsReader.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in readSettingsFile()", e);
        }
        this.doCleanup();
        this.doChanges();
        logger.info("Read user configuration");
        return true;
    }

    private void doChanges() {
        String tmp;
        if (this.getValue(MESSAGE_BASE).length() == 0) {
            this.setValue(MESSAGE_BASE, "news");
        }
        if (this.getIntValue(MIN_DAYS_BEFORE_FILE_RESHARE) == 3) {
            this.setValue(MIN_DAYS_BEFORE_FILE_RESHARE, 5);
        }
        if ((tmp = this.getValue(FILEEXTENSION_ARCHIVE)) != null && tmp.indexOf(".7z") < 0) {
            this.setValue(FILEEXTENSION_ARCHIVE, tmp + ";.7z");
        }
    }

    private void doCleanup() {
        this.settingsHash.remove("fcp2.defaultPriorityFile");
        this.settingsHash.remove("fcp2.defaultPriorityMessage");
        this.settingsHash.remove("spamTreshold");
        this.settingsHash.remove("skinsEnabled");
        this.settingsHash.remove("selectedSkin");
        this.settingsHash.remove("doBoardBackoff");
        this.settingsHash.remove("compactDatabaseTables");
    }

    private boolean writeSettingsFile() {
        PrintWriter settingsWriter;
        File configDir = new File("config");
        if (!configDir.isDirectory()) {
            configDir.mkdirs();
        }
        String configDirStr = this.getValue(DIR_CONFIG);
        File newFile = new File(configDirStr + "frost.ini.new");
        File oldFile = new File(configDirStr + "frost.ini.old");
        File bakFile = new File(configDirStr + "frost.ini.bak");
        try {
            settingsWriter = new PrintWriter(new FileWriter(newFile));
        }
        catch (IOException exception) {
            logger.log(Level.SEVERE, "Exception thrown in writeSettingsFile()", exception);
            return false;
        }
        TreeMap<String, Object> sortedSettings = new TreeMap<String, Object>(this.settingsHash);
        for (String key : sortedSettings.keySet()) {
            if (key.equals(DIR_CONFIG)) continue;
            String val = null;
            if (sortedSettings.get(key) instanceof Color) {
                Color c = (Color)sortedSettings.get(key);
                val = "type.color(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
            } else {
                val = sortedSettings.get(key).toString();
            }
            settingsWriter.println(key + "=" + val);
        }
        try {
            settingsWriter.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in writeSettingsFile", e);
            return false;
        }
        oldFile.delete();
        if (bakFile.isFile()) {
            bakFile.renameTo(oldFile);
        }
        if (this.settingsFile.isFile() && this.settingsFile.length() > 0L) {
            this.settingsFile.renameTo(bakFile);
        }
        newFile.renameTo(this.settingsFile);
        oldFile.delete();
        logger.info("Wrote configuration");
        return true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addUpdater(SettingsUpdater updater) {
        if (updater == null) {
            return;
        }
        if (this.updaters == null) {
            this.updaters = new Vector();
        }
        this.updaters.addElement(updater);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removeUpdater(SettingsUpdater updater) {
        if (updater == null || this.updaters == null) {
            return;
        }
        this.updaters.removeElement(updater);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getValue(String key) {
        return (String)this.settingsHash.get(key);
    }

    public Object getObjectValue(String key) {
        return this.settingsHash.get(key);
    }

    public String[] getArrayValue(String key) {
        String str = (String)this.settingsHash.get(key);
        if (str == null) {
            return new String[0];
        }
        StringTokenizer strtok = new StringTokenizer(str, ";");
        String[] returnStrArr = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreElements()) {
            returnStrArr[i] = strtok.nextToken();
            ++i;
        }
        return returnStrArr;
    }

    public boolean getBoolValue(String key) {
        String str = (String)this.settingsHash.get(key);
        if (str == null) {
            return false;
        }
        try {
            if (str.toLowerCase().equals("false")) {
                return false;
            }
            if (str.toLowerCase().equals("true")) {
                return true;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return this.getBoolValue(this.getDefaultValue(key));
    }

    public int getIntValue(String key) {
        String str = (String)this.settingsHash.get(key);
        if (str == null) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return this.getIntValue(this.getDefaultValue(key));
        }
        catch (Exception e) {
            return 0;
        }
        return val;
    }

    public long getLongValue(String key) {
        String str = (String)this.settingsHash.get(key);
        if (str == null) {
            return 0L;
        }
        long val = 0L;
        try {
            val = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return this.getLongValue(this.getDefaultValue(key));
        }
        catch (Exception e) {
            return 0L;
        }
        return val;
    }

    public float getFloatValue(String key) {
        float val = 0.0f;
        String str = (String)this.settingsHash.get(key);
        if (str == null) {
            return val;
        }
        try {
            val = Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return this.getFloatValue(this.getDefaultValue(key));
        }
        catch (Exception e) {
            return 0.0f;
        }
        return val;
    }

    public void setValue(String key, String value) {
        if (key.endsWith(".dir")) {
            value = this.setSystemFileSeparator(value);
        }
        Object oldValue = this.settingsHash.get(key);
        this.settingsHash.put(key, value);
        this.firePropertyChange(key, oldValue, value);
    }

    public void setValue(String key, Integer value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, int value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, long value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, Float value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, float value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, Boolean value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setValue(String key, boolean value) {
        this.setValue(key, String.valueOf(value));
    }

    public void setObjectValue(String key, Object value) {
        Object oldValue = this.settingsHash.get(key);
        this.settingsHash.put(key, value);
        this.firePropertyChange(key, oldValue, value);
    }

    public void loadDefaults() {
        this.defaults = new Hashtable();
        File fn = File.listRoots()[0];
        this.defaults.put(MIGRATE_VERSION, "0");
        this.defaults.put(DOS_STOP_BOARD_UPDATES_WHEN_DOSED, "true");
        this.defaults.put(DOS_INVALID_SUBSEQUENT_MSGS_THRESHOLD, "30");
        this.defaults.put(DB_CLEANUP_INTERVAL, "5");
        this.defaults.put(DB_CLEANUP_LASTRUN, "0");
        this.defaults.put(DB_CLEANUP_REMOVEOFFLINEFILEWITHKEY, "false");
        this.defaults.put(DB_CLEANUP_OFFLINEFILESMAXDAYSOLD, "365");
        this.defaults.put(DIR_TEMP, "localdata" + this.fs + "temp" + this.fs);
        this.defaults.put(DIR_LOCALDATA, "localdata" + this.fs);
        this.defaults.put(DIR_STORE, "store" + this.fs);
        this.defaults.put(DIR_DOWNLOAD, "downloads" + this.fs);
        this.defaults.put(DIR_LAST_USED, "." + this.fs);
        this.defaults.put(DISABLE_FILESHARING, "false");
        this.defaults.put(DISABLE_SPLASHSCREEN, "false");
        this.defaults.put(STORAGE_STORE_INVALID_MESSAGES, "false");
        this.defaults.put(STORAGE_STORE_SENT_MESSAGES, "true");
        this.defaults.put(ACCEPT_SIGNATURE_FORMAT_V1, "true");
        this.defaults.put(REMEMBER_SHAREDFILE_DOWNLOADED, "true");
        this.defaults.put(FCP2_USE_DDA, "true");
        this.defaults.put(FCP2_USE_PERSISTENCE, "true");
        this.defaults.put(FCP2_USE_ONE_CONNECTION_FOR_MESSAGES, "true");
        this.defaults.put(FCP2_DEFAULT_PRIO_MESSAGE_UPLOAD, "2");
        this.defaults.put(FCP2_DEFAULT_PRIO_MESSAGE_DOWNLOAD, "2");
        this.defaults.put(FCP2_DEFAULT_PRIO_FILE_UPLOAD, "3");
        this.defaults.put(FCP2_DEFAULT_PRIO_FILE_DOWNLOAD, "3");
        this.defaults.put(FCP2_SET_TARGETFILENAME_FOR_MANUAL_PUT, "true");
        this.defaults.put(FCP2_QUICKLY_FAIL_ON_ADNF, "false");
        this.defaults.put(ALTERNATE_EDITOR_COMMAND, fn + "path" + this.fs + "to" + this.fs + "editor" + " %f");
        this.defaults.put(BOARD_AUTOUPDATE_ENABLED, "true");
        this.defaults.put(BOARD_AUTOUPDATE_CONCURRENT_UPDATES, "6");
        this.defaults.put(BOARD_AUTOUPDATE_MIN_INTERVAL, "45");
        this.defaults.put("boardUpdateVisualization", "true");
        this.defaults.put(BOARD_UPDATE_VISUALIZATION_BGCOLOR_NOT_SELECTED, new Color(233, 233, 233));
        this.defaults.put(BOARD_UPDATE_VISUALIZATION_BGCOLOR_SELECTED, new Color(137, 137, 191));
        this.defaults.put(MESSAGE_BLOCK_SUBJECT, "");
        this.defaults.put(MESSAGE_BLOCK_SUBJECT_ENABLED, "false");
        this.defaults.put(MESSAGE_BLOCK_BODY, "");
        this.defaults.put(MESSAGE_BLOCK_BODY_ENABLED, "false");
        this.defaults.put(MESSAGE_BLOCK_BOARDNAME, "");
        this.defaults.put(MESSAGE_BLOCK_BOARDNAME_ENABLED, "false");
        this.defaults.put(MESSAGE_HIDE_UNSIGNED, "false");
        this.defaults.put(MESSAGE_HIDE_BAD, "false");
        this.defaults.put(MESSAGE_HIDE_CHECK, "false");
        this.defaults.put(MESSAGE_HIDE_OBSERVE, "false");
        this.defaults.put(JUNK_HIDE_JUNK_MESSAGES, "false");
        this.defaults.put(KNOWNBOARDS_BLOCK_FROM_UNSIGNED, "false");
        this.defaults.put(KNOWNBOARDS_BLOCK_FROM_BAD, "true");
        this.defaults.put(KNOWNBOARDS_BLOCK_FROM_CHECK, "false");
        this.defaults.put(KNOWNBOARDS_BLOCK_FROM_OBSERVE, "false");
        this.defaults.put(DOWNLOAD_MAX_THREADS, "3");
        this.defaults.put(DOWNLOADING_ACTIVATED, "true");
        this.defaults.put(DOWNLOAD_MAX_RETRIES, "25");
        this.defaults.put(DOWNLOAD_WAITTIME, "5");
        this.defaults.put(DOWNLOAD_DECODE_AFTER_EACH_SEGMENT, "true");
        this.defaults.put(DOWNLOAD_TRY_ALL_SEGMENTS, "true");
        this.defaults.put(UPLOAD_FILE_HTL, "21");
        this.defaults.put(MAX_MESSAGE_DISPLAY, "15");
        this.defaults.put(MAX_MESSAGE_DOWNLOAD, "5");
        this.defaults.put(ALWAYS_DOWNLOAD_MESSAGES_BACKLOAD, "false");
        this.defaults.put(MIN_DAYS_BEFORE_FILE_RESHARE, "5");
        this.defaults.put(MAX_FILELIST_DOWNLOAD_DAYS, "5");
        this.defaults.put(MESSAGE_BASE, "news");
        this.defaults.put(FILE_BASE, "files");
        this.defaults.put(SHOW_SYSTRAY_ICON, "true");
        this.defaults.put(MINIMIZE_TO_SYSTRAY, "false");
        this.defaults.put(DOWNLOAD_REMOVE_FINISHED, "false");
        this.defaults.put(UPLOAD_REMOVE_FINISHED, "false");
        this.defaults.put(SEARCH_MAX_RESULTS, "10000");
        this.defaults.put(SEARCH_HIDE_BAD, "true");
        this.defaults.put(SEARCH_HIDE_CHECK, "false");
        this.defaults.put(SEARCH_HIDE_OBSERVE, "false");
        this.defaults.put(SEARCH_HIDE_FILES_WITHOUT_CHK, "false");
        this.defaults.put(DOWNLOAD_MAX_SPLITFILE_THREADS, "30");
        this.defaults.put(UPLOAD_MAX_SPLITFILE_THREADS, "15");
        this.defaults.put(UPLOAD_REMOVE_CHUNKS, "true");
        this.defaults.put(GQ_SHOW_EXTERNAL_ITEMS_DOWNLOAD, "false");
        this.defaults.put(GQ_SHOW_EXTERNAL_ITEMS_UPLOAD, "false");
        this.defaults.put(MESSAGE_DOWNLOAD_HTL, "23");
        this.defaults.put(BOARDLIST_LAST_SELECTED_BOARD, "0");
        this.defaults.put(MESSAGE_UPLOAD_HTL, "21");
        this.defaults.put(UPLOAD_MAX_THREADS, "3");
        this.defaults.put(ALTERNATE_EDITOR_ENABLED, "false");
        this.defaults.put(LAST_USED_FROMNAME, "Anonymous");
        this.defaults.put(FILEEXTENSION_AUDIO, ".mp3;.ogg;.wav;.mid;.mod;.flac;.sid");
        this.defaults.put(FILEEXTENSION_VIDEO, ".mpeg;.mpg;.avi;.divx;.asf;.wmv;.rm;.ogm;.mov");
        this.defaults.put(FILEEXTENSION_DOCUMENT, ".doc;.txt;.tex;.pdf;.dvi;.ps;.odt;.sxw;.sdw;.rtf;.pdb;.psw");
        this.defaults.put(FILEEXTENSION_EXECUTABLE, ".exe;.vbs;.jar;.sh;.bat;.bin");
        this.defaults.put(FILEEXTENSION_ARCHIVE, ".zip;.rar;.jar;.gz;.arj;.ace;.bz;.tar;.tgz;.tbz");
        this.defaults.put(FILEEXTENSION_IMAGE, ".jpeg;.jpg;.jfif;.gif;.png;.tif;.tiff;.bmp;.xpm");
        this.defaults.put(AUTO_SAVE_INTERVAL, "60");
        this.defaults.put(AUTO_SAVE_LOCAL_IDENTITIES, "true");
        this.defaults.put(MESSAGE_UPLOAD_DISABLED, "false");
        this.defaults.put(MESSAGE_EXPIRE_DAYS, "90");
        this.defaults.put(MESSAGE_EXPIRATION_MODE, "KEEP");
        this.defaults.put(ARCHIVE_KEEP_FLAGGED_AND_STARRED, "true");
        this.defaults.put(ARCHIVE_KEEP_UNREAD, "false");
        this.defaults.put(LANGUAGE_LOCALE, "default");
        this.defaults.put(MAINFRAME_LAST_WIDTH, "700");
        this.defaults.put(MAINFRAME_LAST_HEIGHT, "500");
        this.defaults.put(MAINFRAME_LAST_X, "50");
        this.defaults.put(MAINFRAME_LAST_Y, "50");
        this.defaults.put(MAINFRAME_LAST_MAXIMIZED, "false");
        this.defaults.put(MESSAGE_BODY_FONT_NAME, "Monospaced");
        this.defaults.put(MESSAGE_BODY_FONT_STYLE, new Integer(0).toString());
        this.defaults.put(MESSAGE_BODY_FONT_SIZE, "12");
        this.defaults.put(MESSAGE_LIST_FONT_NAME, "SansSerif");
        this.defaults.put(MESSAGE_LIST_FONT_STYLE, new Integer(0).toString());
        this.defaults.put(MESSAGE_LIST_FONT_SIZE, "11");
        this.defaults.put(FILE_LIST_FONT_NAME, "SansSerif");
        this.defaults.put(FILE_LIST_FONT_STYLE, new Integer(0).toString());
        this.defaults.put(FILE_LIST_FONT_SIZE, "11");
        this.defaults.put(MESSAGE_BODY_ANTIALIAS, "false");
        this.defaults.put(MSGTABLE_MULTILINE_SELECT, "false");
        this.defaults.put(MSGTABLE_SCROLL_HORIZONTAL, "false");
        this.defaults.put(MSGTABLE_SHOW_COLLAPSED_THREADS, "false");
        this.defaults.put(SAVE_SORT_STATES, "false");
        this.defaults.put(SHOW_BOARDDESC_TOOLTIPS, "true");
        this.defaults.put(PREVENT_BOARDTREE_REORDERING, "false");
        this.defaults.put(SHOW_BOARDTREE_FLAGGEDSTARRED_INDICATOR, "true");
        this.defaults.put(LOG_TO_CONSOLE, "false");
        this.defaults.put(LOG_TO_FILE, "true");
        this.defaults.put(LOG_LEVEL, "Options.miscellaneous.logLevel.low");
        this.defaults.put(LOG_FILE_SIZE_LIMIT, "1000");
        this.defaults.put(LOG_FCP2_MESSAGES, "false");
        this.defaults.put(LOG_FILEBASE_MESSAGES, "false");
        this.defaults.put(SILENTLY_RETRY_MESSAGES, "false");
        this.defaults.put(SHOW_DELETED_MESSAGES, "false");
        this.defaults.put(UPLOAD_MAX_RETRIES, "5");
        this.defaults.put(UPLOAD_WAITTIME, "5");
        this.defaults.put(SHOW_THREADS, "true");
        this.defaults.put(HANDLE_OWN_MESSAGES_AS_NEW_DISABLED, "false");
        this.defaults.put(SHOW_OWN_MESSAGES_AS_ME_DISABLED, "false");
        this.defaults.put(SORT_THREADROOTMSGS_ASCENDING, "false");
        this.defaults.put(INDICATE_LOW_RECEIVED_MESSAGES, "true");
        this.defaults.put(INDICATE_LOW_RECEIVED_MESSAGES_COUNT_RED, "1");
        this.defaults.put(INDICATE_LOW_RECEIVED_MESSAGES_COUNT_LIGHTRED, "5");
        this.defaults.put(SHOW_COLORED_ROWS, "true");
        this.defaults.put(SHOW_SMILEYS, "true");
        this.defaults.put(SHOW_KEYS_AS_HYPERLINKS, "true");
        this.defaults.put(LOG_DOWNLOADS_ENABLED, "false");
        this.defaults.put(LOG_UPLOADS_ENABLED, "false");
        this.defaults.put(CONFIRM_MARK_ALL_MSGS_READ, "true");
        this.defaults.put(PERST_PAGEPOOLSIZE_FILES, "512");
        this.defaults.put(PERST_PAGEPOOLSIZE_INDEXSLOTS, "512");
        this.defaults.put(PERST_PAGEPOOLSIZE_SHAREDFILESCHKKEYS, "1024");
        this.defaults.put(PERST_PAGEPOOLSIZE_FILELIST, "1024");
        this.defaults.put(PERST_PAGEPOOLSIZE_IDENTITIES, "1024");
        this.defaults.put(PERST_PAGEPOOLSIZE_MESSAGEARCHIVE, "1024");
        this.defaults.put(PERST_PAGEPOOLSIZE_MESSAGES, "6144");
        this.defaults.put(PERST_PAGEPOOLSIZE_MESSAGECONTENTS, "1024");
        this.defaults.put(PERST_COMPACT_STORAGES, "false");
        this.settingsHash.putAll(this.defaults);
    }

    public void exitSave() throws StorageException {
        if (this.updaters != null) {
            Enumeration<SettingsUpdater> enumeration = this.updaters.elements();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement().updateSettings();
            }
        }
        if (!this.writeSettingsFile()) {
            throw new StorageException("Error while saving the settings.");
        }
    }
}

