/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public class MultiResGraphicsNode
extends AbstractGraphicsNode
implements SVGConstants {
    SoftReference[] srcs;
    Element[] srcElems;
    Dimension[] minSz;
    Dimension[] maxSz;
    Rectangle2D bounds;
    BridgeContext ctx;
    Element multiImgElem;

    public MultiResGraphicsNode(Element element, Rectangle2D rectangle2D, Element[] elementArray, Dimension[] dimensionArray, Dimension[] dimensionArray2, BridgeContext bridgeContext) {
        this.multiImgElem = element;
        this.srcElems = new Element[elementArray.length];
        this.minSz = new Dimension[elementArray.length];
        this.maxSz = new Dimension[elementArray.length];
        this.ctx = bridgeContext;
        int n = 0;
        while (n < elementArray.length) {
            this.srcElems[n] = elementArray[n];
            this.minSz[n] = dimensionArray[n];
            this.maxSz[n] = dimensionArray2[n];
            ++n;
        }
        this.srcs = new SoftReference[elementArray.length];
        this.bounds = rectangle2D;
    }

    public void primitivePaint(Graphics2D graphics2D) {
        double d;
        double d2;
        double d3;
        double d4;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d5 = Math.sqrt(affineTransform.getShearY() * affineTransform.getShearY() + affineTransform.getScaleX() * affineTransform.getScaleX());
        double d6 = Math.sqrt(affineTransform.getShearX() * affineTransform.getShearX() + affineTransform.getScaleY() * affineTransform.getScaleY());
        GraphicsNode graphicsNode = null;
        int n = -1;
        double d7 = this.bounds.getWidth() * d5;
        double d8 = this.calcDist(d7, this.minSz[0], this.maxSz[0]);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.minSz.length) {
            double d9 = this.calcDist(d7, this.minSz[n3], this.maxSz[n3]);
            if (d9 < d8) {
                d8 = d9;
                n2 = n3;
            }
            if (!(this.minSz[n3] != null && !(d7 >= (double)this.minSz[n3].width) || this.maxSz[n3] != null && !(d7 <= (double)this.maxSz[n3].width) || n != -1 && n2 != n3)) {
                n = n3;
            }
            ++n3;
        }
        if (n == -1) {
            n = n2;
        }
        if ((graphicsNode = this.getGraphicsNode(n)) == null) {
            return;
        }
        Rectangle2D rectangle2D = graphicsNode.getBounds();
        double d10 = rectangle2D.getWidth() * d5;
        double d11 = rectangle2D.getHeight() * d6;
        double d12 = rectangle2D.getX() * d5;
        double d13 = rectangle2D.getY() * d6;
        if (d10 < 0.0) {
            d4 = d12 + d10;
            d3 = d12;
        } else {
            d4 = d12;
            d3 = d12 + d10;
        }
        if (d11 < 0.0) {
            d2 = d13 + d11;
            d = d13;
        } else {
            d2 = d13;
            d = d13 + d11;
        }
        d10 = (int)(Math.ceil(d3) - Math.floor(d4));
        d11 = (int)(Math.ceil(d) - Math.floor(d2));
        d5 = d10 / rectangle2D.getWidth() / d5;
        d6 = d11 / rectangle2D.getHeight() / d6;
        AffineTransform affineTransform2 = graphics2D.getTransform();
        affineTransform2 = new AffineTransform(affineTransform2.getScaleX() * d5, affineTransform2.getShearY() * d5, affineTransform2.getShearX() * d6, affineTransform2.getScaleY() * d6, affineTransform2.getTranslateX(), affineTransform2.getTranslateY());
        graphics2D.setTransform(affineTransform2);
        graphicsNode.paint(graphics2D);
    }

    public double calcDist(double d, Dimension dimension, Dimension dimension2) {
        if (dimension == null) {
            if (dimension2 == null) {
                return 1.0E11;
            }
            return Math.abs(d - (double)dimension2.width);
        }
        if (dimension2 == null) {
            return Math.abs(d - (double)dimension.width);
        }
        double d2 = (double)(dimension2.width + dimension.width) / 2.0;
        return Math.abs(d - d2);
    }

    public Rectangle2D getPrimitiveBounds() {
        return this.bounds;
    }

    public Rectangle2D getGeometryBounds() {
        return this.bounds;
    }

    public Rectangle2D getSensitiveBounds() {
        return this.bounds;
    }

    public Shape getOutline() {
        return this.bounds;
    }

    public GraphicsNode getGraphicsNode(int n) {
        Object object;
        if (this.srcs[n] != null && (object = this.srcs[n].get()) != null) {
            return (GraphicsNode)object;
        }
        try {
            object = this.ctx.getGVTBuilder();
            GraphicsNode graphicsNode = object.build(this.ctx, this.srcElems[n]);
            this.srcs[n] = new SoftReference<GraphicsNode>(graphicsNode);
            return graphicsNode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

