/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class NodeMotionListenerView
extends Component {
    private NodeView movedView;
    private boolean isMouseEntered;

    public NodeMotionListenerView(NodeView view) {
        this.movedView = view;
        MapView map = view.getMap();
        this.addMouseListener(map.getNodeMotionListener());
        this.addMouseMotionListener(map.getNodeMotionListener());
    }

    public NodeView getMovedView() {
        return this.movedView;
    }

    protected void setRendering(Graphics2D g) {
        if (this.movedView.getMap().getController().getAntialiasEdges() || this.movedView.getMap().getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isMouseEntered) {
            Graphics2D g2 = (Graphics2D)g;
            this.setRendering(g2);
            g.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            this.setCursor(new Cursor(13));
        }
    }

    public boolean isMouseEntered() {
        return this.isMouseEntered;
    }

    public void setMouseEntered() {
        this.isMouseEntered = true;
        this.repaint();
    }

    public void setMouseExited() {
        this.isMouseEntered = false;
        this.repaint();
    }
}

