/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.NodeView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class EditNodeDialog
extends EditNodeBase {
    private KeyEvent firstEvent;
    private static Tools.BooleanHolder booleanHolderForConfirmState;

    public EditNodeDialog(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl) {
        super(node, text, controller, editControl);
        this.firstEvent = firstEvent;
    }

    public void show() {
        final JDialog dialog = new JDialog((JFrame)((Object)this.getFrame()), this.getText("edit_long_node"), true);
        final JTextArea textArea = new JTextArea(this.getText());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        if (this.firstEvent != null) {
            switch (this.firstEvent.getKeyCode()) {
                case 36: {
                    textArea.setCaretPosition(0);
                    break;
                }
                default: {
                    textArea.setCaretPosition(this.getText().length());
                    break;
                }
            }
        } else {
            textArea.setCaretPosition(this.getText().length());
        }
        JScrollPane editorScrollPane = new JScrollPane(textArea);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        int preferredHeight = this.getNode().getHeight();
        preferredHeight = Math.max(preferredHeight, Integer.parseInt(this.getFrame().getProperty("el__min_default_window_height")));
        preferredHeight = Math.min(preferredHeight, Integer.parseInt(this.getFrame().getProperty("el__max_default_window_height")));
        int preferredWidth = this.getNode().getWidth();
        preferredWidth = Math.max(preferredWidth, Integer.parseInt(this.getFrame().getProperty("el__min_default_window_width")));
        preferredWidth = Math.min(preferredWidth, Integer.parseInt(this.getFrame().getProperty("el__max_default_window_width")));
        editorScrollPane.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        JPanel panel = new JPanel();
        final Tools.IntHolder eventSource = new Tools.IntHolder();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton(this.getText("cancel"));
        JButton splitButton = new JButton(this.getText("split"));
        final JCheckBox enterConfirms = new JCheckBox(this.getText("enter_confirms"), this.binOptionIsTrue("el__enter_confirms_by_default"));
        if (booleanHolderForConfirmState == null) {
            booleanHolderForConfirmState = new Tools.BooleanHolder();
            booleanHolderForConfirmState.setValue(enterConfirms.isSelected());
        } else {
            enterConfirms.setSelected(booleanHolderForConfirmState.getValue());
        }
        okButton.setMnemonic(79);
        enterConfirms.setMnemonic(69);
        splitButton.setMnemonic(83);
        cancelButton.setMnemonic(67);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                eventSource.setValue(0);
                dialog.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                eventSource.setValue(1);
                dialog.dispose();
            }
        });
        splitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                eventSource.setValue(2);
                dialog.dispose();
            }
        });
        enterConfirms.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                textArea.requestFocus();
                booleanHolderForConfirmState.setValue(enterConfirms.isSelected());
            }
        });
        textArea.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    eventSource.setValue(1);
                    dialog.dispose();
                } else if (e.getKeyCode() == 10) {
                    if (enterConfirms.isSelected() == ((e.getModifiers() & 2) == 0)) {
                        e.consume();
                        eventSource.setValue(0);
                        dialog.dispose();
                    } else if (enterConfirms.isSelected() && (e.getModifiers() & 2) != 0) {
                        e.consume();
                        textArea.insert("\n", textArea.getCaretPosition());
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        textArea.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            private void conditionallyShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    EditNodeBase.EditPopupMenu popupMenu = new EditNodeBase.EditPopupMenu(textArea);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }
        });
        textArea.setFont(this.getNode().getFont());
        textArea.setForeground(this.getNode().getForeground());
        JPanel buttonPane = new JPanel();
        buttonPane.add(enterConfirms);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        buttonPane.add(splitButton);
        buttonPane.setMaximumSize(new Dimension(1000, 20));
        if (this.getFrame().getProperty("el__buttons_position").equals("above")) {
            panel.add(buttonPane);
            panel.add(editorScrollPane);
        } else {
            panel.add(editorScrollPane);
            panel.add(buttonPane);
        }
        panel.setLayout(new BoxLayout(panel, 1));
        dialog.setDefaultCloseOperation(2);
        dialog.setContentPane(panel);
        dialog.pack();
        this.getView().scrollNodeToVisible(this.getNode(), 0);
        Point frameScreenLocation = this.getFrame().getLayeredPane().getLocationOnScreen();
        double posX = this.getNode().getLocationOnScreen().getX() - frameScreenLocation.getX();
        double posY = this.getNode().getLocationOnScreen().getY() - frameScreenLocation.getY() + (double)(this.binOptionIsTrue("el__position_window_below_node") ? this.getNode().getHeight() : 0);
        if (posX + (double)dialog.getWidth() > (double)this.getFrame().getLayeredPane().getWidth()) {
            posX = this.getFrame().getLayeredPane().getWidth() - dialog.getWidth();
        }
        if (posY + (double)dialog.getHeight() > (double)this.getFrame().getLayeredPane().getHeight()) {
            posY = this.getFrame().getLayeredPane().getHeight() - dialog.getHeight();
        }
        posX = (posX < 0.0 ? 0.0 : posX) + frameScreenLocation.getX();
        posY = (posY < 0.0 ? 0.0 : posY) + frameScreenLocation.getY();
        dialog.setLocation(new Double(posX).intValue(), new Double(posY).intValue());
        textArea.requestFocusInWindow();
        dialog.show();
        if (eventSource.getValue() == 0) {
            this.getEditControl().ok(textArea.getText());
        }
        if (eventSource.getValue() == 2) {
            this.getEditControl().split(textArea.getText(), textArea.getCaretPosition());
        }
        if (eventSource.getValue() == 1) {
            this.getEditControl().cancel();
        }
    }

    protected KeyEvent getFirstEvent() {
        return this.firstEvent;
    }
}

