/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.controller.StructuredMenuHolder;
import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.actions.GotoLinkNodeAction;
import freemind.modes.browsemode.BrowseArrowLinkModel;
import freemind.modes.browsemode.BrowseMapModel;
import freemind.modes.browsemode.BrowseNodeModel;
import freemind.modes.browsemode.BrowsePopupMenu;
import freemind.modes.browsemode.BrowseToolBar;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class BrowseController
extends ControllerAdapter {
    private JPopupMenu popupmenu;
    private JToolBar toolbar;
    Action followLink = new FollowLinkAction();
    Action nodeUp;
    Action nodeDown;

    public void edit(KeyEvent e, boolean addNew, boolean editLong) {
    }

    public MindMapNode addNew(MindMapNode target, int newNodeMode, KeyEvent e) {
        return null;
    }

    public BrowseController(Mode mode) {
        super(mode);
        this.popupmenu = new BrowsePopupMenu(this);
        this.toolbar = new BrowseToolBar(this);
        this.setAllActions(false);
    }

    public MapAdapter newModel() {
        return new BrowseMapModel(this.getFrame());
    }

    public void doubleClick() {
        if (this.getSelected().getLink() == null) {
            this.toggleFolded.toggleFolded();
        } else {
            this.loadURL();
        }
    }

    public MindMapNode newNode(Object userObject) {
        return new BrowseNodeModel(userObject, this.getFrame());
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public JPopupMenu getPopupForModel(Object obj) {
        if (obj instanceof BrowseArrowLinkModel) {
            BrowseArrowLinkModel link = (BrowseArrowLinkModel)obj;
            JPopupMenu arrowLinkPopup = new JPopupMenu();
            arrowLinkPopup.add(this.getGotoLinkNodeAction(link.getSource()));
            arrowLinkPopup.add(this.getGotoLinkNodeAction(link.getTarget()));
            arrowLinkPopup.addSeparator();
            HashSet<MindMapNode> NodeAlreadyVisited = new HashSet<MindMapNode>();
            NodeAlreadyVisited.add(link.getSource());
            NodeAlreadyVisited.add(link.getTarget());
            Vector links = this.getModel().getLinkRegistry().getAllLinks(link.getSource());
            links.addAll(this.getModel().getLinkRegistry().getAllLinks(link.getTarget()));
            for (int i = 0; i < links.size(); ++i) {
                BrowseArrowLinkModel foreign_link = (BrowseArrowLinkModel)links.get(i);
                if (NodeAlreadyVisited.add(foreign_link.getTarget())) {
                    arrowLinkPopup.add(this.getGotoLinkNodeAction(foreign_link.getTarget()));
                }
                if (!NodeAlreadyVisited.add(foreign_link.getSource())) continue;
                arrowLinkPopup.add(this.getGotoLinkNodeAction(foreign_link.getSource()));
            }
            return arrowLinkPopup;
        }
        return null;
    }

    private GotoLinkNodeAction getGotoLinkNodeAction(MindMapNode destination) {
        return new GotoLinkNodeAction(this, destination);
    }

    BrowseToolBar getToolBar() {
        return (BrowseToolBar)this.toolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadURL(String relative) {
        URL absolute = null;
        try {
            BrowseMapModel map = (BrowseMapModel)this.getMap();
            absolute = map != null ? new URL(map.getURL(), relative) : new URL(relative);
            this.getFrame().out(absolute.toString());
        }
        catch (MalformedURLException ex) {
            this.getController().errorMessage(this.getText("url_error") + " " + ex.getMessage());
            return;
        }
        String type = Tools.getExtension(absolute.getFile());
        try {
            if (type.equals("mm")) {
                this.getFrame().setWaitingCursor(true);
                this.load(absolute);
            } else {
                this.getFrame().openDocument(absolute);
            }
        }
        catch (Exception ex) {
            this.getController().errorMessage(this.getText("url_load_error") + absolute);
            ex.printStackTrace();
        }
        finally {
            this.getFrame().setWaitingCursor(false);
        }
    }

    public void loadURL() {
        String link = this.getSelected().getLink();
        if (link != null) {
            this.loadURL(link);
        }
    }

    private void load(URL url) throws Exception {
        this.getToolBar().setURLField(url.toString());
        BrowseMapModel model = (BrowseMapModel)this.newModel();
        model.load(url);
        this.newMap(model);
    }

    protected void setAllActions(boolean enabled) {
        super.setAllActions(enabled);
        this.toggleFolded.setEnabled(enabled);
        this.toggleChildrenFolded.setEnabled(enabled);
        this.followLink.setEnabled(enabled);
    }

    public void updateMenus(StructuredMenuHolder holder) {
        this.add(holder, "menu_bar/edit//find/find", this.find, "keystroke_find");
        this.add(holder, "menu_bar/edit//find/findNext", this.findNext, "keystroke_find_next");
        this.add(holder, "menu_bar/edit//find/followLink", this.followLink, "keystroke_follow_link");
        holder.addSeparator("menu_bar/edit//find");
        this.add(holder, "menu_bar/edit//find/toggleFolded", this.toggleFolded, "keystroke_toggle_folded");
        this.add(holder, "menu_bar/edit//find/toggleChildrenFolded", this.toggleChildrenFolded, "keystroke_toggle_children_folded");
    }

    private class FollowLinkAction
    extends AbstractAction {
        FollowLinkAction() {
            super(BrowseController.this.getText("follow_link"));
        }

        public void actionPerformed(ActionEvent e) {
            BrowseController.this.loadURL();
        }
    }
}

