/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.AbstractXmlAction;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.CompoundActionType;
import freemind.controller.actions.generated.instance.UndoXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.ControllerAdapter;
import freemind.modes.ModeController;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBException;

public class UndoAction
extends AbstractXmlAction
implements ActorXml {
    private ControllerAdapter controller;
    private boolean isUndoAction;
    protected Vector actionPairList = new Vector();
    private long timeOfLastAdd = 0L;
    private static final long TIME_TO_BEGIN_NEW_ACTION = 100L;
    protected static Logger logger;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$UndoXmlAction;

    public UndoAction(ControllerAdapter controller) {
        this(controller, controller.getText("undo"), new ImageIcon(controller.getResource("images/undo.png")), controller);
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().toString());
        }
    }

    protected UndoAction(ControllerAdapter adapter, String text, Icon icon, ModeController mode) {
        super(text, icon, mode);
        this.controller = adapter;
        this.addActor(this);
        this.setEnabled(false);
        this.isUndoAction = false;
    }

    public boolean isUndoAction() {
        return this.isUndoAction;
    }

    protected void xmlActionPerformed(ActionEvent arg0) throws JAXBException {
        if (this.actionPairList.size() > 0) {
            ActionPair pair = (ActionPair)this.actionPairList.get(0);
            this.informUndoPartner(pair);
            this.actionPairList.remove(0);
            this.undoDoAction(pair);
            if (this.actionPairList.size() == 0) {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(false);
        }
    }

    protected void informUndoPartner(ActionPair pair) {
        this.controller.redo.add(pair.reverse());
        this.controller.redo.setEnabled(true);
    }

    protected void undoDoAction(ActionPair pair) throws JAXBException {
        String doActionString = this.controller.marshall(pair.getDoAction());
        String redoActionString = this.controller.marshall(pair.getUndoAction());
        UndoXmlAction undoAction = this.controller.getActionXmlFactory().createUndoXmlAction();
        undoAction.setDescription(redoActionString);
        undoAction.setRemedia(doActionString);
        UndoXmlAction redoAction = this.controller.getActionXmlFactory().createUndoXmlAction();
        redoAction.setDescription(doActionString);
        undoAction.setRemedia(redoActionString);
        this.isUndoAction = true;
        this.controller.getActionFactory().executeAction(new ActionPair(undoAction, redoAction));
        this.isUndoAction = false;
    }

    public void act(XmlAction action) {
        UndoXmlAction undoAction = (UndoXmlAction)action;
        XmlAction doAction = this.controller.unMarshall(undoAction.getDescription());
        XmlAction redoAction = this.controller.unMarshall(undoAction.getRemedia());
        this.controller.getActionFactory().executeAction(new ActionPair(doAction, redoAction));
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$UndoXmlAction == null ? (class$freemind$controller$actions$generated$instance$UndoXmlAction = UndoAction.class$("freemind.controller.actions.generated.instance.UndoXmlAction")) : class$freemind$controller$actions$generated$instance$UndoXmlAction;
    }

    public void setEnabled(boolean arg0) {
        if (arg0) {
            super.setEnabled(this.actionPairList.size() != 0);
        } else {
            super.setEnabled(false);
        }
    }

    public void add(ActionPair pair) {
        try {
            long currentTime = System.currentTimeMillis();
            if (this.actionPairList.size() > 0 && currentTime - this.timeOfLastAdd < 100L) {
                CompoundAction remedia;
                CompoundAction action;
                ActionPair firstPair = (ActionPair)this.actionPairList.get(0);
                if (!(firstPair.getDoAction() instanceof CompoundActionType) || !(firstPair.getUndoAction() instanceof CompoundActionType)) {
                    action = this.controller.getActionXmlFactory().createCompoundAction();
                    action.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(firstPair.getDoAction());
                    remedia = this.controller.getActionXmlFactory().createCompoundAction();
                    remedia.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(firstPair.getUndoAction());
                    this.actionPairList.remove(0);
                    this.actionPairList.add(0, new ActionPair(action, remedia));
                    firstPair = (ActionPair)this.actionPairList.get(0);
                } else {
                    action = (CompoundAction)firstPair.getDoAction();
                    remedia = (CompoundAction)firstPair.getUndoAction();
                }
                action.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(pair.getDoAction());
                remedia.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(0, pair.getUndoAction());
            } else {
                this.actionPairList.add(0, pair);
                int maxEntries = 100;
                try {
                    maxEntries = new Integer(this.controller.getFrame().getProperty("undo_levels"));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                while (this.actionPairList.size() > maxEntries) {
                    this.actionPairList.remove(this.actionPairList.size() - 1);
                }
            }
            this.timeOfLastAdd = currentTime;
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.actionPairList.clear();
    }

    public void print() {
        logger.info("Undo list:");
        int j = 0;
        Iterator i = this.actionPairList.iterator();
        while (i.hasNext()) {
            ActionPair pair = (ActionPair)i.next();
            logger.info("line " + j++ + " = " + this.controller.marshall(pair.getDoAction()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

