/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.MoveNodesAction;
import freemind.controller.actions.generated.instance.NodeListMember;
import freemind.controller.actions.generated.instance.NodeListMemberType;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.xml.bind.JAXBException;

public class NodeUpAction
extends AbstractAction
implements ActorXml {
    private final ControllerAdapter modeController;
    private static Logger logger;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$MoveNodesAction;

    public NodeUpAction(ControllerAdapter modeController) {
        super(modeController.getText("node_up"));
        this.modeController = modeController;
        modeController.getActionFactory().registerActor(this, this.getDoActionClass());
        if (logger == null) {
            logger = modeController.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.moveNodes(this.modeController.getSelected(), this.modeController.getSelecteds(), -1);
    }

    public void moveNodes(MindMapNode selected, List selecteds, int direction) {
        MoveNodesAction doAction = this.createMoveNodesAction(selected, selecteds, direction);
        MoveNodesAction undoAction = this.createMoveNodesAction(selected, selecteds, -direction);
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    public void _moveNodes(MindMapNode selected, List selecteds, int direction) {
        Comparator comparator;
        Comparator comparator2 = comparator = direction == -1 ? null : new Comparator(){

            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                return i2 - i1;
            }
        };
        if (!selected.isRoot()) {
            MindMapNode node;
            Integer position;
            MindMapNode parent = selected.getParentNode();
            Vector sortedChildren = this.getSortedSiblings(parent);
            TreeSet<Integer> range = new TreeSet<Integer>(comparator);
            Iterator i = selecteds.iterator();
            while (i.hasNext()) {
                MindMapNode node2 = (MindMapNode)i.next();
                if (node2.getParent() != parent) {
                    logger.warning("Not all selected nodes have the same parent.");
                    return;
                }
                range.add(new Integer(sortedChildren.indexOf(node2)));
            }
            Integer last = (Integer)range.iterator().next();
            Iterator i2 = range.iterator();
            while (i2.hasNext()) {
                Integer newInt = (Integer)i2.next();
                if (Math.abs(newInt - last) > 1) {
                    logger.warning("Not adjacent nodes. Skipped. ");
                    return;
                }
                last = newInt;
            }
            i2 = range.iterator();
            while (i2.hasNext()) {
                position = (Integer)i2.next();
                node = (MindMapNode)sortedChildren.get(position);
                this.moveNodeTo(node, parent, direction);
            }
            this.modeController.getView().selectAsTheOnlyOneSelected(selected.getViewer());
            this.modeController.getView().scrollNodeToVisible(selected.getViewer());
            i2 = range.iterator();
            while (i2.hasNext()) {
                position = (Integer)i2.next();
                node = (MindMapNode)sortedChildren.get(position);
                this.modeController.getView().makeTheSelected(node.getViewer());
            }
            this.modeController.getController().obtainFocusForSelected();
        }
    }

    public int moveNodeTo(MindMapNode newChild, MindMapNode parent, int direction) {
        int index;
        MapAdapter model = this.modeController.getModel();
        int newIndex = index = model.getIndexOfChild(parent, newChild);
        if (newChild.isLeft() != null) {
            int maxIndex = parent.getChildCount();
            Vector sortedNodesIndices = this.getSortedSiblings(parent);
            int newPositionInVector = sortedNodesIndices.indexOf(newChild) + direction;
            if (newPositionInVector < 0) {
                newPositionInVector = maxIndex - 1;
            }
            if (newPositionInVector >= maxIndex) {
                newPositionInVector = 0;
            }
            MindMapNode destinationNode = (MindMapNode)sortedNodesIndices.get(newPositionInVector);
            newIndex = model.getIndexOfChild(parent, destinationNode);
            newChild.setLeft(destinationNode.isLeft().getValue());
            model.removeNodeFromParent(newChild);
            model.insertNodeInto(newChild, parent, newIndex);
            this.modeController.nodeStructureChanged(parent);
        }
        return newIndex;
    }

    private Vector getSortedSiblings(MindMapNode node) {
        Vector nodes = new Vector();
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            nodes.add(i.next());
        }
        Collections.sort(nodes, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof MindMapNode) {
                    MindMapNode n1 = (MindMapNode)o1;
                    if (o2 instanceof MindMapNode) {
                        MindMapNode n2 = (MindMapNode)o2;
                        if (n1.isLeft() != null && n2.isLeft() != null) {
                            int b1 = n1.isLeft().getValue() ? 0 : 1;
                            int b2 = n2.isLeft().getValue() ? 0 : 1;
                            return b1 - b2;
                        }
                    }
                }
                throw new IllegalArgumentException("Elements in LeftRightComparator are not comparable.");
            }
        });
        return nodes;
    }

    public void act(XmlAction action) {
        if (action instanceof MoveNodesAction) {
            MoveNodesAction moveAction = (MoveNodesAction)action;
            NodeAdapter selected = this.modeController.getNodeFromID(moveAction.getNode());
            Vector<NodeAdapter> selecteds = new Vector<NodeAdapter>();
            Iterator i = moveAction.getNodeListMember().iterator();
            while (i.hasNext()) {
                NodeListMemberType node = (NodeListMemberType)i.next();
                selecteds.add(this.modeController.getNodeFromID(node.getNode()));
            }
            this._moveNodes(selected, selecteds, moveAction.getDirection());
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$MoveNodesAction == null ? (class$freemind$controller$actions$generated$instance$MoveNodesAction = NodeUpAction.class$("freemind.controller.actions.generated.instance.MoveNodesAction")) : class$freemind$controller$actions$generated$instance$MoveNodesAction;
    }

    private MoveNodesAction createMoveNodesAction(MindMapNode selected, List selecteds, int direction) {
        try {
            MoveNodesAction moveAction = this.modeController.getActionXmlFactory().createMoveNodesAction();
            moveAction.setDirection(direction);
            moveAction.setNode(selected.getObjectId(this.modeController));
            Iterator i = selecteds.iterator();
            while (i.hasNext()) {
                MindMapNode node = (MindMapNode)i.next();
                NodeListMember nodeListMember = this.modeController.getActionXmlFactory().createNodeListMember();
                nodeListMember.setNode(node.getObjectId(this.modeController));
                moveAction.getNodeListMember().add(nodeListMember);
            }
            return moveAction;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

