/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.DeleteNodeAction;
import freemind.controller.actions.generated.instance.NewNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.PermanentNodeHook;
import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBException;

public class NewChildAction
extends AbstractAction
implements ActorXml {
    private final ControllerAdapter c;
    private static Logger logger = null;
    static /* synthetic */ Class class$freemind$modes$actions$NewChildAction;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$NewNodeAction;

    public NewChildAction(ControllerAdapter modeController) {
        super(modeController.getText("new_child"), new ImageIcon(modeController.getResource("images/idea.png")));
        this.c = modeController;
        this.c.getActionFactory().registerActor(this, this.getDoActionClass());
        if (logger == null) {
            logger = this.c.getFrame().getLogger((class$freemind$modes$actions$NewChildAction == null ? (class$freemind$modes$actions$NewChildAction = NewChildAction.class$("freemind.modes.actions.NewChildAction")) : class$freemind$modes$actions$NewChildAction).getName());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.c.addNew(this.c.getSelected(), 2, null);
    }

    public void act(XmlAction action) {
        NewNodeAction addNodeAction = (NewNodeAction)action;
        NodeAdapter parent = this.c.getNodeFromID(addNodeAction.getNode());
        int index = addNodeAction.getIndex();
        MindMapNode newNode = this.c.newNode("");
        String newId = addNodeAction.getNewId();
        MindMapLinkRegistry.ID_Registered reg = this.c.getModel().getLinkRegistry().registerLinkTarget(newNode, newId);
        if (!reg.getID().equals(newId)) {
            throw new IllegalArgumentException("Designated id '" + newId + "' was not given to the node. It received '" + reg.getID() + "'.");
        }
        if (addNodeAction.getPosition() != null) {
            newNode.setLeft(addNodeAction.getPosition().equals("left"));
        }
        this.c.getModel().insertNodeInto(newNode, parent, index);
        Iterator i = parent.getActivatedHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            hook.onNewChild(newNode);
        }
        this.c.getFrame().repaint();
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$NewNodeAction == null ? (class$freemind$controller$actions$generated$instance$NewNodeAction = NewChildAction.class$("freemind.controller.actions.generated.instance.NewNodeAction")) : class$freemind$controller$actions$generated$instance$NewNodeAction;
    }

    public MindMapNode addNew(MindMapNode target, int newNodeMode, KeyEvent e) {
        MindMapNode targetNode = target;
        MindMapNode newNode = null;
        boolean targetIsLeft = true;
        switch (newNodeMode) {
            case 3: 
            case 4: {
                if (targetNode.isRoot()) {
                    this.c.getController().errorMessage(this.c.getText("new_node_as_sibling_not_possible_for_the_root"));
                    this.c.setBlocked(false);
                    return null;
                }
                MindMapNode parent = targetNode.getParentNode();
                int childPosition = parent.getChildPosition(targetNode);
                if (newNodeMode == 3) {
                    ++childPosition;
                }
                newNode = this.addNewNode(parent, childPosition, target.isLeft());
                this.c.select(newNode.getViewer());
                this.c.edit.editLater(newNode.getViewer(), target.getViewer(), e, true, false, false);
                break;
            }
            case 1: 
            case 2: {
                boolean parentFolded = targetNode.isFolded();
                if (parentFolded) {
                    this.c.setFolded(targetNode, false);
                }
                int position = this.c.getFrame().getProperty("placenewbranches").equals("last") ? targetNode.getChildCount() : 0;
                newNode = this.addNewNode(targetNode, position, null);
                if (newNodeMode == 2) {
                    this.c.select(newNode.getViewer());
                }
                this.c.edit.editLater(newNode.getViewer(), target.getViewer(), e, true, parentFolded, false);
            }
        }
        return newNode;
    }

    public MindMapNode addNewNode(MindMapNode parent, int index, Tools.BooleanHolder newNodeIsLeft) {
        try {
            this.c.getModel().getLinkRegistry().registerLinkTarget(parent);
            String newId = this.c.getModel().getLinkRegistry().generateUniqueID("_");
            this.c.getActionFactory().startTransaction(this.c.getText("new_child"));
            NewNodeAction newNodeAction = this.getAddNodeAction(parent, index, newId, newNodeIsLeft);
            DeleteNodeAction deleteAction = this.c.deleteChild.getDeleteNodeAction(newId);
            this.c.getActionFactory().executeAction(new ActionPair(newNodeAction, deleteAction));
            this.c.getActionFactory().endTransaction(this.c.getText("new_child"));
            return (MindMapNode)parent.getChildAt(index);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NewNodeAction getAddNodeAction(MindMapNode parent, int index, String newId, Tools.BooleanHolder newNodeIsLeft) throws JAXBException {
        String pos = null;
        if (newNodeIsLeft != null) {
            pos = newNodeIsLeft.getValue() ? "left" : "right";
        }
        NewNodeAction newNodeAction = this.c.getActionXmlFactory().createNewNodeAction();
        newNodeAction.setNode(this.c.getNodeID(parent));
        newNodeAction.setPosition(pos);
        newNodeAction.setIndex(index);
        newNodeAction.setNewId(newId);
        return newNodeAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

