/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.EditNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.EditNodeDialog;
import freemind.view.mindmapview.EditNodeTextField;
import freemind.view.mindmapview.NodeView;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.xml.bind.JAXBException;

public class EditAction
extends AbstractAction
implements ActorXml {
    private final ControllerAdapter c;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$EditNodeAction;

    public EditAction(ControllerAdapter modeController) {
        super(modeController.getText("edit_node"));
        this.c = modeController;
        this.c.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent arg0) {
        MindMapNode selected = this.c.getSelected();
        this.c.edit(null, false, false);
    }

    public void act(XmlAction action) {
        EditNodeAction editAction = (EditNodeAction)action;
        NodeAdapter node = this.c.getNodeFromID(editAction.getNode());
        if (!node.toString().equals(editAction.getText())) {
            node.setUserObject(editAction.getText());
            this.c.nodeChanged(node);
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$EditNodeAction == null ? (class$freemind$controller$actions$generated$instance$EditNodeAction = EditAction.class$("freemind.controller.actions.generated.instance.EditNodeAction")) : class$freemind$controller$actions$generated$instance$EditNodeAction;
    }

    public void edit(KeyEvent e, boolean addNew, boolean editLong) {
        if (this.c.getView().getSelected() != null) {
            if (e == null || !addNew) {
                this.edit(this.c.getView().getSelected(), this.c.getView().getSelected(), e, false, false, editLong);
            } else if (!this.c.isBlocked()) {
                this.c.addNew(this.c.getSelected(), 3, e);
            }
            if (e != null) {
                e.consume();
            }
        }
    }

    public void editLater(NodeView node, NodeView prevSelected, KeyEvent firstEvent, boolean isNewNode, boolean parentFolded, boolean editLong) {
        class DelayedEditor
        implements Runnable {
            final NodeView node;
            final NodeView prevSelected;
            final KeyEvent firstEvent;
            final boolean isNewNode;
            final boolean parentFolded;
            final boolean editLong;

            DelayedEditor(NodeView node, NodeView prevSelected, KeyEvent firstEvent, boolean isNewNode, boolean parentFolded, boolean editLong) {
                this.node = node;
                this.prevSelected = prevSelected;
                this.firstEvent = firstEvent;
                this.isNewNode = isNewNode;
                this.parentFolded = parentFolded;
                this.editLong = editLong;
            }

            public void run() {
                EditAction.this.edit(this.node, this.prevSelected, this.firstEvent, this.isNewNode, this.parentFolded, this.editLong);
            }
        }
        EventQueue.invokeLater(new DelayedEditor(node, prevSelected, firstEvent, isNewNode, parentFolded, editLong));
    }

    public void edit(final NodeView node, final NodeView prevSelected, KeyEvent firstEvent, final boolean isNewNode, final boolean parentFolded, boolean editLong) {
        if (node == null) {
            return;
        }
        this.c.setBlocked(true);
        String text = ((Object)node.getModel()).toString();
        if (node.getIsLong() || editLong) {
            EditNodeDialog nodeEditDialog = new EditNodeDialog(node, text, firstEvent, this.c, new EditNodeBase.EditControl(){

                public void cancel() {
                }

                public void ok(String newText) {
                    EditAction.this.setNodeText(node.getModel(), newText);
                }

                public void split(String newText, int position) {
                    EditAction.this.c.splitNode(node.getModel(), position, newText);
                    EditAction.this.c.getController().obtainFocusForSelected();
                }
            });
            nodeEditDialog.show();
            this.c.setBlocked(false);
            return;
        }
        EditNodeTextField textfield = new EditNodeTextField(node, text, firstEvent, this.c, new EditNodeBase.EditControl(){

            public void cancel() {
                if (isNewNode) {
                    EditAction.this.c.getView().selectAsTheOnlyOneSelected(node);
                    EditAction.this.c.cut();
                    EditAction.this.c.select(prevSelected);
                    if (parentFolded) {
                        EditAction.this.c.setFolded(prevSelected.getModel(), true);
                    }
                }
                this.endEdit();
            }

            public void ok(String newText) {
                EditAction.this.setNodeText(node.getModel(), newText);
                this.endEdit();
            }

            private void endEdit() {
                EditAction.this.c.getController().obtainFocusForSelected();
                EditAction.this.c.setBlocked(false);
            }

            public void split(String newText, int position) {
            }
        });
        textfield.show();
    }

    public void setNodeText(MindMapNode selected, String newText) {
        String oldText = ((Object)selected).toString();
        try {
            this.c.getActionFactory().startTransaction(this.c.getText("edit_node"));
            EditNodeAction EditAction2 = this.c.getActionXmlFactory().createEditNodeAction();
            EditAction2.setNode(this.c.getNodeID(selected));
            EditAction2.setText(newText);
            EditNodeAction undoEditAction = this.c.getActionXmlFactory().createEditNodeAction();
            undoEditAction.setNode(this.c.getNodeID(selected));
            undoEditAction.setText(oldText);
            this.c.getActionFactory().executeAction(new ActionPair(EditAction2, undoEditAction));
            this.c.getActionFactory().endTransaction(this.c.getText("edit_node"));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    protected ControllerAdapter getModeController() {
        return this.c;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

