/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.AddArrowLinkXmlAction;
import freemind.controller.actions.generated.instance.RemoveArrowLinkXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.actions.RemoveArrowLinkAction;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.xml.bind.JAXBException;

public class AddArrowLinkAction
extends FreemindAction
implements ActorXml {
    private final ModeController modeController;
    private RemoveArrowLinkAction removeAction;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$AddArrowLinkXmlAction;

    public void setRemoveAction(RemoveArrowLinkAction removeAction) {
        this.removeAction = removeAction;
    }

    public AddArrowLinkAction(ModeController modeController) {
        super("add_link", "images/designer.png", modeController);
        this.modeController = modeController;
        this.addActor(this);
    }

    public void actionPerformed(ActionEvent e) {
        List selecteds = this.modeController.getSelecteds();
        if (selecteds.size() < 2) {
            this.modeController.getController().errorMessage(this.modeController.getText("less_than_two_selected_nodes"));
            return;
        }
        for (int i = 1; i < selecteds.size(); ++i) {
            this.addLink((MindMapNode)selecteds.get(i), (MindMapNode)selecteds.get(0));
        }
    }

    public void act(XmlAction action) {
        if (action instanceof AddArrowLinkXmlAction) {
            AddArrowLinkXmlAction arrowAction = (AddArrowLinkXmlAction)action;
            NodeAdapter source = this.modeController.getNodeFromID(arrowAction.getNode());
            NodeAdapter target = this.modeController.getNodeFromID(arrowAction.getDestination());
            String proposedId = arrowAction.getNewId();
            if (this.getLinkRegistry().getLabel(target) == null) {
                this.getLinkRegistry().registerLinkTarget(target);
            }
            MindMapArrowLinkModel linkModel = new MindMapArrowLinkModel(source, target, this.modeController.getFrame());
            linkModel.setDestinationLabel(this.getLinkRegistry().getLabel(target));
            linkModel.setUniqueID(this.getLinkRegistry().generateUniqueLinkID(proposedId));
            if (arrowAction.getColor() != null) {
                linkModel.setColor(Tools.xmlToColor(arrowAction.getColor()));
            }
            if (arrowAction.getEndArrow() != null) {
                linkModel.setEndArrow(arrowAction.getEndArrow());
            }
            if (arrowAction.getEndInclination() != null) {
                linkModel.setEndInclination(Tools.xmlToPoint(arrowAction.getEndInclination()));
            }
            if (arrowAction.getStartArrow() != null) {
                linkModel.setStartArrow(arrowAction.getStartArrow());
            }
            if (arrowAction.getStartInclination() != null) {
                linkModel.setStartInclination(Tools.xmlToPoint(arrowAction.getStartInclination()));
            }
            this.getLinkRegistry().registerLink(linkModel);
            this.modeController.nodeChanged(target);
            this.modeController.nodeChanged(source);
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$AddArrowLinkXmlAction == null ? (class$freemind$controller$actions$generated$instance$AddArrowLinkXmlAction = AddArrowLinkAction.class$("freemind.controller.actions.generated.instance.AddArrowLinkXmlAction")) : class$freemind$controller$actions$generated$instance$AddArrowLinkXmlAction;
    }

    private ActionPair getActionPair(MindMapNode source, MindMapNode target) {
        AddArrowLinkXmlAction doAction = this.createAddArrowLinkXmlAction(source, target, this.getLinkRegistry().generateUniqueLinkID(null));
        RemoveArrowLinkXmlAction undoAction = this.removeAction.createRemoveArrowLinkXmlAction(doAction.getNewId());
        return new ActionPair(doAction, undoAction);
    }

    public AddArrowLinkXmlAction createAddArrowLinkXmlAction(MindMapNode source, MindMapNode target, String proposedID) {
        try {
            AddArrowLinkXmlAction action = this.modeController.getActionXmlFactory().createAddArrowLinkXmlAction();
            action.setNode(source.getObjectId(this.modeController));
            action.setDestination(target.getObjectId(this.modeController));
            action.setNewId(proposedID);
            return action;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addLink(MindMapNode source, MindMapNode target) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getActionPair(source, target));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private MindMapLinkRegistry getLinkRegistry() {
        return this.modeController.getMap().getLinkRegistry();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

