/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.ArrowLinkAdapter;
import freemind.modes.HistoryInformation;
import freemind.modes.MindIcon;
import freemind.modes.MindMapCloud;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class NodeAdapter
implements MindMapNode {
    static final int SHIFT = -2;
    public static final int HGAP = 20;
    public static final int VGAP = 3;
    private HashSet activatedHooks;
    private List hooks;
    protected Object userObject = "no text";
    private String link = null;
    private HashMap toolTip = null;
    protected String style;
    protected Vector icons = null;
    protected TreeMap stateIcons = null;
    protected MindMapCloud cloud;
    protected Color color;
    protected Color backgroundColor;
    protected boolean folded;
    private Tools.BooleanHolder left;
    private int vGap = -1;
    private int hGap = 20;
    private int shiftY = 0;
    protected List children;
    private MindMapNode preferredChild;
    protected Font font;
    protected boolean underlined = false;
    private MindMapNode parent;
    private MindMapEdge edge;
    private NodeView viewer = null;
    private FreeMindMain frame;
    private static final boolean ALLOWSCHILDREN = true;
    private static final boolean ISLEAF = false;
    private HistoryInformation historyInformation = null;
    protected static Logger logger;

    protected NodeAdapter(FreeMindMain frame) {
        this(null, frame);
    }

    protected NodeAdapter(Object userObject, FreeMindMain frame) {
        this.userObject = userObject;
        this.frame = frame;
        this.hooks = null;
        this.activatedHooks = null;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
        this.setHistoryInformation(new HistoryInformation());
    }

    public String getText() {
        return this.toString();
    }

    public void setText(String text) {
        this.setUserObject(text);
    }

    public String getLink() {
        return this.link;
    }

    public String getShortText(ModeController controller) {
        String adaptedText = this.toString();
        if ((adaptedText = adaptedText.replaceAll("<html>", "")).length() > 40) {
            adaptedText = adaptedText.substring(0, 40) + " ...";
        }
        return adaptedText;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public NodeView getViewer() {
        return this.viewer;
    }

    public void setViewer(NodeView viewer) {
        this.viewer = viewer;
    }

    public TreePath getPath() {
        Vector pathVector = new Vector();
        this.addToPathVector(pathVector);
        TreePath treePath = new TreePath(pathVector.toArray());
        return treePath;
    }

    public MindMapEdge getEdge() {
        return this.edge;
    }

    public void setEdge(MindMapEdge edge) {
        this.edge = edge;
    }

    public MindMapCloud getCloud() {
        return this.cloud;
    }

    public void setCloud(MindMapCloud cloud) {
        if (cloud != null && this.cloud == null) {
            this.changeChildCloudIterativeLevels(1);
        } else if (cloud == null && this.cloud != null) {
            this.changeChildCloudIterativeLevels(-1);
        }
        this.cloud = cloud;
    }

    private void changeChildCloudIterativeLevels(int deltaLevel) {
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            NodeAdapter childNode = (NodeAdapter)e.next();
            MindMapCloud childCloud = childNode.getCloud();
            if (childCloud != null) {
                childCloud.changeIterativeLevel(deltaLevel);
            }
            childNode.changeChildCloudIterativeLevels(deltaLevel);
        }
    }

    public String getStyle() {
        String returnedString = this.style;
        if (this.style == null) {
            String stdstyle;
            returnedString = this.isRoot() ? this.getFrame().getProperty("standardrootnodestyle") : ((stdstyle = this.getFrame().getProperty("standardnodestyle")).equals("as_parent") ? this.getParentNode().getStyle() : stdstyle);
        } else if (this.isRoot() && this.style.equals("as_parent")) {
            returnedString = this.getFrame().getProperty("standardrootnodestyle");
        } else if (this.style.equals("as_parent")) {
            returnedString = this.getParentNode().getStyle();
        }
        if (returnedString.equals("combined")) {
            if (this.isFolded()) {
                return "bubble";
            }
            return "fork";
        }
        return returnedString;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void estabilishOwnFont() {
        this.font = this.font != null ? this.font : this.getFrame().getController().getDefaultFont();
    }

    public void setBold(boolean bold) {
        if (bold != this.isBold()) {
            this.toggleBold();
        }
    }

    public void toggleBold() {
        this.estabilishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle() ^ 1, this.font.getSize())));
    }

    public void setItalic(boolean italic) {
        if (italic != this.isItalic()) {
            this.toggleItalic();
        }
    }

    public void toggleItalic() {
        this.estabilishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle() ^ 2, this.font.getSize())));
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public MindMapNode getParentNode() {
        return this.parent;
    }

    public void setFontSize(int fontSize) {
        this.estabilishOwnFont();
        this.setFont(this.getFrame().getController().getFontThroughMap(new Font(this.font.getFamily(), this.font.getStyle(), fontSize)));
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontSize() {
        if (this.getFont() != null) {
            return new Integer(this.getFont().getSize()).toString();
        }
        return this.getFrame().getProperty("defaultfontsize");
    }

    public String getFontFamilyName() {
        if (this.getFont() != null) {
            return this.getFont().getFamily();
        }
        return this.getFrame().getProperty("defaultfont");
    }

    public boolean isBold() {
        return this.font != null ? this.font.isBold() : false;
    }

    public boolean isItalic() {
        return this.font != null ? this.font.isItalic() : false;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public boolean isFolded() {
        return this.folded;
    }

    public List getIcons() {
        if (this.icons == null) {
            return Collections.EMPTY_LIST;
        }
        return this.icons;
    }

    public void addIcon(MindIcon _icon) {
        this.createIcons();
        this.icons.add(_icon);
    }

    public int removeLastIcon() {
        int returnSize;
        this.createIcons();
        if (this.icons.size() > 0) {
            this.icons.setSize(this.icons.size() - 1);
        }
        if ((returnSize = this.icons.size()) == 0) {
            this.icons = null;
        }
        return returnSize;
    }

    public boolean hasFoldedStrictDescendant() {
        ListIterator e = this.childrenUnfolded();
        while (e.hasNext()) {
            NodeAdapter child = (NodeAdapter)e.next();
            if (!child.isFolded() && !child.hasFoldedStrictDescendant()) continue;
            return true;
        }
        return false;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
    }

    protected MindMapNode basicCopy() {
        return null;
    }

    public MindMapNode shallowCopy() {
        MindMapNode copy = this.basicCopy();
        copy.setColor(this.getColor());
        copy.setFont(this.getFont());
        copy.setLink(this.getLink());
        if (this.isLeft() != null) {
            copy.setLeft(this.isLeft().getValue());
        }
        List icons = this.getIcons();
        for (int i = 0; i < icons.size(); ++i) {
            copy.addIcon((MindIcon)icons.get(i));
        }
        return copy;
    }

    public String toString() {
        String string = "";
        if (this.userObject != null) {
            string = this.userObject.toString();
        }
        return string;
    }

    public boolean isDescendantOf(MindMapNode node) {
        if (this.isRoot()) {
            return false;
        }
        if (node == this.getParentNode()) {
            return true;
        }
        return this.getParentNode().isDescendantOf(node);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public int getChildPosition(MindMapNode childNode) {
        int position = 0;
        ListIterator i = this.children.listIterator();
        while (i.hasNext()) {
            if ((MindMapNode)i.next() == childNode) {
                return position;
            }
            ++position;
        }
        return -1;
    }

    public ListIterator childrenUnfolded() {
        return this.children != null ? this.children.listIterator() : Collections.EMPTY_LIST.listIterator();
    }

    public ListIterator childrenFolded() {
        if (this.isFolded()) {
            return Collections.EMPTY_LIST.listIterator();
        }
        return this.childrenUnfolded();
    }

    public Enumeration children() {
        throw new UnsupportedOperationException("Use childrenFolded or childrenUnfolded instead");
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf((MindMapNode)node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public Tools.BooleanHolder isLeft() {
        return this.left;
    }

    public boolean isOneLeftSideOfRoot() {
        if (this.isRoot()) {
            return false;
        }
        if (this.getParentNode().isRoot()) {
            return this.isLeft() == null ? false : this.isLeft().getValue();
        }
        return this.getParentNode().isOneLeftSideOfRoot();
    }

    public void setLeft(boolean isLeft) {
        if (this.left == null) {
            this.left = new Tools.BooleanHolder();
        }
        this.left.setValue(isLeft);
    }

    public void insert(MutableTreeNode child, int index) {
        logger.finest("Insert at " + index + " the node " + child);
        if (index < 0) {
            index = this.getChildCount();
            this.children.add(index, child);
        } else {
            this.children.add(index, child);
            this.preferredChild = (MindMapNode)child;
        }
        child.setParent(this);
    }

    public void remove(int index) {
        MutableTreeNode node = (MutableTreeNode)this.children.get(index);
        this.remove(node);
    }

    public void remove(MutableTreeNode node) {
        if (node == this.preferredChild) {
            int index = this.children.indexOf(node);
            this.preferredChild = this.children.size() > index + 1 ? (MindMapNode)this.children.get(index + 1) : (index > 0 ? (MindMapNode)this.children.get(index - 1) : null);
        }
        node.setParent(null);
        this.children.remove(node);
        this.recursiveCallRemoveChildren(this, (MindMapNode)node, this);
    }

    private void recursiveCallRemoveChildren(MindMapNode node, MindMapNode removedChild, MindMapNode oldDad) {
        Iterator i = node.getActivatedHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            if (removedChild.getParentNode() == node) {
                hook.onRemoveChild(removedChild);
            }
            hook.onRemoveChildren(removedChild, oldDad);
        }
        if (!node.isRoot() && node.getParentNode() != null) {
            this.recursiveCallRemoveChildren(node.getParentNode(), removedChild, oldDad);
        }
    }

    public MindMapNode getPreferredChild() {
        if (this.children.contains(this.preferredChild)) {
            return this.preferredChild;
        }
        if (!this.isLeaf()) {
            return (MindMapNode)this.children.get((this.getChildCount() + 1) / 2 - 1);
        }
        return null;
    }

    public void setPreferredChild(MindMapNode node) {
        this.preferredChild = node;
        if (node == null) {
            return;
        }
        if (this.parent != null) {
            this.parent.setPreferredChild(this);
        }
    }

    public void removeFromParent() {
        this.parent.remove(this);
    }

    public void setParent(MutableTreeNode newParent) {
        this.parent = (MindMapNode)newParent;
    }

    public void setParent(MindMapNode newParent) {
        this.parent = newParent;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    private void addToPathVector(Vector pathVector) {
        pathVector.add(0, this);
        if (this.parent != null) {
            ((NodeAdapter)this.parent).addToPathVector(pathVector);
        }
    }

    public int getNodeLevel() {
        int level = 0;
        MindMapNode parent = this;
        while (!parent.isRoot()) {
            ++level;
            parent = parent.getParentNode();
        }
        return level;
    }

    public PermanentNodeHook addHook(PermanentNodeHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("Added null hook.");
        }
        this.createHooks();
        this.hooks.add(hook);
        return hook;
    }

    public void invokeHook(NodeHook hook) {
        hook.startupMapHook();
        hook.setNode(this);
        try {
            hook.invoke(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (hook instanceof PermanentNodeHook) {
            this.createActivatedHooks();
            this.activatedHooks.add(hook);
        } else {
            hook.shutdownMapHook();
        }
    }

    private void createActivatedHooks() {
        if (this.activatedHooks == null) {
            this.activatedHooks = new HashSet();
        }
    }

    private void createToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new HashMap();
        }
    }

    private void createHooks() {
        if (this.hooks == null) {
            this.hooks = new Vector();
        }
    }

    private void createStateIcons() {
        if (this.stateIcons == null) {
            this.stateIcons = new TreeMap();
        }
    }

    private void createIcons() {
        if (this.icons == null) {
            this.icons = new Vector();
        }
    }

    public List getHooks() {
        if (this.hooks == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.hooks);
    }

    public Collection getActivatedHooks() {
        if (this.activatedHooks == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.activatedHooks);
    }

    public void removeHook(PermanentNodeHook hook) {
        this.createActivatedHooks();
        this.activatedHooks.remove(hook);
        if (this.activatedHooks.size() == 0) {
            this.activatedHooks = null;
        }
        hook.shutdownMapHook();
        this.createHooks();
        this.hooks.remove(hook);
        if (this.hooks.size() == 0) {
            this.hooks = null;
        }
    }

    public Map getToolTip() {
        if (this.toolTip == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(this.toolTip);
    }

    public void setToolTip(String key, String string) {
        this.createToolTip();
        if (string == null) {
            if (this.toolTip.containsKey(key)) {
                this.toolTip.remove(key);
            }
            if (this.toolTip.size() == 0) {
                this.toolTip = null;
            }
        } else {
            this.toolTip.put(key, string);
        }
    }

    public String getObjectId(ModeController controller) {
        return controller.getNodeID(this);
    }

    public XMLElement save(Writer writer, MindMapLinkRegistry registry) throws IOException {
        String label;
        XMLElement edge;
        XMLElement node = new XMLElement();
        node.setName("node");
        String text = this.toString().replace('\u0000', ' ');
        node.setAttribute("TEXT", text);
        if (this.getAdditionalInfo() != null) {
            node.setAttribute("ENCRYPTED_CONTENT", this.getAdditionalInfo());
        }
        if ((edge = this.getEdge().save()) != null) {
            node.addChild(edge);
        }
        if (this.getCloud() != null) {
            XMLElement cloud = this.getCloud().save();
            node.addChild(cloud);
        }
        Vector linkVector = registry.getAllLinksFromMe(this);
        for (int i = 0; i < linkVector.size(); ++i) {
            if (!(linkVector.get(i) instanceof ArrowLinkAdapter)) continue;
            XMLElement arrowLinkElement = ((ArrowLinkAdapter)linkVector.get(i)).save();
            node.addChild(arrowLinkElement);
        }
        if (this.isFolded()) {
            node.setAttribute("FOLDED", "true");
        }
        if (this.isLeft() != null && !this.isRoot() && this.getParentNode().isRoot()) {
            node.setAttribute("POSITION", this.isLeft().getValue() ? "left" : "right");
        }
        if ((label = registry.getLabel(this)) != null) {
            node.setAttribute("ID", label);
        }
        if (this.color != null) {
            node.setAttribute("COLOR", Tools.colorToXml(this.getColor()));
        }
        if (this.getBackgroundColor() != null) {
            node.setAttribute("BACKGROUND_COLOR", Tools.colorToXml(this.getBackgroundColor()));
        }
        if (this.style != null) {
            node.setAttribute("STYLE", this.getStyle());
        }
        if (this.vGap != -1) {
            node.setAttribute("VGAP", Integer.toString(this.vGap));
        }
        if (this.hGap != 20) {
            node.setAttribute("HGAP", Integer.toString(this.hGap));
        }
        if (this.shiftY != 0) {
            node.setAttribute("VSHIFT", Integer.toString(this.shiftY));
        }
        if (this.getLink() != null) {
            node.setAttribute("LINK", this.getLink());
        }
        if (this.historyInformation != null) {
            node.setAttribute("CREATED", Tools.dateToString(this.getHistoryInformation().getCreatedAt()));
            node.setAttribute("MODIFIED", Tools.dateToString(this.getHistoryInformation().getLastModifiedAt()));
        }
        if (this.font != null) {
            XMLElement fontElement = new XMLElement();
            fontElement.setName("font");
            if (this.font != null) {
                fontElement.setAttribute("NAME", this.font.getFamily());
            }
            if (this.font.getSize() != 0) {
                fontElement.setAttribute("SIZE", Integer.toString(this.font.getSize()));
            }
            if (this.isBold()) {
                fontElement.setAttribute("BOLD", "true");
            }
            if (this.isItalic()) {
                fontElement.setAttribute("ITALIC", "true");
            }
            if (this.isUnderlined()) {
                fontElement.setAttribute("UNDERLINE", "true");
            }
            node.addChild(fontElement);
        }
        for (int i = 0; i < this.getIcons().size(); ++i) {
            XMLElement iconElement = new XMLElement();
            iconElement.setName("icon");
            iconElement.setAttribute("BUILTIN", ((MindIcon)this.getIcons().get(i)).getName());
            node.addChild(iconElement);
        }
        Iterator i = this.getActivatedHooks().iterator();
        while (i.hasNext()) {
            XMLElement hookElement = new XMLElement();
            hookElement.setName("hook");
            ((PermanentNodeHook)i.next()).save(hookElement);
            node.addChild(hookElement);
        }
        if (this.childrenUnfolded().hasNext()) {
            node.writeWithoutClosingTag(writer);
            ListIterator e = this.childrenUnfolded();
            while (e.hasNext()) {
                NodeAdapter child = (NodeAdapter)e.next();
                child.save(writer, registry);
            }
            node.writeClosingTag(writer);
        } else {
            node.write(writer);
        }
        return node;
    }

    public int getShiftY() {
        return this.shiftY;
    }

    public int calcShiftY() {
        try {
            return this.shiftY + (this.getParent().getChildCount() == 1 ? -2 : 0);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public void setShiftY(int shiftY) {
        this.shiftY = shiftY;
    }

    public void setAdditionalInfo(String info) {
    }

    public String getAdditionalInfo() {
        return null;
    }

    public synchronized void setStateIcon(String key, ImageIcon icon) {
        this.createStateIcons();
        if (icon != null) {
            this.stateIcons.put(key, icon);
        } else if (this.stateIcons.containsKey(key)) {
            this.stateIcons.remove(key);
        }
        if (this.stateIcons.size() == 0) {
            this.stateIcons = null;
        }
    }

    public Map getStateIcons() {
        if (this.stateIcons == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableSortedMap(this.stateIcons);
    }

    public HistoryInformation getHistoryInformation() {
        return this.historyInformation;
    }

    public void setHistoryInformation(HistoryInformation historyInformation) {
        this.historyInformation = historyInformation;
    }

    public int getHGap() {
        return this.hGap;
    }

    public void setHGap(int gap) {
        this.hGap = Math.max(20, gap);
    }

    public int getVGap() {
        return this.vGap;
    }

    public int calcVGap() {
        if (this.vGap != -1) {
            return this.vGap;
        }
        return 3;
    }

    public void setVGap(int gap) {
        this.vGap = gap == -1 ? -1 : Math.max(gap, 0);
    }
}

