/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.actions.generated.instance.impl.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.validator.DOMLocator;
import com.sun.xml.bind.validator.Locator;
import com.sun.xml.bind.validator.SAXLocator;
import freemind.controller.actions.generated.instance.impl.runtime.DefaultJAXBContextImpl;
import freemind.controller.actions.generated.instance.impl.runtime.ErrorHandlerAdaptor;
import freemind.controller.actions.generated.instance.impl.runtime.GrammarInfo;
import freemind.controller.actions.generated.instance.impl.runtime.SAXUnmarshallerHandler;
import freemind.controller.actions.generated.instance.impl.runtime.SAXUnmarshallerHandlerImpl;
import freemind.controller.actions.generated.instance.impl.runtime.ValidatingUnmarshaller;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class UnmarshallerImpl
extends AbstractUnmarshallerImpl {
    private DefaultJAXBContextImpl context = null;
    private final GrammarInfo grammarInfo;
    private static final DefaultHandler dummyHandler = new DefaultHandler();

    public UnmarshallerImpl(DefaultJAXBContextImpl context, GrammarInfo gi) {
        this.context = context;
        this.grammarInfo = gi;
        DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
    }

    public void setValidating(boolean validating) throws JAXBException {
        super.setValidating(validating);
        if (validating) {
            this.context.getGrammar();
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.createUnmarshallerHandler((Locator)new SAXLocator());
    }

    public SAXUnmarshallerHandler createUnmarshallerHandler(Locator locator) {
        SAXUnmarshallerHandler unmarshaller = new SAXUnmarshallerHandlerImpl(this, this.grammarInfo);
        try {
            if (this.isValidating()) {
                unmarshaller = ValidatingUnmarshaller.create(this.context.getGrammar(), unmarshaller, locator);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return unmarshaller;
    }

    protected Object unmarshal(XMLReader reader, InputSource source) throws JAXBException {
        SAXLocator locator = new SAXLocator();
        SAXUnmarshallerHandler handler = this.createUnmarshallerHandler((Locator)locator);
        reader.setContentHandler(handler);
        reader.setErrorHandler(new ErrorHandlerAdaptor(handler, (Locator)locator));
        try {
            reader.parse(source);
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
        Object result = handler.getResult();
        reader.setContentHandler(dummyHandler);
        reader.setErrorHandler(dummyHandler);
        return result;
    }

    public final Object unmarshal(Node node) throws JAXBException {
        try {
            DOMScanner scanner = new DOMScanner();
            SAXUnmarshallerHandler handler = this.createUnmarshallerHandler((Locator)new DOMLocator(scanner));
            if (node instanceof Element) {
                scanner.parse((Element)node, (ContentHandler)handler);
            } else if (node instanceof Document) {
                scanner.parse(((Document)node).getDocumentElement(), (ContentHandler)handler);
            } else {
                throw new IllegalArgumentException();
            }
            return handler.getResult();
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
    }

    private static void _assert(boolean b, String msg) {
        if (!b) {
            throw new InternalError(msg);
        }
    }
}

