/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.controller.LastOpenedList;
import freemind.controller.StructuredMenuHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    private static Logger logger;
    public static final String MENU_BAR_PREFIX = "menu_bar/";
    public static final String GENERAL_POPUP_PREFIX = "popup/";
    public static final String POPUP_MENU = "popup/popup/";
    public static final String INSERT_MENU = "menu_bar/insert/";
    public static final String NAVIGATE_MENU = "menu_bar/navigate/";
    public static final String VIEW_MENU = "menu_bar/view/";
    public static final String HELP_MENU = "menu_bar/help/";
    public static final String MODES_MENU = "menu_bar/modes/";
    public static final String MINDMAP_MENU = "menu_bar/mindmaps/";
    public static final String EDIT_MENU = "menu_bar/edit/";
    public static final String FILE_MENU = "menu_bar/file/";
    public static final String FORMAT_MENU = "menu_bar/format/";
    public static final String EXTRAS_MENU = "menu_bar/extras/";
    private StructuredMenuHolder menuHolder;
    JPopupMenu mapsPopupMenu;
    private JMenu filemenu;
    private JMenu editmenu;
    private JMenu mapsmenu;
    Controller c;
    ActionListener mapsMenuActionListener = new MapsMenuActionListener();
    ActionListener lastOpenedActionListener = new LastOpenedActionListener();
    private JMenu formatmenu;

    public MenuBar(Controller controller) {
        this.c = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void updateMenus() {
        this.removeAll();
        this.menuHolder = new StructuredMenuHolder();
        this.filemenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("file")), "menu_bar/file/.");
        this.filemenu.setMnemonic(70);
        this.menuHolder.addCategory("menu_bar/file/open");
        this.menuHolder.addCategory("menu_bar/file/close");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/export");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/import");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/print");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/last");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/quit");
        this.editmenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("edit")), "menu_bar/edit/.");
        this.menuHolder.addCategory("menu_bar/edit/undo");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/select");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/paste");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/edit");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/find");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_view")), "menu_bar/view/.");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_insert")), "menu_bar/insert/.");
        this.menuHolder.addCategory("menu_bar/insert/nodes");
        this.menuHolder.addSeparator(INSERT_MENU);
        this.menuHolder.addCategory("menu_bar/insert/icons");
        this.menuHolder.addSeparator(INSERT_MENU);
        this.formatmenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_format")), "menu_bar/format/.");
        this.menuHolder.addCategory("menu_bar/format/patterns");
        this.menuHolder.addSeparator(FORMAT_MENU);
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_navigate")), "menu_bar/navigate/.");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_extras")), "menu_bar/extras/.");
        this.menuHolder.addCategory("menu_bar/extras/first");
        this.menuHolder.addSeparator(EXTRAS_MENU);
        this.menuHolder.addCategory("menu_bar/extras/last");
        this.mapsmenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("mindmaps")), "menu_bar/mindmaps/.");
        this.mapsmenu.setMnemonic(77);
        this.menuHolder.addCategory("menu_bar/mindmaps/navigate");
        this.menuHolder.addSeparator(MINDMAP_MENU);
        this.mapsPopupMenu = new JPopupMenu(this.c.getResourceString("mindmaps"));
        this.menuHolder.addCategory("popup/popup/navigate");
        JMenu modesmenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("modes")), "menu_bar/modes/.");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("help")), "menu_bar/help/.");
        this.menuHolder.addAction(this.c.documentation, "menu_bar/help/doc/documentation");
        this.menuHolder.addAction(this.c.faq, "menu_bar/help/doc/faq");
        this.menuHolder.addSeparator(HELP_MENU);
        this.menuHolder.addAction(this.c.license, "menu_bar/help/about/license");
        this.menuHolder.addAction(this.c.about, "menu_bar/help/about/about");
        this.updateFileMenu();
        this.updateEditMenu();
        this.updateModeMenu();
        this.updateMapsMenu(this.menuHolder, MINDMAP_MENU);
        this.updateMapsMenu(this.menuHolder, POPUP_MENU);
        this.addAdditionalPopupActions();
        if (this.c.getMode() != null) {
            this.c.getMode().getModeController().updateMenus(this.menuHolder);
        }
        this.menuHolder.updateMenus(this, MENU_BAR_PREFIX);
        this.menuHolder.updateMenus(this.mapsPopupMenu, GENERAL_POPUP_PREFIX);
    }

    private void updateModeMenu() {
        ButtonGroup group = new ButtonGroup();
        ModesMenuActionListener modesMenuActionListener = new ModesMenuActionListener();
        LinkedList keys = new LinkedList(this.c.getModes());
        ListIterator i = keys.listIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            JRadioButtonMenuItem newItem = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(new JRadioButtonMenuItem(key), MODES_MENU + key);
            group.add(newItem);
            if (this.c.getMode() != null) {
                newItem.setSelected(((Object)this.c.getMode()).toString().equals(key));
            } else {
                newItem.setSelected(false);
            }
            String keystroke = this.c.getFrame().getProperty("keystroke_mode_" + key);
            if (keystroke != null) {
                newItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
            }
            newItem.addActionListener(modesMenuActionListener);
        }
    }

    private void addAdditionalPopupActions() {
        this.menuHolder.addSeparator(POPUP_MENU);
        JMenuItem newPopupItem = new JMenuItem(this.c.toggleMenubar);
        newPopupItem.setForeground(new Color(100, 80, 80));
        newPopupItem.setEnabled(this.c.getFrame().isApplet());
        this.menuHolder.addMenuItem(newPopupItem, "popup/popup/toggleMenubar");
        newPopupItem = new JMenuItem(this.c.toggleToolbar);
        newPopupItem.setForeground(new Color(100, 80, 80));
        this.menuHolder.addMenuItem(newPopupItem, "popup/popup/toggleToolbar");
        newPopupItem = new JMenuItem(this.c.toggleLeftToolbar);
        newPopupItem.setForeground(new Color(100, 80, 80));
        this.menuHolder.addMenuItem(newPopupItem, "popup/popup/toggleLeftToolbar");
    }

    private void updateMapsMenu(StructuredMenuHolder holder, String basicKey) {
        if (this.c.getMapModuleManager().getMapModules() == null) {
            return;
        }
        LinkedList keys = new LinkedList(this.c.getMapModuleManager().getMapModules().keySet());
        Collections.sort(keys);
        ButtonGroup group = new ButtonGroup();
        ListIterator i = keys.listIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            JRadioButtonMenuItem newItem = new JRadioButtonMenuItem(key);
            newItem.setSelected(false);
            group.add(newItem);
            newItem.addActionListener(this.mapsMenuActionListener);
            newItem.setMnemonic(key.charAt(0));
            if (this.c.getMapModuleManager().getMapModule() != null && key.equals(this.c.getMapModuleManager().getMapModule().toString())) {
                newItem.setSelected(true);
            }
            holder.addMenuItem(newItem, basicKey + key);
        }
    }

    private void updateFileMenu() {
        this.menuHolder.addAction(this.c.page, "menu_bar/file/print/pageSetup");
        JMenuItem print = this.menuHolder.addAction(this.c.print, "menu_bar/file/print/print");
        print.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_print")));
        JMenuItem close = this.menuHolder.addAction(this.c.close, "menu_bar/file/close/close");
        close.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_close")));
        JMenuItem quit = this.menuHolder.addAction(this.c.quit, "menu_bar/file/quit/quit");
        quit.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_quit")));
        this.updateLastOpenedList();
    }

    private void updateLastOpenedList() {
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("most_recent_files")), "menu_bar/file/last/.");
        boolean firstElement = true;
        LastOpenedList lst = this.c.getLastOpenedList();
        ListIterator it = lst.listIterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            JMenuItem item = new JMenuItem(key);
            if (firstElement) {
                firstElement = false;
                item.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_open_first_in_history")));
            }
            item.addActionListener(this.lastOpenedActionListener);
            this.menuHolder.addMenuItem(item, "menu_bar/file/last/" + key.replace('/', '_'));
        }
    }

    private void updateEditMenu() {
        JMenuItem toggleToolbar = this.menuHolder.addAction(this.c.toggleToolbar, "menu_bar/view/toolbars/toggleToolbar");
        JMenuItem toggleLeftToolbar = this.menuHolder.addAction(this.c.toggleLeftToolbar, "menu_bar/view/toolbars/toggleLeftToolbar");
        this.menuHolder.addSeparator(VIEW_MENU);
        JMenuItem zoomIn = this.menuHolder.addAction(this.c.zoomIn, "menu_bar/view/zoom/zoomIn");
        zoomIn.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_zoom_in")));
        JMenuItem zoomOut = this.menuHolder.addAction(this.c.zoomOut, "menu_bar/view/zoom/zoomOut");
        zoomOut.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_zoom_out")));
        JMenuItem moveToRoot = this.menuHolder.addAction(this.c.moveToRoot, "menu_bar/navigate/nodes/moveToRoot");
        moveToRoot.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_moveToRoot")));
        JMenuItem previousMap = this.menuHolder.addAction(this.c.navigationPreviousMap, "menu_bar/mindmaps/navigate/navigationPreviousMap");
        previousMap.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_previousMap")));
        JMenuItem nextMap = this.menuHolder.addAction(this.c.navigationNextMap, "menu_bar/mindmaps/navigate/navigationNextMap");
        nextMap.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_nextMap")));
        JMenuItem prefDialog = this.menuHolder.addAction(this.c.propertyAction, "menu_bar/extras/last/option_dialog");
        prefDialog.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getProperty("keystroke_option_dialog")));
    }

    private void addOptionSet(Action action, String[] textIDs, JMenu menu, String selectedTextID) {
        ButtonGroup group = new ButtonGroup();
        for (int optionIdx = 0; optionIdx < textIDs.length; ++optionIdx) {
            String keystroke;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setText(this.c.getResourceString(textIDs[optionIdx]));
            item.setActionCommand(textIDs[optionIdx]);
            group.add(item);
            menu.add(item);
            if (selectedTextID != null) {
                item.setSelected(selectedTextID.equals(textIDs[optionIdx]));
            }
            if ((keystroke = this.c.getFrame().getProperty("keystroke_" + textIDs[optionIdx])) == null) continue;
            item.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        }
    }

    JPopupMenu getMapsPopupMenu() {
        return this.mapsPopupMenu;
    }

    private void copyMenuItems(JMenu source, JMenu dest) {
        Component[] items = source.getMenuComponents();
        for (int i = 0; i < items.length; ++i) {
            dest.add(items[i]);
        }
    }

    public StructuredMenuHolder getMenuHolder() {
        return this.menuHolder;
    }

    private class ModesMenuActionListener
    implements ActionListener {
        private ModesMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuBar.this.c.changeToMode(e.getActionCommand());
        }
    }

    private class LastOpenedActionListener
    implements ActionListener {
        private LastOpenedActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuBar.this.c.getLastOpenedList().open(e.getActionCommand());
        }
    }

    private class MapsMenuActionListener
    implements ActionListener {
        private MapsMenuActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MenuBar.this.c.getMapModuleManager().changeToMapModule(e.getActionCommand());
        }
    }
}

