/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.view.MapModule;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;

public class LastOpenedList {
    private Controller c;
    private int maxEntries = 25;
    private List lst = new LinkedList();
    private Map hash = new HashMap();

    LastOpenedList(Controller c, String restored) {
        this.c = c;
        this.maxEntries = new Integer(c.getFrame().getProperty("last_opened_list_length"));
        this.load(restored);
    }

    void mapOpened(MapModule map) {
        if (map == null || map.getModel() == null) {
            return;
        }
        String rest = map.getModel().getRestoreable();
        if (rest == null) {
            return;
        }
        if (this.lst.contains(rest)) {
            this.lst.remove(rest);
        }
        this.lst.add(0, rest);
        this.hash.put(rest, map.toString());
        while (this.lst.size() > this.maxEntries) {
            this.lst.remove(this.lst.size() - 1);
        }
    }

    void mapClosed(MapModule map) {
    }

    String save() {
        String str = new String();
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            str = str.concat((String)it.next() + ";");
        }
        return str;
    }

    void load(String data) {
        if (data != null) {
            StringTokenizer token = new StringTokenizer(data, ";");
            while (token.hasMoreTokens()) {
                this.lst.add(token.nextToken());
            }
        }
    }

    public void open(String restoreable) {
        String mode;
        StringTokenizer token;
        if (restoreable != null & !this.c.getMapModuleManager().tryToChangeToMapModule((String)this.hash.get(restoreable)) && (token = new StringTokenizer(restoreable, ":")).hasMoreTokens() && this.c.changeToMode(mode = token.nextToken())) {
            this.c.getMode().restore(token.nextToken("").substring(1));
        }
    }

    ListIterator listIterator() {
        return this.lst.listIterator();
    }
}

