/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.dialogs;

import freemind.main.FreeMindMain;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconSelectionPopupDialog
extends JDialog
implements KeyListener,
MouseListener {
    private Vector icons;
    private int result;
    private JPanel iconPanel = new JPanel();
    private JLabel[] iconLabels;
    private JLabel descriptionLabel;
    private int numOfIcons;
    private int xDimension;
    private int yDimension;
    private Position selected = new Position(0, 0);
    private static Position lastPosition = new Position(0, 0);
    private Vector descriptions;
    private FreeMindMain freeMindMain;

    public IconSelectionPopupDialog(JFrame caller, Vector icons, Vector descriptions, FreeMindMain freeMindMain) {
        super((Frame)caller, "select icon");
        this.getContentPane().setLayout(new BorderLayout());
        this.descriptions = descriptions;
        this.freeMindMain = freeMindMain;
        this.icons = icons;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                IconSelectionPopupDialog.this.close();
            }
        });
        this.numOfIcons = icons.size();
        this.xDimension = new Double(Math.ceil(Math.sqrt(this.numOfIcons))).intValue();
        this.yDimension = this.numOfIcons <= this.xDimension * (this.xDimension - 1) ? this.xDimension - 1 : this.xDimension;
        GridLayout gridlayout = new GridLayout(0, this.xDimension);
        gridlayout.setHgap(3);
        gridlayout.setVgap(3);
        this.iconPanel.setLayout(gridlayout);
        this.iconLabels = new JLabel[this.numOfIcons];
        for (int i = 0; i < this.numOfIcons; ++i) {
            this.iconLabels[i] = new JLabel((Icon)icons.get(i));
            this.iconPanel.add(this.iconLabels[i]);
            this.iconLabels[i].setBorder(BorderFactory.createBevelBorder(0));
            this.iconLabels[i].addMouseListener(this);
        }
        int perIconSize = 27;
        this.iconPanel.setPreferredSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.iconPanel.setMinimumSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.iconPanel.setMaximumSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.iconPanel.setSize(new Dimension(this.xDimension * perIconSize, this.yDimension * perIconSize));
        this.getContentPane().add((Component)this.iconPanel, "Center");
        this.descriptionLabel = new JLabel(" ");
        this.getContentPane().add((Component)this.descriptionLabel, "South");
        this.setSelectedPosition(lastPosition);
        this.select(this.getSelectedPosition());
        this.addKeyListener(this);
        this.pack();
    }

    private boolean canSelect(Position position) {
        return position.getX() >= 0 && position.getX() < this.xDimension && position.getY() >= 0 && position.getY() < this.yDimension && this.calculateIndex(position) < this.numOfIcons;
    }

    private int calculateIndex(Position position) {
        return position.getY() * this.xDimension + position.getX();
    }

    private Position getPosition(JLabel caller) {
        int index = 0;
        for (index = 0; index < this.iconLabels.length && caller != this.iconLabels[index]; ++index) {
        }
        return new Position(index % this.xDimension, index / this.xDimension);
    }

    private void setSelectedPosition(Position position) {
        this.selected = position;
        lastPosition = position;
    }

    private Position getSelectedPosition() {
        return this.selected;
    }

    private void select(Position position) {
        this.unhighlight(this.getSelectedPosition());
        this.setSelectedPosition(position);
        this.highlight(position);
        this.descriptionLabel.setText((String)this.descriptions.get(this.calculateIndex(position)));
    }

    private void unhighlight(Position position) {
        this.iconLabels[this.calculateIndex(position)].setBorder(BorderFactory.createBevelBorder(0));
    }

    private void highlight(Position position) {
        this.iconLabels[this.calculateIndex(position)].setBorder(BorderFactory.createBevelBorder(1));
    }

    private void cursorLeft() {
        Position newPosition = new Position(this.getSelectedPosition().getX() - 1, this.getSelectedPosition().getY());
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorRight() {
        Position newPosition = new Position(this.getSelectedPosition().getX() + 1, this.getSelectedPosition().getY());
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorUp() {
        Position newPosition = new Position(this.getSelectedPosition().getX(), this.getSelectedPosition().getY() - 1);
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void cursorDown() {
        Position newPosition = new Position(this.getSelectedPosition().getX(), this.getSelectedPosition().getY() + 1);
        if (this.canSelect(newPosition)) {
            this.select(newPosition);
        }
    }

    private void addIcon() {
        this.result = this.calculateIndex(this.getSelectedPosition());
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public void keyPressed(KeyEvent arg0) {
        switch (arg0.getKeyCode()) {
            case 39: 
            case 227: {
                this.cursorRight();
                break;
            }
            case 37: 
            case 226: {
                this.cursorLeft();
                break;
            }
            case 40: 
            case 225: {
                this.cursorDown();
                break;
            }
            case 38: 
            case 224: {
                this.cursorUp();
                break;
            }
            case 27: {
                arg0.consume();
                this.close();
                break;
            }
            case 10: 
            case 32: {
                arg0.consume();
                this.addIcon();
            }
        }
    }

    private void close() {
        this.result = -1;
        this.dispose();
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent arg0) {
    }

    public void mouseClicked(MouseEvent arg0) {
        this.addIcon();
    }

    public void mouseEntered(MouseEvent arg0) {
        this.select(this.getPosition((JLabel)arg0.getSource()));
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    static class Position {
        private int x;
        private int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "(" + this.getX() + "," + this.getY() + ")";
        }
    }
}

