/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.ModeControllerHookAdapter;
import freemind.modes.NodeAdapter;
import freemind.view.mindmapview.MapView;
import java.awt.Rectangle;

public class FitToPage
extends ModeControllerHookAdapter {
    private MapView view;

    public void startupMapHook() {
        super.startupMapHook();
        this.view = this.getController().getView();
        if (this.view == null) {
            return;
        }
        this.zoom();
        this.scroll();
    }

    private void scroll() {
        NodeAdapter root = (NodeAdapter)this.getController().getMap().getRoot();
        Rectangle rect = this.view.getInnerBounds(root.getViewer());
        Rectangle viewer = this.view.getVisibleRect();
        this.view.scrollBy(rect.x - viewer.x, rect.y - viewer.y, false);
    }

    private void zoom() {
        NodeAdapter root = (NodeAdapter)this.getController().getMap().getRoot();
        Rectangle rect = this.view.getInnerBounds(root.getViewer());
        double oldZoom = this.getController().getView().getZoom();
        Rectangle viewer = this.view.getVisibleRect();
        this.logger.info("Found viewer rect=" + viewer.height + "/" + rect.height + ", " + viewer.width + "/" + rect.width);
        double newZoom = (double)viewer.width * oldZoom / ((double)rect.width + 0.0);
        double heightZoom = (double)viewer.height * oldZoom / ((double)rect.height + 0.0);
        if (heightZoom < newZoom) {
            newZoom = heightZoom;
        }
        this.logger.info("Calculated new zoom " + newZoom);
        this.getController().getController().setZoom((float)newZoom);
    }
}

