/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import accessories.plugins.dialogs.EnterPasswordDialog;
import freemind.controller.MenuItemEnabledListener;
import freemind.extensions.HookRegistration;
import freemind.extensions.NodeHookAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.actions.NodeHookAction;
import freemind.modes.mindmapmode.EncryptedMindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class EncryptNode
extends NodeHookAdapter {
    public void invoke(MindMapNode node) {
        super.invoke(node);
        String actionType = this.getResourceString("action");
        if (actionType.equals("encrypt")) {
            this.encrypt(node);
            return;
        }
        if (actionType.equals("toggleCryptState")) {
            this.toggleCryptState(node);
            return;
        }
        if (actionType.equals("encrypted_map")) {
            this.newEncryptedMap();
            return;
        }
        throw new IllegalArgumentException("Unknown action type:" + actionType);
    }

    private void newEncryptedMap() {
        StringBuffer password = this.getUsersPassword();
        if (password == null) {
            return;
        }
        EncryptedMindMapNode encryptedMindMapNode = new EncryptedMindMapNode(this.getController().getText("accessories/plugins/EncryptNode.properties_select_me"), this.getController().getFrame());
        encryptedMindMapNode.setPassword(password);
        MindMapMapModel newModel = new MindMapMapModel(encryptedMindMapNode, this.getController().getFrame());
        MindMapController mindmapcontroller = (MindMapController)this.getController();
        mindmapcontroller.newMap(newModel);
    }

    private void encrypt(MindMapNode node) {
        final StringBuffer password = this.getUsersPassword();
        if (password == null) {
            return;
        }
        MindMapController mindmapcontroller = (MindMapController)this.getController();
        mindmapcontroller.setNewNodeCreator(new MindMapController.NewNodeCreator(){

            public MindMapNode createNode(Object userObject) {
                EncryptedMindMapNode encryptedMindMapNode = new EncryptedMindMapNode(userObject, EncryptNode.this.getController().getFrame());
                encryptedMindMapNode.setPassword(password);
                return encryptedMindMapNode;
            }
        });
        try {
            MindMapNode newNode = this.getController().addNewNode(node, 0, node.isLeft());
        }
        catch (Exception e) {
            // empty catch block
        }
        mindmapcontroller.setNewNodeCreator(null);
    }

    private StringBuffer getUsersPassword() {
        EnterPasswordDialog pwdDialog = new EnterPasswordDialog((JFrame)((Object)this.getController().getFrame()), this.getController(), true);
        pwdDialog.setModal(true);
        pwdDialog.show();
        if (pwdDialog.getResult() == -1) {
            return null;
        }
        StringBuffer password = pwdDialog.getPassword();
        return password;
    }

    private void toggleCryptState(MindMapNode node) {
        if (node instanceof EncryptedMindMapNode) {
            EncryptedMindMapNode encNode = (EncryptedMindMapNode)node;
            if (encNode.isVisible()) {
                encNode.encrypt();
                encNode.setShuttingDown(true);
            } else {
                this.doPasswordCheckAndDecryptNode(encNode);
            }
            this.getController().nodeStructureChanged(encNode);
            this.getController().getView().selectAsTheOnlyOneSelected(encNode.getViewer());
            encNode.setShuttingDown(false);
        } else {
            JOptionPane.showMessageDialog(this.getController().getFrame().getContentPane(), this.getController().getText("accessories/plugins/EncryptNode.properties_insert_encrypted_node_first"), "Freemind", 1);
        }
    }

    private void doPasswordCheckAndDecryptNode(EncryptedMindMapNode encNode) {
        while (true) {
            EnterPasswordDialog pwdDialog = new EnterPasswordDialog((JFrame)((Object)this.getController().getFrame()), this.getController(), false);
            pwdDialog.setModal(true);
            pwdDialog.show();
            if (pwdDialog.getResult() == -1) {
                return;
            }
            if (encNode.decrypt(pwdDialog.getPassword())) break;
            JOptionPane.showMessageDialog(this.getController().getFrame().getContentPane(), this.getController().getText("accessories/plugins/EncryptNode.properties_wrong_password"), "Freemind", 0);
        }
    }

    public static class Registration
    implements HookRegistration,
    MenuItemEnabledListener {
        private final ModeController controller;
        private final MindMap mMap;
        private final Logger logger;
        private boolean enabled = false;

        public Registration(ModeController controller, MindMap map) {
            this.controller = controller;
            this.mMap = map;
            this.logger = controller.getFrame().getLogger(this.getClass().getName());
        }

        public void register() {
            this.enabled = true;
        }

        public void deRegister() {
            this.enabled = false;
        }

        public boolean isEnabled(JMenuItem item, Action action) {
            String hookName = ((NodeHookAction)action).getHookName();
            if (!this.enabled) {
                return false;
            }
            boolean isEncryptedNode = false;
            boolean isOpened = false;
            if (this.controller.getSelected() != null && this.controller.getSelected() instanceof EncryptedMindMapNode) {
                isEncryptedNode = true;
                EncryptedMindMapNode enode = (EncryptedMindMapNode)this.controller.getSelected();
                isOpened = enode.isVisible();
            }
            if (hookName.equals("accessories/plugins/EnterPassword.properties")) {
                return isEncryptedNode;
            }
            return !isEncryptedNode || isOpened;
        }
    }
}

