/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.SVGImageElementBridge;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.JpegImage;
import org.apache.fop.image.analyser.ImageReaderFactory;
import org.apache.fop.svg.PDFGraphics2D;
import org.w3c.dom.Element;

public class PDFImageElementBridge
extends SVGImageElementBridge {
    protected GraphicsNode createImageGraphicsNode(BridgeContext ctx, Element e, ParsedURL purl) {
        GraphicsNode origGN = super.createImageGraphicsNode(ctx, e, purl);
        try {
            FopImage.ImageInfo ii = ImageReaderFactory.make(purl.toString(), purl.openStream(), null);
            if (ii.mimeType.toLowerCase() == "image/jpeg") {
                JpegImage jpeg = new JpegImage(ii);
                jpeg.load(2, null);
                PDFJpegNode node = new PDFJpegNode(jpeg, origGN);
                Rectangle2D imgBounds = SVGImageElementBridge.getImageBounds((BridgeContext)ctx, (Element)e);
                Rectangle2D bounds = node.getPrimitiveBounds();
                float[] vb = new float[]{0.0f, 0.0f, (float)bounds.getWidth(), (float)bounds.getHeight()};
                SVGImageElementBridge.initializeViewport((BridgeContext)ctx, (Element)e, (GraphicsNode)node, (float[])vb, (Rectangle2D)imgBounds);
                return node;
            }
        }
        catch (Exception ex) {}
        return origGN;
    }

    public static class PDFJpegNode
    extends AbstractGraphicsNode {
        private JpegImage jpeg;
        private GraphicsNode origGraphicsNode;

        public PDFJpegNode(JpegImage j, GraphicsNode origGraphicsNode) {
            this.jpeg = j;
            this.origGraphicsNode = origGraphicsNode;
        }

        public Shape getOutline() {
            return this.getPrimitiveBounds();
        }

        public void primitivePaint(Graphics2D g2d) {
            if (g2d instanceof PDFGraphics2D) {
                PDFGraphics2D pdfg = (PDFGraphics2D)((Object)g2d);
                float x = 0.0f;
                float y = 0.0f;
                try {
                    float width = this.jpeg.getWidth();
                    float height = this.jpeg.getHeight();
                    pdfg.addJpegImage(this.jpeg, x, y, width, height);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.origGraphicsNode.primitivePaint(g2d);
            }
        }

        public Rectangle2D getGeometryBounds() {
            return this.getPrimitiveBounds();
        }

        public Rectangle2D getPrimitiveBounds() {
            try {
                return new Rectangle2D.Double(0.0, 0.0, this.jpeg.getWidth(), this.jpeg.getHeight());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Rectangle2D getSensitiveBounds() {
            return this.getPrimitiveBounds();
        }
    }
}

