/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.fop.pdf.PDFGState;

public class PDFState {
    private static final String COLOR = "color";
    private static final String BACKCOLOR = "backcolor";
    private static final String PAINT = "paint";
    private static final String BACKPAINT = "backpaint";
    private static final String LINECAP = "lineCap";
    private static final String LINEJOIN = "lineJoin";
    private static final String LINEWIDTH = "lineWidth";
    private static final String MITERLIMIT = "miterLimit";
    private static final String TEXT = "text";
    private static final String DASHOFFSET = "dashOffset";
    private static final String DASHARRAY = "dashArray";
    private static final String TRANSFORM = "transform";
    private static final String FONTSIZE = "fontSize";
    private static final String FONTNAME = "fontName";
    private static final String CLIP = "clip";
    private static final String GSTATE = "gstate";
    private Color color = Color.black;
    private Color backcolor = Color.white;
    private Paint paint = null;
    private Paint backPaint = null;
    private int lineCap = 0;
    private int lineJoin = 0;
    private float lineWidth = 1.0f;
    private float miterLimit = 0.0f;
    private boolean text = false;
    private int dashOffset = 0;
    private int[] dashArray = new int[0];
    private AffineTransform transform = new AffineTransform();
    private float fontSize = 0.0f;
    private String fontName = "";
    private Shape clip = null;
    private PDFGState gstate = null;
    private ArrayList stateStack = new ArrayList();

    public boolean checkClip(Shape cl) {
        return this.clip == null ? cl != null : !new Area(this.clip).equals(new Area(cl));
    }

    public boolean checkTransform(AffineTransform tf) {
        return tf.equals(this.transform) ^ true;
    }

    public PDFGState getGState() {
        PDFGState defaultState = PDFGState.DEFAULT;
        PDFGState newstate = new PDFGState();
        newstate.addValues(defaultState);
        Iterator iter = ((AbstractList)this.stateStack).iterator();
        while (iter.hasNext()) {
            HashMap map = (HashMap)iter.next();
            PDFGState state = (PDFGState)map.get(GSTATE);
            if (state == null) continue;
            newstate.addValues(state);
        }
        if (this.gstate != null) {
            newstate.addValues(this.gstate);
        }
        return newstate;
    }

    public int getStackLevel() {
        return this.stateStack.size();
    }

    public AffineTransform getTransform() {
        AffineTransform at = new AffineTransform();
        Iterator iter = ((AbstractList)this.stateStack).iterator();
        while (iter.hasNext()) {
            HashMap map = (HashMap)iter.next();
            AffineTransform tf = (AffineTransform)map.get(TRANSFORM);
            at.concatenate(tf);
        }
        at.concatenate(this.transform);
        return at;
    }

    public void pop() {
        if (this.getStackLevel() > 0) {
            HashMap saveMap = (HashMap)this.stateStack.get(this.stateStack.size() - 1);
            this.stateStack.remove(this.stateStack.size() - 1);
            this.color = (Color)saveMap.get(COLOR);
            this.backcolor = (Color)saveMap.get(BACKCOLOR);
            this.paint = (Paint)saveMap.get(PAINT);
            this.backPaint = (Paint)saveMap.get(BACKPAINT);
            this.lineCap = (Integer)saveMap.get(LINECAP);
            this.lineJoin = (Integer)saveMap.get(LINEJOIN);
            this.lineWidth = ((Float)saveMap.get(LINEWIDTH)).floatValue();
            this.miterLimit = ((Float)saveMap.get(MITERLIMIT)).floatValue();
            this.text = (Boolean)saveMap.get(TEXT);
            this.dashOffset = (Integer)saveMap.get(DASHOFFSET);
            this.dashArray = (int[])saveMap.get(DASHARRAY);
            this.transform = (AffineTransform)saveMap.get(TRANSFORM);
            this.fontSize = ((Float)saveMap.get(FONTSIZE)).floatValue();
            this.fontName = (String)saveMap.get(FONTNAME);
            this.clip = (Shape)saveMap.get(CLIP);
            this.gstate = (PDFGState)saveMap.get(GSTATE);
        }
    }

    public void push() {
        HashMap<String, Object> saveMap = new HashMap<String, Object>();
        saveMap.put(COLOR, this.color);
        saveMap.put(BACKCOLOR, this.backcolor);
        saveMap.put(PAINT, this.paint);
        saveMap.put(BACKPAINT, this.backPaint);
        saveMap.put(LINECAP, new Integer(this.lineCap));
        saveMap.put(LINEJOIN, new Integer(this.lineJoin));
        saveMap.put(LINEWIDTH, new Float(this.lineWidth));
        saveMap.put(MITERLIMIT, new Float(this.miterLimit));
        saveMap.put(TEXT, new Boolean(this.text));
        saveMap.put(DASHOFFSET, new Integer(this.dashOffset));
        saveMap.put(DASHARRAY, this.dashArray);
        saveMap.put(TRANSFORM, this.transform);
        saveMap.put(FONTSIZE, new Float(this.fontSize));
        saveMap.put(FONTNAME, this.fontName);
        saveMap.put(CLIP, this.clip);
        saveMap.put(GSTATE, this.gstate);
        this.stateStack.add(saveMap);
        this.transform = new AffineTransform();
    }

    public void restoreLevel(int stack) {
        int pos = stack;
        while (this.stateStack.size() > pos + 1) {
            this.stateStack.remove(this.stateStack.size() - 1);
        }
        if (this.stateStack.size() > pos) {
            this.pop();
        }
    }

    public boolean setBackColor(Color col) {
        if (!col.equals(this.backcolor)) {
            this.backcolor = col;
            return true;
        }
        return false;
    }

    public void setClip(Shape cl) {
        if (this.clip != null) {
            Area newClip = new Area(this.clip);
            newClip.intersect(new Area(cl));
            this.clip = new GeneralPath(newClip);
        } else {
            this.clip = cl;
        }
    }

    public boolean setColor(Color col) {
        if (!col.equals(this.color)) {
            this.color = col;
            return true;
        }
        return false;
    }

    public boolean setLineDash(int[] array, int offset) {
        return false;
    }

    public boolean setPaint(Paint p) {
        if (this.paint == null) {
            if (p != null) {
                this.paint = p;
                return true;
            }
        } else if (!this.paint.equals(p)) {
            this.paint = p;
            return true;
        }
        return false;
    }

    public void setTransform(AffineTransform tf) {
        this.transform.concatenate(tf);
    }
}

