/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.Effect;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.control.ChangeSet;
import net.sf.freecol.server.model.LootSession;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPlayer
extends Player
implements ServerModelObject {
    private static final Logger logger = Logger.getLogger(ServerPlayer.class.getName());
    public static final int ALARM_RADIUS = 2;
    public static final int ALARM_TILE_IN_USE = 2;
    public static final int ALARM_MISSIONARY_PRESENT = -10;
    public static final int IS_DEAD = -1;
    public static final int IS_ALIVE = 0;
    public static final int AUTORECRUIT = 1;
    public static final int MAX_CONVERT_DISTANCE = 10;
    private Socket socket;
    private Connection connection;
    private boolean connected = false;
    private int remainingEmigrants = 0;
    private List<ServerPlayer> stanceDirty = new ArrayList<ServerPlayer>();

    public ServerPlayer(Game game, String id) {
        super(game, id);
    }

    public ServerPlayer(Game game, String name, boolean admin, Nation nation, Socket socket, Connection connection) {
        super(game);
        this.name = name;
        this.admin = admin;
        this.europe = null;
        if (nation != null && nation.getType() != null) {
            this.nationType = nation.getType();
            this.nationID = nation.getId();
            try {
                this.addFeatures(this.nationType);
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
            if (this.nationType.isEuropean()) {
                this.playerType = this.nationType.isREF() ? Player.PlayerType.ROYAL : Player.PlayerType.COLONIAL;
                this.europe = new ServerEurope(game, this);
                this.initializeHighSeas();
                if (this.playerType == Player.PlayerType.COLONIAL) {
                    this.monarch = new Monarch(game, this, nation.getRulerNameKey());
                }
                this.gold = 0;
            } else {
                this.playerType = Player.PlayerType.NATIVE;
                this.gold = Integer.MIN_VALUE;
            }
        } else {
            this.nationID = Nation.UNKNOWN_NATION_ID;
            this.playerType = Player.PlayerType.COLONIAL;
            this.gold = 0;
        }
        this.market = new Market(this.getGame(), this);
        this.immigration = 0;
        this.liberty = 0;
        this.currentFather = null;
        String curId = this.getId();
        game.removeFreeColGameObject(curId);
        game.setFreeColGameObject(curId, this);
        this.socket = socket;
        this.connection = connection;
        this.connected = connection != null;
        this.resetExploredTiles(this.getGame().getMap());
        this.invalidateCanSeeTiles();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.connected = connection != null;
    }

    public void startGame(Random random) {
        Specification spec = this.getGame().getSpecification();
        if (this.isEuropean() && !this.isREF()) {
            this.modifyGold(spec.getInteger("model.option.startingMoney"));
            ((ServerEurope)this.getEurope()).initializeMigration(random);
            this.getMarket().randomizeInitialPrice(random);
        }
    }

    public int checkForDeath() {
        Specification spec = this.getGame().getSpecification();
        switch (this.getPlayerType()) {
            case NATIVE: {
                return this.getUnits().isEmpty() ? -1 : 0;
            }
            case COLONIAL: {
                if (!this.isUnknownEnemy()) break;
                return 0;
            }
            case REBEL: 
            case INDEPENDENT: {
                for (Colony colony : this.getColonies()) {
                    if (!colony.isConnectedPort()) continue;
                    return 0;
                }
                return -1;
            }
            case ROYAL: {
                return this.getRebels().isEmpty() ? -1 : 0;
            }
            case UNDEAD: {
                return this.getUnits().isEmpty() ? -1 : 0;
            }
            default: {
                throw new IllegalStateException("Bogus player type");
            }
        }
        if (!this.getColonies().isEmpty()) {
            return 0;
        }
        boolean hasCarrier = false;
        boolean hasColonist = false;
        boolean hasEmbarked = false;
        boolean hasGoods = false;
        for (Unit unit : this.getUnits()) {
            if (unit.isCarrier()) {
                if (unit.hasGoodsCargo()) {
                    hasGoods = true;
                }
                hasCarrier = true;
                continue;
            }
            if (!unit.isColonist() && !unit.isOffensiveUnit()) continue;
            hasColonist = true;
            Unit carrier = unit.getCarrier();
            if (carrier != null) {
                if (carrier.getTile() != null) {
                    logger.info(this.getName() + " alive, unit (embarked) on map.");
                    return 0;
                }
                hasEmbarked = true;
            }
            if (unit.getTile() == null) continue;
            logger.info(this.getName() + " alive, unit on map.");
            return 0;
        }
        int mandatory = spec.getInteger("model.option.mandatoryColonyYear");
        if (this.getGame().getTurn().getYear() >= mandatory) {
            logger.info(this.getName() + " dead, no presence >= " + mandatory);
            return -1;
        }
        if (hasEmbarked) {
            logger.info(this.getName() + " alive, has embarked unit.");
            return 0;
        }
        if (hasGoods) {
            logger.info(this.getName() + " alive, has cargo.");
            return 0;
        }
        Europe europe = this.getEurope();
        int goldNeeded = 0;
        if (!hasCarrier) {
            int price = Integer.MAX_VALUE;
            if (europe != null) {
                for (UnitType type : spec.getUnitTypesWithAbility("model.ability.navalUnit")) {
                    int p = europe.getUnitPrice(type);
                    if (p == Integer.MIN_VALUE || p >= price) continue;
                    price = p;
                }
            }
            if (price == Integer.MAX_VALUE || !this.checkGold(price)) {
                logger.info(this.getName() + " dead, can not buy carrier.");
                return -1;
            }
            goldNeeded += price;
        }
        if (hasColonist) {
            logger.info(this.getName() + " alive, has waiting colonist.");
            return 0;
        }
        if (europe == null) {
            logger.info(this.getName() + " dead, can not recruit.");
            return -1;
        }
        Object unitType = null;
        int price = europe.getRecruitPrice();
        for (UnitType type : spec.getUnitTypesWithAbility("model.ability.foundColony")) {
            int p = europe.getUnitPrice(type);
            if (p == Integer.MIN_VALUE || p >= price) continue;
            price = p;
        }
        if (this.checkGold(goldNeeded += price)) {
            logger.info(this.getName() + " alive, can buy colonist.");
            return 0;
        }
        logger.info(this.getName() + " survives by autorecruit.");
        return 1;
    }

    public boolean checkForREFDefeat() {
        if (!this.isREF()) {
            throw new IllegalStateException("Checking for REF player defeat when player not REF.");
        }
        if (this.getRebels().isEmpty()) {
            return false;
        }
        if (!this.getSettlements().isEmpty()) {
            return false;
        }
        int landREFUnitsRequired = 7;
        CombatModel cm = this.getGame().getCombatModel();
        boolean naval = false;
        int land = 0;
        int power = 0;
        for (Unit u : this.getUnits()) {
            if (u.isNaval()) {
                naval = true;
                continue;
            }
            if (!u.hasAbility("model.ability.refUnit")) continue;
            ++land;
            power = (int)((float)power + cm.getOffencePower(u, null));
        }
        if (naval && land >= 7) {
            return false;
        }
        int rebelPower = 0;
        for (Player rebel : this.getRebels()) {
            for (Unit r : rebel.getUnits()) {
                if (r.isNaval()) continue;
                rebelPower = (int)((float)rebelPower + cm.getOffencePower(r, null));
            }
        }
        return power <= rebelPower;
    }

    public void csKillMissionary(IndianSettlement settlement, String messageId, ChangeSet cs) {
        Unit missionary = settlement.getMissionary();
        settlement.changeMissionary(null);
        cs.add(ChangeSet.See.only(this), settlement);
        cs.addDispose(ChangeSet.See.perhaps().always(this), settlement.getTile(), missionary);
        if ("indianSettlement.mission.denounced".equals(messageId)) {
            cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, settlement).addStringTemplate("%settlement%", settlement.getLocationNameFor(this)));
        } else if ("indianSettlement.mission.destroyed".equals(messageId)) {
            cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.UNIT_LOST, messageId, settlement).addStringTemplate("%settlement%", settlement.getLocationNameFor(this)));
        }
    }

    public void csKill(ChangeSet cs) {
        this.setDead(true);
        cs.addPartial(ChangeSet.See.all(), this, "dead");
        cs.addDead(this);
        for (Player other : this.getGame().getPlayers()) {
            if (other == this) continue;
            if (this.isEuropean() && other.isIndian()) {
                for (IndianSettlement s : other.getIndianSettlements()) {
                    Unit unit = s.getMissionary();
                    if (unit != null && (ServerPlayer)unit.getOwner() == this) {
                        this.csKillMissionary(s, null, cs);
                    }
                    s.removeAlarm(this);
                }
                other.removeTension(this);
            }
            other.setStance(this, null);
        }
        List<Settlement> settlements = this.getSettlements();
        while (!settlements.isEmpty()) {
            Settlement settlement = settlements.remove(0);
            cs.addDispose(ChangeSet.See.perhaps().always(this), settlement.getTile(), settlement);
        }
        for (Tile tile : this.getGame().getMap().getAllTiles()) {
            if (tile.getOwner() != this) continue;
            tile.changeOwnership(null, null);
            cs.add(ChangeSet.See.perhaps().always(this), tile);
        }
        List<Unit> units = this.getUnits();
        while (!units.isEmpty()) {
            Unit unit = units.remove(0);
            if (unit.getLocation() instanceof Tile) {
                cs.add(ChangeSet.See.perhaps().always(this), unit.getTile());
            }
            cs.addDispose(ChangeSet.See.perhaps().always(this), unit.getLocation(), unit);
        }
    }

    public void csWithdraw(ChangeSet cs) {
        cs.addMessage(ChangeSet.See.all(), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, this.isEuropean() && this.getPlayerType() == Player.PlayerType.COLONIAL ? "model.diplomacy.dead.european" : "model.diplomacy.dead.native", this).addStringTemplate("%nation%", this.getNationName()));
        Game game = this.getGame();
        cs.addGlobalHistory(game, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.NATION_DESTROYED).addStringTemplate("%nation%", this.getNationName()));
        this.csKill(cs);
    }

    public int getRemainingEmigrants() {
        return this.remainingEmigrants;
    }

    public void setRemainingEmigrants(int emigrants) {
        this.remainingEmigrants = emigrants;
    }

    public FoundingFather checkFoundingFather() {
        int extraLiberty;
        FoundingFather father = null;
        if (this.currentFather != null && (extraLiberty = this.getRemainingFoundingFatherCost()) <= 0) {
            boolean overflow = this.getSpecification().getBoolean("model.option.saveProductionOverflow");
            this.setLiberty(overflow ? -extraLiberty : 0);
            father = this.currentFather;
            this.currentFather = null;
        }
        return father;
    }

    public boolean canRecruitFoundingFather() {
        Specification spec = this.getGame().getSpecification();
        switch (this.getPlayerType()) {
            case COLONIAL: {
                break;
            }
            case REBEL: 
            case INDEPENDENT: {
                if (spec.getBoolean("model.option.continueFoundingFatherRecruitment")) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return this.canHaveFoundingFathers() && this.currentFather == null && !this.getSettlements().isEmpty() && this.getFatherCount() < spec.getFoundingFathers().size();
    }

    public List<FoundingFather> getRandomFoundingFathers(Random random) {
        Specification spec = this.getGame().getSpecification();
        int age = this.getGame().getTurn().getAge();
        EnumMap choices = new EnumMap(FoundingFather.FoundingFatherType.class);
        for (FoundingFather father : spec.getFoundingFathers()) {
            if (this.hasFather(father) || !father.isAvailableTo(this)) continue;
            FoundingFather.FoundingFatherType type = father.getType();
            ArrayList<RandomChoice<FoundingFather>> rc = (ArrayList<RandomChoice<FoundingFather>>)choices.get((Object)type);
            if (rc == null) {
                rc = new ArrayList<RandomChoice<FoundingFather>>();
            }
            int weight = father.getWeight(age);
            rc.add(new RandomChoice<FoundingFather>(father, weight));
            choices.put(father.getType(), rc);
        }
        ArrayList<FoundingFather> randomFathers = new ArrayList<FoundingFather>();
        String logMessage = "Random fathers";
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            FoundingFather f;
            List rc = (List)choices.get((Object)type);
            if (rc == null || (f = (FoundingFather)RandomChoice.getWeightedRandom(logger, "Choose founding father", random, rc)) == null) continue;
            randomFathers.add(f);
            logMessage = logMessage + ":" + f.getNameKey();
        }
        logger.info(logMessage);
        return randomFathers;
    }

    public List<RandomChoice<UnitType>> generateRecruitablesList() {
        ArrayList<RandomChoice<UnitType>> recruitables = new ArrayList<RandomChoice<UnitType>>();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isRecruitable() || !this.hasAbility("model.ability.canRecruitUnit", unitType)) continue;
            recruitables.add(new RandomChoice<UnitType>(unitType, unitType.getRecruitProbability()));
        }
        return recruitables;
    }

    @Override
    public void addHistory(HistoryEvent event) {
        this.history.add(event);
    }

    public void resetExploredTiles(Map map) {
        if (map != null) {
            for (Unit unit : this.getUnits()) {
                Tile tile = unit.getTile();
                if (tile == null) continue;
                this.setExplored(tile);
                int radius = unit.getColony() != null ? unit.getColony().getLineOfSight() : unit.getLineOfSight();
                for (Tile t : tile.getSurroundingTiles(radius)) {
                    this.setExplored(t);
                }
            }
        }
    }

    @Override
    public boolean hasExplored(Tile tile) {
        return tile.isExploredBy(this);
    }

    @Override
    public void setExplored(Tile tile) {
        tile.setExploredBy(this, true);
    }

    public List<Tile> exploreMap(boolean reveal) {
        ArrayList<Tile> result = new ArrayList<Tile>();
        for (Tile tile : this.getGame().getMap().getAllTiles()) {
            if (tile.isExploredBy(this) == reveal) continue;
            tile.setExploredBy(this, reveal);
            result.add(tile);
        }
        this.resetExploredTiles(this.getGame().getMap());
        this.invalidateCanSeeTiles();
        return result;
    }

    @Override
    public void setExplored(Unit unit) {
        if (this.getGame() == null || this.getGame().getMap() == null || unit == null || unit.getLocation() == null || unit.getTile() == null) {
            return;
        }
        Tile tile = unit.getTile();
        this.setExplored(tile);
        for (Tile t : tile.getSurroundingTiles(unit.getLineOfSight())) {
            this.setExplored(t);
        }
        this.invalidateCanSeeTiles();
    }

    public List<Unit> createUnits(List<AbstractUnit> abstractUnits, Location location) {
        Game game = this.getGame();
        ArrayList<Unit> units = new ArrayList<Unit>();
        if (location == null) {
            return units;
        }
        Specification spec = game.getSpecification();
        for (AbstractUnit au : abstractUnits) {
            for (int i = 0; i < au.getNumber(); ++i) {
                units.add(new ServerUnit(game, location, this, au.getUnitType(spec), au.getEquipment(spec)));
            }
        }
        return units;
    }

    public List<Unit> loadShips(List<Unit> landUnits, List<Unit> navalUnits, Random random) {
        ArrayList<Unit> leftOver = new ArrayList<Unit>();
        Collections.shuffle(navalUnits, random);
        Collections.shuffle(landUnits, random);
        block0: for (Unit unit : landUnits) {
            for (Unit carrier : navalUnits) {
                if (!carrier.canAdd(unit)) continue;
                unit.setLocation(carrier);
                logger.finest("Loading " + unit + " onto carrier " + carrier);
                continue block0;
            }
            leftOver.add(unit);
        }
        return leftOver;
    }

    public int priceMercenaries(List<AbstractUnit> mercenaries) {
        int mercPrice = 0;
        for (AbstractUnit au : mercenaries) {
            mercPrice += this.getPrice(au);
        }
        if (!this.checkGold(mercPrice)) {
            mercPrice = this.getGold();
        }
        return mercPrice;
    }

    private void propagateToEuropeanMarkets(GoodsType type, int amount, Random random) {
        if (!type.isStorable()) {
            return;
        }
        int lowerBound = 5;
        int upperBound = 30;
        amount *= Utils.randomInt(logger, "Propagate goods", random, 26) + 5;
        if ((amount /= 100) == 0) {
            return;
        }
        for (Player other : this.getGame().getLiveEuropeanPlayers()) {
            Market market;
            if ((ServerPlayer)other == this || (market = other.getMarket()) == null) continue;
            market.addGoodsToMarket(type, amount);
        }
    }

    public void csFlushMarket(GoodsType type, ChangeSet cs) {
        Market market = this.getMarket();
        if (market.hasPriceChanged(type)) {
            cs.addMessage(ChangeSet.See.only(this), market.makePriceChangeMessage(type));
            market.flushPriceChange(type);
            cs.add(ChangeSet.See.only(this), market.getMarketData(type));
        }
    }

    public void buy(GoodsContainer container, GoodsType type, int amount, Random random) throws IllegalStateException {
        logger.finest(this.getName() + " buys " + amount + " " + type);
        Market market = this.getMarket();
        int price = market.getBidPrice(type, amount);
        if (!this.checkGold(price)) {
            throw new IllegalStateException("Player " + this.getName() + " tried to buy " + Integer.toString(amount) + " " + type.toString() + " for " + Integer.toString(price) + " but has " + Integer.toString(this.getGold()) + " gold.");
        }
        this.modifyGold(-price);
        market.modifySales(type, -amount);
        market.modifyIncomeBeforeTaxes(type, -price);
        market.modifyIncomeAfterTaxes(type, -price);
        int marketAmount = -((int)this.applyModifier(amount, "model.modifier.tradeBonus", type, this.getGame().getTurn()));
        market.addGoodsToMarket(type, marketAmount);
        this.propagateToEuropeanMarkets(type, marketAmount, random);
        container.addGoods(type, amount);
    }

    public void sell(GoodsContainer container, GoodsType type, int amount, Random random) {
        logger.finest(this.getName() + " sells " + amount + " " + type);
        Market market = this.getMarket();
        int tax = this.getTax();
        int incomeBeforeTaxes = market.getSalePrice(type, amount);
        int incomeAfterTaxes = (100 - tax) * incomeBeforeTaxes / 100;
        this.modifyGold(incomeAfterTaxes);
        market.modifySales(type, amount);
        market.modifyIncomeBeforeTaxes(type, incomeBeforeTaxes);
        market.modifyIncomeAfterTaxes(type, incomeAfterTaxes);
        int marketAmount = (int)this.applyModifier(amount, "model.modifier.tradeBonus", type, this.getGame().getTurn());
        market.addGoodsToMarket(type, marketAmount);
        this.propagateToEuropeanMarkets(type, marketAmount, random);
        if (container != null) {
            container.addGoods(type, -amount);
        }
    }

    public void addStanceChange(ServerPlayer other) {
        if (!this.stanceDirty.contains(other)) {
            this.stanceDirty.add(other);
        }
    }

    public boolean csChangeStance(Player.Stance stance, Player otherPlayer, boolean symmetric, ChangeSet cs) {
        int modifier;
        ServerPlayer other = (ServerPlayer)otherPlayer;
        boolean change = false;
        Player.Stance old = this.getStance(otherPlayer);
        if (old != stance) {
            modifier = old.getTensionModifier(stance);
            this.setStance(otherPlayer, stance);
            if (modifier != 0) {
                cs.add(ChangeSet.See.only(null).perhaps(other), this.modifyTension(otherPlayer, modifier));
            }
            logger.info("Stance modification " + this.getName() + " " + old.toString() + " -> " + stance.toString() + " wrt " + otherPlayer.getName());
            this.addStanceChange(other);
            cs.addMessage(ChangeSet.See.only(other), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + (Object)((Object)stance) + ".declared", this).addStringTemplate("%nation%", this.getNationName()));
            cs.addStance(ChangeSet.See.only(this), this, stance, otherPlayer);
            cs.addStance(ChangeSet.See.only(other), this, stance, otherPlayer);
            change = true;
        }
        if (symmetric && (old = otherPlayer.getStance(this)) != stance) {
            modifier = old.getTensionModifier(stance);
            otherPlayer.setStance(this, stance);
            if (modifier != 0) {
                cs.add(ChangeSet.See.only(null).perhaps(this), otherPlayer.modifyTension(this, modifier));
            }
            logger.info("Stance modification " + otherPlayer.getName() + " " + old.toString() + " -> " + stance.toString() + " wrt " + this.getName() + " (symmetric)");
            other.addStanceChange(this);
            cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + (Object)((Object)stance) + ".declared", otherPlayer).addStringTemplate("%nation%", otherPlayer.getNationName()));
            cs.addStance(ChangeSet.See.only(this), otherPlayer, stance, this);
            cs.addStance(ChangeSet.See.only(other), otherPlayer, stance, this);
            change = true;
        }
        return change;
    }

    @Override
    public void csNewTurn(Random random, ChangeSet cs) {
        logger.finest("ServerPlayer.csNewTurn, for " + this.getName());
        ArrayList<Settlement> settlements = new ArrayList<Settlement>(this.getSettlements());
        int newSoL = 0;
        for (Settlement settlement : settlements) {
            ((ServerModelObject)((Object)settlement)).csNewTurn(random, cs);
            newSoL += settlement.getSoL();
        }
        int numberOfColonies = settlements.size();
        if (numberOfColonies > 0) {
            if (this.oldSoL / 10 != (newSoL /= numberOfColonies) / 10) {
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, newSoL > this.oldSoL ? "model.player.SoLIncrease" : "model.player.SoLDecrease", this).addAmount("%oldSoL%", this.oldSoL).addAmount("%newSoL%", newSoL));
            }
            this.oldSoL = newSoL;
        }
        if (this.europe != null) {
            ((ServerModelObject)((Object)this.europe)).csNewTurn(random, cs);
        }
        for (Unit unit : new ArrayList<Unit>(this.getUnits())) {
            try {
                ((ServerModelObject)((Object)unit)).csNewTurn(random, cs);
            }
            catch (ClassCastException e) {
                logger.log(Level.SEVERE, "Not a ServerUnit: " + unit.getId(), e);
            }
        }
        if (this.isEuropean()) {
            int probability;
            if (this.checkEmigrate() && !this.hasAbility("model.ability.selectRecruit")) {
                this.csEmigrate(0, Europe.MigrationType.NORMAL, random, cs);
            } else {
                cs.addPartial(ChangeSet.See.only(this), this, "immigration");
            }
            cs.addPartial(ChangeSet.See.only(this), this, "liberty");
            if (this.getSpecification().getBoolean("model.option.enableUpkeep")) {
                this.csPayUpkeep(random, cs);
            }
            if ((probability = this.getSpecification().getInteger("model.option.naturalDisasters")) > 0) {
                this.csNaturalDisasters(random, cs, probability);
            }
            if (this.getPlayerType() == Player.PlayerType.REBEL && this.interventionBells >= this.getSpecification().getInteger("model.option.interventionBells")) {
                this.interventionBells = Integer.MIN_VALUE;
                Tile entryLocation = ((Tile)this.getEntryLocation()).getSafeTile(this, random);
                List<Unit> landUnits = this.createUnits(this.getMonarch().getInterventionForce().getLandUnits(), entryLocation);
                List<Unit> navalUnits = this.createUnits(this.getMonarch().getInterventionForce().getNavalUnits(), entryLocation);
                List<Unit> leftOver = this.loadShips(landUnits, navalUnits, random);
                for (Unit unit : leftOver) {
                    logger.warning("Disposing of left over unit " + unit);
                    unit.setLocation(null);
                    unit.dispose();
                }
                cs.add(ChangeSet.See.perhaps(), entryLocation);
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.DEFAULT, "declareIndependence.interventionForceArrives", this));
            }
        }
        while (!this.stanceDirty.isEmpty()) {
            boolean war;
            ServerPlayer s = this.stanceDirty.remove(0);
            Player.Stance sta = this.getStance(s);
            boolean bl = war = sta == Player.Stance.WAR;
            if (sta == Player.Stance.UNCONTACTED) continue;
            for (Player p : this.getGame().getLiveEuropeanPlayers()) {
                ServerPlayer sp = (ServerPlayer)p;
                if (sp == this || p == s || !p.hasContacted(this) || !p.hasContacted(p) || !p.hasAbility("model.ability.betterForeignAffairsReport") && !war) continue;
                cs.addStance(ChangeSet.See.only(sp), this, sta, s);
                cs.addMessage(ChangeSet.See.only(sp), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.diplomacy." + (Object)((Object)sta) + ".others", this).addStringTemplate("%attacker%", this.getNationName()).addStringTemplate("%defender%", s.getNationName()));
            }
        }
    }

    public void csPayUpkeep(Random random, ChangeSet cs) {
        Disaster bankruptcy = this.getSpecification().getDisaster("model.disaster.bankruptcy");
        int upkeep = 0;
        for (Settlement settlement : this.settlements) {
            upkeep += settlement.getUpkeep();
        }
        if (this.getGold() >= upkeep) {
            this.modifyGold(-upkeep);
            if (this.isBankrupt()) {
                this.setBankrupt(false);
                for (RandomChoice randomChoice : bankruptcy.getEffects()) {
                    for (Modifier modifier : ((Effect)randomChoice.getObject()).getModifiers()) {
                        cs.addFeatureChange(this, (FreeColGameObject)this, modifier, false);
                    }
                }
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.GOVERNMENT_EFFICIENCY, "model.disaster.bankruptcy.stop", this));
            }
        } else {
            this.modifyGold(-this.getGold());
            if (!this.isBankrupt()) {
                this.setBankrupt(true);
                this.csApplyDisaster(random, cs, null, bankruptcy);
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.GOVERNMENT_EFFICIENCY, "model.disaster.bankruptcy.start", this));
            }
        }
        cs.addPartial(ChangeSet.See.only(this), this, "bankrupt");
        cs.addPartial(ChangeSet.See.only(this), this, "gold");
    }

    public void csNaturalDisasters(Random random, ChangeSet cs, int probability) {
        if (Utils.randomInt(logger, "check for natural disasters", random, 100) < probability) {
            int size = this.getNumberOfSettlements();
            if (size < 1) {
                return;
            }
            int start = Utils.randomInt(logger, "select colony", random, size);
            for (int index = 0; index < size; ++index) {
                Disaster disaster;
                List<ModelMessage> messages;
                Colony colony = this.getColonies().get((start + index) % size);
                List disasters = colony.getDisasters();
                if (disasters.isEmpty() || (messages = this.csApplyDisaster(random, cs, colony, disaster = (Disaster)RandomChoice.getWeightedRandom(logger, "select disaster", random, disasters))).isEmpty()) continue;
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.disaster.strikes", this).addName("%colony%", colony.getName()).addName("%disaster%", disaster));
                for (ModelMessage message : messages) {
                    cs.addMessage(ChangeSet.See.only(this), message);
                }
                return;
            }
        }
    }

    public List<ModelMessage> csApplyDisaster(Random random, ChangeSet cs, Colony colony, Disaster disaster) {
        logger.finest("Applying effects of disaster " + disaster.getId());
        ArrayList<Object> effects = new ArrayList<Object>();
        switch (disaster.getNumberOfEffects()) {
            case ONE: {
                effects.add(RandomChoice.getWeightedRandom(logger, "Get effects of disaster", random, disaster.getEffects()));
                break;
            }
            case SEVERAL: {
                for (RandomChoice<Effect> effect : disaster.getEffects()) {
                    if (Utils.randomInt(logger, "Get effects of disaster", random, 100) >= effect.getProbability()) continue;
                    effects.add(effect.getObject());
                }
                break;
            }
            case ALL: {
                for (RandomChoice<Effect> effect : disaster.getEffects()) {
                    effects.add(effect.getObject());
                }
                break;
            }
        }
        ArrayList<ModelMessage> messages = new ArrayList<ModelMessage>();
        for (Effect effect : effects) {
            Unit unit;
            Modifier timedModifier;
            if (colony == null) {
                for (Modifier modifier : effect.getModifiers()) {
                    if (modifier.getDuration() > 0) {
                        timedModifier = Modifier.makeTimedModifier(modifier.getId(), modifier, this.getGame().getTurn());
                        cs.addFeatureChange(this, (FreeColGameObject)this, timedModifier, true);
                        continue;
                    }
                    cs.addFeatureChange(this, (FreeColGameObject)this, modifier, true);
                }
                continue;
            }
            if ("model.disaster.effect.lossOfMoney".equals(effect.getId())) {
                int plunder = Math.max(1, colony.getPlunder(null, random) / 5);
                this.modifyGold(-plunder);
                cs.addPartial(ChangeSet.See.only(this), this, "gold");
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), this).addAmount("%amount%", plunder));
                continue;
            }
            if ("model.disaster.effect.lossOfGoods".equals(effect.getId())) {
                Goods goods = Utils.getRandomMember(logger, "select goods", colony.getLootableGoodsList(), random);
                if (goods == null) continue;
                goods.setAmount(Math.min(goods.getAmount() / 2, 50));
                colony.removeGoods(goods);
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), this).addAmount("%amount%", goods.getAmount()).add("%goods%", goods.getType().getNameKey()));
                continue;
            }
            if ("model.disaster.effect.lossOfUnit".equals(effect.getId())) {
                unit = this.getUnitForEffect(colony, effect, random);
                if (unit == null) continue;
                if (colony.getUnitCount() == 1) {
                    messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.disaster.effect.colonyDestroyed", this).addName("%colony%", colony));
                    this.csDisposeSettlement(colony, cs);
                    continue;
                }
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), this).add("%unit%", unit.getType().getNameKey()));
                cs.addDispose(ChangeSet.See.perhaps().always(this), unit.getLocation(), unit);
                continue;
            }
            if ("model.disaster.effect.damageUnit".equals(effect.getId())) {
                unit = this.getUnitForEffect(colony, effect, random);
                if (unit == null || !unit.isNaval()) continue;
                Location repairLocation = unit.getRepairLocation();
                if (repairLocation == null) {
                    messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, "model.disaster.effect.lossOfUnit", this).add("%unit%", unit.getType().getNameKey()));
                    this.csSinkShip(unit, null, cs);
                    continue;
                }
                messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), this).addName("%unit%", unit));
                this.csDamageShip(unit, repairLocation, cs);
                continue;
            }
            messages.add(new ModelMessage(ModelMessage.MessageType.DEFAULT, effect.getId(), this));
            for (Modifier modifier : effect.getModifiers()) {
                if (modifier.getDuration() > 0) {
                    timedModifier = Modifier.makeTimedModifier(modifier.getId(), modifier, this.getGame().getTurn());
                    cs.addFeatureChange(this, (FreeColGameObject)colony, timedModifier, true);
                    continue;
                }
                cs.addFeatureChange(this, (FreeColGameObject)colony, modifier, true);
            }
        }
        return messages;
    }

    public Unit getUnitForEffect(Colony colony, Effect effect, Random random) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (Unit unit : colony.getUnitList()) {
            if (!effect.appliesTo(unit.getType())) continue;
            units.add(unit);
        }
        if (units.isEmpty()) {
            return null;
        }
        return (Unit)Utils.getRandomMember(logger, "select unit", units, random);
    }

    public void csStartTurn(Random random, ChangeSet cs) {
        Game game = this.getGame();
        if (this.isEuropean()) {
            this.csBombardEnemyShips(random, cs);
            this.csYearlyGoodsAdjust(random, cs);
            FoundingFather father = this.checkFoundingFather();
            if (father != null) {
                this.csAddFoundingFather(father, random, cs);
                this.clearOfferedFathers();
            }
        } else if (this.isIndian()) {
            List<IndianSettlement> allSettlements = this.getIndianSettlements();
            HashMap oldLevels = new HashMap();
            for (IndianSettlement settlement : allSettlements) {
                HashMap<Player, Tension.Level> oldLevel = new HashMap<Player, Tension.Level>();
                oldLevels.put(settlement, oldLevel);
                Iterator<Player> i$ = game.getLiveEuropeanPlayers().iterator();
                while (i$.hasNext()) {
                    Player enemy;
                    Tension alarm = settlement.getAlarm(enemy = i$.next());
                    oldLevel.put(enemy, alarm == null ? null : alarm.getLevel());
                }
            }
            for (IndianSettlement settlement : allSettlements) {
                HashMap<Player, Integer> extra = new HashMap<Player, Integer>();
                for (Player enemy : game.getLiveEuropeanPlayers()) {
                    extra.put(enemy, new Integer(0));
                }
                int alarmRadius = settlement.getRadius() + 2;
                int alarm = 0;
                for (Tile tile : settlement.getTile().getSurroundingTiles(alarmRadius)) {
                    Player enemy;
                    Colony colony = tile.getColony();
                    if (tile.getFirstUnit() != null) {
                        enemy = tile.getFirstUnit().getOwner();
                        if (!enemy.isEuropean()) continue;
                        alarm = (Integer)extra.get(enemy);
                        for (Unit unit : tile.getUnitList()) {
                            if (!unit.isOffensiveUnit() || unit.isNaval()) continue;
                            alarm += unit.getType().getOffence();
                        }
                        extra.put(enemy, alarm);
                        continue;
                    }
                    if (colony != null) {
                        enemy = colony.getOwner();
                        extra.put(enemy, (Integer)extra.get(enemy) + 2 + colony.getUnitCount());
                        continue;
                    }
                    if (tile.getOwningSettlement() == null || (enemy = tile.getOwningSettlement().getOwner()) == null || !enemy.isEuropean()) continue;
                    extra.put(enemy, (Integer)extra.get(enemy) + 2);
                }
                if (settlement.getMissionary() != null) {
                    int n;
                    Unit mission = settlement.getMissionary();
                    int n2 = -10;
                    if (mission.hasAbility("model.ability.expertMissionary")) {
                        n = n2 * 2;
                    }
                    Player enemy = mission.getOwner();
                    extra.put(enemy, (Integer)extra.get(enemy) + n);
                }
                for (Map.Entry entry : extra.entrySet()) {
                    Player player = (Player)entry.getKey();
                    int change = (Integer)entry.getValue();
                    if (change == 0) continue;
                    change = (int)player.applyModifier(change, "model.modifier.nativeAlarmModifier", null, game.getTurn());
                    ((ServerIndianSettlement)settlement).modifyAlarm(player, change);
                }
            }
            for (Player enemy : game.getLiveEuropeanPlayers()) {
                if (this.getTension(enemy).getValue() <= 0) continue;
                int change = -this.getTension(enemy).getValue() / 100 - 4;
                this.modifyTension(enemy, change);
            }
            for (IndianSettlement settlement : allSettlements) {
                java.util.Map oldLevel = (java.util.Map)oldLevels.get(settlement);
                for (Map.Entry entry : oldLevel.entrySet()) {
                    String key;
                    Tension.Level newLevel;
                    Player enemy = (Player)entry.getKey();
                    Tension tension = settlement.getAlarm(enemy);
                    Tension.Level level = newLevel = tension == null ? null : tension.getLevel();
                    if (entry.getValue() == null || entry.getValue() == newLevel || !settlement.hasContacted(enemy) || !enemy.hasExplored(settlement.getTile())) continue;
                    cs.add(ChangeSet.See.only(null).perhaps((ServerPlayer)enemy), settlement);
                    if (newLevel == null || entry.getValue() != null && ((Tension.Level)((Object)entry.getValue())).getLimit() > newLevel.getLimit() || !Messages.containsKey(key = "indianSettlement.alarmIncrease." + settlement.getAlarm(enemy).getKey())) continue;
                    cs.addMessage(ChangeSet.See.only((ServerPlayer)enemy), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, key, settlement).addStringTemplate("%nation%", this.getNationName()).addStringTemplate("%enemy%", enemy.getNationName()).addName("%settlement%", settlement.getName()));
                }
            }
            List<UnitType> converts = game.getSpecification().getUnitTypesWithAbility("model.ability.convert");
            StringTemplate nation = this.getNationName();
            for (IndianSettlement settlement : allSettlements) {
                Unit missionary = settlement.getMissionary();
                if (missionary == null) continue;
                ServerPlayer other = (ServerPlayer)missionary.getOwner();
                float f = missionary.applyModifier(0.0f, "model.modifier.conversionSkill");
                int alarm = Math.min(settlement.getAlarm(other).getValue(), Tension.TENSION_MAX);
                f += missionary.applyModifier(alarm, "model.modifier.conversionAlarmRate") - (float)alarm;
                Settlement colony = null;
                if ((f += (float)settlement.getConvertProgress()) < (float)settlement.getType().getConvertThreshold() || settlement.getUnitCount() + settlement.getTile().getUnitCount() <= 2 || (colony = settlement.getTile().getNearestSettlement(other, 10)) == null || converts.isEmpty()) {
                    settlement.setConvertProgress((int)Math.floor(f));
                    continue;
                }
                logger.fine("Convert at " + settlement.getName() + " for " + colony.getName());
                settlement.setConvertProgress(0);
                Tile tile = settlement.getTile();
                Unit brave = Utils.getRandomMember(logger, "Choose convert", !tile.isEmpty() ? tile.getUnitList() : settlement.getUnitList(), random);
                brave.clearEquipment();
                brave.setOwner(other);
                brave.setIndianSettlement(null);
                brave.setNationality(other.getNationID());
                brave.setType(Utils.getRandomMember(logger, "Choose convert type", converts, random));
                brave.setLocation(colony.getTile());
                cs.add(ChangeSet.See.perhaps(), colony.getTile(), settlement);
                cs.addMessage(ChangeSet.See.only(other), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.newConvert", brave).addStringTemplate("%nation%", nation).addName("%colony%", colony.getName()));
            }
        }
    }

    private void csBombardEnemyShips(Random random, ChangeSet cs) {
        for (Colony colony : this.getColonies()) {
            if (!colony.canBombardEnemyShip()) continue;
            for (Tile tile : colony.getTile().getSurroundingTiles(1)) {
                if (tile.isLand() || tile.getFirstUnit() == null || tile.getFirstUnit().getOwner() == this) continue;
                for (Unit unit : tile.getUnitList()) {
                    if (!this.atWarWith(unit.getOwner()) && !unit.hasAbility("model.ability.piracy")) continue;
                    this.csCombat(colony, unit, null, random, cs);
                }
            }
        }
    }

    public void csYearlyGoodsAdjust(Random random, ChangeSet cs) {
        GoodsType extraType;
        List<GoodsType> goodsTypes = this.getGame().getSpecification().getGoodsTypeList();
        Market market = this.getMarket();
        while (!(extraType = Utils.getRandomMember(logger, "Choose goods type", goodsTypes, random)).isStorable()) {
        }
        for (GoodsType type : goodsTypes) {
            if (!type.isStorable() || !market.hasBeenTraded(type)) continue;
            boolean add = market.getAmountInMarket(type) < type.getInitialAmount();
            int amount = this.getGame().getTurn().getNumber() / 10;
            if (type == extraType) {
                amount = 2 * amount + 1;
            }
            if (amount <= 0) continue;
            amount = Utils.randomInt(logger, "Market adjust " + type, random, amount);
            if (!add) {
                amount = -amount;
            }
            market.addGoodsToMarket(type, amount);
            logger.finest(this.getName() + " adjust of " + amount + " " + type + ", total: " + market.getAmountInMarket(type) + ", initial: " + type.getInitialAmount());
            this.csFlushMarket(type, cs);
        }
    }

    public void csAddFoundingFather(FoundingFather father, Random random, ChangeSet cs) {
        java.util.Map<UnitType, UnitType> upgrades;
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        Europe europe = this.getEurope();
        boolean europeDirty = false;
        cs.addFather(this, father);
        cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, "model.player.foundingFatherJoinedCongress", this).add("%foundingFather%", father.getNameKey()).add("%description%", father.getDescriptionKey()));
        cs.addHistory(this, new HistoryEvent(this.getGame().getTurn(), HistoryEvent.EventType.FOUNDING_FATHER).add("%father%", father.getNameKey()));
        List<AbstractUnit> units = father.getUnits();
        if (units != null && !units.isEmpty() && europe != null) {
            this.createUnits(father.getUnits(), europe);
            europeDirty = true;
        }
        if ((upgrades = father.getUpgrades()) != null) {
            for (Unit u : this.getUnits()) {
                UnitType newType = upgrades.get(u.getType());
                if (newType == null) continue;
                u.setType(newType);
                cs.add(ChangeSet.See.perhaps(), u);
            }
        }
        if (this.recalculateBellsBonus()) {
            cs.add(ChangeSet.See.only(this), this);
        }
        for (Event event : father.getEvents()) {
            String eventId = event.getId();
            if (eventId.equals("model.event.resetNativeAlarm")) {
                for (Player p : game.getPlayers()) {
                    if (p.isDead() || !p.isIndian() || !p.hasContacted(this)) continue;
                    p.setTension(this, new Tension(0));
                    for (IndianSettlement is : p.getIndianSettlements()) {
                        if (!is.hasContacted(this)) continue;
                        is.setAlarm(this, new Tension(0));
                        cs.add(ChangeSet.See.only(this), is);
                    }
                    this.csChangeStance(Player.Stance.PEACE, p, true, cs);
                }
                continue;
            }
            if (eventId.equals("model.event.boycottsLifted")) {
                Market market = this.getMarket();
                for (GoodsType goodsType : spec.getGoodsTypeList()) {
                    if (market.getArrears(goodsType) <= 0) continue;
                    market.setArrears(goodsType, 0);
                    cs.add(ChangeSet.See.only(this), market.getMarketData(goodsType));
                }
                continue;
            }
            if (eventId.equals("model.event.freeBuilding")) {
                BuildingType type = spec.getBuildingType(event.getValue());
                for (Colony colony : this.getColonies()) {
                    if (!colony.canBuild(type)) continue;
                    colony.addBuilding(new ServerBuilding(game, colony, type));
                    colony.getBuildQueue().remove(type);
                    cs.add(ChangeSet.See.only(this), colony);
                    if (!this.isAI()) continue;
                    colony.firePropertyChange("rearrangeWorkers", true, false);
                }
                continue;
            }
            if (eventId.equals("model.event.seeAllColonies")) {
                for (Tile t : game.getMap().getAllTiles()) {
                    Colony colony = t.getColony();
                    if (colony == null || (ServerPlayer)colony.getOwner() == this) continue;
                    if (!t.isExploredBy(this)) {
                        t.setExploredBy(this, true);
                    }
                    t.updatePlayerExploredTile(this, false);
                    cs.add(ChangeSet.See.only(this), t);
                    for (Tile x : colony.getOwnedTiles()) {
                        if (!x.isExploredBy(this)) {
                            x.setExploredBy(this, true);
                        }
                        x.updatePlayerExploredTile(this, false);
                        cs.add(ChangeSet.See.only(this), x);
                    }
                }
                continue;
            }
            if (eventId.equals("model.event.increaseSonsOfLiberty")) {
                int value = Integer.parseInt(event.getValue());
                GoodsType bells = spec.getLibertyGoodsTypeList().get(0);
                int totalBells = 0;
                for (Colony colony : this.getColonies()) {
                    float oldRatio = (float)colony.getLiberty() / (float)(colony.getUnitCount() * 200);
                    float reqRatio = Math.min(1.0f, oldRatio + 0.01f * (float)value);
                    int reqBells = Math.round((float)(200 * colony.getUnitCount()) * (reqRatio - oldRatio));
                    if (reqBells <= 0) continue;
                    colony.addGoods(bells, reqBells);
                    colony.updateSoL();
                    cs.add(ChangeSet.See.only(this), colony);
                    totalBells += reqBells;
                }
                this.incrementLiberty(-totalBells);
                continue;
            }
            if (eventId.equals("model.event.newRecruits") && europe != null) {
                List recruits = this.generateRecruitablesList();
                for (int i = 0; i < 3; ++i) {
                    if (this.hasAbility("model.ability.canRecruitUnit", europe.getRecruitable(i))) continue;
                    UnitType newType = (UnitType)RandomChoice.getWeightedRandom(logger, "Replace recruit", random, recruits);
                    europe.setRecruitable(i, newType);
                    europeDirty = true;
                }
                continue;
            }
            if (!eventId.equals("model.event.movementChange")) continue;
            for (Unit u : this.getUnits()) {
                if (u.getMovesLeft() <= 0) continue;
                u.setMovesLeft(u.getInitialMovesLeft());
                cs.addPartial(ChangeSet.See.only(this), u, "movesLeft");
            }
        }
        if (europeDirty) {
            cs.add(ChangeSet.See.only(this), europe);
        }
    }

    public void csClaimLand(Tile tile, Settlement settlement, int price, ChangeSet cs) {
        IndianSettlement is;
        Player owner = tile.getOwner();
        Settlement ownerSettlement = tile.getOwningSettlement();
        tile.changeOwnership(this, settlement);
        cs.add(ChangeSet.See.perhaps(), tile);
        if (price > 0) {
            this.modifyGold(-price);
            owner.modifyGold(price);
            cs.addPartial(ChangeSet.See.only(this), this, "gold");
        } else if (price < 0 && owner.isIndian() && (is = (IndianSettlement)ownerSettlement) != null) {
            cs.add(ChangeSet.See.only(null).perhaps(this), owner.modifyTension(this, 200, is));
        }
    }

    public void csEmigrate(int slot, Europe.MigrationType type, Random random, ChangeSet cs) {
        boolean selected = 1 <= slot && slot <= 3;
        int index = selected ? slot - 1 : Utils.randomInt(logger, "Choose emigrant", random, 3);
        Europe europe = this.getEurope();
        UnitType recruitType = europe.getRecruitable(index);
        Game game = this.getGame();
        ServerUnit unit = new ServerUnit(game, europe, this, recruitType);
        unit.setLocation(europe);
        switch (type) {
            case FOUNTAIN: {
                this.setRemainingEmigrants(this.getRemainingEmigrants() - 1);
                break;
            }
            case RECRUIT: {
                this.modifyGold(-europe.getRecruitPrice());
                cs.addPartial(ChangeSet.See.only(this), this, "gold");
                europe.increaseRecruitmentDifficulty();
            }
            case NORMAL: {
                this.updateImmigrationRequired();
                this.reduceImmigration();
                cs.addPartial(ChangeSet.See.only(this), this, "immigration", "immigrationRequired");
                break;
            }
            case SURVIVAL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bogus migration type");
            }
        }
        for (int i = index; i < 2; ++i) {
            europe.setRecruitable(i, europe.getRecruitable(i + 1));
        }
        List recruits = this.generateRecruitablesList();
        europe.setRecruitable(2, (UnitType)RandomChoice.getWeightedRandom(logger, "Replace recruit", random, recruits));
        cs.add(ChangeSet.See.only(this), europe);
        if (type == Europe.MigrationType.SURVIVAL) {
            cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.europe.autoRecruit", this, unit).add("%europe%", europe.getNameKey()).addStringTemplate("%unit%", unit.getLabel()));
        } else if (!selected) {
            cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.europe.emigrate", this, unit).add("%europe%", europe.getNameKey()).addStringTemplate("%unit%", unit.getLabel()));
        }
    }

    public void csCombat(FreeColGameObject attacker, FreeColGameObject defender, List<CombatModel.CombatResult> crs, Random random, ChangeSet cs) throws IllegalStateException {
        ChangeSet.See vis;
        CombatModel combatModel = this.getGame().getCombatModel();
        boolean isAttack = combatModel.combatIsAttack(attacker, defender);
        boolean isBombard = combatModel.combatIsBombard(attacker, defender);
        Unit attackerUnit = null;
        Settlement attackerSettlement = null;
        Tile attackerTile = null;
        Unit defenderUnit = null;
        ServerPlayer defenderPlayer = null;
        Tile defenderTile = null;
        if (isAttack) {
            attackerUnit = (Unit)attacker;
            attackerTile = attackerUnit.getTile();
            defenderUnit = (Unit)defender;
            defenderPlayer = (ServerPlayer)defenderUnit.getOwner();
            defenderTile = defenderUnit.getTile();
            boolean bombard = attackerUnit.hasAbility("model.ability.bombard");
            cs.addAttribute(ChangeSet.See.only(this), "sound", attackerUnit.isNaval() ? "sound.attack.naval" : (bombard ? "sound.attack.artillery" : (attackerUnit.isMounted() ? "sound.attack.mounted" : "sound.attack.foot")));
            if (attackerUnit.getOwner().isIndian() && defenderPlayer.isEuropean() && defenderUnit.getLocation().getColony() != null && !defenderPlayer.atWarWith(attackerUnit.getOwner())) {
                StringTemplate attackerNation = attackerUnit.getApparentOwnerName();
                Colony colony = defenderUnit.getLocation().getColony();
                cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianSurprise", colony).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()));
            }
        } else if (isBombard) {
            attackerSettlement = (Settlement)attacker;
            attackerTile = attackerSettlement.getTile();
            defenderUnit = (Unit)defender;
            defenderPlayer = (ServerPlayer)defenderUnit.getOwner();
            defenderTile = defenderUnit.getTile();
            cs.addAttribute(ChangeSet.See.only(this), "sound", "sound.attack.bombard");
        } else {
            throw new IllegalStateException("Bogus combat");
        }
        if (crs == null) {
            crs = combatModel.generateAttackResult(random, attacker, defender);
        }
        if (crs.isEmpty()) {
            throw new IllegalStateException("empty attack result");
        }
        CombatModel.CombatResult result = crs.remove(0);
        switch (result) {
            case NO_RESULT: {
                vis = ChangeSet.See.perhaps();
                break;
            }
            case WIN: {
                vis = ChangeSet.See.perhaps().always(defenderPlayer);
                if (!isAttack) break;
                if (attackerTile == null || defenderTile == null || attackerTile == defenderTile || !attackerTile.isAdjacent(defenderTile)) {
                    logger.warning("Bogus attack from " + attackerTile + " to " + defenderTile + "\n" + FreeColDebugger.stackTraceToString());
                    break;
                }
                cs.addAttack(vis, attackerUnit, defenderUnit, attackerTile, defenderTile, true);
                break;
            }
            case LOSE: {
                vis = ChangeSet.See.perhaps().always(this);
                if (!isAttack) break;
                if (attackerTile == null || defenderTile == null || attackerTile == defenderTile || !attackerTile.isAdjacent(defenderTile)) {
                    logger.warning("Bogus attack from " + attackerTile + " to " + defenderTile + "\n" + FreeColDebugger.stackTraceToString());
                    break;
                }
                cs.addAttack(vis, attackerUnit, defenderUnit, attackerTile, defenderTile, false);
                break;
            }
            default: {
                throw new IllegalStateException("generateAttackResult returned: " + (Object)((Object)result));
            }
        }
        boolean attackerTileDirty = false;
        boolean defenderTileDirty = false;
        boolean moveAttacker = false;
        boolean burnedNativeCapital = false;
        Settlement settlement = defenderTile.getSettlement();
        Colony colony = defenderTile.getColony();
        IndianSettlement natives = settlement instanceof IndianSettlement ? (IndianSettlement)settlement : null;
        int attackerTension = 0;
        int defenderTension = 0;
        for (CombatModel.CombatResult cr : crs) {
            boolean ok;
            switch (cr) {
                case AUTOEQUIP_UNIT: {
                    boolean bl = ok = isAttack && settlement != null;
                    if (!ok) break;
                    this.csAutoequipUnit(defenderUnit, settlement, cs);
                    break;
                }
                case BURN_MISSIONS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && this.isEuropean() && defenderPlayer.isIndian();
                    if (!ok) break;
                    defenderTileDirty |= natives.getMissionary(this) != null;
                    this.csBurnMissions(attackerUnit, natives, cs);
                    break;
                }
                case CAPTURE_AUTOEQUIP: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && settlement != null && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csCaptureAutoEquip(attackerUnit, defenderUnit, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isEuropean() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csCaptureColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = false;
                    attackerTileDirty = false;
                    moveAttacker = true;
                    defenderTension += 300;
                    break;
                }
                case CAPTURE_CONVERT: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && this.isEuropean() && defenderPlayer.isIndian();
                    if (!ok) break;
                    this.csCaptureConvert(attackerUnit, natives, random, cs);
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_EQUIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csCaptureEquip(attackerUnit, defenderUnit, cs);
                    } else {
                        this.csCaptureEquip(defenderUnit, attackerUnit, cs);
                    }
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case CAPTURE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csCaptureUnit(attackerUnit, defenderUnit, cs);
                    } else {
                        this.csCaptureUnit(defenderUnit, attackerUnit, cs);
                    }
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    break;
                }
                case DAMAGE_COLONY_SHIPS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null;
                    if (!ok) break;
                    this.csDamageColonyShips(attackerUnit, colony, cs);
                    defenderTileDirty = true;
                    break;
                }
                case DAMAGE_SHIP_ATTACK: {
                    boolean bl = isAttack && result != CombatModel.CombatResult.NO_RESULT && (result == CombatModel.CombatResult.WIN ? defenderUnit : attackerUnit).isNaval() ? true : (ok = false);
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csDamageShipAttack(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csDamageShipAttack(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case DAMAGE_SHIP_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.WIN && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csDamageShipBombard(attackerSettlement, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case DEMOTE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csDemoteUnit(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csDemoteUnit(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case DESTROY_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isIndian() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csDestroyColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    moveAttacker = true;
                    attackerTension -= 200;
                    defenderTension += 300;
                    break;
                }
                case DESTROY_SETTLEMENT: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && natives != null && defenderPlayer.isIndian();
                    if (!ok) break;
                    burnedNativeCapital = settlement.isCapital();
                    this.csDestroySettlement(attackerUnit, natives, random, cs);
                    defenderTileDirty = true;
                    attackerTileDirty = true;
                    moveAttacker = true;
                    attackerTension -= 200;
                    if (burnedNativeCapital) break;
                    defenderTension += 300;
                    break;
                }
                case EVADE_ATTACK: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.NO_RESULT && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csEvadeAttack(attackerUnit, defenderUnit, cs);
                    break;
                }
                case EVADE_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.NO_RESULT && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csEvadeBombard(attackerSettlement, defenderUnit, cs);
                    break;
                }
                case LOOT_SHIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT && attackerUnit.isNaval() && defenderUnit.isNaval();
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csLootShip(attackerUnit, defenderUnit, cs);
                        break;
                    }
                    this.csLootShip(defenderUnit, attackerUnit, cs);
                    break;
                }
                case LOSE_AUTOEQUIP: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && settlement != null && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csLoseAutoEquip(attackerUnit, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case LOSE_EQUIP: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csLoseEquip(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csLoseEquip(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case PILLAGE_COLONY: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null && this.isIndian() && defenderPlayer.isEuropean();
                    if (!ok) break;
                    this.csPillageColony(attackerUnit, colony, random, cs);
                    defenderTileDirty = true;
                    attackerTension -= 200;
                    break;
                }
                case PROMOTE_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csPromoteUnit(attackerUnit, defenderUnit, cs);
                        attackerTileDirty = true;
                        break;
                    }
                    this.csPromoteUnit(defenderUnit, attackerUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SINK_COLONY_SHIPS: {
                    boolean bl = ok = isAttack && result == CombatModel.CombatResult.WIN && colony != null;
                    if (!ok) break;
                    this.csSinkColonyShips(attackerUnit, colony, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SINK_SHIP_ATTACK: {
                    boolean bl = isAttack && result != CombatModel.CombatResult.NO_RESULT && (result == CombatModel.CombatResult.WIN ? defenderUnit : attackerUnit).isNaval() ? true : (ok = false);
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csSinkShipAttack(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        break;
                    }
                    this.csSinkShipAttack(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    break;
                }
                case SINK_SHIP_BOMBARD: {
                    boolean bl = ok = isBombard && result == CombatModel.CombatResult.WIN && defenderUnit.isNaval();
                    if (!ok) break;
                    this.csSinkShipBombard(attackerSettlement, defenderUnit, cs);
                    defenderTileDirty = true;
                    break;
                }
                case SLAUGHTER_UNIT: {
                    boolean bl = ok = isAttack && result != CombatModel.CombatResult.NO_RESULT;
                    if (!ok) break;
                    if (result == CombatModel.CombatResult.WIN) {
                        this.csSlaughterUnit(attackerUnit, defenderUnit, cs);
                        defenderTileDirty = true;
                        attackerTension -= 200;
                        defenderTension += this.getSlaughterTension(defenderUnit);
                        break;
                    }
                    this.csSlaughterUnit(defenderUnit, attackerUnit, cs);
                    attackerTileDirty = true;
                    attackerTension += this.getSlaughterTension(attackerUnit);
                    defenderTension -= 200;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (ok) continue;
            throw new IllegalStateException("Attack (result=" + (Object)((Object)result) + ") has bogus subresult: " + (Object)((Object)cr));
        }
        if (attacker.hasAbility("model.ability.piracy")) {
            if (!defenderPlayer.getAttackedByPrivateers()) {
                defenderPlayer.setAttackedByPrivateers(true);
                cs.addPartial(ChangeSet.See.only(defenderPlayer), defenderPlayer, "attackedByPrivateers");
            }
        } else if (!defender.hasAbility("model.ability.piracy")) {
            if (burnedNativeCapital) {
                defenderPlayer.getTension(this).setValue(Tension.SURRENDERED);
                cs.add(ChangeSet.See.perhaps().always(this), defenderPlayer);
                this.csChangeStance(Player.Stance.PEACE, defenderPlayer, true, cs);
                for (IndianSettlement is : defenderPlayer.getIndianSettlements()) {
                    if (!is.hasContacted(this)) continue;
                    is.getAlarm(this).setValue(Tension.SURRENDERED);
                    if (is.getTile().isExploredBy(this)) {
                        cs.add(ChangeSet.See.perhaps().always(this), is);
                        continue;
                    }
                    cs.add(ChangeSet.See.only(defenderPlayer), is);
                }
            } else if (this.isEuropean() && defenderPlayer.isEuropean()) {
                this.csChangeStance(Player.Stance.WAR, defenderPlayer, true, cs);
            } else {
                if (this.isEuropean()) {
                    this.csChangeStance(Player.Stance.WAR, defenderPlayer, true, cs);
                } else if (this.isIndian()) {
                    if (result == CombatModel.CombatResult.WIN) {
                        attackerTension -= 100;
                    } else if (result == CombatModel.CombatResult.LOSE) {
                        attackerTension += 100;
                    }
                }
                if (defenderPlayer.isEuropean()) {
                    defenderPlayer.csChangeStance(Player.Stance.WAR, this, true, cs);
                } else if (defenderPlayer.isIndian()) {
                    if (result == CombatModel.CombatResult.WIN) {
                        defenderTension += 100;
                    } else if (result == CombatModel.CombatResult.LOSE) {
                        defenderTension -= 100;
                    }
                }
                if (attackerTension != 0) {
                    cs.add(ChangeSet.See.only(null).perhaps(defenderPlayer), this.modifyTension(defenderPlayer, attackerTension));
                }
                if (defenderTension != 0) {
                    cs.add(ChangeSet.See.only(null).perhaps(this), defenderPlayer.modifyTension(this, defenderTension));
                }
            }
        }
        if (moveAttacker) {
            attackerUnit.setMovesLeft(attackerUnit.getInitialMovesLeft());
            ((ServerUnit)attackerUnit).csMove(defenderTile, random, cs);
            attackerUnit.setMovesLeft(0);
            defenderTileDirty = false;
            attackerTileDirty = false;
            cs.add(ChangeSet.See.only(defenderPlayer), defenderTile);
        } else if (isAttack) {
            if (attacker.hasAbility("model.ability.multipleAttacks")) {
                int movecost = attackerUnit.getMoveCost(defenderTile);
                attackerUnit.setMovesLeft(attackerUnit.getMovesLeft() - movecost);
            } else {
                attackerUnit.setMovesLeft(0);
            }
            if (!attackerTileDirty) {
                cs.addPartial(ChangeSet.See.only(this), attacker, "movesLeft");
            }
        }
        if (attackerTileDirty) {
            cs.add(vis, attackerTile);
        }
        if (defenderTileDirty) {
            cs.add(vis, defenderTile);
        }
    }

    private int getSlaughterTension(Unit loser) {
        Settlement settlement = loser.getSettlement();
        if (settlement != null) {
            if (settlement instanceof IndianSettlement) {
                return ((IndianSettlement)settlement).isCapital() ? 600 : 500;
            }
            return 200;
        }
        return loser.getIndianSettlement() != null ? 400 : 100;
    }

    private void csAutoequipUnit(Unit unit, Settlement settlement, ChangeSet cs) {
        ServerPlayer player = (ServerPlayer)unit.getOwner();
        cs.addMessage(ChangeSet.See.only(player), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.automaticDefence", unit).addStringTemplate("%unit%", unit.getLabel()).addName("%colony%", settlement.getName()));
    }

    private void csBurnMissions(Unit attacker, IndianSettlement settlement, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationName();
        ServerPlayer nativePlayer = (ServerPlayer)settlement.getOwner();
        StringTemplate nativeNation = nativePlayer.getNationName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.burnMissions", attacker, settlement).addStringTemplate("%nation%", attackerNation).addStringTemplate("%enemyNation%", nativeNation));
        for (IndianSettlement s : nativePlayer.getIndianSettlements()) {
            if (s.getMissionary(attackerPlayer) == null) continue;
            this.csKillMissionary(s, null, cs);
        }
    }

    private void csCaptureAutoEquip(Unit attacker, Unit defender, ChangeSet cs) {
        EquipmentType equip = defender.getBestCombatEquipmentType(defender.getAutomaticEquipment());
        this.csLoseAutoEquip(attacker, defender, cs);
        this.csCaptureEquipment(attacker, defender, equip, cs);
    }

    private void csCaptureColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        Game game = attacker.getGame();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationName();
        ServerPlayer colonyPlayer = (ServerPlayer)colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationName();
        Tile tile = colony.getTile();
        ArrayList<Unit> units = new ArrayList<Unit>();
        units.addAll(colony.getUnitList());
        units.addAll(tile.getUnitList());
        int plunder = colony.getPlunder(attacker, random);
        cs.addHistory(attackerPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.CONQUER_COLONY).addStringTemplate("%nation%", colonyNation).addName("%colony%", colony.getName()));
        cs.addHistory(colonyPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.COLONY_CONQUERED).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()));
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyCaptured", colony).addName("%colony%", colony.getName()).addAmount("%amount%", plunder));
        cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyCapturedBy", colony.getTile()).addName("%colony%", colony.getName()).addAmount("%amount%", plunder).addStringTemplate("%player%", attackerNation));
        if (plunder > 0) {
            attackerPlayer.modifyGold(plunder);
            colonyPlayer.modifyGold(-plunder);
            cs.addPartial(ChangeSet.See.only(attackerPlayer), attackerPlayer, "gold");
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold");
        }
        colony.changeOwner(attackerPlayer);
        for (Modifier m : colony.getModifiers()) {
            if (!"model.modifier.colonyGoodsParty".equals(m.getSource())) continue;
            colony.removeModifier(m);
        }
        for (Tile t : colony.getOwnedTiles()) {
            if (t == tile) continue;
            cs.add(ChangeSet.See.perhaps().always(colonyPlayer), t);
        }
        if (colony.getLineOfSight() > attacker.getLineOfSight()) {
            for (Tile t : tile.getSurroundingTiles(attacker.getLineOfSight(), colony.getLineOfSight())) {
                attackerPlayer.setExplored(t);
                cs.add(ChangeSet.See.only(attackerPlayer), t);
            }
        }
        cs.addRemoves(ChangeSet.See.only(colonyPlayer), null, units);
        cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.captureColony");
    }

    private void csCaptureConvert(Unit attacker, IndianSettlement natives, Random random, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate convertNation = natives.getOwner().getNationName();
        List<UnitType> converts = this.getGame().getSpecification().getUnitTypesWithAbility("model.ability.convert");
        UnitType type = Utils.getRandomMember(logger, "Choose convert", converts, random);
        Unit convert = natives.getUnitList().get(0);
        convert.clearEquipment();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.newConvertFromAttack", convert).addStringTemplate("%nation%", convertNation).addStringTemplate("%unit%", convert.getLabel()));
        convert.setOwner(attacker.getOwner());
        convert.setType(type);
        convert.setLocation(attacker.getTile());
    }

    private void csCaptureEquip(Unit winner, Unit loser, ChangeSet cs) {
        EquipmentType equip = loser.getBestCombatEquipmentType(loser.getEquipment());
        this.csLoseEquip(winner, loser, cs);
        this.csCaptureEquipment(winner, loser, equip, cs);
    }

    private void csCaptureEquipment(Unit winner, Unit loser, EquipmentType equip, ChangeSet cs) {
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        if ((equip = winner.canCaptureEquipment(equip, loser)) != null) {
            winner.changeEquipment(equip, 1);
            if (winnerPlayer.isIndian()) {
                StringTemplate winnerNation = winnerPlayer.getNationName();
                cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.equipmentCaptured", winnerPlayer).addStringTemplate("%nation%", winnerNation).add("%equipment%", equip.getNameKey()));
                IndianSettlement settlement = winner.getIndianSettlement();
                if (settlement != null) {
                    for (AbstractGoods goods : equip.getRequiredGoods()) {
                        settlement.addGoods(goods);
                        winnerPlayer.logCheat("teleported " + goods.toString() + " back to " + settlement.getName());
                    }
                    cs.add(ChangeSet.See.only(winnerPlayer), settlement);
                }
            }
        }
    }

    private void csCaptureUnit(Unit winner, Unit loser, ChangeSet cs) {
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loserPlayer.getNationName();
        StringTemplate loserLocation = loser.getLocation().getLocationNameFor(loserPlayer);
        StringTemplate oldName = loser.getLabel();
        String messageId = loser.getType().getId() + ".captured";
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winnerPlayer.getNationName();
        StringTemplate winnerLocation = winner.getLocation().getLocationNameFor(winnerPlayer);
        UnitType type = loser.getTypeChange(winnerPlayer.isUndead() ? UnitTypeChange.ChangeType.UNDEAD : UnitTypeChange.ChangeType.CAPTURE, winnerPlayer);
        loser.setOwner(winnerPlayer);
        if (type != null) {
            loser.setType(type);
        }
        loser.setLocation(winner.getTile());
        loser.setState(Unit.UnitState.ACTIVE);
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser).setDefaultId("model.unit.unitCaptured").addStringTemplate("%nation%", loserNation).addStringTemplate("%unit%", oldName).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser.getTile()).setDefaultId("model.unit.unitCaptured").addStringTemplate("%nation%", loserNation).addStringTemplate("%unit%", oldName).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
    }

    private void csDamageColonyShips(Unit attacker, Colony colony, ChangeSet cs) {
        List<Unit> units = colony.getTile().getUnitList();
        while (!units.isEmpty()) {
            Unit unit = units.remove(0);
            if (!unit.isNaval()) continue;
            this.csDamageShipAttack(attacker, unit, cs);
        }
    }

    private void csDamageShipAttack(Unit attacker, Unit ship, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        Location repair = ship.getRepairLocation();
        StringTemplate repairLoc = repair.getLocationNameFor(shipPlayer);
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipDamaged", attacker).addStringTemplate("%unit%", attacker.getLabel()).addStringTemplate("%enemyNation%", shipNation).addStringTemplate("%enemyUnit%", ship.getLabel()));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipDamaged", ship).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%enemyUnit%", attacker.getLabel()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%repairLocation%", repairLoc));
        this.csDamageShip(ship, repair, cs);
    }

    private void csDamageShipBombard(Settlement settlement, Unit ship, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)settlement.getOwner();
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        Location repair = ship.getRepairLocation();
        StringTemplate repairLoc = repair.getLocationNameFor(shipPlayer);
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipDamagedByBombardment", settlement).addName("%colony%", settlement.getName()).addStringTemplate("%nation%", shipNation).addStringTemplate("%unit%", ship.getLabel()));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipDamagedByBombardment", ship).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%repairLocation%", repairLoc));
        this.csDamageShip(ship, repair, cs);
    }

    private void csDamageShip(Unit ship, Location repair, ChangeSet cs) {
        ServerPlayer player = (ServerPlayer)ship.getOwner();
        for (Goods g : ship.getGoodsContainer().getCompactGoods()) {
            ship.remove(g);
        }
        for (Unit u : ship.getUnitList()) {
            ship.remove(u);
            cs.addDispose(ChangeSet.See.only(player), null, u);
        }
        ship.setHitpoints(1);
        ship.setDestination(null);
        ship.setLocation(repair instanceof Colony ? repair.getTile() : repair);
        ship.setState(Unit.UnitState.ACTIVE);
        ship.setMovesLeft(0);
        cs.add(ChangeSet.See.only(player), (FreeColGameObject)((Object)repair));
    }

    private void csDemoteUnit(Unit winner, Unit loser, ChangeSet cs) {
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loser.getApparentOwnerName();
        StringTemplate loserLocation = loser.getLocation().getLocationNameFor(loserPlayer);
        StringTemplate oldName = loser.getLabel();
        String messageId = loser.getType().getId() + ".demoted";
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationNameFor(winnerPlayer);
        UnitType type = loser.getTypeChange(UnitTypeChange.ChangeType.DEMOTION, loserPlayer);
        if (type == null || type == loser.getType()) {
            logger.warning("Demotion failed, type=" + (type == null ? "null" : "same type: " + type));
            return;
        }
        loser.setType(type);
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, winner).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserNation).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerPlayer.getNationName()).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserPlayer.getNationName()).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
    }

    private void csDestroyColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        Game game = attacker.getGame();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer colonyPlayer = (ServerPlayer)colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationName();
        int plunder = colony.getPlunder(attacker, random);
        cs.addHistory(colonyPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.COLONY_DESTROYED).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()));
        cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyBurning", colony.getTile()).addName("%colony%", colony.getName()).addAmount("%amount%", plunder).addStringTemplate("%nation%", attackerNation).addStringTemplate("%unit%", attacker.getLabel()));
        cs.addMessage(ChangeSet.See.all().except(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.colonyBurning.other", colonyPlayer).addName("%colony%", colony.getName()).addStringTemplate("%nation%", colonyNation).addStringTemplate("%attackerNation%", attackerNation));
        if (plunder > 0) {
            attackerPlayer.modifyGold(plunder);
            colonyPlayer.modifyGold(-plunder);
            cs.addPartial(ChangeSet.See.only(attackerPlayer), attackerPlayer, "gold");
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold");
        }
        this.csDisposeSettlement(colony, cs);
    }

    private void csDestroySettlement(Unit attacker, IndianSettlement settlement, Random random, ChangeSet cs) {
        Game game = this.getGame();
        Tile tile = settlement.getTile();
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        ServerPlayer nativePlayer = (ServerPlayer)settlement.getOwner();
        StringTemplate attackerNation = attackerPlayer.getNationName();
        StringTemplate nativeNation = nativePlayer.getNationName();
        String settlementName = settlement.getName();
        boolean capital = settlement.isCapital();
        int plunder = settlement.getPlunder(attacker, random);
        for (Unit u : settlement.getOwnedUnits()) {
            u.setIndianSettlement(null);
            cs.add(ChangeSet.See.only(nativePlayer), u);
        }
        this.csDisposeSettlement(settlement, cs);
        if (plunder > 0) {
            List<UnitType> unitTypes = game.getSpecification().getUnitTypesWithAbility("model.ability.carryTreasure");
            UnitType type = Utils.getRandomMember(logger, "Choose train", unitTypes, random);
            ServerUnit train = new ServerUnit(game, tile, attackerPlayer, type);
            train.setTreasureAmount(plunder);
        }
        int atrocities = -40;
        if (settlement.getType().getClaimableRadius() > 1) {
            atrocities *= 2;
        }
        if (capital) {
            atrocities = atrocities * 3 / 2;
        }
        attackerPlayer.modifyScore(atrocities);
        cs.addPartial(ChangeSet.See.only(attackerPlayer), attackerPlayer, "score");
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianTreasure", attacker).addName("%settlement%", settlementName).addAmount("%amount%", plunder));
        cs.addHistory(attackerPlayer, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.DESTROY_SETTLEMENT).addStringTemplate("%nation%", nativeNation).addName("%settlement%", settlementName));
        if (capital) {
            cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "indianSettlement.capitalBurned", attacker).addName("%name%", settlementName).addStringTemplate("%nation%", nativeNation));
        }
        if (nativePlayer.checkForDeath() == -1) {
            cs.addGlobalHistory(game, new HistoryEvent(game.getTurn(), HistoryEvent.EventType.DESTROY_NATION).addStringTemplate("%nation%", attackerNation).addStringTemplate("%nativeNation%", nativeNation));
        }
        cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.destroySettlement");
    }

    public void csDisposeSettlement(Settlement settlement, ChangeSet cs) {
        Settlement claimant;
        Unit missionary;
        logger.finest("Disposing of " + settlement.getName());
        ServerPlayer owner = (ServerPlayer)settlement.getOwner();
        if (settlement instanceof IndianSettlement && (missionary = ((IndianSettlement)settlement).getMissionary()) != null) {
            ((ServerPlayer)missionary.getOwner()).csKillMissionary((IndianSettlement)settlement, "indianSettlement.mission.destroyed", cs);
        }
        List<Tile> owned = settlement.getOwnedTiles();
        Tile centerTile = settlement.getTile();
        Settlement centerClaimant = null;
        HashMap<Settlement, Integer> votes = new HashMap<Settlement, Integer>();
        HashMap<Tile, Settlement> claims = new HashMap<Tile, Settlement>();
        while (!owned.isEmpty()) {
            Tile tile = owned.remove(0);
            votes.clear();
            for (Tile t : tile.getSurroundingTiles(1)) {
                int value;
                claimant = t.getOwningSettlement();
                if (claimant == null || claimant == settlement || claimant.isDisposed() || claimant.getOwner() == null || !claimant.getOwner().canOwnTile(tile) || !claimant.getOwner().isIndian() && claimant.getTile().getDistanceTo(tile) > claimant.getRadius()) continue;
                int n = claimant.getOwner() == owner ? 3 : (value = claimant.getOwner().isEuropean() == owner.isEuropean() ? 2 : 1);
                if (votes.get(claimant) != null) {
                    value += ((Integer)votes.get(claimant)).intValue();
                }
                votes.put(claimant, new Integer(value));
            }
            claimant = null;
            if (!votes.isEmpty()) {
                int bestValue = 0;
                for (Settlement key : votes.keySet()) {
                    int value = (Integer)votes.get(key);
                    if (bestValue >= value) continue;
                    bestValue = value;
                    claimant = key;
                }
            }
            claims.put(tile, claimant);
        }
        for (Tile t : claims.keySet()) {
            claimant = (Settlement)claims.get(t);
            if (t == centerTile) {
                centerClaimant = claimant;
                continue;
            }
            if (claimant == null) {
                t.changeOwnership(null, null);
            } else {
                t.changeOwnership(claimant.getOwner(), claimant);
            }
            cs.add(ChangeSet.See.perhaps().always(owner), t);
        }
        if (!owner.removeSettlement(settlement)) {
            throw new IllegalStateException("Failed to remove settlement: " + settlement);
        }
        if (owner.hasSettlement(settlement)) {
            throw new IllegalStateException("Still has settlement: " + settlement);
        }
        cs.addDispose(ChangeSet.See.perhaps().always(owner), centerTile, settlement);
        if (centerClaimant == null) {
            centerTile.changeOwnership(null, null);
        } else {
            centerTile.changeOwnership(centerClaimant.getOwner(), centerClaimant);
        }
    }

    private void csEvadeAttack(Unit attacker, Unit defender, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer defenderPlayer = (ServerPlayer)defender.getOwner();
        StringTemplate defenderNation = defender.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipEvaded", attacker).addStringTemplate("%unit%", attacker.getLabel()).addStringTemplate("%enemyUnit%", defender.getLabel()).addStringTemplate("%enemyNation%", defenderNation));
        cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvaded", defender).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%enemyUnit%", attacker.getLabel()).addStringTemplate("%enemyNation%", attackerNation));
    }

    private void csEvadeBombard(Settlement settlement, Unit defender, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)settlement.getOwner();
        ServerPlayer defenderPlayer = (ServerPlayer)defender.getOwner();
        StringTemplate defenderNation = defender.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvadedBombardment", settlement).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%nation%", defenderNation));
        cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipEvadedBombardment", defender).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%nation%", defenderNation));
    }

    private void csLootShip(Unit winner, Unit loser, ChangeSet cs) {
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        if (loser.getGoodsList().size() > 0 && winner.hasSpaceLeft()) {
            ArrayList<Goods> capture = new ArrayList<Goods>(loser.getGoodsList());
            for (Goods g : capture) {
                g.setLocation(null);
            }
            LootSession session = new LootSession(winner, loser);
            session.setCapture(capture);
            cs.add(ChangeSet.See.only(winnerPlayer), ChangeSet.ChangePriority.CHANGE_LATE, new LootCargoMessage(winner, loser.getId(), capture));
        }
        loser.getGoodsContainer().removeAll();
        loser.setState(Unit.UnitState.ACTIVE);
    }

    private void csLoseAutoEquip(Unit attacker, Unit defender, ChangeSet cs) {
        ServerPlayer defenderPlayer = (ServerPlayer)defender.getOwner();
        StringTemplate defenderNation = defenderPlayer.getNationName();
        Settlement settlement = defender.getSettlement();
        StringTemplate defenderLocation = defender.getLocation().getLocationNameFor(defenderPlayer);
        EquipmentType equip = defender.getBestCombatEquipmentType(defender.getAutomaticEquipment());
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerLocation = attacker.getLocation().getLocationNameFor(attackerPlayer);
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        for (AbstractGoods goods : equip.getRequiredGoods()) {
            settlement.removeGoods(goods);
        }
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.unitWinColony", attacker).addStringTemplate("%location%", attackerLocation).addStringTemplate("%nation%", attackerPlayer.getNationName()).addStringTemplate("%unit%", attacker.getLabel()).addStringTemplate("%settlement%", settlement.getLocationNameFor(attackerPlayer)).addStringTemplate("%enemyNation%", defenderNation).addStringTemplate("%enemyUnit%", defender.getLabel()));
        cs.addMessage(ChangeSet.See.only(defenderPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.unitLoseAutoEquip", defender).addStringTemplate("%location%", defenderLocation).addStringTemplate("%nation%", defenderNation).addStringTemplate("%unit%", defender.getLabel()).addStringTemplate("%settlement%", settlement.getLocationNameFor(defenderPlayer)).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
    }

    private void csLoseEquip(Unit winner, Unit loser, ChangeSet cs) {
        String messageId;
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loserPlayer.getNationName();
        StringTemplate loserLocation = loser.getLocation().getLocationNameFor(loserPlayer);
        StringTemplate oldName = loser.getLabel();
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationNameFor(winnerPlayer);
        EquipmentType equip = loser.getBestCombatEquipmentType(loser.getEquipment());
        loser.changeEquipment(equip, -1);
        loser.setMovesLeft(Math.min(loser.getMovesLeft(), loser.getInitialMovesLeft()));
        if (loser.getEquipment().isEmpty()) {
            messageId = "model.unit.unitDemotedToUnarmed";
            loser.setState(Unit.UnitState.ACTIVE);
        } else {
            messageId = loser.getType().getId() + ".demoted";
        }
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, winner).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserNation).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerPlayer.getNationName()).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser).setDefaultId("model.unit.unitDemoted").addStringTemplate("%nation%", loserNation).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
    }

    private void csPillageColony(Unit attacker, Colony colony, Random random, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)attacker.getOwner();
        StringTemplate attackerNation = attacker.getApparentOwnerName();
        ServerPlayer colonyPlayer = (ServerPlayer)colony.getOwner();
        StringTemplate colonyNation = colonyPlayer.getNationName();
        List<Building> buildingList = colony.getBurnableBuildingList();
        List<Unit> shipList = colony.getShipList();
        List<Goods> goodsList = colony.getLootableGoodsList();
        int pillage = Utils.randomInt(logger, "Pillage choice", random, buildingList.size() + shipList.size() + goodsList.size() + (colony.canBePlundered() ? 1 : 0));
        if (pillage < buildingList.size()) {
            Building building = buildingList.get(pillage);
            this.csDamageBuilding(building, cs);
            cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.buildingDamaged", colony).add("%building%", building.getNameKey()).addName("%colony%", colony.getName()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        } else if (pillage < buildingList.size() + shipList.size()) {
            Unit ship = shipList.get(pillage - buildingList.size());
            if (ship.getRepairLocation() == null) {
                this.csSinkShipAttack(attacker, ship, cs);
            } else {
                this.csDamageShipAttack(attacker, ship, cs);
            }
        } else if (pillage < buildingList.size() + shipList.size() + goodsList.size()) {
            Goods goods = goodsList.get(pillage - buildingList.size() - shipList.size());
            goods.setAmount(Math.min(goods.getAmount() / 2, 50));
            colony.removeGoods(goods);
            if (attacker.canAdd(goods)) {
                attacker.add(goods);
            }
            cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.goodsStolen", colony, goods).addAmount("%amount%", goods.getAmount()).add("%goods%", goods.getType().getNameKey()).addName("%colony%", colony.getName()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        } else {
            int plunder = Math.max(1, colony.getPlunder(attacker, random) / 5);
            colonyPlayer.modifyGold(-plunder);
            attackerPlayer.modifyGold(plunder);
            cs.addPartial(ChangeSet.See.only(colonyPlayer), colonyPlayer, "gold");
            cs.addMessage(ChangeSet.See.only(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianPlunder", colony).addAmount("%amount%", plunder).addName("%colony%", colony.getName()).addStringTemplate("%enemyNation%", attackerNation).addStringTemplate("%enemyUnit%", attacker.getLabel()));
        }
        cs.addMessage(ChangeSet.See.all().except(colonyPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.indianRaid", colonyPlayer).addStringTemplate("%nation%", attackerNation).addName("%colony%", colony.getName()).addStringTemplate("%colonyNation%", colonyNation));
    }

    private void csDamageBuilding(Building building, ChangeSet cs) {
        Colony colony = building.getColony();
        if (building.getType().getUpgradesFrom() == null) {
            block0: for (Unit u : building.getUnitList()) {
                for (WorkLocation wl : colony.getAvailableWorkLocations()) {
                    if (wl == building || !wl.canAdd(u)) continue;
                    u.setLocation(wl);
                    continue block0;
                }
                u.setLocation(colony.getTile());
            }
            colony.removeBuilding(building);
            cs.addDispose(ChangeSet.See.only((ServerPlayer)colony.getOwner()), colony, building);
        } else if (building.canBeDamaged()) {
            building.damage();
        }
        if (this.isAI()) {
            colony.firePropertyChange("rearrangeWorkers", true, false);
        }
    }

    private void csPromoteUnit(Unit winner, Unit loser, ChangeSet cs) {
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winnerPlayer.getNationName();
        StringTemplate oldName = winner.getLabel();
        UnitType type = winner.getTypeChange(UnitTypeChange.ChangeType.PROMOTION, winnerPlayer);
        if (type == null || type == winner.getType()) {
            logger.warning("Promotion failed, type=" + (type == null ? "null" : "same type: " + type));
            return;
        }
        winner.setType(type);
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.unitPromoted", winner).addStringTemplate("%oldName%", oldName).addStringTemplate("%unit%", winner.getLabel()).addStringTemplate("%nation%", winnerNation));
    }

    private void csSinkColonyShips(Unit attacker, Colony colony, ChangeSet cs) {
        List<Unit> units = colony.getTile().getUnitList();
        while (!units.isEmpty()) {
            Unit unit = units.remove(0);
            if (!unit.isNaval()) continue;
            this.csSinkShipAttack(attacker, unit, cs);
        }
    }

    private void csSinkShipAttack(Unit attacker, Unit ship, ChangeSet cs) {
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        StringTemplate shipNation = ship.getApparentOwnerName();
        Unit attackerUnit = attacker;
        ServerPlayer attackerPlayer = (ServerPlayer)attackerUnit.getOwner();
        StringTemplate attackerNation = attackerUnit.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.enemyShipSunk", attackerUnit).addStringTemplate("%unit%", attackerUnit.getLabel()).addStringTemplate("%enemyUnit%", ship.getLabel()).addStringTemplate("%enemyNation%", shipNation));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunk", ship.getTile()).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%enemyUnit%", attackerUnit.getLabel()).addStringTemplate("%enemyNation%", attackerNation));
        this.csSinkShip(ship, attackerPlayer, cs);
    }

    private void csSinkShipBombard(Settlement settlement, Unit ship, ChangeSet cs) {
        ServerPlayer attackerPlayer = (ServerPlayer)settlement.getOwner();
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        StringTemplate shipNation = ship.getApparentOwnerName();
        cs.addMessage(ChangeSet.See.only(attackerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunkByBombardment", settlement).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", ship.getLabel()).addStringTemplate("%nation%", shipNation));
        cs.addMessage(ChangeSet.See.only(shipPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, "model.unit.shipSunkByBombardment", ship.getTile()).addName("%colony%", settlement.getName()).addStringTemplate("%unit%", ship.getLabel()));
        this.csSinkShip(ship, attackerPlayer, cs);
    }

    private void csSinkShip(Unit ship, ServerPlayer attackerPlayer, ChangeSet cs) {
        ServerPlayer shipPlayer = (ServerPlayer)ship.getOwner();
        cs.addDispose(ChangeSet.See.perhaps().always(shipPlayer), ship.getLocation(), ship);
        if (attackerPlayer != null) {
            cs.addAttribute(ChangeSet.See.only(attackerPlayer), "sound", "sound.event.shipSunk");
        }
    }

    private void csSlaughterUnit(Unit winner, Unit loser, ChangeSet cs) {
        EquipmentType equip;
        ServerPlayer winnerPlayer = (ServerPlayer)winner.getOwner();
        StringTemplate winnerNation = winner.getApparentOwnerName();
        StringTemplate winnerLocation = winner.getLocation().getLocationNameFor(winnerPlayer);
        ServerPlayer loserPlayer = (ServerPlayer)loser.getOwner();
        StringTemplate loserNation = loser.getApparentOwnerName();
        StringTemplate loserLocation = loser.getLocation().getLocationNameFor(loserPlayer);
        String messageId = loser.getType().getId() + ".destroyed";
        cs.addMessage(ChangeSet.See.only(winnerPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, winner).setDefaultId("model.unit.unitSlaughtered").addStringTemplate("%nation%", loserNation).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerPlayer.getNationName()).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", winnerLocation));
        cs.addMessage(ChangeSet.See.only(loserPlayer), new ModelMessage(ModelMessage.MessageType.COMBAT_RESULT, messageId, loser.getTile()).setDefaultId("model.unit.unitSlaughtered").addStringTemplate("%nation%", loserPlayer.getNationName()).addStringTemplate("%unit%", loser.getLabel()).addStringTemplate("%enemyNation%", winnerNation).addStringTemplate("%enemyUnit%", winner.getLabel()).addStringTemplate("%location%", loserLocation));
        if (loserPlayer.isIndian() && loserPlayer.checkForDeath() == -1) {
            StringTemplate nativeNation = loserPlayer.getNationName();
            cs.addGlobalHistory(this.getGame(), new HistoryEvent(this.getGame().getTurn(), HistoryEvent.EventType.DESTROY_NATION).addStringTemplate("%nation%", winnerNation).addStringTemplate("%nativeNation%", nativeNation));
        }
        while ((equip = loser.getBestCombatEquipmentType(loser.getEquipment())) != null) {
            loser.changeEquipment(equip, -loser.getEquipmentCount(equip));
            this.csCaptureEquipment(winner, loser, equip, cs);
        }
        cs.addDispose(ChangeSet.See.perhaps().always(loserPlayer), loser.getLocation(), loser);
    }

    public void csSeeNewTiles(List<Tile> newTiles, ChangeSet cs) {
        for (Tile t : newTiles) {
            t.updatePlayerExploredTile(this, false);
            cs.add(ChangeSet.See.only(this), t);
        }
    }

    public void csRaiseTax(int tax, Goods goods, boolean accepted, ChangeSet cs) {
        GoodsType goodsType = goods.getType();
        Colony colony = (Colony)goods.getLocation();
        int amount = Math.min(goods.getAmount(), 100);
        if (accepted) {
            this.csSetTax(tax, cs);
            logger.info("Accepted tax raise to: " + tax);
        } else if (colony.getGoodsCount(goodsType) < amount) {
            int extraTax = 3;
            this.csSetTax(tax + 3, cs);
            cs.add(ChangeSet.See.only(this), ChangeSet.ChangePriority.CHANGE_NORMAL, new MonarchActionMessage(Monarch.MonarchAction.FORCE_TAX, StringTemplate.template("model.monarch.action.FORCE_TAX").addAmount("%amount%", tax + 3)));
            logger.info("Forced tax raise to: " + (tax + 3));
        } else {
            Modifier template;
            Specification spec = this.getGame().getSpecification();
            colony.getGoodsContainer().saveState();
            colony.removeGoods(goodsType, amount);
            int arrears = this.market.getPaidForSale(goodsType) * spec.getInteger("model.option.arrearsFactor");
            Market market = this.getMarket();
            market.setArrears(goodsType, arrears);
            Turn turn = this.getGame().getTurn();
            List<Modifier> modifiers = spec.getModifiers("model.modifier.colonyGoodsParty");
            if (modifiers != null && !modifiers.isEmpty()) {
                template = modifiers.get(0);
            } else {
                template = new Modifier("model.modifier.colonyGoodsParty", Specification.COLONY_GOODS_PARTY_SOURCE, 50.0f, Modifier.Type.PERCENTAGE);
                template.setIncrement(-2.0f, Modifier.Type.ADDITIVE, turn, turn);
            }
            Modifier modifier = Modifier.makeTimedModifier("model.goods.bells", template, turn);
            cs.addFeatureChange(this, (FreeColGameObject)colony, modifier, true);
            cs.add(ChangeSet.See.only(this), colony.getGoodsContainer());
            cs.add(ChangeSet.See.only(this), market.getMarketData(goodsType));
            String messageId = goodsType.getId() + ".destroyed";
            if (!Messages.containsKey(messageId)) {
                messageId = colony.isLandLocked() ? "model.monarch.colonyGoodsParty.landLocked" : "model.monarch.colonyGoodsParty.harbour";
            }
            cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, messageId, this).addName("%colony%", colony.getName()).addAmount("%amount%", amount).add("%goods%", goodsType.getNameKey()));
            cs.addAttribute(ChangeSet.See.only(this), "flush", Boolean.TRUE.toString());
            logger.info("Goods party at " + colony.getName() + " with: " + goods + " arrears: " + arrears);
        }
    }

    public void csSetTax(int tax, ChangeSet cs) {
        this.setTax(tax);
        if (this.recalculateBellsBonus()) {
            cs.add(ChangeSet.See.only(this), this);
        } else {
            cs.addPartial(ChangeSet.See.only(this), this, "tax");
        }
    }

    public void csAddMercenaries(List<AbstractUnit> mercs, int price, ChangeSet cs) {
        if (this.checkGold(price)) {
            this.createUnits(mercs, this.getEurope());
            cs.add(ChangeSet.See.only(this), this.getEurope());
            this.modifyGold(-price);
            cs.addPartial(ChangeSet.See.only(this), this, "gold");
        } else {
            this.getMonarch().setDispleasure(true);
            cs.add(ChangeSet.See.only(this), ChangeSet.ChangePriority.CHANGE_NORMAL, new MonarchActionMessage(Monarch.MonarchAction.DISPLEASURE, StringTemplate.template("model.monarch.action.DISPLEASURE")));
        }
    }

    private String getContactKey(ServerPlayer other) {
        String key = "EventPanel.MEETING_" + other.getNationNameKey();
        if (!Messages.containsKey(key)) {
            key = other.isEuropean() ? (this.hasContactedEuropeans() ? null : "EventPanel.MEETING_EUROPEANS") : (this.hasContactedIndians() ? null : "EventPanel.MEETING_NATIVES");
        }
        return key;
    }

    public ServerPlayer csContact(ServerPlayer other, Tile tile, ChangeSet cs) {
        if (this.hasContacted(other)) {
            return null;
        }
        Game game = this.getGame();
        Turn turn = game.getTurn();
        ServerPlayer welcomer = null;
        if (this.isIndian()) {
            if (!other.isIndian()) {
                String key = other.getContactKey(this);
                if (key != null) {
                    cs.addMessage(ChangeSet.See.only(other), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, key, other, this));
                }
                cs.addHistory(other, new HistoryEvent(turn, HistoryEvent.EventType.MEET_NATION).addStringTemplate("%nation%", this.getNationName()));
            }
        } else {
            String key = this.getContactKey(other);
            if (key != null) {
                cs.addMessage(ChangeSet.See.only(this), new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, key, this, other));
            }
            cs.addHistory(this, new HistoryEvent(turn, HistoryEvent.EventType.MEET_NATION).addStringTemplate("%nation%", other.getNationName()));
            if (other.isIndian() && !this.isNewLandNamed() && tile != null && tile.getOwner() == other) {
                welcomer = other;
            }
        }
        this.csChangeStance(Player.Stance.PEACE, other, true, cs);
        this.setTension(other, new Tension(0));
        other.setTension(this, new Tension(0));
        return welcomer;
    }

    @Override
    public String toString() {
        return "ServerPlayer[name=" + this.getName() + ",ID=" + this.getId() + ",conn=" + this.connection + "]";
    }

    @Override
    public String getServerXMLElementTagName() {
        return "serverPlayer";
    }
}

