/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.InputHandler;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class UserConnectionHandler
implements MessageHandler {
    private static Logger logger = Logger.getLogger(UserConnectionHandler.class.getName());
    private final FreeColServer freeColServer;

    public UserConnectionHandler(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public synchronized Element handle(Connection conn, Element element) {
        String type;
        String string = type = element == null ? "(null)" : element.getTagName();
        return "disconnect".equals(type) ? this.disconnect(conn, element) : ("getVacantPlayers".equals(type) ? this.getVacantPlayers(conn, element) : ("login".equals(type) ? this.login(conn, element) : this.unknown(type)));
    }

    private Element unknown(String type) {
        logger.warning("Unknown user connection request: " + type);
        return null;
    }

    private Element disconnect(Connection connection, Element element) {
        try {
            connection.reallyClose();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not close the connection.", e);
        }
        return null;
    }

    private Element login(Connection connection, Element element) {
        InputHandler mh;
        ServerPlayer player;
        ServerGame game;
        boolean starting;
        String userName = element.getAttribute("userName");
        String version = element.getAttribute("version");
        if (userName == null || "".equals(userName)) {
            return DOMMessage.createError("server.missingUserName", null);
        }
        if (version == null || "".equals(version)) {
            return DOMMessage.createError("server.missingVersion", null);
        }
        if (!version.equals(FreeCol.getVersion())) {
            return DOMMessage.createError("server.wrongFreeColVersion", version + " != " + FreeCol.getVersion());
        }
        Server server = this.freeColServer.getServer();
        Unit active = null;
        boolean isCurrentPlayer = false;
        boolean bl = starting = this.freeColServer.getGameState() == FreeColServer.GameState.STARTING_GAME;
        if (starting) {
            int timeOut = 20000;
            while (this.freeColServer.getGame() == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((timeOut -= 1000) > 0) continue;
                return DOMMessage.createError("server.timeOut", null);
            }
            game = this.freeColServer.getGame();
            if (!game.canAddNewPlayer()) {
                return DOMMessage.createError("server.maximumPlayers", null);
            }
            if (game.playerNameInUse(userName)) {
                return DOMMessage.createError("server.userNameInUse", userName + " is already in use.");
            }
            boolean admin = game.getPlayers().size() == 0;
            player = new ServerPlayer(game, userName, admin, game.getVacantNation(), connection.getSocket(), connection);
            game.addPlayer(player);
            Element add = DOMMessage.createMessage("addPlayer", new String[0]);
            add.appendChild(player.toXMLElement(null, add.getOwnerDocument()));
            server.sendToAll(add, connection);
            mh = this.freeColServer.getPreGameInputHandler();
        } else {
            game = this.freeColServer.getGame();
            player = (ServerPlayer)game.getPlayerByName(userName);
            if (player == null) {
                return DOMMessage.createError("server.alreadyStarted", null);
            }
            if (player.isConnected() && !player.isAI()) {
                return DOMMessage.createError("server.userNameInUse", userName + " is already in use.");
            }
            player.setConnection(connection);
            player.setConnected(true);
            if (player.isAI()) {
                player.setAI(false);
                server.sendToAll(DOMMessage.createMessage("setAI", "player", player.getId(), "ai", Boolean.toString(false)));
            }
            boolean bl2 = isCurrentPlayer = game.getCurrentPlayer() == null;
            if (isCurrentPlayer) {
                game.setCurrentPlayer(player);
                active = this.freeColServer.getActiveUnit();
            }
            mh = this.freeColServer.getInGameInputHandler();
        }
        connection.setMessageHandler(mh);
        server.addConnection(connection);
        try {
            this.freeColServer.updateMetaServer();
        }
        catch (NoRouteToServerException e) {
            logger.log(Level.WARNING, "Unable to update meta-server.", e);
        }
        return new LoginMessage(player, userName, version, !starting, this.freeColServer.isSinglePlayer(), isCurrentPlayer, active, game).toXMLElement();
    }

    private Element getVacantPlayers(Connection connection, Element element) {
        ServerGame game = this.freeColServer.getGame();
        if (this.freeColServer.getGameState() == FreeColServer.GameState.STARTING_GAME) {
            return null;
        }
        Element reply = DOMMessage.createMessage("vacantPlayers", new String[0]);
        Document doc = reply.getOwnerDocument();
        for (Player player : game.getPlayers()) {
            if (player.isDead() || !player.isEuropean() || player.isREF() || ((ServerPlayer)player).isConnected() && !player.isAI()) continue;
            Element playerElement = doc.createElement("player");
            playerElement.setAttribute("username", player.getName());
            reply.appendChild(playerElement);
        }
        return reply;
    }
}

