/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.control.FreeColServerHolder;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Element;

public abstract class InputHandler
extends FreeColServerHolder
implements MessageHandler {
    private static Logger logger = Logger.getLogger(InputHandler.class.getName());
    private final Map<String, NetworkRequestHandler> _handlerMap = Collections.synchronizedMap(new HashMap());

    public InputHandler(final FreeColServer freeColServer) {
        super(freeColServer);
        this.register("logout", new NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return InputHandler.this.logout(connection, element);
            }
        });
        this.register("disconnect", new DisconnectHandler());
        this.register("chat", new NetworkRequestHandler(){

            public Element handle(Connection connection, Element element) {
                return new ChatMessage(freeColServer.getGame(), element).handle(freeColServer, connection);
            }
        });
    }

    protected void register(String name, NetworkRequestHandler handler) {
        this._handlerMap.put(name, handler);
    }

    public final Element handle(Connection connection, Element element) {
        String tagName = element.getTagName();
        NetworkRequestHandler handler = this._handlerMap.get(tagName);
        if (handler != null) {
            try {
                return handler.handle(connection, element);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Handler failed", e);
                this.sendReconnectSafely(connection);
            }
        } else {
            logger.warning("No handler installed for " + tagName);
        }
        return null;
    }

    private void sendReconnectSafely(Connection connection) {
        try {
            connection.sendDumping(DOMMessage.createMessage("reconnect", new String[0]));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not send reconnect message!", e);
        }
    }

    protected Element createErrorReply(String message) {
        return DOMMessage.createMessage("error", "message", message);
    }

    protected abstract Element logout(Connection var1, Element var2);

    private class DisconnectHandler
    implements NetworkRequestHandler {
        private DisconnectHandler() {
        }

        public Element handle(Connection connection, Element disconnectElement) {
            ServerPlayer player = InputHandler.this.getFreeColServer().getPlayer(connection);
            this.logDisconnect(connection, player);
            if (player != null && player.isConnected()) {
                InputHandler.this.logout(connection, null);
            }
            try {
                connection.reallyClose();
            }
            catch (IOException e) {
                logger.warning("Could not close the connection.");
            }
            Server server = InputHandler.this.getFreeColServer().getServer();
            if (server != null) {
                server.removeConnection(connection);
            }
            return null;
        }

        private void logDisconnect(Connection connection, ServerPlayer player) {
            logger.info("Disconnection by: " + connection + (player != null ? " (" + player.getName() + ") " : ""));
        }
    }

    abstract class CurrentPlayerNetworkRequestHandler
    implements NetworkRequestHandler {
        CurrentPlayerNetworkRequestHandler() {
        }

        public final Element handle(Connection conn, Element element) {
            ServerPlayer player = InputHandler.this.getFreeColServer().getPlayer(conn);
            if (this.isCurrentPlayer(player)) {
                try {
                    return this.handle(player, conn, element);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Handler failure.", e);
                    InputHandler.this.sendReconnectSafely(conn);
                    return null;
                }
            }
            logger.warning("Received message out of turn from " + player.getNation() + " player:" + element.getTagName());
            return InputHandler.this.createErrorReply("Not your turn.");
        }

        private boolean isCurrentPlayer(Player player) {
            ServerGame game = InputHandler.this.getFreeColServer().getGame();
            if (player != null && game != null) {
                return player.equals(game.getCurrentPlayer());
            }
            return false;
        }

        protected abstract Element handle(Player var1, Connection var2, Element var3);
    }

    static interface NetworkRequestHandler {
        public Element handle(Connection var1, Element var2);
    }
}

