/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.GoodsWish;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.WorkerWish;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.WorkInsideColonyMission;

public class WishRealizationMission
extends Mission {
    private static final Logger logger = Logger.getLogger(WishRealizationMission.class.getName());
    private static final String tag = "AI wisher";
    private Wish wish;

    public WishRealizationMission(AIMain aiMain, AIUnit aiUnit, Wish wish) {
        super(aiMain, aiUnit);
        this.wish = wish;
        logger.finest("AI wisher starting with destination " + wish.getDestination() + ": " + this);
        this.uninitialized = false;
    }

    public WishRealizationMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public void dispose() {
        if (this.wish != null) {
            this.wish.setTransportable(null);
            this.wish = null;
        }
        super.dispose();
    }

    public Location getTransportDestination() {
        Tile tile = this.wish == null || this.wish.getDestination() == null ? null : this.wish.getDestination().getTile();
        return this.getUnit().shouldTakeTransportTo(tile) ? tile : null;
    }

    public Location getTarget() {
        return this.wish == null ? null : this.wish.getDestination();
    }

    public void setTarget(Location target) {
        throw new IllegalStateException("Target is fixed.");
    }

    public Location findTarget() {
        throw new IllegalStateException("Target is fixed.");
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = WishRealizationMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : ((reason = WishRealizationMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner())) != null ? reason : null);
    }

    public String invalidReason() {
        return this.wish == null ? "wish-null" : WishRealizationMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        Unit unit = this.getUnit();
        String reason = this.invalidReason();
        if (reason != null) {
            logger.finest("AI wisher broken(" + reason + "): " + this);
            return;
        }
        Location target = this.getTarget();
        if (this.travelToTarget(tag, target, CostDeciders.avoidSettlementsAndBlockingUnits()) != Unit.MoveType.MOVE) {
            return;
        }
        if (target instanceof Colony) {
            Colony colony = (Colony)target;
            AIUnit aiUnit = this.getAIUnit();
            AIColony aiColony = this.getAIMain().getAIColony(colony);
            aiColony.completeWish(this.wish, "mission(" + unit + ")");
            logger.finest("AI wisher completed at " + colony + ": " + this);
            if (unit.getType().isOffensive()) {
                aiUnit.setMission(new DefendSettlementMission(this.getAIMain(), aiUnit, colony));
            } else {
                aiColony.requestRearrange();
                aiUnit.setMission(new WorkInsideColonyMission(this.getAIMain(), aiUnit, aiColony));
            }
        } else {
            logger.warning("AI wisher unknown destination type " + this.wish + ": " + this);
            this.wish.dispose();
            this.wish = null;
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid() && this.wish.shouldBeStored()) {
            this.toXML(out, WishRealizationMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("wish", this.wish.getId());
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String wid = in.getAttributeValue(null, "wish");
        this.wish = (Wish)this.getAIMain().getAIObject(wid);
        if (this.wish == null) {
            if (wid.startsWith(GoodsWish.getXMLElementTagName()) || wid.startsWith("GoodsWish")) {
                this.wish = new GoodsWish(this.getAIMain(), wid);
            } else if (wid.startsWith(WorkerWish.getXMLElementTagName())) {
                this.wish = new WorkerWish(this.getAIMain(), wid);
            } else {
                logger.warning("Unknown type of Wish.");
            }
        }
    }

    public static String getXMLElementTagName() {
        return "wishRealizationMission";
    }
}

