/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIGoods;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.Transportable;
import net.sf.freecol.server.ai.mission.Mission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportMission
extends Mission {
    private static final Logger logger = Logger.getLogger(TransportMission.class.getName());
    private static final String tag = "AI transport";
    private static final int DESTINATION_UPPER_BOUND = 3;
    private static final int MAX_TRY = 3;
    private static final int MINIMUM_GOLD_TO_STAY_IN_EUROPE = 600;
    private final List<Cargo> cargoes = new ArrayList<Cargo>();
    private Location target = null;
    private static final String CARGO_TAG = "cargo";
    private static final String CARRIER_TAG = "carrier";
    private static final String MODE_TAG = "mode";
    private static final String TARGET_TAG = "target";
    private static final String TURNS_TAG = "turns";
    private static final String TRIES_TAG = "tries";
    private static final String SPACELEFT_TAG = "space";

    public TransportMission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain, aiUnit);
        this.checkCargoes(false);
        this.retarget();
        logger.finest("AI transport begins: " + this.toFullString());
        this.uninitialized = false;
    }

    public TransportMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    @Override
    public void dispose() {
        logger.finest("AI transport disposing (" + this.clearCargoes() + "): " + this);
        super.dispose();
    }

    private PathNode getTrivialPath() {
        Unit carrier = this.getUnit();
        return carrier.isNaval() ? carrier.findOurNearestPort() : carrier.findOurNearestSettlement();
    }

    private boolean isCarrying(Transportable t) {
        return t != null && t.getTransportLocatable() != null && t.getTransportLocatable().getLocation() == this.getUnit();
    }

    public boolean isTransporting(Transportable t) {
        return this.tFind(t) != null;
    }

    private boolean shouldAttack(Unit other) {
        if (TransportMission.invalidAttackReason(this.getAIUnit(), other.getOwner()) != null) {
            return false;
        }
        Unit carrier = this.getUnit();
        CombatModel cm = this.getGame().getCombatModel();
        float offence = cm.getOffencePower(carrier, other) * (carrier.hasCargo() ? 0.3f : 0.8f);
        return offence > cm.getOffencePower(other, carrier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cargo> tCopy() {
        ArrayList<Cargo> nxt;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            nxt = new ArrayList<Cargo>(this.cargoes);
        }
        return nxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cargo> tClear() {
        ArrayList<Cargo> old = new ArrayList<Cargo>();
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            old.addAll(this.cargoes);
            this.cargoes.clear();
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Cargo> tSet(List<Cargo> nxt) {
        List<Cargo> old = this.tClear();
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            this.cargoes.addAll(nxt);
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tSize() {
        int size;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            size = this.cargoes.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cargo tFind(Transportable t) {
        Cargo result = null;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            for (Cargo cargo : this.cargoes) {
                if (cargo.getTransportable() != t) continue;
                result = cargo;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cargo tFirst() {
        Cargo cargo;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            cargo = this.cargoes.isEmpty() ? null : this.cargoes.get(0);
        }
        return cargo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tAdd(Cargo cargo, int index) {
        if (this.tFind(cargo.getTransportable()) != null) {
            return false;
        }
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            if (index >= 0) {
                this.cargoes.add(index, cargo);
            } else {
                this.cargoes.add(cargo);
            }
            this.tSpace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tRemove(Cargo cargo) {
        boolean result;
        List<Cargo> list = this.cargoes;
        synchronized (list) {
            result = this.cargoes.remove(cargo);
            this.tSpace();
        }
        return result;
    }

    private void tSpace() {
        Unit carrier = this.getUnit();
        int maxHolds = carrier.getCargoCapacity();
        int holds = carrier.getCargoSpaceTaken();
        for (Cargo cargo : this.cargoes) {
            cargo.setSpaceLeft(maxHolds - (holds += cargo.getNewSpace()));
        }
    }

    private void retarget() {
        PathNode path;
        Cargo cargo = this.tFirst();
        Location loc = cargo != null ? cargo.getTarget() : ((path = this.getTrivialPath()) == null ? null : TransportMission.upLoc(path.getLastNode().getLocation()));
        this.setTarget(loc);
    }

    private int destinationCount() {
        Location now = null;
        int ret = 0;
        for (Cargo cargo : this.tCopy()) {
            if (now == null) {
                now = cargo.getTarget();
                continue;
            }
            if (Map.isSameLocation(now, cargo.getTarget())) continue;
            ++ret;
            now = cargo.getTarget();
        }
        return ret;
    }

    public int destinationCapacity() {
        return 3 - this.destinationCount();
    }

    private void dropTransportable(Transportable t, String reason) {
        AIUnit carrier = this.getAIUnit();
        if (t.getTransport() == carrier) {
            t.setTransport(null, reason);
        }
    }

    private void takeTransportable(Transportable t, String reason) {
        AIUnit carrier = this.getAIUnit();
        if (t.getTransport() != carrier) {
            t.setTransport(carrier, reason);
        }
    }

    private List<Cargo> wrapCargoes() {
        List<Cargo> ts = this.tCopy();
        String logMe = ":";
        for (Cargo t : ts) {
            logMe = logMe + "\n" + t.toString();
        }
        try {
            for (int i = 0; i < ts.size(); ++i) {
                Cargo head = ts.get(i);
                while (i + 1 < ts.size() && head.couldWrap(ts.get(i + 1))) {
                    head.wrap(ts.remove(i + 1));
                }
            }
        }
        catch (Exception e) {
            logMe = e.getMessage() + logMe;
            throw new IllegalStateException(logMe);
        }
        return ts;
    }

    private List<Cargo> unwrapCargoes(List<Cargo> ts) {
        for (int i = 0; i < ts.size(); ++i) {
            Cargo t = ts.get(i);
            if (!t.hasWrapped()) continue;
            List<Cargo> tl = t.unwrap();
            ts.addAll(i + 1, tl);
            i += tl.size();
        }
        return ts;
    }

    private String clearCargoes() {
        String log = "cargoes cleared: ";
        for (Cargo cargo : this.tClear()) {
            this.dropTransportable(cargo.getTransportable(), "cleared");
            log = log + " " + cargo;
        }
        return log;
    }

    public Cargo makeCargo(Transportable t) {
        String reason;
        Unit carrier = this.getUnit();
        Cargo cargo = null;
        if (t.getTransportDestination() == null) {
            reason = "null transport destination";
        } else if (!this.isCarrying(t) && !t.carriableBy(carrier)) {
            reason = "carrier " + carrier + " can not carry";
        } else {
            cargo = new Cargo(t, carrier);
            reason = cargo.setTarget();
        }
        if (reason == null) {
            return cargo;
        }
        logger.finest("Failed to remake cargo (" + reason + "): " + t);
        return null;
    }

    private boolean addCargo(Cargo cargo, int index) {
        boolean result = this.tAdd(cargo, index);
        if (result) {
            this.takeTransportable(cargo.getTransportable(), "added");
            this.retarget();
        }
        if (result) {
            logger.finest("AI transport added " + cargo.toString() + " (at " + (index < 0 ? "end" : Integer.toString(index)) + "): " + this.toFullString());
        } else {
            logger.finest("AI transport add " + cargo.toString() + " (at " + (index < 0 ? "end" : Integer.toString(index)) + ") failed: " + this.toFullString());
        }
        return result;
    }

    private boolean removeCargo(Cargo cargo, String reason) {
        boolean result = this.tRemove(cargo);
        if (result) {
            this.dropTransportable(cargo.getTransportable(), reason);
            this.retarget();
        }
        if (result) {
            logger.finest("AI transport removed " + cargo.toString() + " (" + reason + "): " + this.toFullString());
        } else {
            logger.finest("AI transport remove " + cargo.toString() + " failed: " + this.toFullString());
        }
        return result;
    }

    public boolean spaceAvailable(Cargo cargo) {
        List<Cargo> ts = this.tCopy();
        int newSpace = cargo.getTransportable().getSpaceTaken();
        for (int i = ts.size() - 1; i >= 0; --i) {
            if (ts.get(i).getSpaceLeft() >= newSpace) continue;
            return false;
        }
        return true;
    }

    private boolean queueCargo(Cargo cargo, boolean requireMatch) {
        Unit carrier = this.getUnit();
        int maxHolds = carrier.getCargoCapacity();
        List<Cargo> ts = this.tCopy();
        int newSpace = cargo.getNewSpace();
        Transportable t = cargo.getTransportable();
        int candidate = -1;
        block0: for (int i = 0; i < ts.size(); ++i) {
            Cargo tr = ts.get(i);
            if (Map.isSameLocation(tr.getTarget(), cargo.getTarget())) {
                for (int j = i; j < ts.size(); ++j) {
                    int holds;
                    int n = holds = j == 0 ? carrier.getCargoSpaceTaken() : maxHolds - ts.get(j - 1).getSpaceLeft();
                    if ((holds += newSpace) < 0 || holds > maxHolds) continue block0;
                }
                if (cargo.compareTo(tr) <= 0) {
                    candidate = i;
                    break;
                }
                candidate = i + 1;
                continue;
            }
            if (candidate >= 0) break;
        }
        if (candidate < 0) {
            int holds;
            if (requireMatch) {
                return false;
            }
            if (!(ts.isEmpty() || this.isCarrying(t) || (holds = maxHolds - ts.get(ts.size() - 1).getSpaceLeft() + newSpace) >= 0 && holds <= maxHolds)) {
                return false;
            }
        }
        return this.addCargo(cargo, candidate);
    }

    private boolean retargetCargo(Cargo cargo) {
        Transportable t = cargo.getTransportable();
        Location dst = t.getTransportDestination();
        int result = 0;
        if (this.tRemove(cargo)) {
            ++result;
            Cargo next = this.makeCargo(t);
            if (next != null) {
                cargo = next;
                ++result;
                if (this.queueCargo(cargo, false)) {
                    this.takeTransportable(t, "retarget/queued");
                    ++result;
                } else {
                    this.dropTransportable(t, "retarget/queuing failed");
                }
            }
        }
        this.retarget();
        switch (result) {
            case 0: {
                logger.finest("AI transport retarget failed to remove " + cargo + ": " + this.toFullString());
                break;
            }
            case 1: {
                logger.finest("AI transport retarget failed to remake " + cargo + ": " + this.toFullString());
                break;
            }
            case 2: {
                logger.finest("AI transport retarget failed to requeue " + cargo + ": " + this.toFullString());
                break;
            }
            case 3: {
                logger.finest("AI transport retarget succeeded for " + cargo + " to " + dst + ": " + this.toFullString());
            }
        }
        return result == 3;
    }

    private void checkCargoes(boolean complain) {
        block20: {
            Location end;
            PathNode path;
            Unit carrier = this.getUnit();
            if (carrier.isAtSea()) {
                return;
            }
            AIUnit aiCarrier = this.getAIUnit();
            ArrayList<Unit> unitsPresent = new ArrayList<Unit>(carrier.getUnitList());
            ArrayList<Goods> goodsPresent = new ArrayList<Goods>(carrier.getGoodsContainer().getCompactGoods());
            for (Cargo cargo : this.tCopy()) {
                String reason = cargo.check(aiCarrier);
                if (reason != null) {
                    this.removeCargo(cargo, reason);
                    continue;
                }
                path = carrier.findPath(cargo.getTarget());
                if (path == null && !cargo.retry()) {
                    this.removeCargo(cargo, "no path " + cargo.getTarget());
                    continue;
                }
                Transportable t = cargo.getTransportable();
                if (carrier.getTile() != null && (reason = cargo.setTarget()) != null && !cargo.retry()) {
                    this.removeCargo(cargo, "can not progress (" + reason + ") to " + t.getTransportDestination());
                    continue;
                }
                if (t instanceof AIUnit) {
                    unitsPresent.remove(((AIUnit)t).getUnit());
                    continue;
                }
                if (t instanceof AIGoods) {
                    Goods goods = ((AIGoods)t).getGoods();
                    int i = 0;
                    while (i < goodsPresent.size()) {
                        Goods goods2 = (Goods)goodsPresent.get(i);
                        if (goods.getType() == goods2.getType()) {
                            goodsPresent.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    continue;
                }
                throw new IllegalStateException("Bogus transportable: " + t);
            }
            EuropeanAIPlayer euaip = this.getEuropeanAIPlayer();
            ArrayList<AIObject> drop = new ArrayList<AIObject>();
            for (Unit u : unitsPresent) {
                AIUnit aiu = this.getAIMain().getAIUnit(u);
                if (aiu == null) {
                    throw new IllegalStateException("Bogus:" + u);
                }
                if (complain) {
                    logger.warning("AI transport found unexpected unit " + aiu + " aboard: " + this.toFullString());
                }
                if (!euaip.retargetCargo(aiu, aiCarrier, this.tCopy())) continue;
                Cargo cargo = this.makeCargo(aiu);
                if (cargo == null) {
                    logger.warning("COULD NOT REMAKE CARGO: " + aiu);
                    drop.add(aiu);
                    continue;
                }
                if (this.queueCargo(cargo, false)) continue;
                logger.warning("COULD NOT QUEUE CARGO: " + cargo);
                drop.add(aiu);
            }
            for (Goods g : goodsPresent) {
                AIGoods aig = new AIGoods(this.getAIMain(), carrier, g.getType(), g.getAmount(), null);
                if (complain) {
                    logger.warning("AI transport found unexpected goods " + aig + " aboard: " + this.toFullString());
                }
                if (euaip.retargetCargo(aig, aiCarrier, this.tCopy()) && this.queueTransportable(aig, false)) continue;
                drop.add(aig);
            }
            if (drop.isEmpty()) break block20;
            path = this.getTrivialPath();
            Location location = end = path == null ? null : path.getLastNode().getLocation();
            if (path == null || carrier.isAtLocation(end)) {
                while (!drop.isEmpty()) {
                    Transportable t = (Transportable)drop.remove(0);
                    this.dumpTransportable(t, true);
                }
            } else {
                String log = "AI transport will dump ";
                for (Transportable transportable : drop) {
                    log = log + " " + transportable;
                }
                logger.warning(log + " at " + (FreeColGameObject)((Object)end) + ": " + this.toFullString());
                while (!drop.isEmpty()) {
                    Transportable t = (Transportable)drop.remove(0);
                    Cargo cargo = new Cargo(t, carrier, end);
                    this.queueCargo(cargo, false);
                }
            }
        }
    }

    private CargoResult tryCargo(Cargo cargo) {
        Unit carrier = this.getUnit();
        Location here = carrier.getLocation();
        Transportable t = cargo.getTransportable();
        Locatable l = t.getTransportLocatable();
        switch (cargo.getMode()) {
            case LOAD: {
                if (!Map.isSameLocation(here, l.getLocation())) {
                    return CargoResult.TCONTINUE;
                }
                switch (carrier.getNoAddReason(l)) {
                    case NONE: {
                        break;
                    }
                    case CAPACITY_EXCEEDED: {
                        return CargoResult.TCONTINUE;
                    }
                    default: {
                        return CargoResult.TRETRY;
                    }
                }
                if (!t.joinTransport(carrier, null)) {
                    logger.warning("AI transport failed to load " + t + " at " + here + ": " + this);
                    return CargoResult.TFAIL;
                }
                logger.finest("AI transport loaded " + t + " at " + here + ": " + this);
                String reason = cargo.setTarget();
                if (reason == null) {
                    return CargoResult.TNEXT;
                }
                logger.finest("AI transport next fail(" + reason + ") " + t + " at " + here + ": " + this);
                return CargoResult.TFAIL;
            }
            case UNLOAD: {
                if (!Map.isSameLocation(here, cargo.getTarget())) {
                    return CargoResult.TCONTINUE;
                }
                if (!t.leaveTransport(null)) {
                    logger.warning("AI transport failed to unload " + t + " at " + here + ": " + this);
                    return CargoResult.TFAIL;
                }
                logger.finest("AI transport completed (unload) of " + t + " at " + here + ": " + this);
                return CargoResult.TDONE;
            }
            case PICKUP: {
                if (!Map.isSameLocation(here, cargo.getTarget())) {
                    return CargoResult.TCONTINUE;
                }
                if (this.isCarrying(t)) {
                    logger.finest("AI transport picked up " + t + " at " + here + ": " + this);
                    String reason = cargo.setTarget();
                    if (reason == null) {
                        return CargoResult.TNEXT;
                    }
                    logger.finest("AI transport next fail(" + reason + ") " + t + " at " + here + ": " + this);
                    return CargoResult.TFAIL;
                }
                AIUnit aiu = (AIUnit)t;
                String reason = aiu.getMission().invalidReason();
                if (reason != null) {
                    logger.warning("AI transport unit mission failed(" + reason + ") for " + t + ": " + this);
                    return CargoResult.TFAIL;
                }
                return CargoResult.TCONTINUE;
            }
            case DROPOFF: {
                if (!Map.isSameLocation(here, cargo.getTarget())) {
                    return CargoResult.TCONTINUE;
                }
                if (!this.isCarrying(t)) {
                    logger.finest("AI transport completed (dropoff) " + t + " at " + carrier.getLocation() + ": " + this);
                    return CargoResult.TDONE;
                }
                AIUnit aiu = (AIUnit)t;
                String reason = aiu.getMission().invalidReason();
                if (reason != null) {
                    logger.warning("AI transport unit mission failed(" + reason + ") for " + t + ": " + this);
                    return CargoResult.TFAIL;
                }
                return CargoResult.TCONTINUE;
            }
            case DUMP: {
                return this.dumpTransportable(t, false) ? CargoResult.TDONE : CargoResult.TCONTINUE;
            }
        }
        throw new IllegalStateException("Can not happen");
    }

    private float scoreCargoOrder(Location initialLocation, List<Cargo> order) {
        Unit carrier = this.getUnit();
        int maxHolds = carrier.getCargoCapacity();
        int holds = carrier.getCargoSpaceTaken();
        Location now = initialLocation;
        float totalHoldTurns = 0.0f;
        float totalTurns = 0.0f;
        float favourEarly = 1.0f;
        for (Cargo cargo : order) {
            int turns = carrier.getTurnsToReach(now, cargo.getTarget());
            totalTurns += (float)turns;
            totalHoldTurns += (float)(holds * turns) * favourEarly;
            if ((holds += cargo.getNewSpace()) < 0 || holds > maxHolds) {
                return -1.0f;
            }
            now = cargo.getTarget();
            favourEarly += 0.1f;
        }
        return totalTurns + 0.001f * totalHoldTurns;
    }

    private void optimizeCargoes() {
        this.checkCargoes(true);
        List<Cargo> ts = this.wrapCargoes();
        List<Cargo> best = null;
        if (1 < ts.size() && ts.size() <= 3) {
            Location current = this.getUnit().getLocation();
            float bestValue = 2.1474836E9f;
            for (List<Cargo> tl : Utils.getPermutations(ts)) {
                float value = this.scoreCargoOrder(current, tl);
                if (!(value > 0.0f) || !(bestValue > value)) continue;
                bestValue = value;
                best = tl;
            }
        }
        if (best != null) {
            this.tSet(this.unwrapCargoes(best));
            this.tSpace();
        } else {
            this.tSet(this.unwrapCargoes(ts));
        }
        this.retarget();
        if (best != null) {
            logger.finest("AI transport post-optimize " + this.getTarget() + ": " + this.toFullString());
        }
    }

    private boolean addTransportable(Transportable t, int index) {
        Cargo cargo;
        if (this.tFind(t) != null) {
            return false;
        }
        AIUnit oldCarrier = t.getTransport();
        if (oldCarrier.getMission() instanceof TransportMission) {
            ((TransportMission)oldCarrier.getMission()).removeTransportable(t, "transferring to " + this.getUnit());
        }
        return (cargo = this.makeCargo(t)) == null ? false : this.addCargo(cargo, index);
    }

    public boolean removeTransportable(Transportable t, String reason) {
        Cargo cargo = this.tFind(t);
        return cargo == null ? false : this.removeCargo(cargo, reason);
    }

    public boolean retargetTransportable(Transportable t) {
        Cargo cargo = this.tFind(t);
        return cargo == null ? false : this.retargetCargo(cargo);
    }

    public boolean queueTransportable(Transportable t, boolean requireMatch) {
        Cargo cargo = this.makeCargo(t);
        return cargo == null ? false : this.queueCargo(cargo, requireMatch);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean dumpTransportable(Transportable t, boolean force) {
        boolean canLeave;
        Unit carrier = this.getUnit();
        AIUnit aiCarrier = this.getAIUnit();
        Location here = carrier.getLocation();
        Locatable l = t.getTransportLocatable();
        boolean bl = canLeave = carrier.isInEurope() || carrier.getLocation().getSettlement() != null;
        if (t instanceof AIUnit) {
            AIUnit aiu = (AIUnit)t;
            Map.Direction direction = null;
            if (!canLeave) {
                for (Tile tile : carrier.getTile().getSurroundingTiles(1)) {
                    if (!tile.isLand() || !aiu.getUnit().getMoveType(tile).isProgress()) continue;
                    direction = carrier.getTile().getDirection(tile);
                    canLeave = true;
                    break;
                }
            }
            if (canLeave && aiu.leaveTransport(direction)) {
                logger.finest("AI transport dumped " + aiu + " at " + here + ": " + this.toFullString());
                return true;
            }
            if (!force) {
                logger.warning("AI transport failed to dump " + aiu + " at " + here + ": " + this.toFullString());
                return false;
            }
            logger.warning("AI transport forcing dump(disband) " + aiu + " at " + here + ": " + this.toFullString());
            return AIMessage.askDisband(aiu);
        }
        if (!(t instanceof AIGoods)) throw new IllegalStateException("Bogus transportable: " + t);
        AIGoods aig = (AIGoods)t;
        if (canLeave && aig.leaveTransport(null)) {
            logger.finest("AI transport dumped " + aig + " at " + here + ": " + this.toFullString());
            return true;
        }
        if (!force) {
            logger.warning("AI transport failed to dump " + aig + " at " + here + ": " + this.toFullString());
            return false;
        }
        logger.warning("AI transport forcing dump(goods) " + aig + " at " + here + ": " + this.toFullString());
        return AIMessage.askUnloadCargo(aiCarrier, aig.getGoods());
    }

    @Override
    public Tile getTransportDestination() {
        return null;
    }

    @Override
    public int getTransportPriority() {
        return 0;
    }

    @Override
    public Location getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Location target) {
        this.target = target;
    }

    @Override
    public Location findTarget() {
        return null;
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = TransportMission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : (!aiUnit.getUnit().isCarrier() ? "unit-not-a-carrier" : null);
    }

    private static String invalidTransportableReason(AIUnit aiUnit, Transportable t) {
        Location dst;
        Unit carrier = aiUnit.getUnit();
        Player owner = carrier.getOwner();
        Locatable l = t.getTransportLocatable();
        if (l == null) {
            return "null-transportable";
        }
        if (l.getLocation() != carrier) {
            if (l.getLocation() instanceof Unit) {
                return "transportable-on-other-carrier";
            }
            Location src = t.getTransportSource();
            if (src == null) {
                return "transportable-source-missing";
            }
            if (((FreeColGameObject)((Object)src)).isDisposed()) {
                return "transportable-source-disposed";
            }
            if (src instanceof Settlement && ((Settlement)src).getOwner() != null && !owner.owns((Settlement)src)) {
                return "transportable-source-captured";
            }
        }
        if ((dst = t.getTransportDestination()) == null) {
            return "transportable-destination-missing";
        }
        if (((FreeColGameObject)((Object)dst)).isDisposed()) {
            return "transportable-destination-disposed";
        }
        if (dst instanceof Settlement && ((Settlement)dst).getOwner() != null && !owner.owns((Settlement)dst)) {
            return "transportable-destination-captured";
        }
        return t instanceof AIUnit ? TransportMission.invalidAIUnitReason((AIUnit)t) : null;
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = TransportMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof Europe || loc instanceof Colony ? TransportMission.invalidTargetReason(loc, aiUnit.getUnit().getOwner()) : (loc instanceof Tile ? null : "target-invalid"));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return TransportMission.invalidMissionReason(aiUnit);
    }

    @Override
    public String invalidReason() {
        Cargo cargo;
        AIUnit aiUnit = this.getAIUnit();
        String reason = TransportMission.invalidReason(aiUnit, this.getTarget());
        return reason != null ? reason : ((cargo = this.tFirst()) == null ? null : TransportMission.invalidTransportableReason(aiUnit, cargo.getTransportable()));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void doMission() {
        this.checkCargoes(true);
        reason = this.invalidReason();
        if (reason != null) {
            this.retarget();
            reason = this.invalidReason();
            if (reason != null) {
                this.optimizeCargoes();
                reason = this.invalidReason();
                if (reason != null) {
                    TransportMission.logger.finest("AI transport broken(" + reason + "): " + this.toFullString());
                    return;
                }
            }
        }
        aiCarrier = this.getAIUnit();
        carrier = this.getUnit();
        euaip = this.getEuropeanAIPlayer();
        fallBackDecider = CostDeciders.avoidSettlementsAndBlockingUnits();
        costDecider = CostDeciders.defaultCostDeciderFor(carrier);
        block17: while (true) {
            TransportMission.logger.info("AI transport travelling: " + this.toFullString());
            mt = this.travelToTarget("AI transport", this.target, costDecider);
            switch (1.$SwitchMap$net$sf$freecol$common$model$Unit$MoveType[mt.ordinal()]) {
                case 1: 
                case 2: {
                    return;
                }
                case 3: {
                    blocker = TransportMission.resolveBlockage(aiCarrier, this.target);
                    if (blocker instanceof Unit && this.shouldAttack((Unit)blocker)) {
                        TransportMission.logger.finest("AI transport attacking " + blocker + ": " + this);
                        AIMessage.askAttack(aiCarrier, carrier.getTile().getDirection(blocker.getTile()));
                        continue block17;
                    }
                }
                case 4: {
                    if (carrier.getTile().isAdjacent(this.target.getTile()) || costDecider == fallBackDecider) {
                        this.moveRandomly("AI transport", null);
                        carrier.setMovesLeft(0);
                        TransportMission.logger.finest("AI transport blocked at " + carrier.getLocation() + ", moving randomly: " + this);
                        return;
                    }
                    TransportMission.logger.finest("AI transport blocked at " + carrier.getLocation() + ", retrying: " + this);
                    costDecider = fallBackDecider;
                    continue block17;
                }
                case 5: {
                    if (this.tSize() > 0) {
                        logMe = "AI transport delivery-pass:";
                        cont = new ArrayList<Cargo>();
                        for (Cargo cargo : this.tCopy()) {
                            result = cargo.getMode().isCollection() != false ? CargoResult.TCONTINUE : this.tryCargo(cargo);
                            logMe = logMe + "\n    " + cargo.toString() + " = " + (Object)result;
                            switch (1.$SwitchMap$net$sf$freecol$server$ai$mission$TransportMission$CargoResult[result.ordinal()]) {
                                case 1: 
                                case 2: {
                                    cont.add(cargo);
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    break;
                                }
                                case 5: {
                                    throw new IllegalStateException("Can not happen");
                                }
                            }
                        }
                        TransportMission.logger.finest(logMe);
                        this.tSet(cont);
                        this.tSpace();
                        this.optimizeCargoes();
                        logMe = "AI transport collection-pass:";
                        cont.clear();
                        next = new ArrayList<Cargo>();
                        for (Cargo cargo : this.tCopy()) {
                            result = cargo.getMode().isCollection() != false ? this.tryCargo(cargo) : CargoResult.TCONTINUE;
                            logMe = logMe + "\n    " + cargo.toString() + " = " + (Object)result;
                            switch (1.$SwitchMap$net$sf$freecol$server$ai$mission$TransportMission$CargoResult[result.ordinal()]) {
                                case 1: {
                                    cont.add(cargo);
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                case 5: {
                                    next.add(cargo);
                                    break;
                                }
                                case 2: {
                                    if (!cargo.retry()) break;
                                    next.add(cargo);
                                    break;
                                }
                            }
                        }
                        TransportMission.logger.finest(logMe);
                        this.tSet(cont);
                        this.tSpace();
                        while (!next.isEmpty()) {
                            this.queueCargo((Cargo)next.remove(0), false);
                        }
                    }
                    if (this.destinationCapacity() > 0 && (tl = euaip.getTransportablesAt(here = TransportMission.upLoc(carrier.getLocation()))) != null) {
                        for (Transportable t : tl) {
                            if (!this.queueTransportable(t, true)) continue;
                            euaip.claimTransportable(t, here);
                        }
                    }
                    for (n = this.destinationCapacity(); n > 0 && (t = euaip.getBestTransportable(carrier)) != null; --n) {
                        if (!this.queueTransportable(t, false)) continue;
                        euaip.claimTransportable(t);
                    }
                    this.retarget();
                    if (carrier.isAtLocation(this.target)) ** break;
                    continue block17;
                    TransportMission.logger.finest("AI transport waiting at " + this.target + ": " + this.toFullString());
                    return;
                }
            }
            break;
        }
        TransportMission.logger.warning("AI transport unexpected move " + (Object)mt + ": " + this.toFullString());
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, TransportMission.getXMLElementTagName());
        }
    }

    @Override
    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            this.writeLocationAttribute(out, TARGET_TAG, this.target);
        }
    }

    @Override
    protected void writeChildren(XMLStreamWriter out) throws XMLStreamException {
        AIUnit aiCarrier = this.getAIUnit();
        for (Cargo cargo : this.tCopy()) {
            String reason = cargo.check(aiCarrier);
            if (reason != null) {
                this.removeCargo(cargo, reason);
                continue;
            }
            if (cargo.getMode() == CargoMode.DUMP) continue;
            out.writeStartElement(CARGO_TAG);
            AIObject aio = (AIObject)((Object)cargo.getTransportable());
            this.writeAttribute(out, "ID", aio.getId());
            this.writeAttribute(out, CARRIER_TAG, cargo.getCarrier());
            this.writeAttribute(out, MODE_TAG, cargo.getMode());
            if (cargo.getTarget() != null) {
                this.writeLocationAttribute(out, TARGET_TAG, cargo.getTarget());
            }
            this.writeAttribute(out, TURNS_TAG, cargo.getTurns());
            this.writeAttribute(out, TRIES_TAG, cargo.getTries());
            this.writeAttribute(out, SPACELEFT_TAG, cargo.getSpaceLeft());
            out.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.target = this.getLocationAttribute(in, TARGET_TAG, this.getGame());
    }

    @Override
    protected void readChildren(XMLStreamReader in) throws XMLStreamException {
        this.tClear();
        super.readChildren(in);
    }

    @Override
    protected void readChild(XMLStreamReader in) throws XMLStreamException {
        Game game = this.getGame();
        String tag = in.getLocalName();
        if (CARGO_TAG.equals(tag)) {
            String tid = this.getAttribute(in, "ID", null);
            AIObject aio = null;
            if (tid != null && (aio = this.getAIMain().getAIObject(tid)) == null) {
                if (tid.startsWith(Unit.getXMLElementTagName())) {
                    aio = new AIUnit(this.getAIMain(), tid);
                } else if (tid.startsWith(AIGoods.getXMLElementTagName())) {
                    aio = new AIGoods(this.getAIMain(), tid);
                }
            }
            if (aio == null) {
                throw new XMLStreamException("Transportable expected: " + tid);
            }
            Unit carrier = game.getFreeColGameObject(in, CARRIER_TAG, Unit.class, this.getUnit());
            CargoMode mode = this.getAttribute(in, MODE_TAG, CargoMode.class, CargoMode.DUMP);
            Location target = this.getLocationAttribute(in, TARGET_TAG, game);
            int turns = this.getAttribute(in, TURNS_TAG, -1);
            int tries = this.getAttribute(in, TRIES_TAG, 0);
            int spaceLeft = this.getAttribute(in, SPACELEFT_TAG, -1);
            this.tAdd(new Cargo((Transportable)((Object)aio), carrier, mode, target, turns, tries, spaceLeft), -1);
            in.nextTag();
        } else if ("transportable".equals(tag)) {
            in.nextTag();
        } else {
            super.readChild(in);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" -> ");
        sb.append(this.target);
        return sb.toString();
    }

    public String toFullString() {
        StringBuilder sb = new StringBuilder(this.toString());
        for (Cargo cargo : this.tCopy()) {
            sb.append("\n  ->");
            sb.append(cargo.toString());
        }
        return sb.toString();
    }

    public static String getXMLElementTagName() {
        return "transportMission";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Cargo
    implements Comparable<Cargo> {
        private Transportable transportable;
        private Unit carrier;
        private CargoMode mode;
        private Location target;
        private int turns;
        private int tries;
        private int spaceLeft;
        private List<Cargo> wrapped;

        public Cargo(Transportable transportable, Unit carrier) {
            this(transportable, carrier, null);
        }

        public Cargo(Transportable transportable, Unit carrier, Location target) {
            this(transportable, carrier, CargoMode.DUMP, target, -1, 0, -1);
        }

        public Cargo(Transportable transportable, Unit carrier, CargoMode mode, Location target, int turns, int tries, int spaceLeft) {
            this.transportable = transportable;
            this.carrier = carrier;
            this.mode = mode;
            this.target = target;
            this.turns = turns;
            this.tries = tries;
            this.spaceLeft = spaceLeft;
            this.wrapped = null;
        }

        public Transportable getTransportable() {
            return this.transportable;
        }

        public Unit getCarrier() {
            return this.carrier;
        }

        public CargoMode getMode() {
            return this.mode;
        }

        public Location getTarget() {
            return this.target;
        }

        public int getTurns() {
            return this.turns;
        }

        public int getTries() {
            return this.tries;
        }

        public int getSpaceLeft() {
            return this.spaceLeft;
        }

        public void setSpaceLeft(int spaceLeft) {
            this.spaceLeft = spaceLeft;
        }

        public int getNewSpace() {
            int ret = 0;
            ret += this.mode.isCollection() ? this.getTransportable().getSpaceTaken() : -this.getTransportable().getSpaceTaken();
            if (this.hasWrapped()) {
                for (Cargo t : this.wrapped) {
                    ret += t.getNewSpace();
                }
            }
            return ret;
        }

        public boolean hasWrapped() {
            return this.wrapped != null;
        }

        public boolean couldWrap(Cargo other) {
            return this.getTarget() == other.getTarget() && this.getNewSpace() < 0 && other.getNewSpace() < 0;
        }

        public void wrap(Cargo other) {
            if (other == this) {
                throw new IllegalStateException("Autowrap at" + this);
            }
            if (this.wrapped == null) {
                this.wrapped = new ArrayList<Cargo>();
            }
            this.wrapped.add(other);
        }

        public List<Cargo> unwrap() {
            if (this.wrapped == null) {
                throw new IllegalStateException("Bogus unwrap " + this);
            }
            List<Cargo> result = this.wrapped;
            this.wrapped = null;
            return result;
        }

        public boolean retry() {
            return this.tries++ < 3;
        }

        @Override
        public int compareTo(Cargo other) {
            return this.getNewSpace() - other.getNewSpace();
        }

        public String setTarget() {
            Location dst = this.transportable.getTransportDestination();
            if (dst == null) {
                return "no-destination";
            }
            dst = AIObject.upLoc(dst);
            if (this.transportable instanceof AIUnit) {
                Unit unit = ((AIUnit)this.transportable).getUnit();
                if (unit.getLocation() == this.carrier) {
                    PathNode path = unit.findPath(this.carrier.getLocation(), dst, this.carrier, null);
                    if (path == null) {
                        return "no-deliver " + unit + "/" + this.carrier + " -> " + dst;
                    }
                    PathNode drop = path.getTransportDropNode();
                    if (AIObject.upLoc(drop.getLocation()) instanceof Tile) {
                        this.mode = CargoMode.DROPOFF;
                        this.turns = drop.previous.getTotalTurns();
                        this.target = AIObject.upLoc(drop.previous.getLocation());
                    } else {
                        this.mode = CargoMode.UNLOAD;
                        this.turns = drop.getTotalTurns();
                        this.target = AIObject.upLoc(drop.getLocation());
                    }
                } else {
                    PathNode path = unit.findPath(unit.getLocation(), dst, this.carrier, null);
                    if (path == null) {
                        return "no-collect " + unit + "/" + this.carrier + " -> " + dst;
                    }
                    PathNode drop = path.getCarrierMove();
                    if (drop == null) {
                        return "carrier not needed for " + unit.toString();
                    }
                    path = this.carrier.findPath(drop.getLocation());
                    if (path == null) {
                        return "carrier can not reach collection point " + this.carrier + " -> " + (FreeColGameObject)((Object)drop.getLocation());
                    }
                    if (AIObject.upLoc(drop.getLocation()) instanceof Tile) {
                        this.mode = CargoMode.PICKUP;
                        this.turns = drop.getTotalTurns();
                        this.target = AIObject.upLoc(drop.getLocation());
                    } else {
                        this.mode = CargoMode.LOAD;
                        this.turns = drop.getTotalTurns();
                        this.target = AIObject.upLoc(drop.getLocation());
                    }
                }
                return null;
            }
            if (this.transportable instanceof AIGoods) {
                Goods goods = ((AIGoods)this.transportable).getGoods();
                if (goods.getLocation() == this.carrier) {
                    PathNode path = this.carrier.findPath(dst);
                    if (path == null) {
                        return "no-deliver for " + this.carrier + " -> " + dst;
                    }
                    this.mode = CargoMode.UNLOAD;
                    this.turns = path.getLastNode().getTotalTurns();
                    this.target = AIObject.upLoc(path.getLastNode().getLocation());
                } else {
                    PathNode path = this.carrier.findPath(goods.getLocation());
                    if (path == null) {
                        return "no-collect for " + this.carrier + " -> " + dst;
                    }
                    this.mode = CargoMode.LOAD;
                    this.turns = path.getLastNode().getTotalTurns();
                    this.target = AIObject.upLoc(path.getLastNode().getLocation());
                }
                return null;
            }
            throw new IllegalStateException("Bogus transportable: " + this.transportable);
        }

        public String check(AIUnit aiCarrier) {
            String reason = TransportMission.invalidReason(aiCarrier, this.target);
            if (reason != null) {
                return reason;
            }
            Locatable l = this.transportable.getTransportLocatable();
            if (l == null) {
                return "null locatable: " + this.transportable.toString();
            }
            Location tLoc = l.getLocation();
            if (tLoc instanceof Unit && (Unit)tLoc != this.carrier) {
                return "carrier usurped";
            }
            return null;
        }

        public String toString() {
            return "[" + this.transportable.toString() + " mode=" + (Object)((Object)this.mode) + (this.mode.isCollection() ? " from " : " to ") + this.target + " " + this.turns + "/" + this.tries + " space=" + this.spaceLeft + (this.wrapped == null ? "" : " wrap") + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CargoMode {
        LOAD,
        UNLOAD,
        PICKUP,
        DROPOFF,
        DUMP;


        public boolean isCollection() {
            return this == LOAD || this == PICKUP;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CargoResult {
        TCONTINUE,
        TDONE,
        TFAIL,
        TNEXT,
        TRETRY;

    }
}

