/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.mission.Mission;

public class MissionaryMission
extends Mission {
    private static final Logger logger = Logger.getLogger(MissionaryMission.class.getName());
    private static final String tag = "AI missionary";
    private Location target = null;

    public MissionaryMission(AIMain aiMain, AIUnit aiUnit) {
        this(aiMain, aiUnit, MissionaryMission.findTarget(aiUnit, 20, true));
    }

    public MissionaryMission(AIMain aiMain, AIUnit aiUnit, Location target) {
        super(aiMain, aiUnit);
        this.setTarget(target);
        logger.finest("AI missionary starts at " + aiUnit.getUnit().getLocation() + " with target " + this.getTarget() + ": " + this);
        this.uninitialized = false;
    }

    public MissionaryMission(AIMain aiMain, AIUnit aiUnit, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, aiUnit);
        this.readFromXML(in);
        this.uninitialized = this.getAIUnit() == null;
    }

    public static Location extractTarget(AIUnit aiUnit, PathNode path) {
        Settlement settlement;
        if (path == null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location loc = path.getLastNode().getLocation();
        Settlement settlement2 = settlement = loc == null ? null : loc.getSettlement();
        return settlement instanceof IndianSettlement && MissionaryMission.invalidIndianSettlementReason(aiUnit, (IndianSettlement)settlement) == null ? (IndianSettlement)settlement : (settlement instanceof Colony && MissionaryMission.invalidColonyReason(aiUnit, (Colony)settlement) != null ? (Colony)settlement : null);
    }

    public static int scorePath(AIUnit aiUnit, PathNode path) {
        Location loc = MissionaryMission.extractTarget(aiUnit, path);
        return loc instanceof IndianSettlement ? 1000 / (path.getTotalTurns() + 1) : Integer.MIN_VALUE;
    }

    private static GoalDecider getGoalDecider(final AIUnit aiUnit, boolean deferOK) {
        GoalDecider gd = new GoalDecider(){
            private PathNode bestPath = null;
            private int bestValue = 0;

            public PathNode getGoal() {
                return this.bestPath;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode path) {
                int value = MissionaryMission.scorePath(aiUnit, path);
                if (this.bestValue < value) {
                    this.bestValue = value;
                    this.bestPath = path;
                    return true;
                }
                return false;
            }
        };
        return deferOK ? GoalDeciders.getComposedGoalDecider(gd, GoalDeciders.getOurClosestSettlementGoalDecider()) : gd;
    }

    private static PathNode findTargetPath(AIUnit aiUnit, int range, boolean deferOK) {
        if (MissionaryMission.invalidAIUnitReason(aiUnit) != null) {
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Tile startTile = unit.getPathStartTile();
        if (startTile == null) {
            return null;
        }
        Unit carrier = unit.getCarrier();
        GoalDecider gd = MissionaryMission.getGoalDecider(aiUnit, deferOK);
        CostDecider standardCd = CostDeciders.avoidSettlementsAndBlockingUnits();
        return unit.search(startTile, gd, standardCd, range, carrier);
    }

    public static Location findTarget(AIUnit aiUnit, int range, boolean deferOK) {
        PathNode path = MissionaryMission.findTargetPath(aiUnit, range, deferOK);
        return path != null ? MissionaryMission.extractTarget(aiUnit, path) : MissionaryMission.upLoc(MissionaryMission.findCircleTarget(aiUnit, MissionaryMission.getGoalDecider(aiUnit, deferOK), range * 3, deferOK));
    }

    public static String prepare(AIUnit aiUnit) {
        String reason = MissionaryMission.invalidReason(aiUnit);
        if (reason == null) {
            Unit unit = aiUnit.getUnit();
            if (!unit.hasAbility("model.ability.establishMission") && ((FreeColGameObject)((Object)unit.getLocation())).hasAbility("model.ability.dressMissionary")) {
                aiUnit.equipForRole(Unit.Role.MISSIONARY, false);
            }
            reason = unit.hasAbility("model.ability.establishMission") ? null : "unit-can-not-establish-mission";
        }
        return reason;
    }

    public Location getTransportDestination() {
        return this.getUnit().shouldTakeTransportTo(this.getTarget()) ? this.getTarget() : null;
    }

    public Location getTarget() {
        return this.target;
    }

    public void setTarget(Location target) {
        if (target == null || target instanceof Settlement) {
            boolean retarget = this.target != null && this.target != target;
            this.target = target;
            if (retarget) {
                this.retargetTransportable();
            }
        }
    }

    public Location findTarget() {
        return MissionaryMission.findTarget(this.getAIUnit(), 20, true);
    }

    private static String invalidMissionReason(AIUnit aiUnit) {
        String reason = MissionaryMission.invalidAIUnitReason(aiUnit);
        if (reason != null) {
            return reason;
        }
        Unit unit = aiUnit.getUnit();
        return !unit.isPerson() ? "unit-not-a-person" : (unit.getSkillLevel() >= -1 && !unit.hasAbility("model.ability.expertMissionary") ? "unit-is-not-subskilled-or-expertMissionary" : (unit.isInEurope() || unit.isAtSea() ? (unit.getOwner().getNumberOfSettlements() <= 0 ? "unit-off-map-but-missing-initial-settlement" : null) : (unit.isInMission() ? "unit-is-already-at-mission" : null)));
    }

    private static String invalidColonyReason(AIUnit aiUnit, Colony colony) {
        return MissionaryMission.invalidTargetReason(colony, aiUnit.getUnit().getOwner());
    }

    private static String invalidIndianSettlementReason(AIUnit aiUnit, IndianSettlement is) {
        String reason = MissionaryMission.invalidTargetReason(is);
        if (reason != null) {
            return reason;
        }
        Player owner = aiUnit.getUnit().getOwner();
        return !owner.hasContacted(is.getOwner()) ? "target-is-uncontacted" : (is.getOwner().atWarWith(owner) ? "target-at-war" : (is.getMissionary() != null && is.getMissionary().getOwner() == owner ? "target-has-our-mission" : null));
    }

    public static String invalidReason(AIUnit aiUnit) {
        return MissionaryMission.invalidMissionReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = MissionaryMission.invalidMissionReason(aiUnit);
        return reason != null ? reason : (loc instanceof IndianSettlement ? MissionaryMission.invalidIndianSettlementReason(aiUnit, (IndianSettlement)loc) : (loc instanceof Colony ? MissionaryMission.invalidColonyReason(aiUnit, (Colony)loc) : "target-invalid"));
    }

    public String invalidReason() {
        return MissionaryMission.invalidReason(this.getAIUnit(), this.getTarget());
    }

    public void doMission() {
        String reason = this.invalidReason();
        if (this.isTargetReason(reason)) {
            if (!this.retargetMission(tag, reason)) {
                return;
            }
        } else if (reason != null) {
            logger.finest("AI missionary broken(" + reason + "): " + this);
            return;
        }
        AIUnit aiUnit = this.getAIUnit();
        Unit unit = this.getUnit();
        Unit.MoveType mt = this.travelToTarget(tag, this.getTarget(), CostDeciders.avoidSettlementsAndBlockingUnits());
        switch (mt) {
            case MOVE_NO_MOVES: 
            case MOVE_NO_REPAIR: 
            case MOVE_ILLEGAL: {
                break;
            }
            case MOVE: {
                Location completed = this.getTarget();
                this.setTarget(MissionaryMission.findTarget(aiUnit, 20, false));
                logger.finest("AI missionary reached colony target " + completed + ", retargeting " + this.getTarget() + ": " + this);
                break;
            }
            case ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY: {
                Map.Direction d = unit.getTile().getDirection(this.getTarget().getTile());
                if (d == null) {
                    throw new IllegalStateException("Unit not next to target " + this.getTarget() + ": " + unit + "/" + unit.getLocation());
                }
                IndianSettlement is = (IndianSettlement)this.getTarget();
                AIMessage.askEstablishMission(aiUnit, d, is.getMissionary() != null);
                if (unit.isDisposed()) {
                    logger.finest("AI missionary died at target " + this.getTarget() + ": " + this);
                    break;
                }
                if (is.getMissionary() == unit && unit.isInMission()) {
                    logger.finest("AI missionary completed at " + this.getTarget() + ": " + this);
                    this.setTarget(null);
                    break;
                }
                logger.warning("AI missionary unexpected failure at " + this.getTarget() + ": " + this);
                break;
            }
            default: {
                logger.warning("AI missionary unexpected move type (" + (Object)((Object)mt) + ") at " + unit.getLocation() + ": " + this);
            }
        }
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(out, MissionaryMission.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        if (this.target != null) {
            out.writeAttribute("target", this.target.getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "target");
        this.target = str == null ? null : this.getGame().getFreeColLocation(str);
    }

    public static String getXMLElementTagName() {
        return "missionaryMission";
    }
}

