/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;

public abstract class Mission
extends AIObject {
    private static final Logger logger = Logger.getLogger(Mission.class.getName());
    protected static final int MINIMUM_TRANSPORT_PRIORITY = 60;
    protected static final int NORMAL_TRANSPORT_PRIORITY = 100;
    protected static final int NO_PATH_TO_TARGET = -2;
    protected static final int NO_MORE_MOVES_LEFT = -1;
    protected static final String AIUNITNULL = "aiUnit-null";
    protected static final String TARGETNULL = "target-null";
    protected static final String TARGETINVALID = "target-invalid";
    protected static final String TARGETOWNERSHIP = "target-ownership";
    protected static final String TARGETNOTFOUND = "target-not-found";
    protected static final String UNITNOTAPERSON = "unit-not-a-person";
    protected static final String UNITNOTOFFENSIVE = "unit-not-offensive";
    protected static final String UNITNOTONMAP = "unit-not-on-map";
    private AIUnit aiUnit;

    public Mission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain);
        this.aiUnit = aiUnit;
    }

    public void dispose() {
    }

    public AIUnit getAIUnit() {
        return this.aiUnit;
    }

    protected void setAIUnit(AIUnit aiUnit) {
        this.aiUnit = aiUnit;
    }

    public Unit getUnit() {
        return this.aiUnit == null ? null : this.aiUnit.getUnit();
    }

    protected Player getPlayer() {
        return this.getUnit() == null ? null : this.getUnit().getOwner();
    }

    protected AIPlayer getAIPlayer() {
        return this.getAIMain().getAIPlayer(this.getUnit().getOwner());
    }

    protected EuropeanAIPlayer getEuropeanAIPlayer() {
        Player player = this.getUnit().getOwner();
        if (!player.isEuropean()) {
            throw new IllegalArgumentException("Not a European player: " + player);
        }
        return (EuropeanAIPlayer)this.getAIMain().getAIPlayer(player);
    }

    protected Random getAIRandom() {
        return this.aiUnit.getAIRandom();
    }

    public final boolean isValid() {
        return this.invalidReason() == null;
    }

    public boolean isTargetReason(String reason) {
        return reason != null && reason.startsWith("target-");
    }

    public static String invalidUnitReason(Unit unit) {
        return unit == null ? "unit-null" : (unit.isUninitialized() ? "unit-uninitialized" : (unit.isDisposed() ? "unit-disposed" : (unit.isUnderRepair() ? "unit-under-repair" : null)));
    }

    public static String invalidAIUnitReason(AIUnit aiUnit) {
        String reason;
        return aiUnit == null ? AIUNITNULL : ((reason = Mission.invalidUnitReason(aiUnit.getUnit())) != null ? reason : null);
    }

    public static String invalidNewMissionReason(AIUnit aiUnit) {
        return aiUnit == null ? AIUNITNULL : (aiUnit.hasMission() && !aiUnit.getMission().isOneTime() && aiUnit.getMission().isValid() ? "mission-exists" : null);
    }

    public static String invalidTargetReason(Location target) {
        return target == null ? TARGETNULL : (((FreeColGameObject)((Object)target)).isDisposed() ? "target-disposed" : null);
    }

    public static String invalidTargetReason(Location target, Player owner) {
        String reason = Mission.invalidTargetReason(target);
        return reason != null ? reason : (target instanceof Ownable && owner != ((Ownable)((Object)target)).getOwner() ? TARGETOWNERSHIP : null);
    }

    public static String invalidAttackReason(AIUnit aiUnit, Player other) {
        Unit unit = aiUnit.getUnit();
        Player player = unit.getOwner();
        return player == other ? TARGETOWNERSHIP : (player.isIndian() && player.getTension(other).getLevel().compareTo(Tension.Level.CONTENT) <= 0 ? "target-native-tension-too-low" : (player.isEuropean() && player.getStance(other) != Player.Stance.WAR && (!unit.hasAbility("model.ability.piracy") || player.getStance(other) == Player.Stance.ALLIANCE) ? "target-european-war-absent" : null));
    }

    protected static Location findCircleTarget(AIUnit aiUnit, GoalDecider gd, int radius, boolean deferOK) {
        Unit unit = aiUnit.getUnit();
        Tile start = unit.getTile();
        if (start == null) {
            if (!deferOK) {
                return null;
            }
            Settlement settlement = unit.getOwner().getClosestPortForEurope();
            return settlement == null ? null : settlement;
        }
        return unit.getGame().getMap().searchCircle(start, gd, radius);
    }

    public static Location resolveBlockage(AIUnit aiUnit, Location target) {
        Unit unit = aiUnit.getUnit();
        PathNode path = unit.findPath(target);
        Object d = null;
        if (path != null && path.next != null) {
            GoodsLocation blocker;
            Tile tile = path.next.getTile();
            Settlement settlement = tile.getSettlement();
            Unit defender = tile.getDefendingUnit(unit);
            GoodsLocation goodsLocation = blocker = settlement != null ? settlement : unit;
            if (UnitSeekAndDestroyMission.invalidReason(aiUnit, blocker) == null) {
                return blocker;
            }
        }
        return null;
    }

    protected Map.Direction moveRandomly(String logMe, Map.Direction direction) {
        Unit unit = this.getUnit();
        if (unit.getMovesLeft() <= 0 || !(unit.getLocation() instanceof Tile)) {
            return null;
        }
        if (logMe == null) {
            logMe = "moveRandomly";
        }
        Random aiRandom = this.getAIRandom();
        if (direction == null) {
            direction = Map.Direction.getRandomDirection(logMe, aiRandom);
        }
        Map.Direction[] directions = direction.getClosestDirections(logMe, aiRandom);
        for (int j = 0; j < directions.length; ++j) {
            Map.Direction d = directions[j];
            Tile moveTo = unit.getTile().getNeighbourOrNull(d);
            if (moveTo == null || unit.getMoveType(d) != Unit.MoveType.MOVE || !this.aiUnit.move(d)) continue;
            return d;
        }
        return null;
    }

    protected void moveRandomlyTurn(String logMe) {
        Map.Direction direction = null;
        while ((direction = this.moveRandomly(logMe, direction)) != null) {
        }
        this.getUnit().setMovesLeft(0);
    }

    protected static Settlement getBestSettlement(Player player) {
        int bestValue = -1;
        Settlement best = null;
        for (Settlement settlement : player.getSettlements()) {
            int value = settlement.getUnitCount() + settlement.getTile().getUnitCount();
            if (settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                value += (colony.isConnectedPort() ? 10 : 0) + colony.getAvailableWorkLocations().size();
            }
            if (value <= bestValue) continue;
            bestValue = value;
            best = settlement;
        }
        return best == null ? null : best;
    }

    protected Unit.MoveType travelToTarget(String logMe, Location target, CostDecider costDecider) {
        Tile targetTile = target.getTile();
        if (!(target instanceof Europe) && targetTile == null) {
            throw new IllegalStateException("Target neither Europe nor Tile");
        }
        Unit unit = this.getUnit();
        AIUnit aiUnit = this.getAIUnit();
        Unit carrier = unit.getCarrier();
        Map map = unit.getGame().getMap();
        PathNode path = null;
        boolean inTransit = false;
        boolean needTransport = false;
        if (unit.isAtLocation(target)) {
            if (unit.isOnCarrier() && !aiUnit.leaveTransport(null)) {
                logger.warning(logMe + " at " + target + " failed to disembark from " + carrier + ": " + this);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            return Unit.MoveType.MOVE;
        }
        if (unit.isAtSea()) {
            logger.finest(logMe + " at sea: " + this);
            return Unit.MoveType.MOVE_NO_MOVES;
        }
        if (unit.isInEurope()) {
            if (!unit.getOwner().canMoveToEurope()) {
                throw new IllegalStateException("Impossible move from Europe");
            }
            if (unit.getType().canMoveToHighSeas()) {
                unit.setDestination(target);
                if (AIMessage.askMoveTo(aiUnit, map)) {
                    logger.finest(logMe + " sailed for " + target + ": " + this);
                    return Unit.MoveType.MOVE_HIGH_SEAS;
                }
                logger.fine(logMe + " failed to sail for " + target + ": " + this);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
        } else {
            if (unit.getTile() == null) {
                throw new IllegalStateException("Null unit tile: " + unit);
            }
            if (target instanceof Europe) {
                if (!unit.getOwner().canMoveToEurope()) {
                    logger.fine(logMe + " impossible move to Europe" + ": " + this);
                    return Unit.MoveType.MOVE_ILLEGAL;
                }
                if (unit.getType().canMoveToHighSeas() && unit.getTile().isDirectlyHighSeasConnected()) {
                    if (AIMessage.askMoveTo(aiUnit, target)) {
                        logger.finest(logMe + " sailed for " + target + ": " + this);
                        return Unit.MoveType.MOVE_HIGH_SEAS;
                    }
                    logger.fine(logMe + " failed to sail for " + target + ": " + this);
                    return Unit.MoveType.MOVE_ILLEGAL;
                }
            }
        }
        if ((path = unit.findPath(unit.getLocation(), target, carrier, costDecider)) == null) {
            if (unit.getType().canMoveToHighSeas() || unit.isOnCarrier()) {
                logger.fine(logMe + " no path from " + unit.getLocation() + " to " + target + ": " + this);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            AIUnit newAICarrier = aiUnit.getTransport();
            if (newAICarrier == null) {
                logger.finest(logMe + " at " + unit.getLocation() + " needs transport to " + target + ": " + this);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            Unit newCarrier = newAICarrier.getUnit();
            path = unit.findPath(unit.getLocation(), target, newCarrier, costDecider);
            if (path == null) {
                logger.fine(logMe + " no path from " + unit.getLocation() + " to " + target + " with assigned carrier " + newCarrier + ": " + this);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
        }
        if (path.next == null) {
            throw new IllegalStateException("Trivial path found " + path.fullPathToString() + " from " + unit.getLocation() + " to target " + target + " result=" + unit.isAtLocation(target));
        }
        return this.followPath(logMe, path.next);
    }

    protected Unit.MoveType followPath(String logMe, PathNode path) {
        Unit unit = this.getUnit();
        AIUnit aiUnit = this.getAIUnit();
        Unit carrier = unit.getCarrier();
        Location target = path.getLastNode().getLocation();
        boolean NO_EUROPE = false;
        boolean USES_EUROPE = true;
        int BOTH_EUROPE = 2;
        while (path != null) {
            block34: {
                int useEurope;
                block35: {
                    Map.Direction d;
                    block33: {
                        Map.Direction d2;
                        useEurope = 0;
                        if (unit.isDisposed()) {
                            logger.fine(logMe + " died going to " + path.getLocation() + ": " + this);
                            return Unit.MoveType.MOVE_NO_REPAIR;
                        }
                        if (unit.getMovesLeft() <= 0 || unit.isAtSea()) {
                            logger.finest(logMe + " at " + unit.getLocation() + " en route to " + target + ": " + this);
                            return Unit.MoveType.MOVE_NO_MOVES;
                        }
                        if (unit.isInEurope()) {
                            ++useEurope;
                        } else if (unit.getTile() == null) {
                            logger.fine(logMe + " null location tile: " + this);
                            return Unit.MoveType.MOVE_ILLEGAL;
                        }
                        if (path.getLocation() instanceof Europe) {
                            ++useEurope;
                        } else if (path.getTile() == null) {
                            logger.fine(logMe + " null path tile " + path.toString() + ": " + this);
                            return Unit.MoveType.MOVE_ILLEGAL;
                        }
                        if (unit.isOnCarrier() && path.isOnCarrier()) {
                            logger.finest(logMe + " at " + unit.getLocation() + " in transit to " + target + ": " + this);
                            return Unit.MoveType.MOVE_NO_MOVES;
                        }
                        if (!unit.isOnCarrier() || path.isOnCarrier()) break block33;
                        if (unit.isAtLocation(path.getLocation())) {
                            d2 = null;
                        } else if (unit.getTile() != null && unit.getTile().isAdjacent(path.getTile())) {
                            if (unit.getMovesLeft() <= 0) {
                                logger.finest(logMe + " at " + unit.getLocation() + " waiting to disembark: " + this);
                                return Unit.MoveType.MOVE_NO_MOVES;
                            }
                            d2 = unit.getTile().getDirection(path.getTile());
                        } else {
                            logger.warning(logMe + " at " + unit.getLocation() + " should be in range of " + path.getLocation() + " to disembark: " + this);
                            return Unit.MoveType.MOVE_ILLEGAL;
                        }
                        Unit.MoveType mt = unit.getMoveType(d2);
                        if (!mt.isProgress()) {
                            logger.finest(logMe + " at " + unit.getLocation() + " has special disembark " + (Object)((Object)mt) + " to " + path.getTile() + ": " + this);
                            return mt;
                        }
                        if (!aiUnit.leaveTransport(d2)) {
                            logger.warning(logMe + " at " + unit.getLocation() + " unexpected failure to disembark: " + this + "\n" + path.fullPathToString());
                            return Unit.MoveType.MOVE_ILLEGAL;
                        }
                        break block34;
                    }
                    if (unit.isOnCarrier() || !path.isOnCarrier()) break block35;
                    AIUnit newAICarrier = aiUnit.getTransport();
                    if (newAICarrier == null) {
                        logger.finest(logMe + " at " + unit.getLocation() + " requires transport to " + target + ": " + this);
                        return Unit.MoveType.MOVE_ILLEGAL;
                    }
                    Unit newCarrier = newAICarrier.getUnit();
                    if (!newCarrier.isAtLocation(path.getLocation())) {
                        logger.finest(logMe + " at " + unit.getLocation() + " waiting for carrier " + newCarrier + " to arrive and transport it to " + target + ": " + this);
                        return Unit.MoveType.MOVE_ILLEGAL;
                    }
                    if (!newCarrier.canAdd(unit)) {
                        logger.warning(logMe + " at " + unit.getLocation() + " can not join assigned carrier " + newCarrier + ": " + this);
                        return Unit.MoveType.MOVE_ILLEGAL;
                    }
                    if (unit.isAtLocation(path.getLocation())) {
                        d = null;
                    } else if (unit.getTile() != null && unit.getTile().isAdjacent(newCarrier.getTile())) {
                        if (unit.getMovesLeft() <= 0) {
                            logger.finest(logMe + " at " + unit.getLocation() + " waiting to embark on " + newCarrier + ": " + this);
                            return Unit.MoveType.MOVE_NO_MOVES;
                        }
                        d = unit.getTile().getDirection(newCarrier.getTile());
                    } else {
                        logger.warning(logMe + " at " + unit.getLocation() + " should be in range of " + path.getLocation() + " to embark to " + newCarrier + ": " + this);
                        return Unit.MoveType.MOVE_ILLEGAL;
                    }
                    if (!aiUnit.joinTransport(newCarrier, d)) {
                        logger.finest(logMe + " at " + unit.getLocation() + " unexpected failure to embark to " + newCarrier + " at " + newCarrier.getLocation() + ": " + this);
                        return Unit.MoveType.MOVE_ILLEGAL;
                    }
                    break block34;
                }
                switch (useEurope) {
                    case 0: {
                        Unit.MoveType mt = unit.getMoveType(path.getDirection());
                        if (mt == Unit.MoveType.MOVE_NO_MOVES) {
                            unit.setMovesLeft(0);
                            return Unit.MoveType.MOVE_NO_MOVES;
                        }
                        if (!mt.isProgress()) {
                            logger.finest(logMe + " at " + unit.getTile() + " has special move " + (Object)((Object)mt) + " to " + path.getTile() + ": " + this);
                            return mt;
                        }
                        if (!aiUnit.move(path.getDirection())) break;
                        break block34;
                    }
                    case 1: {
                        Location dst;
                        Location location = dst = unit.isInEurope() ? unit.getGame().getMap() : path.getLocation();
                        if (!AIMessage.askMoveTo(aiUnit, dst)) break;
                        logger.finest(logMe + " now on high seas: " + this);
                        return Unit.MoveType.MOVE_HIGH_SEAS;
                    }
                    case 2: {
                        break block34;
                    }
                    default: {
                        throw new IllegalStateException("Can not happen");
                    }
                }
                logger.finest(logMe + " at " + unit.getLocation() + " failed to move to " + path.getLocation() + ": " + this);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            path = path.next;
        }
        return Unit.MoveType.MOVE;
    }

    public boolean retargetTransportable() {
        AIUnit aiCarrier;
        Unit u = this.getUnit();
        AIUnit aiUnit = this.getAIUnit();
        if (aiUnit == null) {
            return false;
        }
        AIUnit aIUnit = aiCarrier = u.isOnCarrier() ? this.getAIMain().getAIUnit(u.getCarrier()) : aiUnit.getTransport();
        if (aiCarrier == null) {
            return false;
        }
        Mission m = aiCarrier.getMission();
        if (!(m instanceof TransportMission)) {
            return false;
        }
        return ((TransportMission)m).retargetTransportable(aiUnit);
    }

    public boolean retargetMission(String tag, String reason) {
        Location newTarget = this.findTarget();
        this.setTarget(newTarget);
        logger.finest(tag + " retargetting(" + reason + ") -> " + newTarget + ": " + this);
        return newTarget != null;
    }

    public Location getTransportDestination() {
        PathNode path;
        Unit unit = this.getUnit();
        Unit carrier = unit.getCarrier();
        return unit.getTile() == null ? (unit.isOnCarrier() ? carrier : unit).getFullEntryLocation() : (!unit.isOnCarrier() ? null : (carrier.getSettlement() != null ? carrier.getTile() : ((path = unit.findOurNearestSettlement()) == null ? null : path.getLastNode().getTile())));
    }

    public int getTransportPriority() {
        return this.getTransportDestination() != null ? 100 : 0;
    }

    public abstract Location getTarget();

    public abstract void setTarget(Location var1);

    public abstract Location findTarget();

    public abstract String invalidReason();

    public static String invalidReason(AIUnit aiUnit) {
        return Mission.invalidAIUnitReason(aiUnit);
    }

    public static String invalidReason(AIUnit aiUnit, Location loc) {
        String reason = Mission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : Mission.invalidTargetReason(loc);
    }

    public boolean isOneTime() {
        return false;
    }

    public abstract void doMission();

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
    }

    public String toString() {
        return Utils.lastPart(this.getClass().getName(), ".") + "@" + Integer.toString(this.hashCode()) + "-" + this.aiUnit;
    }
}

