/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ValuedAIObject;
import net.sf.freecol.server.ai.mission.PioneeringMission;
import org.w3c.dom.Element;

public class TileImprovementPlan
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(TileImprovementPlan.class.getName());
    private TileImprovementType type;
    private Tile target;
    private AIUnit pioneer = null;

    public TileImprovementPlan(AIMain aiMain, String id) throws XMLStreamException {
        super(aiMain, id);
        this.type = null;
        this.target = null;
        this.pioneer = null;
    }

    public TileImprovementPlan(AIMain aiMain, Tile target, TileImprovementType type, int value) {
        super(aiMain, TileImprovementPlan.getXMLElementTagName() + ":" + aiMain.getNextId());
        this.target = target;
        this.type = type;
        this.pioneer = null;
        this.setValue(value);
        this.uninitialized = this.getType() == null || this.getTarget() == null;
    }

    public TileImprovementPlan(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.getType() == null || this.getTarget() == null;
    }

    public TileImprovementPlan(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.getType() == null || this.getTarget() == null;
    }

    public void dispose() {
        if (this.pioneer != null && this.pioneer.getMission() instanceof PioneeringMission) {
            this.pioneer.abortMission("disposing plan");
        }
        this.pioneer = null;
        super.dispose();
    }

    public AIUnit getPioneer() {
        return this.pioneer;
    }

    public void setPioneer(AIUnit pioneer) {
        this.pioneer = pioneer;
    }

    public TileImprovementType getType() {
        return this.type;
    }

    public void setType(TileImprovementType type) {
        this.type = type;
    }

    public Tile getTarget() {
        return this.target;
    }

    public static TileImprovementType getBestTileImprovementType(Tile tile, GoodsType goodsType) {
        int bestValue = 0;
        TileImprovementType bestType = null;
        for (TileImprovementType impType : tile.getSpecification().getTileImprovementTypeList()) {
            int value;
            if (impType.isNatural() || !impType.isTileTypeAllowed(tile.getType()) || impType.getExpendedAmount() > 1 || tile.findTileImprovementType(impType) != null || (value = impType.getImprovementValue(tile, goodsType)) <= bestValue) continue;
            bestValue = value;
            bestType = impType;
        }
        return bestType;
    }

    public boolean update(GoodsType goodsType) {
        TileImprovementType type = TileImprovementPlan.getBestTileImprovementType(this.target, goodsType);
        if (type == null) {
            return false;
        }
        this.setType(type);
        this.setValue(type.getImprovementValue(this.target, goodsType));
        return true;
    }

    public boolean isComplete() {
        return this.target != null && this.target.hasImprovement(this.getType());
    }

    public boolean validate() {
        if (this.type == null) {
            logger.warning("Removing typeless TileImprovementPlan");
            this.dispose();
            return false;
        }
        if (this.target == null) {
            logger.warning("Removing targetless TileImprovementPlan");
            this.dispose();
            return false;
        }
        if (this.getPioneer() != null && (this.getPioneer().getUnit() == null || this.getPioneer().getUnit().isDisposed())) {
            logger.warning("Clearing broken pioneer for TileImprovementPlan");
            this.setPioneer(null);
        }
        return true;
    }

    public boolean checkIntegrity() {
        return super.checkIntegrity() && this.type != null && this.target != null && (this.pioneer == null || this.pioneer.checkIntegrity());
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        if (this.validate()) {
            this.toXML(out, TileImprovementPlan.getXMLElementTagName());
        }
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("type", this.type.getId());
        out.writeAttribute("target", this.target.getId());
        if (this.pioneer != null && this.pioneer.checkIntegrity()) {
            out.writeAttribute("pioneer", this.pioneer.getId());
        }
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "type");
        this.type = str == null ? null : this.getSpecification().getTileImprovementType(str);
        str = in.getAttributeValue(null, "pioneer");
        if (str != null) {
            this.pioneer = (AIUnit)this.getAIMain().getAIObject(str);
            if (this.pioneer == null) {
                this.pioneer = new AIUnit(this.getAIMain(), str);
            }
        } else {
            this.pioneer = null;
        }
        this.target = (str = in.getAttributeValue(null, "target")) == null ? null : this.getAIMain().getGame().getFreeColGameObject(str, Tile.class);
    }

    public String toString() {
        return "[" + this.getId() + " " + this.type.getNameKey() + " at " + this.target + "/" + this.getValue() + "]";
    }

    public static String getXMLElementTagName() {
        return "tileImprovementPlan";
    }
}

