/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;
import net.sf.freecol.server.model.ServerPlayer;

public class REFAIPlayer
extends EuropeanAIPlayer {
    private static final Logger logger = Logger.getLogger(REFAIPlayer.class.getName());
    private static int seekAndDestroyRange = 12;

    public REFAIPlayer(AIMain aiMain, ServerPlayer player) {
        super(aiMain, player);
        this.uninitialized = this.getPlayer() == null;
    }

    public REFAIPlayer(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.getPlayer() == null;
    }

    public Tile initialize(boolean teleport) {
        AIUnit aiUnit = null;
        for (AIUnit aiu : this.getAIUnits()) {
            if (aiu.getUnit().isNaval() || !aiu.getUnit().isOffensiveUnit()) continue;
            aiUnit = aiu;
            break;
        }
        if (aiUnit == null) {
            logger.warning("REF has no army?!?");
            return null;
        }
        Unit unit = aiUnit.getUnit();
        Location target = UnitSeekAndDestroyMission.findTarget(aiUnit, Integer.MAX_VALUE, false);
        if (!(target instanceof Colony)) {
            logger.warning("Rebels have no connected colonies?!?");
            return null;
        }
        Colony colony = (Colony)target;
        Tile tile = colony.getTile();
        AIMain aiMain = this.getAIMain();
        for (AIUnit aiu : this.getAIUnits()) {
            if (aiu.getUnit().isNaval()) continue;
            aiu.setMission(new UnitSeekAndDestroyMission(aiMain, aiu, colony));
        }
        for (AIUnit aiu : this.getAIUnits()) {
            Unit ship;
            if (!aiu.getUnit().isNaval() || (ship = aiu.getUnit()).getUnitCount() <= 0) continue;
            TransportMission tm = new TransportMission(aiMain, aiu);
            aiu.setMission(tm);
        }
        GoalDecider gd = new GoalDecider(){
            private PathNode goal = null;

            public PathNode getGoal() {
                return this.goal;
            }

            public boolean hasSubGoals() {
                return true;
            }

            public boolean check(Unit u, PathNode pathNode) {
                Tile tile = pathNode.getTile();
                if (tile == null || !tile.isEmpty()) {
                    return false;
                }
                for (Tile t : pathNode.getTile().getSurroundingTiles(1)) {
                    if (!t.isHighSeasConnected() || !t.isEmpty()) continue;
                    this.goal = pathNode;
                    return true;
                }
                return false;
            }
        };
        PathNode path = unit.search(tile, gd, null, 10, unit.getCarrier());
        if (path == null) {
            logger.warning("Can not find suitable REF landing site for: " + colony);
            return null;
        }
        tile = path.getTile();
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (!t.isHighSeasConnected() || !t.isEmpty()) continue;
            tile = t;
            break;
        }
        if (teleport) {
            return tile;
        }
        if (unit.isOnCarrier()) {
            Tile entry = unit.getCarrier().getBestEntryTile(tile);
            if (entry != null) {
                return entry;
            }
            logger.warning("Can not find path to Europe from: " + tile);
            return null;
        }
        logger.warning("REF land unit not aboard a ship: " + unit);
        return null;
    }

    public void startWorking() {
        Player player = this.getPlayer();
        logger.finest("Entering method startWorking: " + player + ", year " + this.getGame().getTurn());
        if (!player.isWorkForREF()) {
            logger.warning("No work for REF: " + player);
            return;
        }
        super.startWorking();
    }

    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (value > 0) {
            if (type == DefendSettlementMission.class) {
                Location loc = DefendSettlementMission.extractTarget(aiUnit, path);
                if (loc instanceof Settlement && this.getSettlementDefenders((Settlement)loc) > 0) {
                    value = 0;
                }
            } else if (type == UnitSeekAndDestroyMission.class) {
                Location target = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
                if (target instanceof Settlement) {
                    if (((Settlement)target).isConnectedPort()) {
                        value += 500;
                    } else if (this.getPlayer().getNumberOfSettlements() <= 0) {
                        return Integer.MIN_VALUE;
                    }
                } else if (target instanceof Unit) {
                    if (this.getPlayer().getNumberOfSettlements() <= 0) {
                        return Integer.MIN_VALUE;
                    }
                    for (AIUnit au : this.getAIUnits()) {
                        Location loc;
                        Mission m = au.getMission();
                        if (m == null || !(m instanceof UnitSeekAndDestroyMission) || (loc = ((UnitSeekAndDestroyMission)m).getTarget()) == null || !(loc instanceof Unit) || loc != target) continue;
                        return Integer.MIN_VALUE;
                    }
                    value /= 2;
                }
            }
        }
        return value;
    }

    public void giveNormalMissions() {
        for (AIUnit aiu : this.getAIUnits()) {
            Unit u = aiu.getUnit();
            if (u.isNaval() || aiu.hasMission() || !u.isOffensiveUnit()) continue;
            Location target = UnitSeekAndDestroyMission.findTarget(aiu, seekAndDestroyRange, false);
            Mission m = target == null ? new UnitWanderHostileMission(this.getAIMain(), aiu) : new UnitSeekAndDestroyMission(this.getAIMain(), aiu, target);
            aiu.setMission(m);
        }
        super.giveNormalMissions();
    }
}

