/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.Wish;
import org.w3c.dom.Element;

public class GoodsWish
extends Wish {
    private static final Logger logger = Logger.getLogger(GoodsWish.class.getName());
    private GoodsType goodsType;
    private int amountRequested;

    public GoodsWish(AIMain aiMain, String id) {
        super(aiMain, id);
        this.goodsType = null;
        this.amountRequested = -1;
    }

    public GoodsWish(AIMain aiMain, Location destination, int value, int amountRequested, GoodsType goodsType) {
        this(aiMain, GoodsWish.getXMLElementTagName() + ":" + aiMain.getNextId());
        if (destination == null) {
            throw new NullPointerException("destination == null");
        }
        this.destination = destination;
        this.setValue(value);
        this.goodsType = goodsType;
        this.amountRequested = amountRequested;
        this.uninitialized = false;
    }

    public GoodsWish(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.goodsType == null;
    }

    public GoodsWish(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        super(aiMain, in);
        this.uninitialized = this.goodsType == null;
    }

    public boolean shouldBeStored() {
        return true;
    }

    public GoodsType getGoodsType() {
        return this.goodsType;
    }

    public boolean satisfiedBy(Goods goods) {
        return goods.getType() == this.goodsType && goods.getAmount() >= this.amountRequested;
    }

    public int getGoodsAmount() {
        return this.amountRequested;
    }

    public void setGoodsAmount(int amount) {
        this.amountRequested = amount;
    }

    public boolean checkIntegrity() {
        return super.checkIntegrity() && this.goodsType != null && this.amountRequested > 0;
    }

    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement(GoodsWish.getXMLElementTagName());
        this.writeAttributes(out);
        out.writeEndElement();
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        super.writeAttributes(out);
        out.writeAttribute("goodsType", this.goodsType.getId());
        out.writeAttribute("amountRequested", Integer.toString(this.amountRequested));
    }

    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        String str = in.getAttributeValue(null, "goodsType");
        this.goodsType = this.getSpecification().getGoodsType(str);
        this.amountRequested = this.getAttribute(in, "amountRequested", 100);
    }

    public String toString() {
        return "[" + this.getId() + " for " + this.destination + " on " + this.transportable + " " + this.amountRequested + " " + this.goodsType + " (" + this.getValue() + ")]";
    }

    public static String getXMLElementTagName() {
        return "goodsWish";
    }
}

