/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIMain;
import org.w3c.dom.Element;

public abstract class AIObject
extends FreeColObject {
    private static final Logger logger = Logger.getLogger(FreeColObject.class.getName());
    private final AIMain aiMain;
    protected boolean uninitialized = false;

    public AIObject(AIMain aiMain) {
        this.aiMain = aiMain;
        this.uninitialized = true;
    }

    public AIObject(AIMain aiMain, String id) {
        this(aiMain);
        if (id != null) {
            this.setId(id);
            aiMain.addAIObject(id, this);
        }
        this.uninitialized = true;
    }

    public AIObject(AIMain aiMain, Element element) {
        this(aiMain);
        this.readFromXMLElement(element);
        this.addAIObjectWithId();
    }

    public AIObject(AIMain aiMain, XMLStreamReader in) throws XMLStreamException {
        this(aiMain);
        this.readFromXML(in);
        this.addAIObjectWithId();
    }

    public void dispose() {
        this.getAIMain().removeAIObject(this.getId());
    }

    public boolean isDisposed() {
        return this.getAIMain().getAIObject(this.getId()) == null;
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public Game getGame() {
        return this.aiMain.getGame();
    }

    public Specification getSpecification() {
        return this.getGame().getSpecification();
    }

    public boolean isUninitialized() {
        return this.uninitialized;
    }

    public boolean checkIntegrity() {
        return !this.isUninitialized();
    }

    public void fixIntegrity() {
        this.dispose();
    }

    protected void addAIObjectWithId() {
        if (this.getId() != null) {
            this.aiMain.addAIObject(this.getId(), this);
        }
    }

    public static Location upLoc(Location loc) {
        if (loc instanceof Unit) {
            loc = ((Unit)loc).getLocation();
        }
        return loc == null ? null : (loc.getSettlement() != null ? loc.getSettlement() : loc);
    }

    protected void writeAttributes(XMLStreamWriter out) throws XMLStreamException {
        out.writeAttribute("ID", this.getId());
    }

    public final void readFromXML(XMLStreamReader in) throws XMLStreamException {
        super.readFromXML(in);
        this.uninitialized = false;
    }

    public static String getXMLElementTagName() {
        return "AIObject";
    }
}

