/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.FreeColSeed;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.NoRouteToServerException;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.common.util.XMLStream;
import net.sf.freecol.server.ai.AIInGameInputHandler;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.control.Controller;
import net.sf.freecol.server.control.InGameController;
import net.sf.freecol.server.control.InGameInputHandler;
import net.sf.freecol.server.control.PreGameController;
import net.sf.freecol.server.control.PreGameInputHandler;
import net.sf.freecol.server.control.UserConnectionHandler;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.SimpleMapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerModelObject;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.TransactionSession;
import net.sf.freecol.server.networking.DummyConnection;
import net.sf.freecol.server.networking.Server;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FreeColServer {
    private static final Logger logger = Logger.getLogger(FreeColServer.class.getName());
    private static final int META_SERVER_UPDATE_INTERVAL = 60000;
    private static final int NUMBER_OF_HIGH_SCORES = 10;
    public static final int SAVEGAME_VERSION = 12;
    public static final int MINIMUM_SAVEGAME_VERSION = 7;
    public static final String defaultSpec = "freecol";
    private GameState gameState = GameState.STARTING_GAME;
    private Server server;
    private final UserConnectionHandler userConnectionHandler;
    private final PreGameController preGameController;
    private final PreGameInputHandler preGameInputHandler;
    private final InGameInputHandler inGameInputHandler;
    private final InGameController inGameController;
    private ServerGame game;
    private AIMain aiMain;
    private MapGenerator mapGenerator;
    private boolean singlePlayer;
    private String owner;
    private boolean publicServer = false;
    private int port;
    private String name;
    private Random random = null;
    private boolean integrity = false;
    private Unit activeUnit = null;
    private List<HighScore> highScores = null;
    public static final Comparator<HighScore> highScoreComparator = new Comparator<HighScore>(){

        @Override
        public int compare(HighScore score1, HighScore score2) {
            return score2.getScore() - score1.getScore();
        }
    };

    private Server serverStart(int firstPort) throws IOException {
        int tries;
        int port;
        if (firstPort < 0) {
            port = FreeCol.getDefaultPort();
            tries = 10;
        } else {
            port = firstPort;
            tries = 1;
        }
        logger.finest("serverStart(" + firstPort + ") => " + port + " x " + tries);
        for (int i = tries; i > 0; --i) {
            block7: {
                try {
                    this.server = new Server(this, port);
                    this.port = port;
                    this.server.start();
                    break;
                }
                catch (BindException be) {
                    if (i == 1) {
                        logger.log(Level.WARNING, "Bind exception starting server.", be);
                        throw new IOException(be.getMessage());
                    }
                }
                catch (IOException ie) {
                    if (i != 1) break block7;
                    logger.log(Level.WARNING, "IO exception starting server.", ie);
                    throw ie;
                }
            }
            ++port;
        }
        return this.server;
    }

    public FreeColServer(Specification specification, boolean publicServer, boolean singlePlayer, int port, String name) throws IOException, NoRouteToServerException {
        this(specification, publicServer, singlePlayer, port, name, NationOptions.Advantages.SELECTABLE);
    }

    public FreeColServer(Specification specification, boolean publicServer, boolean singlePlayer, int port, String name, NationOptions.Advantages advantages) throws IOException, NoRouteToServerException {
        this.publicServer = publicServer;
        this.singlePlayer = singlePlayer;
        this.port = port;
        this.name = name;
        this.random = new Random(FreeColSeed.getFreeColSeed());
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.inGameController = new InGameController(this, this.random);
        this.game = new ServerGame(specification);
        this.game.setNationOptions(new NationOptions(specification, advantages));
        this.fixGameOptions();
        this.mapGenerator = new SimpleMapGenerator(this.random, specification);
        this.server = this.serverStart(port);
        this.updateMetaServer(true);
        this.startMetaServerUpdateThread();
    }

    public FreeColServer(FreeColSavegameFile savegame, int port, String name) throws IOException, FreeColException, NoRouteToServerException {
        this(savegame, port, name, null);
    }

    public FreeColServer(FreeColSavegameFile savegame, int port, String name, Specification specification) throws IOException, FreeColException, NoRouteToServerException {
        this.port = port;
        this.name = name;
        this.mapGenerator = null;
        this.userConnectionHandler = new UserConnectionHandler(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.server = this.serverStart(port);
        try {
            this.game = this.loadGame(savegame, specification);
        }
        catch (FreeColException e) {
            this.server.shutdown();
            throw e;
        }
        catch (Exception e) {
            this.server.shutdown();
            FreeColException fe = new FreeColException("couldNotLoadGame");
            fe.initCause(e);
            throw fe;
        }
        if (this.random == null) {
            this.random = new Random(FreeColSeed.getFreeColSeed());
        }
        this.inGameController = new InGameController(this, this.random);
        this.mapGenerator = new SimpleMapGenerator(this.random, this.getSpecification());
        this.updateMetaServer(true);
        this.startMetaServerUpdateThread();
        TransactionSession.clearAll();
    }

    public int getPort() {
        return this.port;
    }

    public void setSinglePlayer(boolean singlePlayer) {
        this.singlePlayer = singlePlayer;
    }

    public boolean isSinglePlayer() {
        return this.singlePlayer;
    }

    public Specification getSpecification() {
        return this.game.getSpecification();
    }

    public UserConnectionHandler getUserConnectionHandler() {
        return this.userConnectionHandler;
    }

    public Controller getController() {
        if (this.getGameState() == GameState.IN_GAME) {
            return this.inGameController;
        }
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public ServerGame getGame() {
        return this.game;
    }

    public void setGame(ServerGame game) {
        this.game = game;
    }

    public void setAIMain(AIMain aiMain) {
        this.aiMain = aiMain;
    }

    public AIMain getAIMain() {
        return this.aiMain;
    }

    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState state) {
        this.gameState = state;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public Random getServerRandom() {
        return this.random;
    }

    public void setServerRandom(Random random) {
        this.random = random;
    }

    public MapGenerator getMapGenerator() {
        return this.mapGenerator;
    }

    public void setMapGenerator(MapGenerator mapGenerator) {
        this.mapGenerator = mapGenerator;
    }

    public void updateMetaServer() throws NoRouteToServerException {
        this.updateMetaServer(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Unit getActiveUnit() {
        return this.activeUnit;
    }

    public void setActiveUnit(Unit unit) {
        this.activeUnit = unit;
    }

    public void setPublicServer(boolean publicServer) {
        this.publicServer = publicServer;
    }

    public void startMetaServerUpdateThread() {
        if (!this.publicServer) {
            return;
        }
        Timer t = new Timer(true);
        t.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                try {
                    FreeColServer.this.updateMetaServer();
                }
                catch (NoRouteToServerException noRouteToServerException) {
                    // empty catch block
                }
            }
        }, 60000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetaServer(boolean firstTime) throws NoRouteToServerException {
        Connection mc;
        if (!this.publicServer) {
            return;
        }
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not connect to meta-server.", e);
            return;
        }
        String tag = firstTime ? "register" : "update";
        String addr = this.name != null ? this.name : mc.getSocket().getLocalAddress().getHostAddress() + ":" + Integer.toString(this.port);
        int nPlayers = this.getNumberOfLivingHumanPlayers();
        boolean started = this.gameState != GameState.STARTING_GAME;
        try {
            Element reply = mc.askDumping(DOMMessage.createMessage(tag, "name", addr, "port", Integer.toString(this.port), "slotsAvailable", Integer.toString(this.getSlotsAvailable()), "currentlyPlaying", Integer.toString(nPlayers), "isGameStarted", Boolean.toString(started), "version", FreeCol.getVersion(), "gameState", Integer.toString(this.getGameState().ordinal())));
            if (reply != null && reply.getTagName().equals("noRouteToServer")) {
                throw new NoRouteToServerException();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Network error with meta-server.", e);
            return;
        }
        finally {
            mc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMetaServer() {
        Connection mc;
        if (!this.publicServer) {
            return;
        }
        try {
            mc = new Connection("meta.freecol.org", 3540, null, "FreeColServer:");
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not connect to meta-server.", e);
            return;
        }
        try {
            mc.sendDumping(DOMMessage.createMessage("remove", "port", Integer.toString(this.port)));
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Network error with meta-server.", e);
            return;
        }
        finally {
            mc.close();
        }
    }

    public int getSlotsAvailable() {
        List<Player> players = this.game.getPlayers();
        int n = 0;
        for (int i = 0; i < players.size(); ++i) {
            ServerPlayer p = (ServerPlayer)players.get(i);
            if (!p.isEuropean() || p.isREF() || p.isDead() || p.isConnected() && !p.isAI()) continue;
            ++n;
        }
        return n;
    }

    public int getNumberOfLivingHumanPlayers() {
        int n = 0;
        for (Player p : this.game.getPlayers()) {
            ServerPlayer serverPlayer = (ServerPlayer)p;
            if (serverPlayer.isAI() || serverPlayer.isDead() || serverPlayer.isConnected()) continue;
            ++n;
        }
        return n;
    }

    public void saveGame(File file, String username, OptionGroup options) throws IOException {
        this.saveGame(file, username, options, null);
    }

    public void saveGame(File file, String username, OptionGroup options, BufferedImage image) throws IOException {
        ServerGame game = this.getGame();
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        ZipOutputStream fos = null;
        try {
            fos = new JarOutputStream(new FileOutputStream(file));
            if (image != null) {
                ((JarOutputStream)fos).putNextEntry(new JarEntry("thumbnail.png"));
                ImageIO.write((RenderedImage)image, "png", fos);
                fos.closeEntry();
            }
            if (options != null) {
                ((JarOutputStream)fos).putNextEntry(new JarEntry("client-options.xml"));
                options.save(fos);
                fos.closeEntry();
            }
            Properties properties = new Properties();
            properties.put("map.width", Integer.toString(game.getMap().getWidth()));
            properties.put("map.height", Integer.toString(game.getMap().getHeight()));
            ((JarOutputStream)fos).putNextEntry(new JarEntry("savegame.properties"));
            properties.store(fos, null);
            fos.closeEntry();
            ((JarOutputStream)fos).putNextEntry(new JarEntry("savegame.xml"));
            XMLStreamWriter xsw = xof.createXMLStreamWriter(fos, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeComment("Game version: " + FreeCol.getRevision());
            xsw.writeStartElement("savedGame");
            xsw.writeAttribute("owner", username);
            xsw.writeAttribute("publicServer", Boolean.toString(this.publicServer));
            xsw.writeAttribute("singleplayer", Boolean.toString(this.singlePlayer));
            xsw.writeAttribute("version", Integer.toString(12));
            xsw.writeAttribute("randomState", Utils.getRandomState(this.random));
            xsw.writeAttribute("debug", FreeColDebugger.getDebugModes());
            if (this.getActiveUnit() != null) {
                xsw.writeAttribute("activeUnit", this.getActiveUnit().getId());
            }
            xsw.writeStartElement("serverObjects");
            for (ServerModelObject smo : game.getServerModelObjects()) {
                xsw.writeStartElement(smo.getServerXMLElementTagName());
                xsw.writeAttribute("ID", ((FreeColGameObject)((Object)smo)).getId());
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            game.toXML(xsw, null, true, true);
            if (this.aiMain != null) {
                this.aiMain.toXML(xsw);
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("XMLStreamException: " + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Exception: " + e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static XMLStream createXMLStreamReader(FreeColSavegameFile fis) throws IOException {
        return new XMLStream(fis.getSavegameInputStream());
    }

    public ServerGame loadGame(FreeColSavegameFile fis) throws IOException, FreeColException {
        return this.loadGame(fis, null);
    }

    public static ServerGame readGame(FreeColSavegameFile fis, Specification specification, FreeColServer server) throws IOException, FreeColException {
        int savegameVersion = FreeColServer.getSavegameVersion(fis);
        ArrayList<String> serverStrings = null;
        XMLStream xs = null;
        Game game = null;
        try {
            String active = null;
            xs = FreeColServer.createXMLStreamReader(fis);
            XMLStreamReader xsr = xs.getXMLStreamReader();
            xsr.nextTag();
            logger.info("Found savegame version " + savegameVersion);
            if (server != null) {
                String str = xsr.getAttributeValue(null, "singleplayer");
                server.setSinglePlayer(str == null ? true : Boolean.parseBoolean(str));
                str = xsr.getAttributeValue(null, "publicServer");
                server.setPublicServer(str == null ? false : Boolean.parseBoolean(str));
                str = xsr.getAttributeValue(null, "randomState");
                server.setServerRandom(Utils.restoreRandomState(str));
                str = xsr.getAttributeValue(null, "debug");
                FreeColDebugger.setDebugModes(str);
                server.setOwner(xsr.getAttributeValue(null, "owner"));
                active = xsr.getAttributeValue(null, "activeUnit");
            }
            while (xsr.nextTag() != 2) {
                String tag = xsr.getLocalName();
                if ("serverObjects".equals(tag)) {
                    serverStrings = new ArrayList<String>();
                    while (xsr.nextTag() != 2) {
                        serverStrings.add(xsr.getLocalName());
                        serverStrings.add(xsr.getAttributeValue(null, "ID"));
                        xsr.nextTag();
                    }
                    if (savegameVersion >= 11) continue;
                    FreeColServer.v11FixServerObjects(serverStrings, fis);
                    continue;
                }
                if (Game.getXMLElementTagName().equals(tag)) {
                    if (savegameVersion < 9 && specification == null) {
                        specification = new FreeColTcFile(defaultSpec).getSpecification();
                        logger.info("Reading old format game (version: " + savegameVersion + "), using " + defaultSpec + " specification.");
                    }
                    game = new ServerGame(null, xsr, serverStrings, specification);
                    game.setCurrentPlayer(null);
                    if (server != null) {
                        server.setGame((ServerGame)game);
                    }
                    if (savegameVersion >= 9 || game.getDifficultyLevel() != null) continue;
                    game.getSpecification().applyDifficultyLevel("model.difficulty.medium");
                    logger.info("Applying default difficulty of medium.");
                    continue;
                }
                if (AIMain.getXMLElementTagName().equals(tag)) {
                    if (server == null) break;
                    server.setAIMain(new AIMain(server, xsr));
                    continue;
                }
                throw new XMLStreamException("Unknown tag: " + tag);
            }
            if (server != null && active != null && game != null) {
                Unit u = game.getFreeColGameObject(active, Unit.class);
                server.setActiveUnit(u);
            }
        }
        catch (Exception e) {
            throw new IOException("Exception: " + e.getMessage());
        }
        finally {
            if (xs != null) {
                xs.close();
            }
        }
        return game;
    }

    public ServerGame loadGame(FreeColSavegameFile fis, Specification specification) throws FreeColException, IOException {
        ServerGame game = FreeColServer.readGame(fis, specification, this);
        this.gameState = GameState.IN_GAME;
        this.integrity = game.checkIntegrity();
        int savegameVersion = FreeColServer.getSavegameVersion(fis);
        if (savegameVersion < 12) {
            for (Player p : game.getPlayers()) {
                if (p.isIndian()) {
                    for (IndianSettlement is : p.getIndianSettlements()) {
                        is.updateMostHated();
                    }
                }
                if (p.isIndian() || p.getEurope() == null) continue;
                p.initializeHighSeas();
                for (Unit u : p.getEurope().getUnitList()) {
                    if (u.getState() == Unit.UnitState.TO_EUROPE) {
                        logger.info("Found unit on way to europe: " + u.toString());
                        u.setLocation(p.getHighSeas());
                        u.setDestination(p.getEurope());
                        continue;
                    }
                    if (u.getState() != Unit.UnitState.TO_AMERICA) continue;
                    logger.info("Found unit on way to new world: " + u.toString());
                    u.setLocation(p.getHighSeas());
                    u.setDestination(game.getMap());
                }
            }
            for (Tile tile : game.getMap().getAllTiles()) {
                TerrainGenerator.encodeStyle(tile);
            }
        }
        this.fixGameOptions();
        if (savegameVersion < 11) {
            for (Tile t : game.getMap().getAllTiles()) {
                t.fixup09x();
            }
        }
        game.getMap().resetContiguity();
        game.getMapGeneratorOptions().setEditable(false);
        try {
            specification.getOptionGroup("gameOptions").setEditable(false);
            specification.getOptionGroup("difficultyLevels").setEditable(false);
        }
        catch (Exception e) {
            logger.warning("Failed to make option groups read-only");
        }
        AIMain aiMain = this.getAIMain();
        if (aiMain.checkIntegrity()) {
            logger.info("AI integrity test succeeded.");
        } else if (aiMain.fixIntegrity()) {
            logger.info("AI integrity test failed, but fixed.");
        } else {
            aiMain = new AIMain(this);
            logger.warning("AI integrity test failed, replaced AIMain.");
        }
        game.setFreeColGameObjectListener(aiMain);
        Collections.sort(game.getPlayers(), Player.playerComparator);
        for (Player player : game.getPlayers()) {
            if (!player.isAI()) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DummyConnection theConnection = new DummyConnection("Server-Server-" + player.getName(), this.getInGameInputHandler());
            DummyConnection aiConnection = new DummyConnection("Server-AI-" + player.getName(), new AIInGameInputHandler(this, serverPlayer, aiMain));
            aiConnection.setOutgoingMessageHandler(theConnection);
            theConnection.setOutgoingMessageHandler(aiConnection);
            this.getServer().addDummyConnection(theConnection);
            serverPlayer.setConnection(theConnection);
            serverPlayer.setConnected(true);
        }
        return game;
    }

    private static int getSavegameVersion(FreeColSavegameFile fis) throws FreeColException {
        XMLStream xs = null;
        try {
            xs = FreeColServer.createXMLStreamReader(fis);
            XMLStreamReader xsr = xs.getXMLStreamReader();
            xsr.nextTag();
            String version = xsr.getAttributeValue(null, "version");
            int savegameVersion = 0;
            try {
                savegameVersion = Integer.parseInt(version);
            }
            catch (Exception e) {
                throw new FreeColException("incompatibleVersions");
            }
            if (savegameVersion < 7) {
                throw new FreeColException("incompatibleVersions");
            }
            int n = savegameVersion;
            return n;
        }
        catch (Exception e) {
            throw new FreeColException(e.toString());
        }
        finally {
            if (xs != null) {
                xs.close();
            }
        }
    }

    private void fixGameOptions() {
        Specification spec = this.game.getSpecification();
        this.addIntegerOption("model.option.monarchSupport", "model.difficulty.monarch", 2, true);
        this.addStringOption("model.option.buildOnNativeLand", "model.difficulty.natives", "model.option.buildOnNativeLand.never", true);
        if (!spec.hasOption("model.option.amphibiousMoves")) {
            this.addBooleanOption("model.option.amphibiousMoves", "gameOptions.map", false, false);
            spec.addModifier(new Modifier("model.modifier.amphibiousAttack", Specification.AMPHIBIOUS_ATTACK_PENALTY_SOURCE, -75.0f, Modifier.Type.PERCENTAGE));
        }
        this.addBooleanOption("model.option.settlementActionsContactChief", "gameOptions.map", false, false);
        this.addBooleanOption("model.option.enhancedMissionaries", "gameOptions.map", false, false);
        this.addBooleanOption("model.option.continueFoundingFatherRecruitment", "gameOptions.map", false, false);
        this.addIntegerOption("model.option.settlementLimitModifier", "gameOptions.map", 0, false);
        this.addIntegerOption("model.option.startingPositions", "gameOptions.map", 0, false);
        this.addBooleanOption("model.option.teleportREF", "gameOptions.map", false, false);
        this.addIntegerOption("model.option.shipTradePenalty", "gameOptions.map", -30, false);
        if (spec.getModifiers("model.modifier.shipTradePenalty") == null) {
            spec.addModifier(new Modifier("model.modifier.shipTradePenalty", Specification.SHIP_TRADE_PENALTY_SOURCE, -30.0f, Modifier.Type.PERCENTAGE));
        }
        this.addBooleanOption("model.option.enableUpkeep", "gameOptions.colony", false, false);
        this.addIntegerOption("model.option.naturalDisasters", "gameOptions.colony", 0, false);
        this.addOptionGroup("model.difficulty.cheat", true);
        this.addIntegerOption("model.option.liftBoycottCheat", "model.difficulty.cheat", 10, true);
        this.addIntegerOption("model.option.equipScoutCheat", "model.difficulty.cheat", 10, true);
        this.addIntegerOption("model.option.landUnitCheat", "model.difficulty.cheat", 10, true);
        this.addIntegerOption("model.option.offensiveNavalUnitCheat", "model.difficulty.cheat", 10, true);
        this.addIntegerOption("model.option.transportNavalUnitCheat", "model.difficulty.cheat", 10, true);
        this.addIntegerOption("model.option.giftProbability", "gameOptions.map", 5, false);
        this.addIntegerOption("model.option.demandProbability", "gameOptions.map", 10, false);
        this.addBooleanOption("model.option.emptyTraders", "gameOptions.map", false, false);
    }

    private void addOptionGroup(String id, boolean difficulty) {
        Specification spec = this.game.getSpecification();
        try {
            spec.getOptionGroup(id);
        }
        catch (Exception e) {
            spec.fixOptionGroup(new OptionGroup(id, spec), difficulty);
        }
    }

    private void addBooleanOption(String id, String gr, boolean defaultValue, boolean difficulty) {
        BooleanOption op = new BooleanOption(id);
        op.setGroup(gr);
        op.setValue(defaultValue);
        this.addOption(op, difficulty);
    }

    private void addIntegerOption(String id, String gr, int defaultValue, boolean difficulty) {
        IntegerOption op = new IntegerOption(id);
        op.setGroup(gr);
        op.setValue(defaultValue);
        this.addOption(op, difficulty);
    }

    private void addStringOption(String id, String gr, String defaultValue, boolean difficulty) {
        StringOption op = new StringOption(id);
        op.setGroup(gr);
        op.setValue(defaultValue);
        this.addOption(op, difficulty);
    }

    private void addOption(AbstractOption option, boolean difficulty) {
        Specification spec = this.game.getSpecification();
        if (!spec.hasOption(option.getId())) {
            spec.addAbstractOption(option);
            if (difficulty) {
                for (OptionGroup level : spec.getDifficultyLevels()) {
                    if (level.hasOptionGroup()) {
                        level.getOptionGroup(option.getGroup()).add(option);
                        continue;
                    }
                    level.add(option);
                }
            } else {
                spec.getOptionGroup(option.getGroup()).add(option);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void v11FixServerObjects(List<String> serverStrings, FreeColSavegameFile fis) {
        XMLStream xs = null;
        try {
            xs = FreeColServer.createXMLStreamReader(fis);
            XMLStreamReader xsr = xs.getXMLStreamReader();
            xsr.nextTag();
            String owner = xsr.getAttributeValue(null, "owner");
            while (xsr.nextTag() != 2) {
                if (xsr.getLocalName().equals(Game.getXMLElementTagName())) {
                    ServerGame game = new ServerGame(null, xsr, new ArrayList<String>(serverStrings), new FreeColTcFile(defaultSpec).getSpecification());
                    Iterator<FreeColGameObject> objs = game.getFreeColGameObjectIterator();
                    while (objs.hasNext()) {
                        FreeColGameObject fcgo = objs.next();
                        if (serverStrings.contains(fcgo.getId())) continue;
                        if (fcgo instanceof Europe) {
                            serverStrings.add("serverEurope");
                        } else if (fcgo instanceof Colony) {
                            serverStrings.add("serverColony");
                        } else if (fcgo instanceof Building) {
                            serverStrings.add("serverBuilding");
                        } else if (fcgo instanceof ColonyTile) {
                            serverStrings.add("serverColonyTile");
                        } else if (fcgo instanceof IndianSettlement) {
                            serverStrings.add("serverIndianSettlement");
                        } else {
                            if (!(fcgo instanceof Unit)) continue;
                            serverStrings.add("serverUnit");
                        }
                        serverStrings.add(fcgo.getId());
                    }
                    break;
                }
                while (xsr.nextTag() != 2) {
                    xsr.nextTag();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (xs != null) {
                xs.close();
            }
        }
    }

    public static void removeAutosaves(String prefix) {
        for (File autosaveFile : FreeColDirectories.getAutosaveDirectory().listFiles()) {
            if (!autosaveFile.getName().startsWith(prefix)) continue;
            autosaveFile.delete();
        }
    }

    public void exploreMapForAllPlayers(boolean reveal) {
        for (Player player : this.getGame().getLiveEuropeanPlayers()) {
            ((ServerPlayer)player).exploreMap(reveal);
        }
        this.getSpecification().getBooleanOption("model.option.fogOfWar").setValue(reveal);
        for (Player player : this.getGame().getLiveEuropeanPlayers()) {
            try {
                ((ServerPlayer)player).getConnection().sendDumping(DOMMessage.createMessage("reconnect", new String[0]));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error sending reconnect.", e);
            }
        }
    }

    public ServerPlayer getPlayer(Connection connection) {
        Iterator<Player> playerIterator = this.getGame().getPlayerIterator();
        while (playerIterator.hasNext()) {
            ServerPlayer player = (ServerPlayer)playerIterator.next();
            if (player.getConnection() != connection) continue;
            return player;
        }
        return null;
    }

    public ServerPlayer addAIPlayer(Nation nation) {
        String name = nation.getRulerNameKey();
        DummyConnection theConnection = new DummyConnection("Server connection - " + name, this.getInGameInputHandler());
        ServerPlayer aiPlayer = new ServerPlayer(this.getGame(), name, false, nation, null, theConnection);
        aiPlayer.setAI(true);
        DummyConnection aiConnection = new DummyConnection("AI connection - " + name, new AIInGameInputHandler(this, aiPlayer, this.getAIMain()));
        aiConnection.setOutgoingMessageHandler(theConnection);
        theConnection.setOutgoingMessageHandler(aiConnection);
        this.getServer().addDummyConnection(theConnection);
        this.getGame().addPlayer(aiPlayer);
        Element player = DOMMessage.createMessage("addPlayer", new String[0]);
        player.appendChild(aiPlayer.toXMLElement(null, player.getOwnerDocument()));
        this.getServer().sendToAll(player, theConnection);
        return aiPlayer;
    }

    public AIPlayer getAIPlayer(Player player) {
        return this.getAIMain().getAIPlayer(player);
    }

    public List<HighScore> getHighScores() {
        if (this.highScores == null) {
            try {
                this.loadHighScores();
            }
            catch (Exception e) {
                logger.warning(e.toString());
                this.highScores = new ArrayList<HighScore>();
            }
        }
        return this.highScores;
    }

    public boolean newHighScore(Player player) {
        if (FreeColDebugger.isInDebugMode()) {
            return false;
        }
        this.getHighScores();
        if (!this.highScores.isEmpty() && player.getScore() <= this.highScores.get(this.highScores.size() - 1).getScore()) {
            return false;
        }
        this.highScores.add(new HighScore(player, new Date()));
        Collections.sort(this.highScores, highScoreComparator);
        if (this.highScores.size() == 10) {
            this.highScores.remove(9);
        }
        return true;
    }

    public void saveHighScores() throws IOException {
        if (this.highScores == null || this.highScores.isEmpty()) {
            return;
        }
        Collections.sort(this.highScores, highScoreComparator);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(FreeColDirectories.getHighScoreFile());
            XMLStreamWriter xsw = xof.createXMLStreamWriter(fos, "UTF-8");
            xsw.writeStartDocument("UTF-8", "1.0");
            xsw.writeStartElement("highScores");
            int count = 0;
            for (HighScore score : this.highScores) {
                score.toXML(xsw);
                if (++count != 10) continue;
                break;
            }
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("XMLStreamException: " + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Exception: " + e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void loadHighScores() throws IOException, FreeColException {
        this.highScores = new ArrayList<HighScore>();
        File hsf = FreeColDirectories.getHighScoreFile();
        if (!hsf.exists()) {
            return;
        }
        XMLInputFactory xif = XMLInputFactory.newInstance();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(hsf);
            XMLStreamReader xsr = xif.createXMLStreamReader(fis, "UTF-8");
            xsr.nextTag();
            while (xsr.nextTag() != 2) {
                if (!xsr.getLocalName().equals("highScore")) continue;
                this.highScores.add(new HighScore(xsr));
            }
            xsr.close();
            Collections.sort(this.highScores, highScoreComparator);
        }
        catch (XMLStreamException e) {
            throw new IOException("XMLStreamException: " + e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Exception: " + e.getMessage());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameState {
        STARTING_GAME,
        IN_GAME,
        ENDING_GAME;

    }
}

