/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStream
implements Closeable {
    private static final Logger logger = Logger.getLogger(XMLStream.class.getName());
    private InputStream inputStream;
    private XMLStreamReader xmlStreamReader;

    public XMLStream(InputStream inputStream) throws IOException {
        this.inputStream = inputStream;
        this.xmlStreamReader = this.createXMLStreamReader(inputStream);
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.xmlStreamReader;
    }

    public void close() {
        try {
            this.xmlStreamReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.inputStream.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Close input stream fail", e);
        }
    }

    private XMLStreamReader createXMLStreamReader(InputStream inputStream) throws IOException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            return xif.createXMLStreamReader(inputStream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new IOException("XMLStreamException: " + e.getMessage());
        }
        catch (NullPointerException e) {
            throw new NullPointerException("NullPointerException: " + e.getMessage());
        }
    }
}

