/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerOption
extends AbstractOption<Integer> {
    private static Logger logger = Logger.getLogger(IntegerOption.class.getName());
    private int value;
    private int minimumValue = Integer.MIN_VALUE;
    private int maximumValue = Integer.MAX_VALUE;

    public IntegerOption(String id) {
        super(id);
    }

    public IntegerOption(Specification specification) {
        super(specification);
    }

    public IntegerOption(String id, Specification specification) {
        super(id, specification);
    }

    @Override
    public IntegerOption clone() {
        IntegerOption result = new IntegerOption(this.getId());
        result.setValues(this);
        result.minimumValue = this.minimumValue;
        result.maximumValue = this.maximumValue;
        return result;
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(int minimumValue) {
        this.minimumValue = minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(int maximumValue) {
        this.maximumValue = maximumValue;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        int oldValue = this.value;
        this.value = value;
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", (Object)oldValue, value);
        }
        this.isDefined = true;
    }

    protected String getStringValue() {
        return Integer.toString(this.value);
    }

    @Override
    protected void setValue(String value) {
        this.setValue(Integer.parseInt(value));
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        this.setValue(Integer.parseInt(valueString != null ? valueString : defaultValueString));
    }

    @Override
    protected void toXMLImpl(XMLStreamWriter out) throws XMLStreamException {
        this.toXMLImpl(out, IntegerOption.getXMLElementTagName());
    }

    protected void toXMLImpl(XMLStreamWriter out, String tag) throws XMLStreamException {
        out.writeStartElement(tag);
        out.writeAttribute("id", this.getId());
        out.writeAttribute("value", Integer.toString(this.value));
        if (this.minimumValue > Integer.MIN_VALUE) {
            out.writeAttribute("minimumValue", Integer.toString(this.minimumValue));
        }
        if (this.maximumValue < Integer.MAX_VALUE) {
            out.writeAttribute("maximumValue", Integer.toString(this.maximumValue));
        }
        out.writeEndElement();
    }

    @Override
    protected void readAttributes(XMLStreamReader in) throws XMLStreamException {
        super.readAttributes(in);
        this.minimumValue = this.getAttribute(in, "minimumValue", Integer.MIN_VALUE);
        this.maximumValue = this.getAttribute(in, "maximumValue", Integer.MAX_VALUE);
    }

    @Override
    public String toString() {
        return IntegerOption.getXMLElementTagName() + " [value=" + this.value + "]";
    }

    public static String getXMLElementTagName() {
        return "integerOption";
    }
}

