/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Element;

public class UpdateCurrentStopMessage
extends DOMMessage {
    private String unitId;

    public UpdateCurrentStopMessage(Unit unit) {
        this.unitId = unit.getId();
    }

    public UpdateCurrentStopMessage(Game game, Element element) {
        this.unitId = element.getAttribute("unit");
    }

    public Element handle(FreeColServer server, Connection connection) {
        Unit unit;
        ServerPlayer serverPlayer = server.getPlayer(connection);
        try {
            unit = serverPlayer.getFreeColGameObject(this.unitId, Unit.class);
        }
        catch (Exception e) {
            return DOMMessage.clientError(e.getMessage());
        }
        return server.getInGameController().updateCurrentStop(serverPlayer, unit);
    }

    public Element toXMLElement() {
        return UpdateCurrentStopMessage.createMessage(UpdateCurrentStopMessage.getXMLElementTagName(), "unit", this.unitId);
    }

    public static String getXMLElementTagName() {
        return "updateCurrentStop";
    }
}

